# -*- coding: utf-8 -*-

# django-mcadmin
# mcadmin/migrations/0001_initial.py

# Generated by Django 3.0.3 on 2020-02-10 20:48


from typing import List, Tuple  # pylint: disable=W0611

import django.db.models.deletion
from django.conf import settings
from django.db import models, migrations


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]  # type: List[Tuple[str, str]]

    operations = [
        migrations.CreateModel(
            name="Group",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True, max_length=256, verbose_name="name"
                    ),
                ),
            ],
            options={
                "verbose_name": "management commands group",
                "verbose_name_plural": "management commands groups",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="Command",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "command",
                    models.CharField(
                        choices=[],
                        db_index=True,
                        help_text="got from management commands admin registry",
                        max_length=256,
                        verbose_name="name",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="commands_permissions",
                        to="mcadmin.Group",
                        verbose_name="group",
                    ),
                ),
            ],
            options={
                "verbose_name": "management command",
                "verbose_name_plural": "management commands",
                "ordering": ["command"],
                "unique_together": {("command", "group")},
            },
        ),
        migrations.CreateModel(
            name="CommandPermission",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "command",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="users",
                        to="mcadmin.Command",
                        verbose_name="command",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="commands",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "management command permission",
                "verbose_name_plural": "management commands permission",
                "ordering": ["command"],
                "unique_together": {("command", "user")},
            },
        ),
        migrations.CreateModel(
            name="CommandGroupPermission",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="users",
                        to="mcadmin.Group",
                        verbose_name="group",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="commands_groups_permissions",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "management command group permission",
                "verbose_name_plural": "management commands groups permission",
                "ordering": ["group"],
                "unique_together": {("group", "user")},
            },
        ),
    ]  # type: List[migrations.CreateModel]
