from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Camera_autogen import Camera


@register
class CombinedCamera(Camera):
    """CombinedCamera

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, width=0, height=0, fov=50, near=0.1, far=2000, orthoNear=0.1, orthoFar=2000, **kwargs):
        kwargs['width'] = width
        kwargs['height'] = height
        kwargs['fov'] = fov
        kwargs['near'] = near
        kwargs['far'] = far
        kwargs['orthoNear'] = orthoNear
        kwargs['orthoFar'] = orthoFar
        super(CombinedCamera, self).__init__(**kwargs)

    _model_name = Unicode('CombinedCameraModel').tag(sync=True)

    fov = IEEEFloat(50, allow_none=False).tag(sync=True)

    zoom = IEEEFloat(1, allow_none=False).tag(sync=True)

    near = IEEEFloat(0.1, allow_none=False).tag(sync=True)

    far = IEEEFloat(2000, allow_none=False).tag(sync=True)

    orthoNear = IEEEFloat(0.1, allow_none=False).tag(sync=True)

    orthoFar = IEEEFloat(2000, allow_none=False).tag(sync=True)

    width = IEEEFloat(0, allow_none=False).tag(sync=True)

    height = IEEEFloat(0, allow_none=False).tag(sync=True)

    mode = Enum(['perspective', 'orthographic'], "perspective", allow_none=False).tag(sync=True)

    impersonate = Bool(True, allow_none=False).tag(sync=True)

    type = Unicode("CombinedCamera", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
CombinedCamera.__signature__ = inspect.signature(CombinedCamera.__init__)
