from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from .PerspectiveCamera_autogen import PerspectiveCamera

@register
class StereoCamera(ThreeWidget):
    """StereoCamera

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/cameras/StereoCamera
    """

    def __init__(self, **kwargs):
        super(StereoCamera, self).__init__(**kwargs)

    _model_name = Unicode('StereoCameraModel').tag(sync=True)

    aspect = IEEEFloat(1, allow_none=False).tag(sync=True)

    eyeSep = IEEEFloat(0.064, allow_none=False).tag(sync=True)

    cameraL = Instance(PerspectiveCamera, allow_none=True).tag(sync=True, **widget_serialization)

    cameraR = Instance(PerspectiveCamera, allow_none=True).tag(sync=True, **widget_serialization)


import inspect
# Include explicit signature since the metaclass screws it up
StereoCamera.__signature__ = inspect.signature(StereoCamera.__init__)
