from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Controls_autogen import Controls


@register
class FlyControls(Controls):
    """FlyControls

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, controlling=None, **kwargs):
        kwargs['controlling'] = controlling
        super(FlyControls, self).__init__(**kwargs)

    _model_name = Unicode('FlyControlsModel').tag(sync=True)

    moveVector = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    rotationVector = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    movementSpeed = IEEEFloat(1, allow_none=False).tag(sync=True)

    rollSpeed = IEEEFloat(0.05, allow_none=False).tag(sync=True)

    syncRate = IEEEFloat(1, allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
FlyControls.__signature__ = inspect.signature(FlyControls.__init__)
