from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Controls_autogen import Controls


class OrbitControls(Controls):
    """OrbitControls

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, controlling=None, **kwargs):
        kwargs['controlling'] = controlling
        super(OrbitControls, self).__init__(**kwargs)

    _model_name = Unicode('OrbitControlsModel').tag(sync=True)

    autoRotate = Bool(False, allow_none=False).tag(sync=True)

    autoRotateSpeed = IEEEFloat(2, allow_none=False).tag(sync=True)

    dampingFactor = IEEEFloat(0.25, allow_none=False).tag(sync=True)

    enabled = Bool(True, allow_none=False).tag(sync=True)

    enableDamping = Bool(False, allow_none=False).tag(sync=True)

    enableKeys = Bool(True, allow_none=False).tag(sync=True)

    enablePan = Bool(True, allow_none=False).tag(sync=True)

    enableRotate = Bool(True, allow_none=False).tag(sync=True)

    enableZoom = Bool(True, allow_none=False).tag(sync=True)

    keyPanSpeed = IEEEFloat(7, allow_none=False).tag(sync=True)

    maxAzimuthAngle = IEEEFloat(float('inf'), allow_none=False).tag(sync=True)

    maxDistance = IEEEFloat(float('inf'), allow_none=False).tag(sync=True)

    maxPolarAngle = IEEEFloat(3.141592653589793, allow_none=False).tag(sync=True)

    maxZoom = IEEEFloat(float('inf'), allow_none=False).tag(sync=True)

    minAzimuthAngle = IEEEFloat(-float('inf'), allow_none=False).tag(sync=True)

    minDistance = IEEEFloat(0, allow_none=False).tag(sync=True)

    minPolarAngle = IEEEFloat(0, allow_none=False).tag(sync=True)

    minZoom = IEEEFloat(0, allow_none=False).tag(sync=True)

    panSpeed = IEEEFloat(1, allow_none=False).tag(sync=True)

    rotateSpeed = IEEEFloat(1, allow_none=False).tag(sync=True)

    screenSpacePanning = Bool(True, allow_none=False).tag(sync=True)

    zoomSpeed = IEEEFloat(1, allow_none=False).tag(sync=True)

    target = Vector3(default_value=[0, 0, 0]).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
OrbitControls.__signature__ = inspect.signature(OrbitControls.__init__)
