from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Controls_autogen import Controls

from ..core.Object3D import Object3D

@register
class Picker(Controls):
    """Picker

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, controlling=None, **kwargs):
        kwargs['controlling'] = controlling
        super(Picker, self).__init__(**kwargs)

    _model_name = Unicode('PickerModel').tag(sync=True)

    event = Unicode("click", allow_none=False).tag(sync=True)

    lineThreshold = IEEEFloat(1, allow_none=False).tag(sync=True)

    pointThreshold = IEEEFloat(1, allow_none=False).tag(sync=True)

    all = Bool(False, allow_none=False).tag(sync=True)

    distance = IEEEFloat(None, allow_none=True).tag(sync=True)

    point = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    instanceId = CInt(None, allow_none=True).tag(sync=True)

    face = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    faceNormal = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    faceVertices = List(trait=List()).tag(sync=True)

    index = CInt(None, allow_none=True).tag(sync=True)

    faceIndex = CInt(None, allow_none=True).tag(sync=True)

    modifiers = List().tag(sync=True)

    object = Instance(Object3D, allow_none=True).tag(sync=True, **widget_serialization)

    picked = List().tag(sync=True)

    uv = Vector2(default_value=[0, 0]).tag(sync=True)

    indices = List().tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Picker.__signature__ = inspect.signature(Picker.__init__)
