from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


class BufferAttribute(ThreeWidget):
    """BufferAttribute

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/BufferAttribute
    """

    def __init__(self, array=None, normalized=False, **kwargs):
        kwargs['array'] = array
        kwargs['normalized'] = normalized
        super(BufferAttribute, self).__init__(**kwargs)

    _model_name = Unicode('BufferAttributeModel').tag(sync=True)

    array = WebGLDataUnion().tag(sync=True)

    dynamic = Bool(False, allow_none=False).tag(sync=True)

    needsUpdate = Bool(False, allow_none=False).tag(sync=True)

    normalized = Bool(False, allow_none=False).tag(sync=True)

    version = CInt(-1, allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
BufferAttribute.__signature__ = inspect.signature(BufferAttribute.__init__)
