from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .BaseGeometry_autogen import BaseGeometry


class Geometry(BaseGeometry):
    """Geometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/Geometry
    """

    def __init__(self, **kwargs):
        super(Geometry, self).__init__(**kwargs)

    _model_name = Unicode('GeometryModel').tag(sync=True)

    vertices = List(trait=List()).tag(sync=True)

    colors = List(trait=Unicode(), default_value=["#ffffff"]).tag(sync=True)

    faces = TypedTuple(trait=Face3()).tag(sync=True)

    faceVertexUvs = List().tag(sync=True)

    lineDistances = List().tag(sync=True)

    morphTargets = List().tag(sync=True)

    morphNormals = List().tag(sync=True)

    skinWeights = List(trait=List()).tag(sync=True)

    skinIndices = List(trait=List()).tag(sync=True)

    _ref_geometry = Instance(BaseGeometry, allow_none=True).tag(sync=True, **widget_serialization)

    _store_ref = Bool(False, allow_none=False).tag(sync=True)

    type = Unicode("Geometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Geometry.__signature__ = inspect.signature(Geometry.__init__)
