from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .InterleavedBuffer_autogen import InterleavedBuffer


@register
class InstancedInterleavedBuffer(InterleavedBuffer):
    """InstancedInterleavedBuffer

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/InstancedInterleavedBuffer
    """

    def __init__(self, array=None, meshPerAttribute=1, **kwargs):
        kwargs['array'] = array
        kwargs['meshPerAttribute'] = meshPerAttribute
        super(InstancedInterleavedBuffer, self).__init__(**kwargs)

    _model_name = Unicode('InstancedInterleavedBufferModel').tag(sync=True)

    meshPerAttribute = CInt(1, allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
InstancedInterleavedBuffer.__signature__ = inspect.signature(InstancedInterleavedBuffer.__init__)
