from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from ..math.Ray_autogen import Ray

@register
class Raycaster(ThreeWidget):
    """Raycaster

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/Raycaster
    """

    def __init__(self, origin=[0, 0, 0], direction=[0, 0, 0], near=0, far=1000000, **kwargs):
        kwargs['origin'] = origin
        kwargs['direction'] = direction
        kwargs['near'] = near
        kwargs['far'] = far
        super(Raycaster, self).__init__(**kwargs)

    _model_name = Unicode('RaycasterModel').tag(sync=True)

    origin = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    direction = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    near = IEEEFloat(0, allow_none=False).tag(sync=True)

    far = IEEEFloat(1000000, allow_none=False).tag(sync=True)

    ray = Instance(Ray, allow_none=True).tag(sync=True, **widget_serialization)

    linePrecision = IEEEFloat(1, allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Raycaster.__signature__ = inspect.signature(Raycaster.__init__)
