from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry


@register
class BoxBufferGeometry(BaseBufferGeometry):
    """BoxBufferGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/BoxGeometry
    """

    def __init__(self, width=1, height=1, depth=1, widthSegments=1, heightSegments=1, depthSegments=1, **kwargs):
        kwargs['width'] = width
        kwargs['height'] = height
        kwargs['depth'] = depth
        kwargs['widthSegments'] = widthSegments
        kwargs['heightSegments'] = heightSegments
        kwargs['depthSegments'] = depthSegments
        super(BoxBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('BoxBufferGeometryModel').tag(sync=True)

    width = IEEEFloat(1, allow_none=False).tag(sync=True)

    height = IEEEFloat(1, allow_none=False).tag(sync=True)

    depth = IEEEFloat(1, allow_none=False).tag(sync=True)

    widthSegments = CInt(1, allow_none=False).tag(sync=True)

    heightSegments = CInt(1, allow_none=False).tag(sync=True)

    depthSegments = CInt(1, allow_none=False).tag(sync=True)

    type = Unicode("BoxBufferGeometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
BoxBufferGeometry.__signature__ = inspect.signature(BoxBufferGeometry.__init__)
