from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class CircleGeometry(BaseGeometry):
    """CircleGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/CircleGeometry
    """

    def __init__(self, radius=1, segments=8, thetaStart=0, thetaLength=6.283185307179586, **kwargs):
        kwargs['radius'] = radius
        kwargs['segments'] = segments
        kwargs['thetaStart'] = thetaStart
        kwargs['thetaLength'] = thetaLength
        super(CircleGeometry, self).__init__(**kwargs)

    _model_name = Unicode('CircleGeometryModel').tag(sync=True)

    radius = IEEEFloat(1, allow_none=False).tag(sync=True)

    segments = CInt(8, allow_none=False, min=3).tag(sync=True)

    thetaStart = IEEEFloat(0, allow_none=False).tag(sync=True)

    thetaLength = IEEEFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("CircleGeometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
CircleGeometry.__signature__ = inspect.signature(CircleGeometry.__init__)
