from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class CylinderGeometry(BaseGeometry):
    """CylinderGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/CylinderGeometry
    """

    def __init__(self, radiusTop=1, radiusBottom=1, height=1, radialSegments=8, heightSegments=1, openEnded=False, thetaStart=0, thetaLength=6.283185307179586, **kwargs):
        kwargs['radiusTop'] = radiusTop
        kwargs['radiusBottom'] = radiusBottom
        kwargs['height'] = height
        kwargs['radialSegments'] = radialSegments
        kwargs['heightSegments'] = heightSegments
        kwargs['openEnded'] = openEnded
        kwargs['thetaStart'] = thetaStart
        kwargs['thetaLength'] = thetaLength
        super(CylinderGeometry, self).__init__(**kwargs)

    _model_name = Unicode('CylinderGeometryModel').tag(sync=True)

    radiusTop = IEEEFloat(1, allow_none=False).tag(sync=True)

    radiusBottom = IEEEFloat(1, allow_none=False).tag(sync=True)

    height = IEEEFloat(1, allow_none=False).tag(sync=True)

    radialSegments = CInt(8, allow_none=False).tag(sync=True)

    heightSegments = CInt(1, allow_none=False).tag(sync=True)

    openEnded = Bool(False, allow_none=False).tag(sync=True)

    thetaStart = IEEEFloat(0, allow_none=False).tag(sync=True)

    thetaLength = IEEEFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("CylinderGeometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
CylinderGeometry.__signature__ = inspect.signature(CylinderGeometry.__init__)
