from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class ExtrudeGeometry(BaseGeometry):
    """ExtrudeGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/ExtrudeGeometry
    """

    def __init__(self, **kwargs):
        raise NotImplementedError('ExtrudeGeometry is not yet implemented!')

    _model_name = Unicode('ExtrudeGeometryModel').tag(sync=True)

    type = Unicode("ExtrudeGeometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
ExtrudeGeometry.__signature__ = inspect.signature(ExtrudeGeometry.__init__)
