from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry


@register
class LatheBufferGeometry(BaseBufferGeometry):
    """LatheBufferGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/LatheGeometry
    """

    def __init__(self, points=[], segments=12, phiStart=0, phiLength=6.283185307179586, **kwargs):
        kwargs['points'] = points
        kwargs['segments'] = segments
        kwargs['phiStart'] = phiStart
        kwargs['phiLength'] = phiLength
        super(LatheBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('LatheBufferGeometryModel').tag(sync=True)

    points = List(trait=List()).tag(sync=True)

    segments = CInt(12, allow_none=False).tag(sync=True)

    phiStart = IEEEFloat(0, allow_none=False).tag(sync=True)

    phiLength = IEEEFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("LatheBufferGeometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
LatheBufferGeometry.__signature__ = inspect.signature(LatheBufferGeometry.__init__)
