from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry

from ..extras.core.Shape_autogen import Shape

@register
class ShapeGeometry(BaseGeometry):
    """ShapeGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/ShapeGeometry
    """

    def __init__(self, shapes=[], **kwargs):
        kwargs['shapes'] = shapes
        super(ShapeGeometry, self).__init__(**kwargs)

    _model_name = Unicode('ShapeGeometryModel').tag(sync=True)

    shapes = Tuple().tag(sync=True, **widget_serialization)

    curveSegments = CInt(12, allow_none=False).tag(sync=True)

    material = CInt(0, allow_none=False).tag(sync=True)

    type = Unicode("ShapeGeometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
ShapeGeometry.__signature__ = inspect.signature(ShapeGeometry.__init__)
