from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry


@register
class SphereBufferGeometry(BaseBufferGeometry):
    """SphereBufferGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/SphereGeometry
    """

    def __init__(self, radius=1, widthSegments=8, heightSegments=6, phiStart=0, phiLength=6.283185307179586, thetaStart=0, thetaLength=3.141592653589793, **kwargs):
        kwargs['radius'] = radius
        kwargs['widthSegments'] = widthSegments
        kwargs['heightSegments'] = heightSegments
        kwargs['phiStart'] = phiStart
        kwargs['phiLength'] = phiLength
        kwargs['thetaStart'] = thetaStart
        kwargs['thetaLength'] = thetaLength
        super(SphereBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('SphereBufferGeometryModel').tag(sync=True)

    radius = IEEEFloat(1, allow_none=False).tag(sync=True)

    widthSegments = CInt(8, allow_none=False).tag(sync=True)

    heightSegments = CInt(6, allow_none=False).tag(sync=True)

    phiStart = IEEEFloat(0, allow_none=False).tag(sync=True)

    phiLength = IEEEFloat(6.283185307179586, allow_none=False).tag(sync=True)

    thetaStart = IEEEFloat(0, allow_none=False).tag(sync=True)

    thetaLength = IEEEFloat(3.141592653589793, allow_none=False).tag(sync=True)

    type = Unicode("SphereBufferGeometry", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
SphereBufferGeometry.__signature__ = inspect.signature(SphereBufferGeometry.__init__)
