from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..objects.Blackbox import Blackbox


@register
class ArrowHelper(Blackbox):
    """ArrowHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/ArrowHelper
    """

    def __init__(self, dir=[0, 0, 1], origin=[0, 0, 0], length=1, color="#ffff00", headLength=None, headWidth=None, **kwargs):
        kwargs['dir'] = dir
        kwargs['origin'] = origin
        kwargs['length'] = length
        kwargs['color'] = color
        kwargs['headLength'] = headLength
        kwargs['headWidth'] = headWidth
        super(ArrowHelper, self).__init__(**kwargs)

    _model_name = Unicode('ArrowHelperModel').tag(sync=True)

    dir = Vector3(default_value=[0, 0, 1]).tag(sync=True)

    origin = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    length = IEEEFloat(1, allow_none=False).tag(sync=True)

    color = Color("#ffff00", allow_none=False).tag(sync=True)

    headLength = IEEEFloat(None, allow_none=True).tag(sync=True)

    headWidth = IEEEFloat(None, allow_none=True).tag(sync=True)

    type = Unicode("ArrowHelper", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
ArrowHelper.__signature__ = inspect.signature(ArrowHelper.__init__)
