from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class AxesHelper(Object3D):
    """AxesHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/AxesHelper
    """

    def __init__(self, size=1, **kwargs):
        kwargs['size'] = size
        super(AxesHelper, self).__init__(**kwargs)

    _model_name = Unicode('AxesHelperModel').tag(sync=True)

    size = IEEEFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("AxesHelper", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
AxesHelper.__signature__ = inspect.signature(AxesHelper.__init__)
