from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..cameras.Camera_autogen import Camera

@register
class CameraHelper(Object3D):
    """CameraHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/CameraHelper
    """

    def __init__(self, camera=None, **kwargs):
        kwargs['camera'] = camera
        super(CameraHelper, self).__init__(**kwargs)

    _model_name = Unicode('CameraHelperModel').tag(sync=True)

    camera = Instance(Camera, allow_none=True).tag(sync=True, **widget_serialization)

    type = Unicode("CameraHelper", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
CameraHelper.__signature__ = inspect.signature(CameraHelper.__init__)
