from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class FaceNormalsHelper(Object3D):
    """FaceNormalsHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/FaceNormalsHelper
    """

    def __init__(self, object=None, size=1, color="#ffff00", linewidth=1, **kwargs):
        kwargs['object'] = object
        kwargs['size'] = size
        kwargs['color'] = color
        kwargs['linewidth'] = linewidth
        super(FaceNormalsHelper, self).__init__(**kwargs)

    _model_name = Unicode('FaceNormalsHelperModel').tag(sync=True)

    object = Instance(Object3D, allow_none=True).tag(sync=True, **widget_serialization)

    size = IEEEFloat(1, allow_none=False).tag(sync=True)

    color = Color("#ffff00", allow_none=False).tag(sync=True)

    linewidth = IEEEFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("FaceNormalsHelper", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
FaceNormalsHelper.__signature__ = inspect.signature(FaceNormalsHelper.__init__)
