from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..math.Plane_autogen import Plane

@register
class PlaneHelper(Object3D):
    """PlaneHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/PlaneHelper
    """

    def __init__(self, plane=None, size=1, color="yellow", **kwargs):
        kwargs['plane'] = plane
        kwargs['size'] = size
        kwargs['color'] = color
        super(PlaneHelper, self).__init__(**kwargs)

    _model_name = Unicode('PlaneHelperModel').tag(sync=True)

    plane = Instance(Plane, allow_none=True).tag(sync=True, **widget_serialization)

    size = IEEEFloat(1, allow_none=False).tag(sync=True)

    color = Color("yellow", allow_none=True).tag(sync=True)

    type = Unicode("PlaneHelper", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
PlaneHelper.__signature__ = inspect.signature(PlaneHelper.__init__)
