from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..lights.SpotLight_autogen import SpotLight

@register
class SpotLightHelper(Object3D):
    """SpotLightHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/SpotLightHelper
    """

    def __init__(self, light=None, color="#ffffff", **kwargs):
        kwargs['light'] = light
        kwargs['color'] = color
        super(SpotLightHelper, self).__init__(**kwargs)

    _model_name = Unicode('SpotLightHelperModel').tag(sync=True)

    light = Instance(SpotLight, allow_none=True).tag(sync=True, **widget_serialization)

    color = Color("#ffffff", allow_none=True).tag(sync=True)

    type = Unicode("SpotLightHelper", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
SpotLightHelper.__signature__ = inspect.signature(SpotLightHelper.__init__)
