from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Light_autogen import Light

from ..core.Object3D import Object3D
from .LightShadow_autogen import LightShadow

@register
class DirectionalLight(Light):
    """DirectionalLight

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/lights/DirectionalLight
    """

    def __init__(self, color="#ffffff", intensity=1, **kwargs):
        kwargs['color'] = color
        kwargs['intensity'] = intensity
        super(DirectionalLight, self).__init__(**kwargs)

    _model_name = Unicode('DirectionalLightModel').tag(sync=True)

    target = Union([
        Instance(Uninitialized),
        Instance(Object3D),
        ], default_value=UninitializedSentinel, allow_none=False).tag(sync=True, **unitialized_serialization)

    shadow = Union([
        Instance(Uninitialized),
        Instance(LightShadow),
        ], default_value=UninitializedSentinel, allow_none=False).tag(sync=True, **unitialized_serialization)

    type = Unicode("DirectionalLight", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
DirectionalLight.__signature__ = inspect.signature(DirectionalLight.__init__)
