from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Light_autogen import Light

from ..core.Object3D import Object3D
from .LightShadow_autogen import LightShadow

@register
class SpotLight(Light):
    """SpotLight

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/lights/SpotLight
    """

    def __init__(self, color="#ffffff", intensity=1, distance=0, angle=1.0471975511965976, penumbra=0, decay=1, **kwargs):
        kwargs['color'] = color
        kwargs['intensity'] = intensity
        kwargs['distance'] = distance
        kwargs['angle'] = angle
        kwargs['penumbra'] = penumbra
        kwargs['decay'] = decay
        super(SpotLight, self).__init__(**kwargs)

    _model_name = Unicode('SpotLightModel').tag(sync=True)

    target = Union([
        Instance(Uninitialized),
        Instance(Object3D),
        ], default_value=UninitializedSentinel, allow_none=False).tag(sync=True, **unitialized_serialization)

    distance = IEEEFloat(0, allow_none=False).tag(sync=True)

    angle = IEEEFloat(1.0471975511965976, allow_none=False).tag(sync=True)

    penumbra = IEEEFloat(0, allow_none=False).tag(sync=True)

    decay = IEEEFloat(1, allow_none=False).tag(sync=True)

    shadow = Union([
        Instance(Uninitialized),
        Instance(LightShadow),
        ], default_value=UninitializedSentinel, allow_none=False).tag(sync=True, **unitialized_serialization)

    type = Unicode("SpotLight", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
SpotLight.__signature__ = inspect.signature(SpotLight.__init__)
