from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Material import Material


@register
class LineBasicMaterial(Material):
    """LineBasicMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/LineBasicMaterial
    """

    _model_name = Unicode('LineBasicMaterialModel').tag(sync=True)

    color = Color("#ffffff", allow_none=False).tag(sync=True)

    lights = Bool(False, allow_none=False).tag(sync=True)

    linewidth = IEEEFloat(1, allow_none=False).tag(sync=True)

    linecap = Unicode("round", allow_none=False).tag(sync=True)

    linejoin = Unicode("round", allow_none=False).tag(sync=True)

    type = Unicode("LineBasicMaterial", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
LineBasicMaterial.__signature__ = inspect.signature(LineBasicMaterial.__init__)
