from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Material import Material


@register
class LineMaterial(Material):
    """LineMaterial

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    _model_name = Unicode('LineMaterialModel').tag(sync=True)

    color = Color("#ffffff", allow_none=False).tag(sync=True)

    fog = Bool(False, allow_none=False).tag(sync=True)

    lights = Bool(False, allow_none=False).tag(sync=True)

    linewidth = IEEEFloat(1, allow_none=False).tag(sync=True)

    dashScale = IEEEFloat(1, allow_none=False).tag(sync=True)

    dashSize = IEEEFloat(1, allow_none=False).tag(sync=True)

    gapSize = IEEEFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("LineMaterial", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
LineMaterial.__signature__ = inspect.signature(LineMaterial.__init__)
