from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Material import Material


@register
class MeshNormalMaterial(Material):
    """MeshNormalMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/MeshNormalMaterial
    """

    _model_name = Unicode('MeshNormalMaterialModel').tag(sync=True)

    fog = Bool(False, allow_none=False).tag(sync=True)

    lights = Bool(False, allow_none=False).tag(sync=True)

    morphTargets = Bool(False, allow_none=False).tag(sync=True)

    wireframe = Bool(False, allow_none=False).tag(sync=True)

    wireframeLinewidth = IEEEFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("MeshNormalMaterial", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
MeshNormalMaterial.__signature__ = inspect.signature(MeshNormalMaterial.__init__)
