from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .MeshStandardMaterial_autogen import MeshStandardMaterial


@register
class MeshPhysicalMaterial(MeshStandardMaterial):
    """MeshPhysicalMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/MeshPhysicalMaterial
    """

    def __init__(self, **kwargs):
        super(MeshPhysicalMaterial, self).__init__(**kwargs)

    _model_name = Unicode('MeshPhysicalMaterialModel').tag(sync=True)

    clearCoat = IEEEFloat(0, allow_none=False).tag(sync=True)

    clearCoatRoughness = IEEEFloat(0, allow_none=False).tag(sync=True)

    defines = Dict(default_value={"PHYSICAL":""}, allow_none=True).tag(sync=True)

    reflectivity = IEEEFloat(0.5, allow_none=False).tag(sync=True)

    type = Unicode("MeshPhysicalMaterial", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
MeshPhysicalMaterial.__signature__ = inspect.signature(MeshPhysicalMaterial.__init__)
