from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .ShaderMaterial_autogen import ShaderMaterial


@register
class ShadowMaterial(ShaderMaterial):
    """ShadowMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/ShadowMaterial
    """

    def __init__(self, **kwargs):
        super(ShadowMaterial, self).__init__(**kwargs)

    _model_name = Unicode('ShadowMaterialModel').tag(sync=True)

    lights = Bool(True, allow_none=False).tag(sync=True)

    transparent = Bool(True, allow_none=False).tag(sync=True)

    type = Unicode("ShadowMaterial", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
ShadowMaterial.__signature__ = inspect.signature(ShadowMaterial.__init__)
