from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from .Plane_autogen import Plane

@register
class Frustum(ThreeWidget):
    """Frustum

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Frustum
    """

    def __init__(self, p0=None, p1=None, p2=None, p3=None, p4=None, p5=None, **kwargs):
        kwargs['p0'] = p0
        kwargs['p1'] = p1
        kwargs['p2'] = p2
        kwargs['p3'] = p3
        kwargs['p4'] = p4
        kwargs['p5'] = p5
        super(Frustum, self).__init__(**kwargs)

    _model_name = Unicode('FrustumModel').tag(sync=True)

    p0 = Instance(Plane, allow_none=True).tag(sync=True, **widget_serialization)

    p1 = Instance(Plane, allow_none=True).tag(sync=True, **widget_serialization)

    p2 = Instance(Plane, allow_none=True).tag(sync=True, **widget_serialization)

    p3 = Instance(Plane, allow_none=True).tag(sync=True, **widget_serialization)

    p4 = Instance(Plane, allow_none=True).tag(sync=True, **widget_serialization)

    p5 = Instance(Plane, allow_none=True).tag(sync=True, **widget_serialization)


import inspect
# Include explicit signature since the metaclass screws it up
Frustum.__signature__ = inspect.signature(Frustum.__init__)
