from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Line3(ThreeWidget):
    """Line3

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Line3
    """

    def __init__(self, start=[0, 0, 0], end=[0, 0, 0], **kwargs):
        kwargs['start'] = start
        kwargs['end'] = end
        super(Line3, self).__init__(**kwargs)

    _model_name = Unicode('Line3Model').tag(sync=True)

    start = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    end = Vector3(default_value=[0, 0, 0]).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Line3.__signature__ = inspect.signature(Line3.__init__)
