from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Plane(ThreeWidget):
    """Plane

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Plane
    """

    def __init__(self, normal=[0, 0, 0], constant=0, **kwargs):
        kwargs['normal'] = normal
        kwargs['constant'] = constant
        super(Plane, self).__init__(**kwargs)

    _model_name = Unicode('PlaneModel').tag(sync=True)

    normal = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    constant = IEEEFloat(0, allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Plane.__signature__ = inspect.signature(Plane.__init__)
