from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Ray(ThreeWidget):
    """Ray

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Ray
    """

    def __init__(self, origin=[0, 0, 0], direction=[0, 0, 0], **kwargs):
        kwargs['origin'] = origin
        kwargs['direction'] = direction
        super(Ray, self).__init__(**kwargs)

    _model_name = Unicode('RayModel').tag(sync=True)

    origin = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    direction = Vector3(default_value=[0, 0, 0]).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Ray.__signature__ = inspect.signature(Ray.__init__)
