from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class Group(Object3D):
    """Group

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/objects/Group
    """

    def __init__(self, **kwargs):
        super(Group, self).__init__(**kwargs)

    _model_name = Unicode('GroupModel').tag(sync=True)

    type = Unicode("Group", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Group.__signature__ = inspect.signature(Group.__init__)
