from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class FogExp2(ThreeWidget):
    """FogExp2

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/scenes/FogExp2
    """

    def __init__(self, color="white", density=0.00025, **kwargs):
        kwargs['color'] = color
        kwargs['density'] = density
        super(FogExp2, self).__init__(**kwargs)

    _model_name = Unicode('FogExp2Model').tag(sync=True)

    name = Unicode("", allow_none=False).tag(sync=True)

    color = Color("white", allow_none=False).tag(sync=True)

    density = IEEEFloat(0.00025, allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
FogExp2.__signature__ = inspect.signature(FogExp2.__init__)
