from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Fog(ThreeWidget):
    """Fog

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/scenes/Fog
    """

    def __init__(self, color="white", near=1, far=1000, **kwargs):
        kwargs['color'] = color
        kwargs['near'] = near
        kwargs['far'] = far
        super(Fog, self).__init__(**kwargs)

    _model_name = Unicode('FogModel').tag(sync=True)

    name = Unicode("", allow_none=False).tag(sync=True)

    color = Color("white", allow_none=False).tag(sync=True)

    near = IEEEFloat(1, allow_none=False).tag(sync=True)

    far = IEEEFloat(1000, allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Fog.__signature__ = inspect.signature(Fog.__init__)
