from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from .Fog_autogen import Fog
from .FogExp2_autogen import FogExp2
from ..materials.Material import Material

@register
class Scene(Object3D):
    """Scene

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/scenes/Scene
    """

    def __init__(self, **kwargs):
        super(Scene, self).__init__(**kwargs)

    _model_name = Unicode('SceneModel').tag(sync=True)

    fog = Union([
        Instance(Fog, allow_none=True),
        Instance(FogExp2, allow_none=True)
    ]).tag(sync=True, **widget_serialization)

    overrideMaterial = Instance(Material, allow_none=True).tag(sync=True, **widget_serialization)

    autoUpdate = Bool(True, allow_none=False).tag(sync=True)

    background = Color("#ffffff", allow_none=True).tag(sync=True)

    type = Unicode("Scene", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
Scene.__signature__ = inspect.signature(Scene.__init__)
