from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Texture_autogen import Texture


@register
class ImageTexture(Texture):
    """ImageTexture

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, imageUri="", mapping="UVMapping", wrapS="ClampToEdgeWrapping", wrapT="ClampToEdgeWrapping", magFilter="LinearFilter", minFilter="LinearMipMapLinearFilter", format="RGBAFormat", type="UnsignedByteType", anisotropy=1, **kwargs):
        kwargs['imageUri'] = imageUri
        kwargs['mapping'] = mapping
        kwargs['wrapS'] = wrapS
        kwargs['wrapT'] = wrapT
        kwargs['magFilter'] = magFilter
        kwargs['minFilter'] = minFilter
        kwargs['format'] = format
        kwargs['type'] = type
        kwargs['anisotropy'] = anisotropy
        super(ImageTexture, self).__init__(**kwargs)

    _model_name = Unicode('ImageTextureModel').tag(sync=True)

    imageUri = Unicode("", allow_none=False).tag(sync=True)


import inspect
# Include explicit signature since the metaclass screws it up
ImageTexture.__signature__ = inspect.signature(ImageTexture.__init__)
