"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const fs_extra_1 = require("fs-extra");
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = log4js_1.getLogger();
/**
 * Generates the typescript client using OpenAPI Generator
 */
class GeneratedTypescriptClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            // Generate the typescript client
            logger.debug("Generating typescript client...");
            utils_1.invokeOpenApiGenerator({
                generator: "typescript-fetch",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.TYPESCRIPT,
                additionalProperties: {
                    npmName: this.project.package.packageName,
                    typescriptThreePlus: "true",
                    useSingleParameter: "true",
                    supportsES6: "true",
                },
                srcDir: this.project.srcdir,
            });
            // Write an index.ts which exposes the additional generated file OperationConfig.ts, which contains handler wrappers
            // and other generated code used by the construct.
            fs_extra_1.writeFileSync(path.join(this.project.outdir, "src", "index.ts"), [
                "/* tslint:disable */",
                "/* eslint-disable */",
                "export * from './runtime';",
                "export * from './apis';",
                "export * from './models';",
                "export * from './apis/DefaultApi/OperationConfig';",
            ].join("\n"));
        }
    }
}
exports.GeneratedTypescriptClientSourceCode = GeneratedTypescriptClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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