from rest_framework import permissions
from rest_framework.permissions import BasePermission, SAFE_METHODS

class ObjectPermissions(permissions.DjangoObjectPermissions):
    """
    Permission setup for objects
    https://github.com/rpkilby/django-rest-framework-guardian
    """
    perms_map = {
        'GET': ['%(app_label)s.view_%(model_name)s'],
        'OPTIONS': ['%(app_label)s.view_%(model_name)s'],
        'HEAD': ['%(app_label)s.view_%(model_name)s'],
        'POST': ['%(app_label)s.add_%(model_name)s'],
        'PUT': ['%(app_label)s.change_%(model_name)s'],
        'PATCH': ['%(app_label)s.change_%(model_name)s'],
        'DELETE': ['%(app_label)s.delete_%(model_name)s']
    }

class ReadOnlyPermission(BasePermission):
    """
    Permission to let the user read objects anonymous user have permission assigned
    """
    def has_permission(self, request, view):
        return request.method in SAFE_METHODS