"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.views = self.__class__.views(path + ["views"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        super().__init__(path, service)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)

    class views(TUIMenu):
        """
        Enter the view manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.camera = self.__class__.camera(path + ["camera"], service)
            self.display_states = self.__class__.display_states(path + ["display_states"], service)
            super().__init__(path, service)
        def delete_view(self, *args, **kwargs):
            """
            Removes a view from the list.
            """
            return PyMenu(self.service, "/views/delete_view").execute(*args, **kwargs)
        def restore_view(self, *args, **kwargs):
            """
            Uses a saved view.
            """
            return PyMenu(self.service, "/views/restore_view").execute(*args, **kwargs)
        def next_view(self, *args, **kwargs):
            """
            .
            """
            return PyMenu(self.service, "/views/next_view").execute(*args, **kwargs)
        def list_views(self, *args, **kwargs):
            """
            Lists predefined and saved views.
            """
            return PyMenu(self.service, "/views/list_views").execute(*args, **kwargs)
        def auto_scale(self, *args, **kwargs):
            """
            Scales and centers the current scene without changing its orientation.
            """
            return PyMenu(self.service, "/views/auto_scale").execute(*args, **kwargs)
        def write_views(self, *args, **kwargs):
            """
            Writes selected views to a view file.
            """
            return PyMenu(self.service, "/views/write_views").execute(*args, **kwargs)
        def last_view(self, *args, **kwargs):
            """
            Returns to the camera position before the last manipulation.
            """
            return PyMenu(self.service, "/views/last_view").execute(*args, **kwargs)
        def save_view(self, *args, **kwargs):
            """
            Saves the current view to the view list.
            """
            return PyMenu(self.service, "/views/save_view").execute(*args, **kwargs)
        def default_view(self, *args, **kwargs):
            """
            Resets view to front and center.
            """
            return PyMenu(self.service, "/views/default_view").execute(*args, **kwargs)
        def read_views(self, *args, **kwargs):
            """
            Reads views from a view file.
            """
            return PyMenu(self.service, "/views/read_views").execute(*args, **kwargs)

        class camera(TUIMenu):
            """
            Enters the camera menu to modify the current viewing parameters.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def roll_camera(self, *args, **kwargs):
                """
                Adjusts the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/roll_camera").execute(*args, **kwargs)
            def pan_camera(self, *args, **kwargs):
                """
                Adjusts the camera target without modifying the position.
                """
                return PyMenu(self.service, "/views/camera/pan_camera").execute(*args, **kwargs)
            def field(self, *args, **kwargs):
                """
                Sets the field of view (width and height).
                """
                return PyMenu(self.service, "/views/camera/field").execute(*args, **kwargs)
            def target(self, *args, **kwargs):
                """
                Sets the point to be the center of the camera view.
                """
                return PyMenu(self.service, "/views/camera/target").execute(*args, **kwargs)
            def position(self, *args, **kwargs):
                """
                Sets the camera position.
                """
                return PyMenu(self.service, "/views/camera/position").execute(*args, **kwargs)
            def projection(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/camera/projection").execute(*args, **kwargs)
            def up_vector(self, *args, **kwargs):
                """
                Sets the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/up_vector").execute(*args, **kwargs)
            def dolly_camera(self, *args, **kwargs):
                """
                Adjusts the camera position and target.
                """
                return PyMenu(self.service, "/views/camera/dolly_camera").execute(*args, **kwargs)
            def zoom_camera(self, *args, **kwargs):
                """
                Adjusts the camera’s field of view. This operation is similar to dollying the camera in or out of the scene. Dollying causes objects in front to move past you. Zooming changes the perspective effect in the scene (and can be disconcerting).
                """
                return PyMenu(self.service, "/views/camera/zoom_camera").execute(*args, **kwargs)
            def orbit_camera(self, *args, **kwargs):
                """
                Adjusts the camera position without modifying the target.
                """
                return PyMenu(self.service, "/views/camera/orbit_camera").execute(*args, **kwargs)

        class display_states(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/list").execute(*args, **kwargs)
            def restore_state(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/restore_state").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/read").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename object.
                """
                return PyMenu(self.service, "/views/display_states/rename").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/copy").execute(*args, **kwargs)
            def use_active(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/use_active").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete object.
                """
                return PyMenu(self.service, "/views/display_states/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit display-states object.
                """
                return PyMenu(self.service, "/views/display_states/edit").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/write").execute(*args, **kwargs)
            def new(self, *args, **kwargs):
                """
                Create a new display-states object.
                """
                return PyMenu(self.service, "/views/display_states/new").execute(*args, **kwargs)

    class parametric_study(TUIMenu):
        """
        Enter the parametric study menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.study = self.__class__.study(path + ["study"], service)
            self.design_points = self.__class__.design_points(path + ["design_points"], service)
            self.update = self.__class__.update(path + ["update"], service)
            super().__init__(path, service)
        def delete_study(self, *args, **kwargs):
            """
            Delete Study.
            """
            return PyMenu(self.service, "/parametric_study/delete_study").execute(*args, **kwargs)
        def import_design_table(self, *args, **kwargs):
            """
            Import Design Point Table.
            """
            return PyMenu(self.service, "/parametric_study/import_design_table").execute(*args, **kwargs)
        def initialize(self, *args, **kwargs):
            """
            Start Parametric Study.
            """
            return PyMenu(self.service, "/parametric_study/initialize").execute(*args, **kwargs)
        def case_settings_changed(self, *args, **kwargs):
            """
            Check if case settings are changed.
            """
            return PyMenu(self.service, "/parametric_study/case_settings_changed").execute(*args, **kwargs)
        def use_base_data(self, *args, **kwargs):
            """
            Use Base Data.
            """
            return PyMenu(self.service, "/parametric_study/use_base_data").execute(*args, **kwargs)
        def rename_study(self, *args, **kwargs):
            """
            Rename Study.
            """
            return PyMenu(self.service, "/parametric_study/rename_study").execute(*args, **kwargs)
        def set_as_current_study(self, *args, **kwargs):
            """
            Set As Current Study.
            """
            return PyMenu(self.service, "/parametric_study/set_as_current_study").execute(*args, **kwargs)
        def export_design_table(self, *args, **kwargs):
            """
            Export Design Point Table.
            """
            return PyMenu(self.service, "/parametric_study/export_design_table").execute(*args, **kwargs)
        def list_studies(self, *args, **kwargs):
            """
            List Studies.
            """
            return PyMenu(self.service, "/parametric_study/list_studies").execute(*args, **kwargs)
        def duplicate_study(self, *args, **kwargs):
            """
            Duplicate Parametric Study.
            """
            return PyMenu(self.service, "/parametric_study/duplicate_study").execute(*args, **kwargs)

        class study(TUIMenu):
            """
            Enter the study menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def set_as_current(self, *args, **kwargs):
                """
                Set As Current Study.
                """
                return PyMenu(self.service, "/parametric_study/study/set_as_current").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename Study.
                """
                return PyMenu(self.service, "/parametric_study/study/rename").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Study.
                """
                return PyMenu(self.service, "/parametric_study/study/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List Studies.
                """
                return PyMenu(self.service, "/parametric_study/study/list").execute(*args, **kwargs)
            def use_base_data(self, *args, **kwargs):
                """
                Use Base Data for Current Study.
                """
                return PyMenu(self.service, "/parametric_study/study/use_base_data").execute(*args, **kwargs)
            def initialize(self, *args, **kwargs):
                """
                Start Parametric Study.
                """
                return PyMenu(self.service, "/parametric_study/study/initialize").execute(*args, **kwargs)
            def duplicate(self, *args, **kwargs):
                """
                Duplicate Parametric Study.
                """
                return PyMenu(self.service, "/parametric_study/study/duplicate").execute(*args, **kwargs)

        class design_points(TUIMenu):
            """
            Enter the design points menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.auto_create = self.__class__.auto_create(path + ["auto_create"], service)
                self.table = self.__class__.table(path + ["table"], service)
                self.concurrent = self.__class__.concurrent(path + ["concurrent"], service)
                self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def save_journals(self, *args, **kwargs):
                """
                Save Journals.
                """
                return PyMenu(self.service, "/parametric_study/design_points/save_journals").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Design Point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/delete").execute(*args, **kwargs)
            def clear_data_and_edit_values(self, *args, **kwargs):
                """
                Clear Generated Data.
                """
                return PyMenu(self.service, "/parametric_study/design_points/clear_data_and_edit_values").execute(*args, **kwargs)
            def duplicate(self, *args, **kwargs):
                """
                Duplicate Design Point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/duplicate").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add new design point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/add").execute(*args, **kwargs)
            def load_case_data_for_current_dp(self, *args, **kwargs):
                """
                Loads relevant case/data file for current design point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/load_case_data_for_current_dp").execute(*args, **kwargs)

            class auto_create(TUIMenu):
                """
                Enter the auto-crate design points menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_designs(self, *args, **kwargs):
                    """
                    Export designs by writing a JSON file.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/export_designs").execute(*args, **kwargs)
                def create_design_points(self, *args, **kwargs):
                    """
                    Create design points automatically.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/create_design_points").execute(*args, **kwargs)
                def open_designs_in_optislang_postprocessor(self, *args, **kwargs):
                    """
                    Export designs into JSON and open this JSON into optiSLang Postprocessor.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/open_designs_in_optislang_postprocessor").execute(*args, **kwargs)
                def list_current_settings(self, *args, **kwargs):
                    """
                    List current settings for auto-create design points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/list_current_settings").execute(*args, **kwargs)
                def go_to_optislang(self, *args, **kwargs):
                    """
                    Open the optiSLang project.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/go_to_optislang").execute(*args, **kwargs)

            class table(TUIMenu):
                """
                Enter the design point table menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def import_design_table(self, *args, **kwargs):
                    """
                    Import Design Points Table.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/table/import_design_table").execute(*args, **kwargs)
                def export_design_table(self, *args, **kwargs):
                    """
                    Export Design Points Table.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/table/export_design_table").execute(*args, **kwargs)

            class concurrent(TUIMenu):
                """
                Enter the concurrent design points menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def abort_all_design_points(self, *args, **kwargs):
                    """
                    Interrupt All Design Points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/abort_all_design_points").execute(*args, **kwargs)
                def abort_design_point(self, *args, **kwargs):
                    """
                    Interrupt Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/abort_design_point").execute(*args, **kwargs)
                def refresh_status(self, *args, **kwargs):
                    """
                    Refresh Status.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/refresh_status").execute(*args, **kwargs)

            class print_to_console(TUIMenu):
                """
                Enter the design points print menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def output_parameters_of_dp(self, *args, **kwargs):
                    """
                    Print Output Parameter Values of Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/output_parameters_of_dp").execute(*args, **kwargs)
                def status_of_dp(self, *args, **kwargs):
                    """
                    Print Status of given DP.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/status_of_dp").execute(*args, **kwargs)
                def input_parameters_of_dp(self, *args, **kwargs):
                    """
                    Print Input Parameter Values of Current Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/input_parameters_of_dp").execute(*args, **kwargs)
                def capture_simulation_report_data(self, *args, **kwargs):
                    """
                    Print Capture Simulation Report Data option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/capture_simulation_report_data").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    Print WriteData option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/write_data").execute(*args, **kwargs)
                def current_dp(self, *args, **kwargs):
                    """
                    Print Name of Current Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/current_dp").execute(*args, **kwargs)
                def status_of_all_dps(self, *args, **kwargs):
                    """
                    Print Statuses of all Design Points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/status_of_all_dps").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the design points Set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_data(self, *args, **kwargs):
                    """
                    Set WriteData option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/write_data").execute(*args, **kwargs)
                def input_parameters_of_dp(self, *args, **kwargs):
                    """
                    Set Input Parameter Values of Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/input_parameters_of_dp").execute(*args, **kwargs)
                def current_dp(self, *args, **kwargs):
                    """
                    Set current design point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/current_dp").execute(*args, **kwargs)
                def capture_simulation_report_data(self, *args, **kwargs):
                    """
                    Set Capture Simulation Report Data option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/capture_simulation_report_data").execute(*args, **kwargs)

        class update(TUIMenu):
            """
            Enter the update menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.concurrent = self.__class__.concurrent(path + ["concurrent"], service)
                super().__init__(path, service)
            def update_selected_design_points(self, *args, **kwargs):
                """
                Update Selected Design Points.
                """
                return PyMenu(self.service, "/parametric_study/update/update_selected_design_points").execute(*args, **kwargs)
            def update_all(self, *args, **kwargs):
                """
                Update All Design Points.
                """
                return PyMenu(self.service, "/parametric_study/update/update_all").execute(*args, **kwargs)
            def set_update_method(self, *args, **kwargs):
                """
                Set update method.
                """
                return PyMenu(self.service, "/parametric_study/update/set_update_method").execute(*args, **kwargs)
            def print_update_method(self, *args, **kwargs):
                """
                Print update method.
                """
                return PyMenu(self.service, "/parametric_study/update/print_update_method").execute(*args, **kwargs)
            def update_current(self, *args, **kwargs):
                """
                Update Current Design Point.
                """
                return PyMenu(self.service, "/parametric_study/update/update_current").execute(*args, **kwargs)

            class concurrent(TUIMenu):
                """
                Enter Concurrent Update menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                    self.licensing = self.__class__.licensing(path + ["licensing"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def register_new_endpoint(self, *args, **kwargs):
                    """
                    Register a new endpoint.
                    """
                    return PyMenu(self.service, "/parametric_study/update/concurrent/register_new_endpoint").execute(*args, **kwargs)
                def delete_endpoint(self, *args, **kwargs):
                    """
                    Delete endpoint.
                    """
                    return PyMenu(self.service, "/parametric_study/update/concurrent/delete_endpoint").execute(*args, **kwargs)

                class print_to_console(TUIMenu):
                    """
                    Print to console concurrent options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def current_endpoint(self, *args, **kwargs):
                        """
                        Get the current endpoint.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/current_endpoint").execute(*args, **kwargs)
                    def number_of_cores_per_dp(self, *args, **kwargs):
                        """
                        Get Number of Cores per Design Point.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/number_of_cores_per_dp").execute(*args, **kwargs)
                    def registered_endpoints(self, *args, **kwargs):
                        """
                        List registered endpoints.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/registered_endpoints").execute(*args, **kwargs)
                    def current_queue(self, *args, **kwargs):
                        """
                        Get the current queue.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/current_queue").execute(*args, **kwargs)
                    def number_of_concurrent_dps(self, *args, **kwargs):
                        """
                        Print Number of Concurrent Design Points.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/number_of_concurrent_dps").execute(*args, **kwargs)

                class licensing(TUIMenu):
                    """
                    Enter Concurrent Licensing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                        super().__init__(path, service)

                    class set(TUIMenu):
                        """
                        Enter Concurrent Licensing Menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def optislang_license_count(self, *args, **kwargs):
                            """
                            OptiSLang License Count.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/optislang_license_count").execute(*args, **kwargs)
                        def optislang_license_type(self, *args, **kwargs):
                            """
                            OptiSLang License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/optislang_license_type").execute(*args, **kwargs)
                        def license_type(self, *args, **kwargs):
                            """
                            License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/license_type").execute(*args, **kwargs)

                    class print_to_console(TUIMenu):
                        """
                        Print Concurrent Licensing Settings.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def optislang_license_type(self, *args, **kwargs):
                            """
                            OptiSLang License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/optislang_license_type").execute(*args, **kwargs)
                        def license_type(self, *args, **kwargs):
                            """
                            License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/license_type").execute(*args, **kwargs)
                        def optislang_license_count(self, *args, **kwargs):
                            """
                            OptiSLang License Count.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/optislang_license_count").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Set concurrent update options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def number_of_cores_per_dp(self, *args, **kwargs):
                        """
                        Set Number of Cores per Design Point.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/number_of_cores_per_dp").execute(*args, **kwargs)
                    def current_endpoint(self, *args, **kwargs):
                        """
                        Set the current endpoint.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/current_endpoint").execute(*args, **kwargs)
                    def current_queue(self, *args, **kwargs):
                        """
                        Set the current queue.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/current_queue").execute(*args, **kwargs)
                    def number_of_concurrent_dps(self, *args, **kwargs):
                        """
                        Set Number of Concurrent Design Points.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/number_of_concurrent_dps").execute(*args, **kwargs)

    class turbo_post(TUIMenu):
        """
        Enter the turbo menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def current_topology(self, *args, **kwargs):
            """
            Sets the current turbo topology for global use.
            """
            return PyMenu(self.service, "/turbo_post/current_topology").execute(*args, **kwargs)
        def two_d_contours(self, *args, **kwargs):
            """
            Display 2d contours.
            """
            return PyMenu(self.service, "/turbo_post/two_d_contours").execute(*args, **kwargs)
        def avg_contours(self, *args, **kwargs):
            """
            Displays average contours.
            """
            return PyMenu(self.service, "/turbo_post/avg_contours").execute(*args, **kwargs)
        def xy_plot_avg(self, *args, **kwargs):
            """
            Displays average XY plots.
            """
            return PyMenu(self.service, "/turbo_post/xy_plot_avg").execute(*args, **kwargs)
        def compute_report(self, *args, **kwargs):
            """
            Computes turbomachinery quantities.
            """
            return PyMenu(self.service, "/turbo_post/compute_report").execute(*args, **kwargs)
        def write_report(self, *args, **kwargs):
            """
            Writes the turbo report to file.
            """
            return PyMenu(self.service, "/turbo_post/write_report").execute(*args, **kwargs)

    class simulation_reports(TUIMenu):
        """
        Enter the simulation reports menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
            super().__init__(path, service)
        def rename_simulation_report(self, *args, **kwargs):
            """
            Rename a report which has already been generated.
            """
            return PyMenu(self.service, "/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
        def read_simulation_report_template_file(self, *args, **kwargs):
            """
            Read a JSON template file with existing Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
        def duplicate_simulation_report(self, *args, **kwargs):
            """
            Duplicate a report and all of its settings to a new report.
            """
            return PyMenu(self.service, "/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
        def delete_simulation_report(self, *args, **kwargs):
            """
            Delete the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
        def view_simulation_report(self, *args, **kwargs):
            """
            View a simulation report that has already been generated. In batch mode this will print the report's URL.
            """
            return PyMenu(self.service, "/simulation_reports/view_simulation_report").execute(*args, **kwargs)
        def write_report_names_to_file(self, *args, **kwargs):
            """
            Write the list of currently generated report names to a txt file.
            """
            return PyMenu(self.service, "/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
        def write_simulation_report_template_file(self, *args, **kwargs):
            """
            Write a JSON template file with this case's Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
        def reset_report_to_defaults(self, *args, **kwargs):
            """
            Reset all report settings to default for the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
        def list_simulation_reports(self, *args, **kwargs):
            """
            List all report names.
            """
            return PyMenu(self.service, "/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
        def export_simulation_report_as_html(self, *args, **kwargs):
            """
            Export the provided simulation report as HTML.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
        def export_simulation_report_as_pdf(self, *args, **kwargs):
            """
            Export the provided simulation report as a PDF file.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
        def generate_simulation_report(self, *args, **kwargs):
            """
            Generate a new simulation report or regenerate an existing simulation report with the provided name.
            """
            return PyMenu(self.service, "/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
        def export_simulation_report_as_pptx(self, *args, **kwargs):
            """
            Export the provided simulation report as a PPT file.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)

        class parametric_study(TUIMenu):
            """
            Enter the parametric study menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def generate_design_point_report(self, *args, **kwargs):
                """
                Generate a simulation report for an updated design point.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
            def generate_parametric_report(self, *args, **kwargs):
                """
                Generate a parametric report for your study.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

    class parallel(TUIMenu):
        """
        Enter the parallel processing menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.gpgpu = self.__class__.gpgpu(path + ["gpgpu"], service)
            super().__init__(path, service)
        def load_balance(self, *args, **kwargs):
            """
            Enters the load balancing parameters menu.
            """
            return PyMenu(self.service, "/parallel/load_balance").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs checks of various factors that affect parallel performance.
            """
            return PyMenu(self.service, "/parallel/check").execute(*args, **kwargs)
        def bandwidth(self, *args, **kwargs):
            """
            Shows network bandwidth.
            """
            return PyMenu(self.service, "/parallel/bandwidth").execute(*args, **kwargs)
        def show_connectivity(self, *args, **kwargs):
            """
            Prints the network connectivity for the selected compute node.
            """
            return PyMenu(self.service, "/parallel/show_connectivity").execute(*args, **kwargs)
        def thread_number_control(self, *args, **kwargs):
            """
            Thread number control.
            """
            return PyMenu(self.service, "/parallel/thread_number_control").execute(*args, **kwargs)
        def latency(self, *args, **kwargs):
            """
            Shows network latency.
            """
            return PyMenu(self.service, "/parallel/latency").execute(*args, **kwargs)
        def multidomain(self, *args, **kwargs):
            """
            Enters the multidomain architecture menu.
            """
            return PyMenu(self.service, "/parallel/multidomain").execute(*args, **kwargs)
        def timer(self, *args, **kwargs):
            """
            Enters the timer menu.
            """
            return PyMenu(self.service, "/parallel/timer").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets verbosity output of the parallel check. Higher verbosity corresponds to more detailed information.
            """
            return PyMenu(self.service, "/parallel/check_verbosity").execute(*args, **kwargs)
        def set(self, *args, **kwargs):
            """
            Enters the set parallel parameters menu.
            """
            return PyMenu(self.service, "/parallel/set").execute(*args, **kwargs)
        def partition(self, *args, **kwargs):
            """
            Enters the partition domain menu.
            """
            return PyMenu(self.service, "/parallel/partition").execute(*args, **kwargs)
        def network(self, *args, **kwargs):
            """
            Enter the network configuration menu.
            """
            return PyMenu(self.service, "/parallel/network").execute(*args, **kwargs)

        class gpgpu(TUIMenu):
            """
            Enters the GPGPU menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def show(self, *args, **kwargs):
                """
                Lists the available GPGPUs. GPGPUs selected for use are indicated by the presence of an asterisk (\*).
                """
                return PyMenu(self.service, "/parallel/gpgpu/show").execute(*args, **kwargs)
            def select(self, *args, **kwargs):
                """
                Selects which GPGPUs to use for AMG acceleration.
                """
                return PyMenu(self.service, "/parallel/gpgpu/select").execute(*args, **kwargs)

    class mesh(TUIMenu):
        """
        Enter the mesh menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.surface_mesh = self.__class__.surface_mesh(path + ["surface_mesh"], service)
            self.polyhedra = self.__class__.polyhedra(path + ["polyhedra"], service)
            self.geometry = self.__class__.geometry(path + ["geometry"], service)
            self.reorder = self.__class__.reorder(path + ["reorder"], service)
            self.adapt = self.__class__.adapt(path + ["adapt"], service)
            self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
            self.repair_improve = self.__class__.repair_improve(path + ["repair_improve"], service)
            super().__init__(path, service)
        def smooth_mesh(self, *args, **kwargs):
            """
            Smooths the mesh using quality-based, Laplacian, or skewness methods.
            """
            return PyMenu(self.service, "/mesh/smooth_mesh").execute(*args, **kwargs)
        def rotate(self, *args, **kwargs):
            """
            Rotates the mesh.
            """
            return PyMenu(self.service, "/mesh/rotate").execute(*args, **kwargs)
        def check_before_solve(self, *args, **kwargs):
            """
            The default value for mesh/check-before-solve is “no”. If mesh/check-before-solve is set to “yes”, a mesh check operation will be invoked prior to starting solver. If grid check fails, solver will be interrupted, and relevant information will be printed in the Fluent console.
            """
            return PyMenu(self.service, "/mesh/check_before_solve").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets the level of details that will be added to the mesh check report generated by mesh/check. A value of 0 (the default) notes when checks are being performed, but does not list them individually. A value of 1 lists the individual checks as they are performed. A value of 2 enables the availability of additional mesh field variables, lists the individual checks as they are performed, and provides additional details (for example, the location of the problem, the affected cells).  The check-verbosity text command can also be used to set the level of detail displayed in the mesh quality report generated by mesh/quality. A value of 0 (the default) or 1 lists the minimum orthogonal quality and the maximum aspect ratio. A value of 2 adds information about the zones that contain the cells with the lowest quality, and additional metrics such as the maximum cell squish index and the minimum expansion ratio.
            """
            return PyMenu(self.service, "/mesh/check_verbosity").execute(*args, **kwargs)
        def memory_usage(self, *args, **kwargs):
            """
            Reports solver memory use.
            """
            return PyMenu(self.service, "/mesh/memory_usage").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Set unit conversion factors.
            """
            return PyMenu(self.service, "/mesh/units").execute(*args, **kwargs)
        def show_periodic_shadow_zones(self, *args, **kwargs):
            """
            Option to show periodic shadow zones in user interface.
            """
            return PyMenu(self.service, "/mesh/show_periodic_shadow_zones").execute(*args, **kwargs)
        def translate(self, *args, **kwargs):
            """
            Prompts for the translation offset in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/translate").execute(*args, **kwargs)
        def adjacency(self, *args, **kwargs):
            """
            Views and renames face zones adjacent to selected cell  zones.
            """
            return PyMenu(self.service, "/mesh/adjacency").execute(*args, **kwargs)
        def quality(self, *args, **kwargs):
            """
            Displays information about the quality of the mesh in the console, including the minimum orthogonal quality and the maximum aspect ratio. The level of detail displayed depends on the setting specified for mesh/check-verbosity.
            """
            return PyMenu(self.service, "/mesh/quality").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs various mesh consistency checks and displays a report in the console that lists the domain extents, the volume statistics, the face area statistics, and any warnings, as well as details about the various checks and mesh failures (depending on the setting specified for mesh/check-verbosity).
            """
            return PyMenu(self.service, "/mesh/check").execute(*args, **kwargs)
        def redistribute_boundary_layer(self, *args, **kwargs):
            """
            Redistributes the nodes in a boundary layer zone to achieve a desired growth rate after anisotropic adaption.
            """
            return PyMenu(self.service, "/mesh/redistribute_boundary_layer").execute(*args, **kwargs)
        def enhanced_orthogonal_quality(self, *args, **kwargs):
            """
            Enables / disables an enhanced definition when calculating the orthogonal quality. When enabled, the orthogonal quality is defined using a variety quality measures, including: the orthogonality of a face relative to a vector between the face and cell centroids; a metric that detects poor cell shape at a local edge (such as twisting and/or concavity); and the variation of normals between the faces that can be constructed from the cell face. This enhanced definition is optimal for evaluating thin prism cells.
            """
            return PyMenu(self.service, "/mesh/enhanced_orthogonal_quality").execute(*args, **kwargs)
        def replace(self, *args, **kwargs):
            """
            Replace mesh and interpolate data.
            """
            return PyMenu(self.service, "/mesh/replace").execute(*args, **kwargs)
        def size_info(self, *args, **kwargs):
            """
            Prints mesh size.
            """
            return PyMenu(self.service, "/mesh/size_info").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            To apply standard set of units to all quantities.
            """
            return PyMenu(self.service, "/mesh/set_unit_system").execute(*args, **kwargs)
        def mesh_info(self, *args, **kwargs):
            """
            Prints zone information size.
            """
            return PyMenu(self.service, "/mesh/mesh_info").execute(*args, **kwargs)
        def scale(self, *args, **kwargs):
            """
            Prompts for the scaling factors in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/scale").execute(*args, **kwargs)
        def swap_mesh_faces(self, *args, **kwargs):
            """
            Swaps mesh faces.
            """
            return PyMenu(self.service, "/mesh/swap_mesh_faces").execute(*args, **kwargs)

        class surface_mesh(TUIMenu):
            """
            Enters the Surface Mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def read(self, *args, **kwargs):
                """
                Reads surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/read").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/display").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes surface mesh.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/delete").execute(*args, **kwargs)

        class polyhedra(TUIMenu):
            """
            Enters the polyhedra menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def convert_hanging_nodes_zones(self, *args, **kwargs):
                """
                Convert selected cell zones with hanging nodes and faces to polyhedra.
                The selected cell zones cannot be connected to other zones.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes_zones").execute(*args, **kwargs)
            def convert_hanging_nodes(self, *args, **kwargs):
                """
                Converts cells with hanging nodes/edges to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes").execute(*args, **kwargs)
            def convert_domain(self, *args, **kwargs):
                """
                Converts the entire domain to polyhedra cells.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_domain").execute(*args, **kwargs)
            def convert_skewed_cells(self, *args, **kwargs):
                """
                Converts skewed cells to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_skewed_cells").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the polyhedra options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def preserve_interior_zones(self, *args, **kwargs):
                    """
                    Enables the preservation of surfaces (that is, manifold zones of type interior) during the conversion of the domain to polyhedra. Note that only those zones with a name that includes the string you specify will be preserved.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_interior_zones").execute(*args, **kwargs)
                def migrate_and_reorder(self, *args, **kwargs):
                    """
                    Enables / disables the migration of newly created partitions to the compute-nodes and the reordering of the domain as part of polyhedra conversion. This is disabled by default, because it requires significant additional memory; when disabled, it is recommended that you save the case file after conversion, read it in a new Fluent session (so that the new / stored partitions become active), and then manually reorder using the mesh/reorder/reorder-domain text command. If you want to run the calculation in the current Fluent session you can enable the migrate-and-reorder? text command prior to conversion, but you must ensure that no more than half of the available memory of your system is currently used.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/migrate_and_reorder").execute(*args, **kwargs)
                def preserve_boundary_layer(self, *args, **kwargs):
                    """
                    Specifies whether boundary layer cells will be preserved when the domain is converted to polyhedra. When the value is set to 0 (default) ANSYS Fluent checks for high aspect ratio cells at the boundary layer and if any are found, Fluent asks if you want to preserve the boundary layer. When the value is set to 1, the boundary layer cells are never preserved; when it is set to 2, the boundary layer cells are always preserved (regardless of the aspect ratio of the boundary layer cells).
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_boundary_layer").execute(*args, **kwargs)

        class geometry(TUIMenu):
            """
            Enter the geometry menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/mesh/geometry/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/mesh/geometry/delete").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/mesh/geometry/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/mesh/geometry/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/mesh/geometry/list").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display geometry.
                """
                return PyMenu(self.service, "/mesh/geometry/display").execute(*args, **kwargs)

        class reorder(TUIMenu):
            """
            Reorders domain menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def reorder_zones(self, *args, **kwargs):
                """
                Reorders zones by partition, type, and ID.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_zones").execute(*args, **kwargs)
            def band_width(self, *args, **kwargs):
                """
                Prints cell bandwidth.
                """
                return PyMenu(self.service, "/mesh/reorder/band_width").execute(*args, **kwargs)
            def reorder_domain(self, *args, **kwargs):
                """
                Reorders cells and faces using the reverse Cuthill-McKee algorithm. Note that you must save a new case file (and a data file, if data exists) after reordering with this text command, as well as recreate any ray files and/or surface cluster information.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_domain").execute(*args, **kwargs)

        class adapt(TUIMenu):
            """
            Enters the mesh adaption menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.geometry = self.__class__.geometry(path + ["geometry"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.manage_criteria = self.__class__.manage_criteria(path + ["manage_criteria"], service)
                self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
                self.profile = self.__class__.profile(path + ["profile"], service)
                self.multi_layer_refinement = self.__class__.multi_layer_refinement(path + ["multi_layer_refinement"], service)
                super().__init__(path, service)
            def coarsening_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/coarsening_criteria").execute(*args, **kwargs)
            def display_adaption_cells(self, *args, **kwargs):
                """
                Displays the cells that are marked for adaption in the graphics window.
                """
                return PyMenu(self.service, "/mesh/adapt/display_adaption_cells").execute(*args, **kwargs)
            def list_adaption_cells(self, *args, **kwargs):
                """
                Prints the number of cells marked for refinement, coarsening, and both to the console.
                """
                return PyMenu(self.service, "/mesh/adapt/list_adaption_cells").execute(*args, **kwargs)
            def refinement_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/refinement_criteria").execute(*args, **kwargs)
            def free_hierarchy(self, *args, **kwargs):
                """
                Deletes the defined adaption hierarchy.
                """
                return PyMenu(self.service, "/mesh/adapt/free_hierarchy").execute(*args, **kwargs)
            def manual_coarsening_criteria(self, *args, **kwargs):
                """
                Set expression for manual coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_coarsening_criteria").execute(*args, **kwargs)
            def anisotropic_adaption(self, *args, **kwargs):
                """
                Applies legacy anisotropic adaption to refine the boundary layers or registers. Cells will be split in the normal direction to the boundary face. Note that this text command is only available for 3D cases that have the adaption method set to hanging node.
                """
                return PyMenu(self.service, "/mesh/adapt/anisotropic_adaption").execute(*args, **kwargs)
            def adapt_mesh(self, *args, **kwargs):
                """
                Performs manual adaption on the mesh according to the methods and settings that you specified.
                """
                return PyMenu(self.service, "/mesh/adapt/adapt_mesh").execute(*args, **kwargs)
            def manual_refinement_criteria(self, *args, **kwargs):
                """
                Set expression for manual refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_refinement_criteria").execute(*args, **kwargs)

            class geometry(TUIMenu):
                """
                Enters the geometry menu. Note that this text command menu is not available unless the adaption method is set to hanging node.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reconstruct_geometry(self, *args, **kwargs):
                    """
                    Enables/disables geometry-based adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/reconstruct_geometry").execute(*args, **kwargs)
                def set_geometry_controls(self, *args, **kwargs):
                    """
                    Sets geometry controls for wall zones.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/set_geometry_controls").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def anisotropic_split_ratio(self, *args, **kwargs):
                    """
                    Sets the split ratio for the cells as part of anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_split_ratio").execute(*args, **kwargs)
                def display_settings(self, *args, **kwargs):
                    """
                    Sets the graphics display options for the refinement, coarsening, and common cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/display_settings").execute(*args, **kwargs)
                def cell_zones(self, *args, **kwargs):
                    """
                    Sets cell zones to be used for marking adaption. An empty list specifies that all zones are considered for adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/cell_zones").execute(*args, **kwargs)
                def dynamic_adaption(self, *args, **kwargs):
                    """
                    Adapt the mesh during solution.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption").execute(*args, **kwargs)
                def anisotropic_boundary_zones(self, *args, **kwargs):
                    """
                    Allows you to select the boundary zones that specify directions for anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_boundary_zones").execute(*args, **kwargs)
                def dynamic_adaption_frequency(self, *args, **kwargs):
                    """
                    Set frequency for dynamic adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption_frequency").execute(*args, **kwargs)
                def overset_adapt_dead_cells(self, *args, **kwargs):
                    """
                    Enables/disables the adaption of dead cells in overset meshes.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/overset_adapt_dead_cells").execute(*args, **kwargs)
                def minimum_edge_length(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the edge length for cells that are considered for refinement. Even if a cell is marked for refinement, it will not be refined if (for 3D) its volume is less than the cube of this field or (for 2D) its area is less than the square of this field. The default value of zero places no limits on the size of cells that are refined.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_edge_length").execute(*args, **kwargs)
                def minimum_cell_quality(self, *args, **kwargs):
                    """
                    Sets the minimum value allowed for the orthogonal quality of cells during adaption. If your solution diverges, you may find that using a higher minimum quality value resolves the issue. This text command is only available with the PUMA 3D adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_cell_quality").execute(*args, **kwargs)
                def maximum_cell_count(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the total cell count of the mesh during adaption. Fluent uses this value to determine when to stop marking cells for refinement. A value of zero places no limits on the number of cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_cell_count").execute(*args, **kwargs)
                def maximum_refinement_level(self, *args, **kwargs):
                    """
                    Controls the number of levels of refinement used to split cells during the adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Allows you set how much information about the adaption is printed to the console.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/verbosity").execute(*args, **kwargs)
                def additional_refinement_layers(self, *args, **kwargs):
                    """
                    Allows you to specify additional refinement layers (this is an advanced control).
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/additional_refinement_layers").execute(*args, **kwargs)
                def anisotropic_adaption(self, *args, **kwargs):
                    """
                    Enables / disables anisotropic adaption for prismatic cells as part of manual adaption. Note that this text command requires that the adaption method is set to PUMA.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_adaption").execute(*args, **kwargs)
                def encapsulate_children(self, *args, **kwargs):
                    """
                    Encapsulate all children of parent cells on the same partition.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/encapsulate_children").execute(*args, **kwargs)
                def method(self, *args, **kwargs):
                    """
                    Sets the adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/method").execute(*args, **kwargs)

            class manage_criteria(TUIMenu):
                """
                Enters the manage criteria menu, which provides text commands for managing automatic adaption criteria.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all the existing automatic adaption criteria.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Adds a new automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/add").execute(*args, **kwargs)

            class cell_registers(TUIMenu):
                """
                Enters the cell registers menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def apply_poor_mesh_numerics(self, *args, **kwargs):
                    """
                    Applies poor mesh numerics to the mesh of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/edit").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Displays a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/display").execute(*args, **kwargs)
                def refine(self, *args, **kwargs):
                    """
                    Refine the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/refine").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/add").execute(*args, **kwargs)
                def coarsen(self, *args, **kwargs):
                    """
                    Coarsen the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/coarsen").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all of the currently defined cell registers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list_properties").execute(*args, **kwargs)
                def adapt(self, *args, **kwargs):
                    """
                    Adapt cell register objects.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/adapt").execute(*args, **kwargs)

            class profile(TUIMenu):
                """
                Enters the profile menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear(self, *args, **kwargs):
                    """
                    Clears the adaption profiling counters.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/clear").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/disable").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Prints adaption profiling results.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/print").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/enable").execute(*args, **kwargs)

            class multi_layer_refinement(TUIMenu):
                """
                Enter the multiple boundary layer refinement menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def parameters(self, *args, **kwargs):
                    """
                    Specify parameters for multiple boundary layer refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/parameters").execute(*args, **kwargs)
                def refine_mesh(self, *args, **kwargs):
                    """
                    Refine the mesh for multiple boundary layers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/refine_mesh").execute(*args, **kwargs)
                def boundary_zones(self, *args, **kwargs):
                    """
                    Specify boundary zones for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/boundary_zones").execute(*args, **kwargs)
                def layer_count(self, *args, **kwargs):
                    """
                    Specify the layer count for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/layer_count").execute(*args, **kwargs)

        class modify_zones(TUIMenu):
            """
            Enters the zone modification menu. For a description of the items in this menu, see define/boundary-conditions/modify-zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def extrude_face_zone_delta(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a list of deltas.
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
            def delete_cell_zone(self, *args, **kwargs):
                """
                Delete a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_cell_zone").execute(*args, **kwargs)
            def delete_all_shells(self, *args, **kwargs):
                """
                Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_all_shells").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_type").execute(*args, **kwargs)
            def sep_cell_zone_region(self, *args, **kwargs):
                """
                Separate a cell zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
            def sep_face_zone_angle(self, *args, **kwargs):
                """
                Separate a face zone based on significant angle.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
            def append_mesh(self, *args, **kwargs):
                """
                Append new mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh").execute(*args, **kwargs)
            def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                """
                Change all solid zones motion specification from MRF to solid motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
            def copy_move_cell_zone(self, *args, **kwargs):
                """
                Copy and translate or rotate a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
            def sep_face_zone_mark(self, *args, **kwargs):
                """
                Separate a face zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
            def matching_tolerance(self, *args, **kwargs):
                """
                Set the normalized tolerance used for finding coincident nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/matching_tolerance").execute(*args, **kwargs)
            def append_mesh_data(self, *args, **kwargs):
                """
                Append new mesh with data.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh_data").execute(*args, **kwargs)
            def activate_cell_zone(self, *args, **kwargs):
                """
                Activate a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/activate_cell_zone").execute(*args, **kwargs)
            def mrf_to_sliding_mesh(self, *args, **kwargs):
                """
                Change motion specification from MRF to moving mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
            def change_zone_phase(self, *args, **kwargs):
                """
                Change the realgas phase for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_phase").execute(*args, **kwargs)
            def recreate_all_shells(self, *args, **kwargs):
                """
                Create shell on all the walls where which were deleted using the command delete-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/recreate_all_shells").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/mesh/modify_zones/list_zones").execute(*args, **kwargs)
            def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Attempt to establish conformal periodic face zone connectivity.
                """
                return PyMenu(self.service, "/mesh/modify_zones/make_periodic").execute(*args, **kwargs)
            def rotate_zone(self, *args, **kwargs):
                """
                Rotate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/rotate_zone").execute(*args, **kwargs)
            def slit_interior_between_diff_solids(self, *args, **kwargs):
                """
                Slit interior created between different solids into coupled walls.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
            def orient_face_zone(self, *args, **kwargs):
                """
                Orient the face zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/orient_face_zone").execute(*args, **kwargs)
            def sep_face_zone_face(self, *args, **kwargs):
                """
                Separate each face in a zone into unique zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
            def fuse_face_zones(self, *args, **kwargs):
                """
                Attempt to fuse zones by removing duplicate faces and nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/fuse_face_zones").execute(*args, **kwargs)
            def deactivate_cell_zone(self, *args, **kwargs):
                """
                Deactivate cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
            def create_periodic_interface(self, *args, **kwargs):
                """
                Create a conformal or non-conformal periodic interface.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_periodic_interface").execute(*args, **kwargs)
            def sep_cell_zone_mark(self, *args, **kwargs):
                """
                Separate a cell zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
            def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
            def scale_zone(self, *args, **kwargs):
                """
                Scale nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/scale_zone").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_name").execute(*args, **kwargs)
            def create_all_shell_threads(self, *args, **kwargs):
                """
                Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
            def extrude_face_zone_para(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
            def translate_zone(self, *args, **kwargs):
                """
                Translate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/translate_zone").execute(*args, **kwargs)
            def replace_zone(self, *args, **kwargs):
                """
                Replace a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/replace_zone").execute(*args, **kwargs)
            def sep_face_zone_region(self, *args, **kwargs):
                """
                Separate a face zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
            def slit_face_zone(self, *args, **kwargs):
                """
                Slit a two-sided wall into two connected wall zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_face_zone").execute(*args, **kwargs)
            def slit_periodic(self, *args, **kwargs):
                """
                Slit a periodic zone into two symmetry zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_periodic").execute(*args, **kwargs)
            def merge_zones(self, *args, **kwargs):
                """
                Merge zones of the same type and condition into one.
                """
                return PyMenu(self.service, "/mesh/modify_zones/merge_zones").execute(*args, **kwargs)
            def change_zone_state(self, *args, **kwargs):
                """
                Change the realgas material state for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_state").execute(*args, **kwargs)

        class repair_improve(TUIMenu):
            """
            Enter the repair and improve quality menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def repair_face_node_order(self, *args, **kwargs):
                """
                Modifies face nodes to repair faces with improper face node order and, therefore, eliminates any resulting left-handed faces.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_node_order").execute(*args, **kwargs)
            def allow_repair_at_boundaries(self, *args, **kwargs):
                """
                Allows the adjustment of the positions of nodes on boundaries as part of the mesh repairs performed by the mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/allow_repair_at_boundaries").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improves poor quality cells in the mesh, if possible.
                """
                return PyMenu(self.service, "/mesh/repair_improve/improve_quality").execute(*args, **kwargs)
            def repair_periodic(self, *args, **kwargs):
                """
                Modifies the mesh to enforce a rotational angle or translational distance for periodic boundaries. For translationally periodic boundaries, the command computes an average translation distance and adjusts the node coordinates on the shadow face zone to match this distance. For rotationally periodic boundaries, the command prompts for an angle and adjusts the node coordinates on the shadow face zone using this angle and the defined rotational axis for the cell zone.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_periodic").execute(*args, **kwargs)
            def include_local_polyhedra_conversion_in_repair(self, *args, **kwargs):
                """
                Enables/disables the local conversion of degenerate cells into polyhedra based on skewness criteria as part of the mesh repairs performed by the  mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/include_local_polyhedra_conversion_in_repair").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_wall_distance").execute(*args, **kwargs)
            def repair_face_handedness(self, *args, **kwargs):
                """
                Modifies cell centroids to repair meshes that contain left-handed faces without face node order problems.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_handedness").execute(*args, **kwargs)
            def repair(self, *args, **kwargs):
                """
                Repairs mesh problems identified by the mesh check, if possible. The repairs include fixing cells that have the wrong node order, the wrong face handedness, faces that are small or nonexistent, or very poor quality. Only interior nodes are repositioned by default; boundary nodes may be repositioned if the  mesh/repair-improve/allow-repair-at-boundaries text command is enabled. Note that highly skewed cells may be converted into polyhedra, depending on whether the  mesh/repair-improve/include-local-polyhedra-conversion-in-repair text command is enabled.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair").execute(*args, **kwargs)
            def report_poor_elements(self, *args, **kwargs):
                """
                Reports invalid and poor quality elements.
                """
                return PyMenu(self.service, "/mesh/repair_improve/report_poor_elements").execute(*args, **kwargs)

    class solve(TUIMenu):
        """
        Enter the solve menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.report_files = self.__class__.report_files(path + ["report_files"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            super().__init__(path, service)
        def patch(self, *args, **kwargs):
            """
            Patches a value for a flow variable in the domain. You can either provide a numerical value, which you can enter directly, or you can enter an expression, which must be entered within quotation marks.
            """
            return PyMenu(self.service, "/solve/patch").execute(*args, **kwargs)
        def dpm_update(self, *args, **kwargs):
            """
            Updates discrete phase source terms.
            """
            return PyMenu(self.service, "/solve/dpm_update").execute(*args, **kwargs)
        def mesh_motion(self, *args, **kwargs):
            """
            Performs mesh motion.
            """
            return PyMenu(self.service, "/solve/mesh_motion").execute(*args, **kwargs)
        def update_physical_time(self, *args, **kwargs):
            """
            Advances the unsteady solution to the next physical time level. Using this command in conjunction with theiterate command allows you to manually advance the solution in time (rather than doing it automatically with the dual-time-iterate command).
            """
            return PyMenu(self.service, "/solve/update_physical_time").execute(*args, **kwargs)
        def multistage_time_iterate(self, *args, **kwargs):
            """
            Perform unsteady iterations.
            """
            return PyMenu(self.service, "/solve/multistage_time_iterate").execute(*args, **kwargs)
        def iterate_steady_2way_fsi(self, *args, **kwargs):
            """
            Perform a specified number of steps.
            """
            return PyMenu(self.service, "/solve/iterate_steady_2way_fsi").execute(*args, **kwargs)
        def iterate(self, *args, **kwargs):
            """
            Performs a specified number of iterations.  This option is still available during transient simulations, since it can be used to add more iterations to the same time step after interrupting iterations within a time step.
            """
            return PyMenu(self.service, "/solve/iterate").execute(*args, **kwargs)
        def convergence_conditions(self, *args, **kwargs):
            """
            Enters the convergence conditions menu.
            """
            return PyMenu(self.service, "/solve/convergence_conditions").execute(*args, **kwargs)
        def dual_time_iterate(self, *args, **kwargs):
            """
            Performs unsteady iterations for a specified number of time steps.
            """
            return PyMenu(self.service, "/solve/dual_time_iterate").execute(*args, **kwargs)

        class report_files(TUIMenu):
            """
            Enters the report files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def edit(self, *args, **kwargs):
                """
                Edits a report file.
                """
                return PyMenu(self.service, "/solve/report_files/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report file.
                """
                return PyMenu(self.service, "/solve/report_files/list_properties").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report file object.
                """
                return PyMenu(self.service, "/solve/report_files/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report files.
                """
                return PyMenu(self.service, "/solve/report_files/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report file.
                """
                return PyMenu(self.service, "/solve/report_files/add").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report file objects.
                """
                return PyMenu(self.service, "/solve/report_files/delete_all").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report file.
                """
                return PyMenu(self.service, "/solve/report_files/clear_data").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Enters the report definitions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def edit(self, *args, **kwargs):
                """
                Edits a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/edit").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Creates a copy of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/copy").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/compute").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report definition objects.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete_all").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/report_definitions/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report definitions.
                """
                return PyMenu(self.service, "/solve/report_definitions/list").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Renames a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/rename").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enters the set solution parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.enhanced_les_numerics = self.__class__.enhanced_les_numerics(path + ["enhanced_les_numerics"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                super().__init__(path, service)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/adaptive_time_stepping").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Sets the reference density method for the Eulerian multiphase model. The following options are available:
                0 (default): Averaged density of the phase
                1: Cell density of the phase
                1: Constant value of 1
                1: Cell density of the phase
                See  for more information.
                """
                return PyMenu(self.service, "/solve/set/mp_reference_density").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enters the residual tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/residual_tolerance").execute(*args, **kwargs)
            def reactions(self, *args, **kwargs):
                """
                Enables the species reaction sources and sets relaxation factor.
                """
                return PyMenu(self.service, "/solve/set/reactions").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Sets the solution methods to the default settings.
                """
                return PyMenu(self.service, "/solve/set/set_solution_methods_to_default").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Sets solution steering parameters.
                """
                return PyMenu(self.service, "/solve/set/set_solution_steering").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Sets the order in which the model equations are solved, which can affect the convergence speed when you are using the pressure-based solver. The standard method is enabled by default and corresponds to the ordering shown in  and  in the Theory Guide; alternatively, you can select theoptimized-for-volumetric-expansion method, which is recommended for flows in which the density is strongly dependent on thermal effects, chemical composition, and so on (such as combustion simulations). This text command is not available for steady simulations and/or when a multiphase model is enabled.
                """
                return PyMenu(self.service, "/solve/set/equation_ordering").execute(*args, **kwargs)
            def multi_grid_controls(self, *args, **kwargs):
                """
                Sets multigrid parameters and termination criteria.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_controls").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension_expert").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Sets the number of iterations for which convergence monitors are reported. The default is 1 (after every iteration).
                """
                return PyMenu(self.service, "/solve/set/reporting_interval").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enables solution steering for the density-based solver.
                """
                return PyMenu(self.service, "/solve/set/solution_steering").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Sets anisotropic drag parameters for the Eulerian multiphase model.
                """
                return PyMenu(self.service, "/solve/set/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Sets gradient options.
                """
                return PyMenu(self.service, "/solve/set/gradient_scheme").execute(*args, **kwargs)
            def enable_output_dp_dt(self, *args, **kwargs):
                """
                Controls whether the output field variabledp-dt will be available for transient simulation postprocessing. If you select no, pressure fields at the previous time steps will not be stored in memory which reduces memory usage.
                """
                return PyMenu(self.service, "/solve/set/enable_output_dp_dt").execute(*args, **kwargs)
            def relaxation_method(self, *args, **kwargs):
                """
                Sets the solver relaxation method.
                """
                return PyMenu(self.service, "/solve/set/relaxation_method").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when reversed flow occurs at inlets and outlets, and when mass-flow inlets develop supersonic regions. By default, flow warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/flow_warnings").execute(*args, **kwargs)
            def multi_stage(self, *args, **kwargs):
                """
                Sets the multi-stage coefficients and the dissipation and viscous evaluation stages. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_stage").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Sets all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solve/set/set_all_species_together").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Sets the sub time step calculation method for VOF calculations.
                """
                return PyMenu(self.service, "/solve/set/vof_explicit_controls").execute(*args, **kwargs)
            def multi_grid_fas(self, *args, **kwargs):
                """
                Sets the parameters that control the FAS multigrid solver. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_fas").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Specifies whether you want to lock (or “freeze”) the temperature values for all the cells in solid zones (including those to which you have a hooked an energy source through a UDF) and in walls that have shell conduction enabled, so that the values do not change during further solver iterations.
                """
                return PyMenu(self.service, "/solve/set/lock_solid_temperature").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Enables data sampling for steady or unsteady flow statistics.
                """
                return PyMenu(self.service, "/solve/set/data_sampling").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Sets solver limits for various solution variables, in order to improve the stability of the solution.
                """
                return PyMenu(self.service, "/solve/set/limits").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Sets pressure-velocity controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls").execute(*args, **kwargs)
            def p_v_controls_advanced(self, *args, **kwargs):
                """
                Set advanced pressure-velocity coupling controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls_advanced").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solve/set/time_step").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enters the under-relaxation menu, which allows you to set the under-relaxation factor for each equation that is being solved in a segregated manner.
                """
                return PyMenu(self.service, "/solve/set/under_relaxation").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enables a modified NITA scheme and other setting changes that can speed up the simulation. This option is only available with the Large Eddy Simulation (LES) turbulence model, and is intended for unreacting flow simulations that use a constant-density fluid.
                """
                return PyMenu(self.service, "/solve/set/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Sets phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solve/set/phase_based_vof_discretization").execute(*args, **kwargs)
            def moving_mesh_numerics(self, *args, **kwargs):
                """
                Transient options for sliding, moving, and/or dynamic mesh.
                """
                return PyMenu(self.service, "/solve/set/moving_mesh_numerics").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enters the discretization scheme menu. This allows you to select the discretization scheme for the convection terms in the solution equations. The following text commands can make a selection from a subset of the models in the following table:.
                """
                return PyMenu(self.service, "/solve/set/discretization_scheme").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/variable_time_stepping").execute(*args, **kwargs)
            def slope_limiter_set(self, *args, **kwargs):
                """
                Selects a new Fluent solver slope limiter.
                """
                return PyMenu(self.service, "/solve/set/slope_limiter_set").execute(*args, **kwargs)
            def numerics(self, *args, **kwargs):
                """
                Sets numerics options.
                """
                return PyMenu(self.service, "/solve/set/numerics").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                For flows that do not transition from sub-critical to super-critical, or vice-versa, you can speed-up the solution calculation by updating the frequency of Froude number during run time.
                """
                return PyMenu(self.service, "/solve/set/open_channel_controls").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enables convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solve/set/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Sets VOF numeric options.
                """
                return PyMenu(self.service, "/solve/set/vof_numerics").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Sets solver options for stiff chemistry solutions.
                """
                return PyMenu(self.service, "/solve/set/stiff_chemistry").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Sets pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solve/set/bc_pressure_extrapolations").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Completely disables reconstruction, resulting in totally first-order accuracy.
                """
                return PyMenu(self.service, "/solve/set/disable_reconstruction").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Switches between the modified treatment of node-based gradients at boundary cells and the legacy treatment (R14.5.7 and earlier). If using the density-based solver, you can also specify the extended treatment. For details, see .
                """
                return PyMenu(self.service, "/solve/set/nb_gradient_boundary_option").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Enables / disables the variable time step size formulation for second-order implicit transient formulations. If you disable the variable time step size formulation, note that any change in the time step size will introduce an error proportional to the change in the time step size ratio.
                """
                return PyMenu(self.service, "/solve/set/second_order_time_options").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Sets the number of iterations for a steady-state simulation without starting the calculation.
                """
                return PyMenu(self.service, "/solve/set/number_of_iterations").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enters the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solve/set/relaxation_factor").execute(*args, **kwargs)
            def expert(self, *args, **kwargs):
                """
                Sets expert options.
                """
                return PyMenu(self.service, "/solve/set/expert").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Selects the equations to be solved.
                """
                return PyMenu(self.service, "/solve/set/equations").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when quantities are being limited. By default, limiter warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/limiter_warnings").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def multi_grid_amg(self, *args, **kwargs):
                """
                Sets the parameters that govern the algebraic multigrid procedure.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_amg").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Sets the amount of residual information to be printed. A value of 0 (the default) prints residuals at the end of each fine grid iteration. A value of 1 prints residuals after every stage of the fine grid iteration. A value of 2 prints residuals after every stage on every grid level.
                """
                return PyMenu(self.service, "/solve/set/residual_verbosity").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Selects which pressure-velocity coupling scheme is to be used. Five schemes are available:.
                """
                return PyMenu(self.service, "/solve/set/p_v_coupling").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Sets the heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/solve/set/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solve/set/flux_type").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Sets surface-tension calculation options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Sets the fine-grid Courant number (time step factor). This command is available only for the coupled solvers.
                """
                return PyMenu(self.service, "/solve/set/courant_number").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enters the max-corrections menu.
                """
                return PyMenu(self.service, "/solve/set/max_corrections").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Sets damping function in flow direction. This command appears only when the VOF model is enabled. Select the damping function to be used:
                Index
                Damping Function
                0
                Linear
                1
                Quadratic
                2
                Cubic
                3
                Cosine.
                """
                return PyMenu(self.service, "/solve/set/numerical_beach_controls").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Sets controls to default values.
                """
                return PyMenu(self.service, "/solve/set/set_controls_to_default").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solve/set/material_property_warnings").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Sets the implicit residual smoothing parameters. This command is available only for the explicit coupled solver.
                """
                return PyMenu(self.service, "/solve/set/residual_smoothing").execute(*args, **kwargs)
            def correction_tolerance(self, *args, **kwargs):
                """
                Enters the correction tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/correction_tolerance").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enters the poor mesh numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Resets the list of poor cells included by the default, cell quality, user-defined, cell gradient quality, and solution and cell quality criteria.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the cell gradient quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command. This criterion is only available with the pressure-based solver, and is not supported for cases that have periodic boundaries.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def user_defined_on_register_auto(self, *args, **kwargs):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Sets the orthogonal quality threshold used for applying poor mesh numerics when the solve/set/poor-mesh-numerics/cell-quality-based? text command is enabled. By default, cells with an orthogonal quality of 0.05 or lower are corrected.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the solution and cell quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command, and at a specified frequency (of iterations or time steps). This criterion is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Includes a register for the poor mesh numerics or not.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells (those with an orthogonal quality of 0, as well as those identified by other enabled criteria), and defines whether the local solution correction is 0th, 1st, or 2nd order.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Prints out a listing of the poor cells for each criterion: default, cell quality, and user-defined, and (if enabled) cell gradient quality and solution and cell quality.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells with an orthogonal quality that is equal to or less than the threshold defined by the solve/set/poor-mesh-numerics/set-quality-threshold text command (which by default is set to 0.05).
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Enables/disables the relocation of select cell centroids, to improve the orthogonality metrics and solution stability. It is applied to cells when the criterion value is equal to or less than a threshold value defined as part of the text command. Note that the enhanced metrics are only apparent when reporting the quality in the solution mode of Fluent, and not in the meshing mode.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)

            class fast_transient_settings(TUIMenu):
                """
                Enters the fast transient settings menu. This menu is only available for transient cases that use the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rk2(self, *args, **kwargs):
                    """
                    Allows you to enable the use of a two-stage Runge-Kutta scheme for time integration, or revert to the default multi-stage Runge-Kutta scheme. This text command is only available for transient cases that use the density-based explicit formulation.
                    """
                    return PyMenu(self.service, "/solve/set/fast_transient_settings/rk2").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enters the menu to specify parameters of the acoustics wave equation solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the menu to specify the expert parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the explicit relaxation factor. Should be used only with  bad meshes, when iterations do not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the implicit under-relaxation factor. Should be used only  with bad meshes, when the AMG linear solver does not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Sets multiphase numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    super().__init__(path, service)

                class boiling_parameters(TUIMenu):
                    """
                    Enters the menu for the multiphase boiling model parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def thin_film(self, *args, **kwargs):
                        """
                        When enabled, includes multiphase boiling thin film effects using .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        When enabled, considers liquid volume fraction effects by multiplying the heat transfer coefficients by the local liquid volume fraction.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Enters the compressible multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Enables an enhanced numerical treatment that provides better  stability at startup and during calculation of compressible  flows.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Enables an alternative formulation for compressible phases at an  inlet boundary. This formulation calculates static temperature and  pressure using an iterative method based on fundamental thermodynamic  relations.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Enters the viscous multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Forces harmonic averaging of cell viscosities to calculate face  viscosity used in momentum equation. This can improve convergence for  highly viscous flow applications (the VOF model only).
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Enters the porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Allows you to fix the saturation (volume fraction) of the phase at  its user-specified residual saturation value.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Enters the menu for the stability controls for multiphase flows. For more information about the below option, see  and .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.num_ventilation = self.__class__.num_ventilation(path + ["num_ventilation"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        super().__init__(path, service)

                    class hybrid_nita(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Allows you to change the number of initial time-steps and the number of initial outer iterations to control solution stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Sets the number of outer iterations.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Enters the menu for the instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Sets the velocity limit for detecting unstable events.  This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Sets the number of outer iterations for an unstable  event.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enables/disables the instability detector to deal with  possible instability problems. Once this option is enabled,  additional instability detection options become  available.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Sets the Courant number limit for detecting unstable  events. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Selects the CFL number type for detection of an unstable  event. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Enters the anti-diffusion menu. This item is available for VOF cases  with the Interfacial Anti-Diffusion option  enabled.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Sets the cosine exponent in the dynamic strength treatment in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Sets the maximum value of dynamic anti-diffusion strength in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enables dynamic strength to reduce compression in the direction tangential to the interface.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            When enabled, solves the flow equation at the end of the iteration. This improves the behavior at the start of new time-step if the solution does not converge properly.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)

                    class num_ventilation(TUIMenu):
                        """
                        Numerical Ventilation Menu for VOF Model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def trapped_phase_vof_min(self, *args, **kwargs):
                            """
                            Set trapped phase minimum volume fraction to activate numerical ventilation treatment for trapped phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_min").execute(*args, **kwargs)
                        def tau_estimation_options(self, *args, **kwargs):
                            """
                            Set time step size option for numerical ventilation treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/tau_estimation_options").execute(*args, **kwargs)
                        def near_wall_treatment_options(self, *args, **kwargs):
                            """
                            Set near wall treatment options.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/near_wall_treatment_options").execute(*args, **kwargs)
                        def trapped_phase_vof_max(self, *args, **kwargs):
                            """
                            Set trapped phase maximum volume fraction to activate numerical ventilation treatment for non-trapped phases.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_max").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enable numerical ventilation treatment to remove trapped phase adjacent to wall.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/enable").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Enters the menu for the pressure-velocity coupling controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            super().__init__(path, service)

                        class coupled_vof(TUIMenu):
                            """
                            Enters the stability control menu for VOF cases that involve the Coupled pressure-velocity coupling scheme.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Allows you to use the linearized buoyancy force and the  blended treatment for the buoyancy force.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Enters the stability controls menu for the Rhie-Chow interpolation.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Enables/disables the low-order velocity interpolation in  the flux calculation.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class skewness_correction(TUIMenu):
                            """
                            Enters the skewness correction menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Enables/disables the limited pressure correction  gradient in skewness terms for the PISO, SIMPLEC, or  fractional step pressure-coupling schemes.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Enters the default controls menu. This menu is available only for multiphase flows.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Applies the multiphase defaults (version 2020 R1) to the loaded case  file.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    Enters the solution-stabilization numerics menu. This item is available only for the VOF model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        super().__init__(path, service)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        When enabled, modifies solver settings for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        When enabled, uses additional controls for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Enters the menu for the velocity-limiting-treatment.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            When enabled, the solver prints the number of velocity limited cells at each iteration.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Specifies the maximum velocity magnitude.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enables/disables the velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Enters the menu for additional advanced stability controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Enables/disables the blended compressive discretization scheme.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Enters the menu for the multiphase heat mass transfer parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Enables the alternative treatment of the energy sources. For more  information, see .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Enters the cavitation heat mass transfer menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Sets the minimum vapor pressure limit for the cavitation mass-transfer model. The default value is 1 Pa.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enables/disables the turbulent diffusion treatment for a cavitating turbulent flow. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Sets the evaporation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 1.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the vapor pressure after the turbulence and thermal correction. The default value is five times the vapor pressure, with consideration of turbulent and thermal effects for each cell and phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Sets the condensation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 0.2.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Enters the menu for the advanced boiling options for the  semi-mechanistic boiling model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Enables/disables the two-resistance boiling framework to improve the robustness and accuracy of the solution of cases with multiple boiling mechanisms. For more information about this item, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes the expert options for the semi-mechanistic boiling model. For more information about these options, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Sets the under-relaxation factor for boiling heat flux. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Enters the menu for the area density.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Enables/disables the interfacial area density Gradient-Symmetric model. For more information about this model, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Sets the minimum volume fraction for the area density and cavitation. This may be useful, for example, in cases when a species mass transfer model (such as the Symmetric model or Particle model) do not consider evaporation or condensation if the volume fraction of one of the phases is zero. The seeding allows for a phase change to occur in the fluid flow. The default value is 1e-6.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    super().__init__(path, service)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/verbosity").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enters the warped-face gradient correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables gradient enhancement computations and specifies whether Fluent uses fast or memory saving mode.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Provides text commands that allow you to undo enhancements to the default solver behavior.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R3 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2022 R1 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_2023r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2023R1.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2023r1_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2021 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2021 R2 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)

            class amg_options(TUIMenu):
                """
                Enters the AMG options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def conservative_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of conservative coarsening techniques for scalar and/or coupled equations that can improve parallel performance and/or convergence for some difficult cases.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                def amg_gpgpu_options(self, *args, **kwargs):
                    """
                    Set GPGPU AMG solver options.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                def laplace_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables Laplace coarsening for scalar and/or coupled equations.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/laplace_coarsening").execute(*args, **kwargs)
                def aggressive_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of a version of the AMG solver that is optimized for high coarsening rates. This option is recommended if the AMG solver diverges with the default settings.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def expert(self, *args, **kwargs):
                    """
                    Sets the level of stabilization used to achieve fast convergence. Enter a number 0-5 corresponding to the Mach number range that best characterizes the flow.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/expert").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Speed Numerics.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/enable").execute(*args, **kwargs)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Makes available the Pressure Discontinuity Sensor which is a binary identifier equal to 1 if a cell is in proximity of a pressure discontinuity.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enters the NITA expert control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Enables/disables coupling of the neighbor and skewness corrections.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Setting this to 1, enables the verbosity for NITA diagnostics. The default value of 0 disables verbosity output for NITA diagnostics.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/set_verbosity").execute(*args, **kwargs)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Enables and sets hybrid NITA options. For more details, see .
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)

            class enhanced_les_numerics(TUIMenu):
                """
                Enter enhanced LES options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def optimized_cd(self, *args, **kwargs):
                    """
                    Use optimized central difference discretization.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_cd").execute(*args, **kwargs)
                def optimized_algorithm(self, *args, **kwargs):
                    """
                    Use solver algorithm optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_algorithm").execute(*args, **kwargs)
                def optimized_advection(self, *args, **kwargs):
                    """
                    Use advection scheme optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_advection").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enters the divergence prevention menu. This menu is only available for the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables a divergence prevention option so that Fluent applies under-relaxation to the variables in select cells where the temperature and/or pressure values are approaching the minimum and/or maximum limits.
                    """
                    return PyMenu(self.service, "/solve/set/divergence_prevention/enable").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solve/set/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets the relaxation factor.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Selects the variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Enter the menu for specifying quantities and zones for steady and unsteady flow statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dft_datasets = self.__class__.dft_datasets(path + ["dft_datasets"], service)
                    super().__init__(path, service)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    Lists the combinations of zones and quantities that are defined for sampling steady and unsteady flow statistics.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/list_datasets").execute(*args, **kwargs)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Specify zone and quantity combinations for sampling Fourier coefficients of unsteady flows.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)

                class dft_datasets(TUIMenu):
                    """
                    Data sampling options for runtime discrete Fourier transform.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def freq_step_and_sampling(self, *args, **kwargs):
                        """
                        Specify either the band resolution or the sampling timesteps number. The other value will be computed consistently.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_step_and_sampling").execute(*args, **kwargs)
                    def quantities(self, *args, **kwargs):
                        """
                        Select quantities for a new DFT dataset. Enter () to complete the quantity selection.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/quantities").execute(*args, **kwargs)
                    def band_or_tone(self, *args, **kwargs):
                        """
                        Specify, whether a new dataset is for DFT in a frequency band resolved by many harmonics or for a single tone.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/band_or_tone").execute(*args, **kwargs)
                    def freq_tone_and_sampling(self, *args, **kwargs):
                        """
                        Specify single tone frequency and sampling duration as the number of tone periods.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_tone_and_sampling").execute(*args, **kwargs)
                    def add_datasets(self, *args, **kwargs):
                        """
                        Add DFT datasets.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/add_datasets").execute(*args, **kwargs)
                    def freq_min_max(self, *args, **kwargs):
                        """
                        Specify the minimum and the maximum frequency for a band.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_min_max").execute(*args, **kwargs)
                    def zones(self, *args, **kwargs):
                        """
                        Select zones for a new DFT dataset.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/zones").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Enters the advanced settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                    self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                    self.turbomachinery_specific_numerics = self.__class__.turbomachinery_specific_numerics(path + ["turbomachinery_specific_numerics"], service)
                    super().__init__(path, service)
                def correction_form(self, *args, **kwargs):
                    """
                    S.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/correction_form").execute(*args, **kwargs)
                def singhal_et_al_cavitation_model(self, *args, **kwargs):
                    """
                    Enables/disables the availability of the Singhal et al. cavitation model option, which can then be enabled in the Multiphase Model dialog box or by using the following text command: define/phases/set-domain-properties/interaction-domain/heat-mass-reaction/cavitation/cavitation?.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/singhal_et_al_cavitation_model").execute(*args, **kwargs)
                def skewness_correction_enhanced(self, *args, **kwargs):
                    """
                    Enable enhanced skewness correction scheme.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/skewness_correction_enhanced").execute(*args, **kwargs)
                def alternate_wall_temp_formulation(self, *args, **kwargs):
                    """
                    Enables/disables an alternate formulation for wall temperatures.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/alternate_wall_temp_formulation").execute(*args, **kwargs)
                def energy_reconstruction_gradient_limiting(self, *args, **kwargs):
                    """
                    Enable limiting of reconstruction gradient for the energy equation.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_reconstruction_gradient_limiting").execute(*args, **kwargs)
                def anisotropic_solid_heat_transfer(self, *args, **kwargs):
                    """
                    Set up the heat transfer for anisotropic solid zones.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/anisotropic_solid_heat_transfer").execute(*args, **kwargs)
                def explicit_under_relaxation_value(self, *args, **kwargs):
                    """
                    Explicit under-relaxation value.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/explicit_under_relaxation_value").execute(*args, **kwargs)
                def retain_temporary_solver_mem(self, *args, **kwargs):
                    """
                    Enables/disables the retention of temporary solver memory, which retains gradient data and makes some advanced options available for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_temporary_solver_mem").execute(*args, **kwargs)
                def show_all_discretization_schemes(self, *args, **kwargs):
                    """
                    Enables/disables the availability of all applicable discretization schemes.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/show_all_discretization_schemes").execute(*args, **kwargs)
                def linearized_mass_transfer_udf(self, *args, **kwargs):
                    """
                    Enables/disables the use of a linearized mass transfer user-defined function (that is, the DEFINE_LINEARIZED_MASS_TRANSFER macro), as opposed to a mass transfer user-defined function (that is, the DEFINE_MASS_TRANSFER macro).
                    """
                    return PyMenu(self.service, "/solve/set/advanced/linearized_mass_transfer_udf").execute(*args, **kwargs)
                def bcd_boundedness(self, *args, **kwargs):
                    """
                    Specifies the BCD scheme parameter, which controls the boundedness strength of the BCD scheme in the pressure-based solver, as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_boundedness").execute(*args, **kwargs)
                def retain_cell_residuals(self, *args, **kwargs):
                    """
                    Enables/disables the retention of cell residuals for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_cell_residuals").execute(*args, **kwargs)
                def energy_numerical_noise_filter(self, *args, **kwargs):
                    """
                    Enables/disables a filter to eliminate non-physical numerical noise in the energy field. Numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present. Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive. This text command is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_numerical_noise_filter").execute(*args, **kwargs)
                def bcd_weights_freeze(self, *args, **kwargs):
                    """
                    Enables/disables freezing of weighting coefficients of the central differencing and the upwind components of the BCD scheme. This dialog command requires the iteration number, after which the BCD scheme weights are to be frozen at each timestep. Freezing the BCD weighting coefficients may help to improve convergence of the timestep iterations as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_weights_freeze").execute(*args, **kwargs)

                class secondary_gradient_limiting(TUIMenu):
                    """
                    Enters the secondary gradient limiting menu. This menu is only available when the define/models/solver/pressure-based text command is enabled.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def energy(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the energy  calculations on coupled two-sided walls. This limiting can help prevent  divergence when the cells on such walls have poor orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                    def mesh_quality_limits(self, *args, **kwargs):
                        """
                        Defines the mesh quality limits used when applying secondary  gradient limiting to faces on coupled two-sided walls. Shifting this  range closer to 1 will decrease the risk of divergence, but at the cost  of accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                    def uds(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the user-defined  scalar (UDS) calculations on coupled two-sided walls. This limiting can  help prevent divergence when the cells on such walls have poor  orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/uds").execute(*args, **kwargs)

                class non_reflecting_boundary_treatment(TUIMenu):
                    """
                    Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)

                class turbomachinery_specific_numerics(TUIMenu):
                    """
                    Enter turbomachinery specific numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Activate/deactivate turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/enable").execute(*args, **kwargs)
                    def settings(self, *args, **kwargs):
                        """
                        Adjust settings for turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/settings").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Sets buffer layer height, verbosity, and open channel wave theory formulation.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Specifies which open channel wave theory formulation Fluent uses.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Sets the buffer layer height.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Sets the open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enters the transient controls menu, which allows you to define settings related to time advancement for transient flow calculations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Enables / disables an option that allows for better prediction of the flow field in rotating fluid zones at every time step, in order to speed up the calculation. This text command is only available for transient simulations.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial conditions at time step n+1. The predictor algorithm is a computation that sets a better initial condition for the time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Sets the maximum flow time.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_flow_time").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the convective time scale (global Courant number): the time-step-size calculation depends on the mesh density and velocity in interfacial cells. This method is available for all multiphase models using the implicit or explicit volume fraction formulation, except for the wet steam model.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the total number of time steps that the simulation will run (which includes any time steps that have already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to1.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Sets the magnitude of the (physical) time step . This text command is only available when the solve/set/transient-controls/fixed-user-specified text command is set toyes.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Specifies the time interval for acoustic data sampling. This text command is only available when both the Ffowcs Williams and Hawkings model is selected and the density-based solver is used with the explicit formulation and explicit transient formulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Sets the method by which you will specify the duration of the calculation. The duration can be defined by the total time, the total number of time steps, the incremental time, or the number of incremental time steps. In this context, "total" indicates that Fluent will consider the amount of time / steps that have already been solved and stop appropriately, whereas "incremental" indicates that the solution will proceed for a specified amount of time / steps regardless of what has previously been calculated. This text command is only available when the time stepping is adaptive or based on a user-defined function.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which you directly specify the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the specified truncation error tolerance.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing the next time step. The predictor algorithm is a computation that sets a better initial condition for the time step. It uses the rate of change between the prediction and the correction as an indicator for whether the next time step should be larger, smaller, or the same as the current one.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/predict_next_time").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation without starting the calculation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Allows you to open theSimulation Status dialog box, which reports details about the simulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solution_status").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size is defined by a user-defined function (UDF) that uses theDEFINE_DELTAT macro.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation.  This option is available when automatic initialization and case modification is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which a specified period or frequency is the basis for determining the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Sets the amount of incremental (that is, additional) time to run the simulation, regardless of how much time has already been run in previous calculations. This text command is only available when the solve/set/transient-controls/duration-specification-method is set to3.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/incremental_time").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Sets the total amount of time that the simulation will be run (which includes any time that has already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to2.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_time").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Specifies whether to define the transient advancement either directly by entering a time step size / period / frequency (using the text commands available in thesolve/set/transient-controls menu) or indirectly by entering a Courant number value (using the solve/set/courant-number text command). This text command is only available for the density-based solver when both the explicit formulation and explicit transient formulation are used.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/specified_time_step").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enters the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    When enabled, if the truncation error within a time step exceeds the specified tolerance Fluent will automatically undo the current calculation and make another attempt with the time step reduced by 1/2. This will be attempted up to 5 times after which Fluent will accept the result and proceed to the next time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/undo_timestep").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent as the calculation proceeds such that the Courant–Friedrichs–Lewy (CFL) condition is satisfied, using the specified Courant number.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size used for solid zones is independent from that used for fluid zones. This text command is only available when both a solid zone exists and energy is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solid_time_step_size").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Enters the menu for setting multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def verbosity(self, *args, **kwargs):
                        """
                        When enabled, various time scales (depending on the selection) are  printed to the console window at every time step. This text command is  available with the moving mesh CFL constraint and with the physics-based  constraint.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Enables/disables the physics-driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Enters the menu for choosing the time-scale options. This menu  becomes available after you enable the physics-driven time-step  constraints using the solve/set/transient-controls/multiphase-specific-time-constraints/physics-based-constraint?  text command.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the surface-tension-driven time scale. This option is available only if the surface tension force modeling is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the viscous time scale. This option is disabled by default. This command is not available with inviscid flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the acoustic time scale. This option is available only for compressible flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the gravitational time scale. This option is available only if gravity is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Specifies overset meshing solver options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    Uses the pressure gradient of the donor cell in the interpolation of pressure for its receptor cell.
                    """
                    return PyMenu(self.service, "/solve/set/overset/high_order_pressure").execute(*args, **kwargs)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Selects the interpolation method for overset interfaces. Note that the least squares method is recommended for sliding mesh cases.
                    """
                    return PyMenu(self.service, "/solve/set/overset/interpolation_method").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enables/disables a numerical treatment that attempts to assign reasonable data values to orphan cells.
                    """
                    return PyMenu(self.service, "/solve/set/overset/orphan_cell_treatment").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enters the pseudo time method menu. This menu is only available for cases that use a pressure-based segregated solver (SIMPLE, SIMPLEC, or PISO) or for steady-state cases that use the pressure-based coupled solver or the density-based implicit solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def formulation(self, *args, **kwargs):
                    """
                    Enables and sets the pseudo time step size formulation or disables the pseudo time method option.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/formulation").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time Courant number when the local time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enters the advanced options menu, which allows you to enable / disable the pseudo time method for individual equations and define their pseudo time scale factors or under-relaxation factors, respectively. These settings only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enters the relaxation factors menu, where you can set the pseudo time explicit relaxation factors for individual equations. These factors only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time settings for the calculation when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the messages related to the pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/verbosity").execute(*args, **kwargs)

        class cell_register_operations(TUIMenu):
            """
            Enters the cell register operations menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/delete").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists the currently defined cell register operations.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/add").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Enters the cell registers menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solve/cell_registers/adapt").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Applies poor mesh numerics to the mesh of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/refine").execute(*args, **kwargs)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/coarsen").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/delete").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/display").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/cell_registers/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solve/cell_registers/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the currently defined cell registers.
                """
                return PyMenu(self.service, "/solve/cell_registers/list").execute(*args, **kwargs)

        class report_plots(TUIMenu):
            """
            Enters the report plots menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def curves(self, *args, **kwargs):
                """
                Defines the curves for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/curves").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/list_properties").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plots the specified report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/plot").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report plot object.
                """
                return PyMenu(self.service, "/solve/report_plots/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report plots.
                """
                return PyMenu(self.service, "/solve/report_plots/list").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Defines the axes for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/axes").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/edit").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/clear_data").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report plot objects.
                """
                return PyMenu(self.service, "/solve/report_plots/delete_all").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enters the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.pulse = self.__class__.pulse(path + ["pulse"], service)
                self.define = self.__class__.define(path + ["define"], service)
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.playback = self.__class__.playback(path + ["playback"], service)
                super().__init__(path, service)

            class pulse(TUIMenu):
                """
                Enter the pulse animation menu (only available when one or more particle track or pathline graphics objects are defined).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.hardcopy = self.__class__.hardcopy(path + ["hardcopy"], service)
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def write(self, *args, **kwargs):
                    """
                    Select a pathline or particle track graphics object, specify whether you want to write a video file or picture files, and enter the destination directory for the files. Continuous pulse animations result in a 5 second video. Single pulse animations run for a full cycle.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/write").execute(*args, **kwargs)
                def pulse_mode(self, *args, **kwargs):
                    """
                    Set whether the pulse is a single pulse or continuous.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/pulse_mode").execute(*args, **kwargs)

                class hardcopy(TUIMenu):
                    """
                    Hardcopy options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                        self.driver = self.__class__.driver(path + ["driver"], service)
                        super().__init__(path, service)
                    def dpi(self, *args, **kwargs):
                        """
                        Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/dpi").execute(*args, **kwargs)
                    def landscape(self, *args, **kwargs):
                        """
                        Plot hardcopies in landscape or portrait orientation.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/landscape").execute(*args, **kwargs)
                    def x_resolution(self, *args, **kwargs):
                        """
                        Set the width of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/x_resolution").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/set_standard_resolution").execute(*args, **kwargs)
                    def jpeg_hardcopy_quality(self, *args, **kwargs):
                        """
                        To set jpeg hardcopy quality.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/jpeg_hardcopy_quality").execute(*args, **kwargs)
                    def y_resolution(self, *args, **kwargs):
                        """
                        Set the height of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/y_resolution").execute(*args, **kwargs)
                    def invert_background(self, *args, **kwargs):
                        """
                        Use a white background when the picture is saved.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/invert_background").execute(*args, **kwargs)
                    def preview(self, *args, **kwargs):
                        """
                        Display a preview image of a hardcopy.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/preview").execute(*args, **kwargs)
                    def use_window_resolution(self, *args, **kwargs):
                        """
                        Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/use_window_resolution").execute(*args, **kwargs)

                    class color_mode(TUIMenu):
                        """
                        Enter the hardcopy color mode menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            Display the current hardcopy color mode.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/list").execute(*args, **kwargs)
                        def gray_scale(self, *args, **kwargs):
                            """
                            Convert color to grayscale for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/gray_scale").execute(*args, **kwargs)
                        def color(self, *args, **kwargs):
                            """
                            Plot hardcopies in color.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/color").execute(*args, **kwargs)
                        def mono_chrome(self, *args, **kwargs):
                            """
                            Convert color to monochrome (black and white) for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/mono_chrome").execute(*args, **kwargs)

                    class driver(TUIMenu):
                        """
                        Enter the set hardcopy driver menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.post_format = self.__class__.post_format(path + ["post_format"], service)
                            super().__init__(path, service)
                        def options(self, *args, **kwargs):
                            """
                            Set the hardcopy options. Available options are:
                            "no gamma correction", disables gamma correction of colors,
                            "physical size = (width,height)", where width and height
                            are the actual measurements of the printable area of the page
                            in centimeters.
                            "subscreen = (left,right,bottom,top)", where left,right,
                            bottom, and top are numbers in [-1,1] describing a subwindow on
                            the page in which to place the hardcopy.
                            The options may be combined by separating them with commas.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/options").execute(*args, **kwargs)
                        def ppm(self, *args, **kwargs):
                            """
                            Produce PPM output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/ppm").execute(*args, **kwargs)
                        def tiff(self, *args, **kwargs):
                            """
                            Use TIFF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/tiff").execute(*args, **kwargs)
                        def jpeg(self, *args, **kwargs):
                            """
                            Produce JPEG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/jpeg").execute(*args, **kwargs)
                        def glb(self, *args, **kwargs):
                            """
                            Use GLB output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/glb").execute(*args, **kwargs)
                        def vrml(self, *args, **kwargs):
                            """
                            Use VRML output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/vrml").execute(*args, **kwargs)
                        def png(self, *args, **kwargs):
                            """
                            Use PNG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/png").execute(*args, **kwargs)
                        def dump_window(self, *args, **kwargs):
                            """
                            Set the command used to dump the graphics window to a file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/dump_window").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List the current hardcopy driver.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/list").execute(*args, **kwargs)
                        def eps(self, *args, **kwargs):
                            """
                            Produce encapsulated PostScript (EPS) output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/eps").execute(*args, **kwargs)
                        def post_script(self, *args, **kwargs):
                            """
                            Produce PostScript output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_script").execute(*args, **kwargs)
                        def avz(self, *args, **kwargs):
                            """
                            Use AVZ output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/avz").execute(*args, **kwargs)
                        def hsf(self, *args, **kwargs):
                            """
                            Use HSF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/hsf").execute(*args, **kwargs)

                        class post_format(TUIMenu):
                            """
                            Enter the PostScript driver format menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def rle_raster(self, *args, **kwargs):
                                """
                                Use the run-length encoded raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/rle_raster").execute(*args, **kwargs)
                            def raster(self, *args, **kwargs):
                                """
                                Use the original raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/raster").execute(*args, **kwargs)
                            def fast_raster(self, *args, **kwargs):
                                """
                                Use the new raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/fast_raster").execute(*args, **kwargs)
                            def vector(self, *args, **kwargs):
                                """
                                Use vector format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/vector").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/scale").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/width").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/name").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/format").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/fps").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/use_original_resolution").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/set_standard_resolution").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/quality").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/height").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/enable_h264").execute(*args, **kwargs)

            class define(TUIMenu):
                """
                Enters the animation definition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def define_monitor(self, *args, **kwargs):
                    """
                    Defines new animation.
                    """
                    return PyMenu(self.service, "/solve/animate/define/define_monitor").execute(*args, **kwargs)
                def edit_monitor(self, *args, **kwargs):
                    """
                    Changes animation monitor attributes.
                    """
                    return PyMenu(self.service, "/solve/animate/define/edit_monitor").execute(*args, **kwargs)

            class objects(TUIMenu):
                """
                Enters the object manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_history(self, *args, **kwargs):
                    """
                    Clears solution animation object history.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/clear_history").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates new solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/create").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/edit").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copies solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/copy").execute(*args, **kwargs)

            class playback(TUIMenu):
                """
                Enters the animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Specify a custom start frame, increment, and end frame for video export.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes animation sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/delete").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Plays the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/stored_view").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Writes animation sequence to the file.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/write").execute(*args, **kwargs)
                def play(self, *args, **kwargs):
                    """
                    Plays the selected animation.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/play").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Reads new animation from file or already defined animations.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/read").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enters the video menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/quality").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Sets the name of the saved video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/name").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/height").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Expands or collapses the resolution based on this scaling  factor.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/scale").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Controls whether the resolution of the saved video file matches that  of the images used to create it.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Specifies what format the video file will be written in (MP4 | AVI |  FLV | MOV | MPEG).
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/format").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Sets the target frames per second (FPS) for the saved video  file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/fps").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/width").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)

        class execute_commands(TUIMenu):
            """
            Enters the execute commands menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/delete").execute(*args, **kwargs)
            def export(self, *args, **kwargs):
                """
                Export execute-commands to a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/export").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/disable").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/enable").execute(*args, **kwargs)
            def add_edit(self, *args, **kwargs):
                """
                Adds or edits execute commands.
                """
                return PyMenu(self.service, "/solve/execute_commands/add_edit").execute(*args, **kwargs)
            def import_(self, *args, **kwargs):
                """
                Import execute-commands from a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/import").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/copy").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Sets solution monitors.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                super().__init__(path, service)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solve/monitors/set_average_over").execute(*args, **kwargs)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solve/monitors/convergence_conditions").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/clear_data").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/add").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete_all").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list_properties").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enters the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced formulation for the local scaling of the continuity residuals with the pressure-based solver, so that the absolute mass flow rate at each cell is used. This text command is only available when the computing of the local scale is enabled through the solve/monitors/residual/scale-by-coefficient? text command.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Sets convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/plot").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Chooses whether to scale residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Chooses whether to delete the residual history and reset iteration counter to 1.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/reset").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Sets the number of iterations through which normalization factors will be maximized.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Sets normalization factors for currently monitored residuals (if normalize? is set to yes).
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/print").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Chooses which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/monitor").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Chooses which currently monitored residuals should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/check_convergence").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Sets relative convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Sets number of residuals to be saved with data. History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_save").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Sets convergence criterion type.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/criterion_type").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Re-normalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/re_normalize").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Chooses whether to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalize").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Sets the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_display").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/plot").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/axes").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/curves").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/add").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enters the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                super().__init__(path, service)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initializes using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solve/initialize/hyb_initialization").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Displays the number of iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solve/initialize/repair_wall_distance").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Sets default initial values.
                """
                return PyMenu(self.service, "/solve/initialize/set_defaults").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Opens channel automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Deletes wall film particles and initializes wall film variables to zero. This option is available only with the wall-film DPM boundary condition.
                """
                return PyMenu(self.service, "/solve/initialize/lwf_initialization").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enters the hybrid initialization menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initializes instantaneous velocity field out of steady state RANS results, for use before enabling a scale resolving simulation such as LES.
                """
                return PyMenu(self.service, "/solve/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                Lists default values.
                """
                return PyMenu(self.service, "/solve/initialize/list_defaults").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Sets reference frame to absolute or relative.
                """
                return PyMenu(self.service, "/solve/initialize/reference_frame").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/levelset_auto_init").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initializes unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/init_flow_statistics").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enters the set full-multigrid for initialization menu. Initial values for each variable can be set within this menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solve/initialize/patch").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initializes using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solve/initialize/fmg_initialization").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Displays the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_time_sampled").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specifies the number of timesteps for ramping of sound sources and re-initializes the acoustics wave equation solution. For the initialized acoustics solution, Fluent reports the current state of the sound sources ramping.
                """
                return PyMenu(self.service, "/solve/initialize/init_acoustics_options").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initializes the flow field with the current default values.
                """
                return PyMenu(self.service, "/solve/initialize/initialize_flow").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Resets discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solve/initialize/dpm_reset").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enters the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)
                def set_options(self, *args, **kwargs):
                    """
                    Sets options for patching and smoothing volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enters the compute default values menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initializes the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/radiator").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Enters the menu for localized turbulent flow initialization.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Sets values for the turbulent intensity and turbulent viscosity ratio for localized initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables localized initialization of turbulent flow variables.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)

    class parameters__and__customization(TUIMenu):
        """
        Enter Parameters and custom menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            super().__init__(path, service)

        class user_defined(TUIMenu):
            """
            Enter the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def execute_on_demand(self, *args, **kwargs):
                """
                Execute UDFs on demand.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/execute_on_demand").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocate user-defined memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_memory").execute(*args, **kwargs)
            def interpreted_functions(self, *args, **kwargs):
                """
                Load interpreted user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/interpreted_functions").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Open user-defined function library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compiled_functions").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/one_D_coupling").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_contributed_cpp").execute(*args, **kwargs)
            def fan_model(self, *args, **kwargs):
                """
                Configure user-defined fan model.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/fan_model").execute(*args, **kwargs)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enable/disable the use of the built-in compiler.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_built_in_compiler").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Define user-defined scalars.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_scalars").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hook up user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/function_hooks").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def nist_settings(self, *args, **kwargs):
                    """
                    Select refprop library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Select state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/set_state").execute(*args, **kwargs)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined multispecies real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)

        class parameters(TUIMenu):
            """
            Enter the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enable/disable parameters in the text user interface.
                """
                return PyMenu(self.service, "/parameters__and__customization/parameters/enable_in_TUI").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/input_parameters").execute(*args, **kwargs)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/output_parameters").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enter the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create(self, *args, **kwargs):
                    """
                    Create an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/create").execute(*args, **kwargs)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Write all parameter values to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Print all parameter values to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)
                def print_to_console(self, *args, **kwargs):
                    """
                    Print parameter value to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_to_console").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/delete").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write parameter value to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Rename an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/rename").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/edit").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enter the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/delete").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/delete").execute(*args, **kwargs)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/list").execute(*args, **kwargs)

    class surface(TUIMenu):
        """
        Enter the data surface manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
            self.query = self.__class__.query(path + ["query"], service)
            super().__init__(path, service)
        def plane(self, *args, **kwargs):
            """
            Create a plane given 3 points bounded by the domain.
            """
            return PyMenu(self.service, "/surface/plane").execute(*args, **kwargs)
        def surface_cells(self, *args, **kwargs):
            """
            Extracts all cells intersected by a data surface.
            """
            return PyMenu(self.service, "/surface/surface_cells").execute(*args, **kwargs)
        def mouse_plane(self, *args, **kwargs):
            """
            Extracts a planar surface defined by selecting three points with the mouse.
            """
            return PyMenu(self.service, "/surface/mouse_plane").execute(*args, **kwargs)
        def circle_slice(self, *args, **kwargs):
            """
            Extracts a circular slice.
            """
            return PyMenu(self.service, "/surface/circle_slice").execute(*args, **kwargs)
        def plane_slice(self, *args, **kwargs):
            """
            Extracts a planar slice.
            """
            return PyMenu(self.service, "/surface/plane_slice").execute(*args, **kwargs)
        def multiple_plane_surfaces(self, *args, **kwargs):
            """
            Creates multiple planes at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_plane_surfaces").execute(*args, **kwargs)
        def mouse_rake(self, *args, **kwargs):
            """
            Extracts a “rake" surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_rake").execute(*args, **kwargs)
        def zone_surface(self, *args, **kwargs):
            """
            Creates a surface of a designated zone and gives it a specified name.
            """
            return PyMenu(self.service, "/surface/zone_surface").execute(*args, **kwargs)
        def delete_surface(self, *args, **kwargs):
            """
            Removes a defined data surface.
            """
            return PyMenu(self.service, "/surface/delete_surface").execute(*args, **kwargs)
        def expression_volume(self, *args, **kwargs):
            """
            Create volume with boolean expression.
            """
            return PyMenu(self.service, "/surface/expression_volume").execute(*args, **kwargs)
        def edit_surface(self, *args, **kwargs):
            """
            Allows you to edit any of the listed available surfaces.
            """
            return PyMenu(self.service, "/surface/edit_surface").execute(*args, **kwargs)
        def group_surfaces(self, *args, **kwargs):
            """
            Group a set of surfaces.
            """
            return PyMenu(self.service, "/surface/group_surfaces").execute(*args, **kwargs)
        def point_array(self, *args, **kwargs):
            """
            Extracts a rectangular array of data points.
            """
            return PyMenu(self.service, "/surface/point_array").execute(*args, **kwargs)
        def sphere_slice(self, *args, **kwargs):
            """
            Extracts a spherical slice.
            """
            return PyMenu(self.service, "/surface/sphere_slice").execute(*args, **kwargs)
        def ungroup_surface(self, *args, **kwargs):
            """
            Ungroup the surface(if grouped).
            """
            return PyMenu(self.service, "/surface/ungroup_surface").execute(*args, **kwargs)
        def reset_zone_surfaces(self, *args, **kwargs):
            """
            Recreates missing surface zones by resetting the case surface list.
            """
            return PyMenu(self.service, "/surface/reset_zone_surfaces").execute(*args, **kwargs)
        def list_surfaces(self, *args, **kwargs):
            """
            Displays the ID and name, and the number of point, curve, and surface facets of the current surfaces.
            """
            return PyMenu(self.service, "/surface/list_surfaces").execute(*args, **kwargs)
        def quadric_slice(self, *args, **kwargs):
            """
            Extracts a quadric slice.
            """
            return PyMenu(self.service, "/surface/quadric_slice").execute(*args, **kwargs)
        def plane_surface(self, *args, **kwargs):
            """
            Create a plane from a coordinate plane, point and normal, or three points.
            """
            return PyMenu(self.service, "/surface/plane_surface").execute(*args, **kwargs)
        def iso_clip(self, *args, **kwargs):
            """
            Clips a data surface (surface, curve, or point) between two isovalues.
            """
            return PyMenu(self.service, "/surface/iso_clip").execute(*args, **kwargs)
        def multiple_zone_surfaces(self, *args, **kwargs):
            """
            Creates multiple data surfaces at one time. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_zone_surfaces").execute(*args, **kwargs)
        def point_surface(self, *args, **kwargs):
            """
            Defines a “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/point_surface").execute(*args, **kwargs)
        def structural_point_surface(self, *args, **kwargs):
            """
            Defines a structural “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/structural_point_surface").execute(*args, **kwargs)
        def multiple_iso_surfaces(self, *args, **kwargs):
            """
            Creates multiple iso-surfaces at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_iso_surfaces").execute(*args, **kwargs)
        def rename_surface(self, *args, **kwargs):
            """
            Renames a defined data surface.
            """
            return PyMenu(self.service, "/surface/rename_surface").execute(*args, **kwargs)
        def cone_slice(self, *args, **kwargs):
            """
            Extract a cone slice.
            """
            return PyMenu(self.service, "/surface/cone_slice").execute(*args, **kwargs)
        def line_slice(self, *args, **kwargs):
            """
            Extracts a linear slice in 2D, given the normal to the line and a distance from the origin.
            """
            return PyMenu(self.service, "/surface/line_slice").execute(*args, **kwargs)
        def mouse_line(self, *args, **kwargs):
            """
            Extracts a line surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_line").execute(*args, **kwargs)
        def ellipsoid_slice(self, *args, **kwargs):
            """
            Extract a ellipsoid slice.
            """
            return PyMenu(self.service, "/surface/ellipsoid_slice").execute(*args, **kwargs)
        def closest_point_search(self, *args, **kwargs):
            """
            Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
            """
            return PyMenu(self.service, "/surface/closest_point_search").execute(*args, **kwargs)
        def rake_surface(self, *args, **kwargs):
            """
            Extracts a “rake" surface, given the coordinates of the endpoints.
            """
            return PyMenu(self.service, "/surface/rake_surface").execute(*args, **kwargs)
        def iso_surface(self, *args, **kwargs):
            """
            Extracts an iso-surface (surface, curve, or point) from the current data field.
            """
            return PyMenu(self.service, "/surface/iso_surface").execute(*args, **kwargs)
        def partition_surface(self, *args, **kwargs):
            """
            Defines a data surface consisting of mesh faces on the partition boundary.
            """
            return PyMenu(self.service, "/surface/partition_surface").execute(*args, **kwargs)
        def create_imprint_surface(self, *args, **kwargs):
            """
            Imprint surface.
            """
            return PyMenu(self.service, "/surface/create_imprint_surface").execute(*args, **kwargs)
        def transform_surface(self, *args, **kwargs):
            """
            Transforms surface.
            """
            return PyMenu(self.service, "/surface/transform_surface").execute(*args, **kwargs)
        def line_surface(self, *args, **kwargs):
            """
            Defines a “line" surface by specifying the two endpoint coordinates.
            """
            return PyMenu(self.service, "/surface/line_surface").execute(*args, **kwargs)

        class post_processing_volume(TUIMenu):
            """
            Enter post-processing volume menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def create_octree(self, *args, **kwargs):
                """
                Create post-processing octree mesh based on current case.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_octree").execute(*args, **kwargs)
            def create_from_file(self, *args, **kwargs):
                """
                Read post-processing mesh from file.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)

        class query(TUIMenu):
            """
            Enter surface query menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def named_surface_list(self, *args, **kwargs):
                """
                Create named list of surfaces.
                """
                return PyMenu(self.service, "/surface/query/named_surface_list").execute(*args, **kwargs)
            def delete_query(self, *args, **kwargs):
                """
                Delete saved query.
                """
                return PyMenu(self.service, "/surface/query/delete_query").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List surfaces.
                """
                return PyMenu(self.service, "/surface/query/list_surfaces").execute(*args, **kwargs)
            def list_queries(self, *args, **kwargs):
                """
                List all saved queries.
                """
                return PyMenu(self.service, "/surface/query/list_queries").execute(*args, **kwargs)
            def list_named_selection(self, *args, **kwargs):
                """
                List named selection of surface type.
                """
                return PyMenu(self.service, "/surface/query/list_named_selection").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            super().__init__(path, service)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)

    class report(TUIMenu):
        """
        Enter the report menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.system = self.__class__.system(path + ["system"], service)
            self.modified_setting = self.__class__.modified_setting(path + ["modified_setting"], service)
            self.forces = self.__class__.forces(path + ["forces"], service)
            self.icing = self.__class__.icing(path + ["icing"], service)
            self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
            self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
            self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
            self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
            super().__init__(path, service)
        def dpm_sample(self, *args, **kwargs):
            """
            Samples trajectories at boundaries and lines/planes.
            """
            return PyMenu(self.service, "/report/dpm_sample").execute(*args, **kwargs)
        def dpm_sample_output_udf(self, *args, **kwargs):
            """
            Allows you to hook a previously loaded DEFINE_DPM_OUTPUT UDF for file format specification for sampling of trajectories and VOF-to-DPM lump conversion transcripts.
            """
            return PyMenu(self.service, "/report/dpm_sample_output_udf").execute(*args, **kwargs)
        def surface_integrals(self, *args, **kwargs):
            """
            Enters the surface integral menu.
            """
            return PyMenu(self.service, "/report/surface_integrals").execute(*args, **kwargs)
        def aero_optical_distortions(self, *args, **kwargs):
            """
            Optics report menu.
            """
            return PyMenu(self.service, "/report/aero_optical_distortions").execute(*args, **kwargs)
        def mphase_summary(self, *args, **kwargs):
            """
            Prints summary report for a multiphase case setup.
            """
            return PyMenu(self.service, "/report/mphase_summary").execute(*args, **kwargs)
        def dpm_summary(self, *args, **kwargs):
            """
            Prints discrete phase summary report.
            """
            return PyMenu(self.service, "/report/dpm_summary").execute(*args, **kwargs)
        def particle_summary(self, *args, **kwargs):
            """
            Prints summary report for all current particles.
            """
            return PyMenu(self.service, "/report/particle_summary").execute(*args, **kwargs)
        def dpm_sample_sort_file(self, *args, **kwargs):
            """
            Enables/disables writing of sorted DPM sample files.
            """
            return PyMenu(self.service, "/report/dpm_sample_sort_file").execute(*args, **kwargs)
        def volume_integrals(self, *args, **kwargs):
            """
            Enters the volume integral menu.
            """
            return PyMenu(self.service, "/report/volume_integrals").execute(*args, **kwargs)
        def uds_flow(self, *args, **kwargs):
            """
            Prints list of user-defined scalar flow rate at boundaries.
            """
            return PyMenu(self.service, "/report/uds_flow").execute(*args, **kwargs)
        def dpm_extended_summary(self, *args, **kwargs):
            """
            Create an extended discrete phase summary report of the discrete phase injection(s). You can choose whether you want to save the extended report to a file or print it in the console window. For unsteady tracking, you will be asked whether you want to include in-domain particle/tracks in the report. You will be also prompted whether you want to select a single injection for the summary report. By default, all injections are included. The output depends on whether you have enabled the report/dpm-zone-summaries-per-injection? text command, in which case additional information is printed for escaped particles, such as per-injection data. Note that, for unsteady particle tracking, it is necessary to enable the report/dpm-zone-summaries-per-injection? text command before any particle parcels are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_extended_summary").execute(*args, **kwargs)
        def species_mass_flow(self, *args, **kwargs):
            """
            Prints list of species mass flow rate at inlets and outlets. This reports the mass flow rates of all species (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/species_mass_flow").execute(*args, **kwargs)
        def element_mass_flow(self, *args, **kwargs):
            """
            Prints list of element flow rate at inlets and outlets. This reports the mass flow rates of all chemical elements (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/element_mass_flow").execute(*args, **kwargs)
        def summary(self, *args, **kwargs):
            """
            Prints the current settings for physical models, boundary conditions, material properties, and solution parameters.
            """
            return PyMenu(self.service, "/report/summary").execute(*args, **kwargs)
        def print_histogram(self, *args, **kwargs):
            """
            Prints a histogram of a scalar quantity.
            """
            return PyMenu(self.service, "/report/print_histogram").execute(*args, **kwargs)
        def dpm_zone_summaries_per_injection(self, *args, **kwargs):
            """
            Enables/disables calculation of the escaped mass per injection. Note that for unsteady particle tracking, if you want to report the mass of escaped particles per injection, this text command must be enabled before any particles are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
        def path_line_summary(self, *args, **kwargs):
            """
            Prints pathline summary report.
            """
            return PyMenu(self.service, "/report/path_line_summary").execute(*args, **kwargs)
        def write_histogram(self, *args, **kwargs):
            """
            Write a histogram of a scalar quantity to a file.
            """
            return PyMenu(self.service, "/report/write_histogram").execute(*args, **kwargs)
        def projected_surface_area(self, *args, **kwargs):
            """
            Computes the area of the projection of selected surfaces along the  ,  , or   axis.
            """
            return PyMenu(self.service, "/report/projected_surface_area").execute(*args, **kwargs)

        class system(TUIMenu):
            """
            Enters the system menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def proc_stats(self, *args, **kwargs):
                """
                Prints ANSYS Fluent process information. This is used to report the memory usage of each of the ANSYS Fluent processes.
                """
                return PyMenu(self.service, "/report/system/proc_stats").execute(*args, **kwargs)
            def sys_stats(self, *args, **kwargs):
                """
                System information. This is used to report the CPU configuration of the machines where ANSYS Fluent processes have been spawned.
                """
                return PyMenu(self.service, "/report/system/sys_stats").execute(*args, **kwargs)
            def time_stats(self, *args, **kwargs):
                """
                Timer information. This is used to report CPU timings for user and kernel processes and detailed solver timings.
                """
                return PyMenu(self.service, "/report/system/time_stats").execute(*args, **kwargs)
            def gpgpu_stats(self, *args, **kwargs):
                """
                Prints information about installed general purpose graphical processing units.
                """
                return PyMenu(self.service, "/report/system/gpgpu_stats").execute(*args, **kwargs)

        class modified_setting(TUIMenu):
            """
            Enter the modified settings menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def modified_setting(self, *args, **kwargs):
                """
                Specify which areas of setup will be checked for non-default settings for generating the Modified Settings Summary table. The table is displayed tabbed with the graphics window.
                """
                return PyMenu(self.service, "/report/modified_setting/modified_setting").execute(*args, **kwargs)
            def write_user_setting(self, *args, **kwargs):
                """
                Write the contents of the Modified Settings Summary table to a file.
                """
                return PyMenu(self.service, "/report/modified_setting/write_user_setting").execute(*args, **kwargs)

        class forces(TUIMenu):
            """
            Enters the forces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def wall_forces(self, *args, **kwargs):
                """
                Computes the forces along the specified force vector for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_forces").execute(*args, **kwargs)
            def wall_moments(self, *args, **kwargs):
                """
                Computes the moments about the specified moment center for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_moments").execute(*args, **kwargs)
            def pressure_center(self, *args, **kwargs):
                """
                Prints the center of pressure on wall zones.
                """
                return PyMenu(self.service, "/report/forces/pressure_center").execute(*args, **kwargs)

        class icing(TUIMenu):
            """
            Icing reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def particles_droplets_collection_eff(self, *args, **kwargs):
                """
                Print Droplets Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
            def particles_crystals_collection_eff(self, *args, **kwargs):
                """
                Print Crystals Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)
            def mass_of_water_impinged(self, *args, **kwargs):
                """
                Print Mass of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/mass_of_water_impinged").execute(*args, **kwargs)
            def energy_of_water_impinged(self, *args, **kwargs):
                """
                Print Energy of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
            def mass_of_ice(self, *args, **kwargs):
                """
                Print Mass of Ice Accretion.
                """
                return PyMenu(self.service, "/report/icing/mass_of_ice").execute(*args, **kwargs)
            def icing_energy_of_conduction(self, *args, **kwargs):
                """
                Print Energy of Conduction.
                """
                return PyMenu(self.service, "/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)
            def energy_of_ice_formation(self, *args, **kwargs):
                """
                Print Energy of Ice Formation.
                """
                return PyMenu(self.service, "/report/icing/energy_of_ice_formation").execute(*args, **kwargs)

        class simulation_reports(TUIMenu):
            """
            Enter the simulation reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                super().__init__(path, service)
            def export_simulation_report_as_pdf(self, *args, **kwargs):
                """
                Export the provided simulation report as a PDF file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
            def delete_simulation_report(self, *args, **kwargs):
                """
                Delete the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
            def export_simulation_report_as_pptx(self, *args, **kwargs):
                """
                Export the provided simulation report as a PPT file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)
            def rename_simulation_report(self, *args, **kwargs):
                """
                Rename a report which has already been generated.
                """
                return PyMenu(self.service, "/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
            def reset_report_to_defaults(self, *args, **kwargs):
                """
                Reset all report settings to default for the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
            def list_simulation_reports(self, *args, **kwargs):
                """
                List all report names.
                """
                return PyMenu(self.service, "/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
            def generate_simulation_report(self, *args, **kwargs):
                """
                Generate a new simulation report or regenerate an existing simulation report with the provided name.
                """
                return PyMenu(self.service, "/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
            def write_simulation_report_template_file(self, *args, **kwargs):
                """
                Write a JSON template file with this case's Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
            def export_simulation_report_as_html(self, *args, **kwargs):
                """
                Export the provided simulation report as HTML.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
            def duplicate_simulation_report(self, *args, **kwargs):
                """
                Duplicate a report and all of its settings to a new report.
                """
                return PyMenu(self.service, "/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
            def read_simulation_report_template_file(self, *args, **kwargs):
                """
                Read a JSON template file with existing Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
            def view_simulation_report(self, *args, **kwargs):
                """
                View a simulation report that has already been generated. In batch mode this will print the report's URL.
                """
                return PyMenu(self.service, "/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)
            def write_report_names_to_file(self, *args, **kwargs):
                """
                Write the list of currently generated report names to a txt file.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)

            class parametric_study(TUIMenu):
                """
                Enter the parametric study menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def generate_design_point_report(self, *args, **kwargs):
                    """
                    Generate a simulation report for an updated design point.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
                def generate_parametric_report(self, *args, **kwargs):
                    """
                    Generate a parametric report for your study.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Enters the reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def yplus(self, *args, **kwargs):
                """
                Sets reference yplus for calculation of Yplus Based Heat Transfer Coefficient.
                """
                return PyMenu(self.service, "/report/reference_values/yplus").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists current reference values.
                """
                return PyMenu(self.service, "/report/reference_values/list").execute(*args, **kwargs)
            def temperature(self, *args, **kwargs):
                """
                Sets reference temperature for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/temperature").execute(*args, **kwargs)
            def pressure(self, *args, **kwargs):
                """
                Sets reference pressure for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/pressure").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Sets reference density for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/density").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Sets reference depth for volume calculation.
                """
                return PyMenu(self.service, "/report/reference_values/depth").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Sets reference velocity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/velocity").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Sets reference zone.
                """
                return PyMenu(self.service, "/report/reference_values/zone").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Sets reference length for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/length").execute(*args, **kwargs)
            def area(self, *args, **kwargs):
                """
                Sets reference area for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/area").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Sets reference viscosity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/viscosity").execute(*args, **kwargs)
            def enthalpy(self, *args, **kwargs):
                """
                Sets reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/report/reference_values/enthalpy").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Computes reference values from zone boundary conditions.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/solid").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/wall").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fan").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/axis").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/overset").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/periodic").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interface").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/radiator").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network_end").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interior").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fluid").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outflow").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/geometry").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/shadow").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/degassing").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)

        class heat_exchanger(TUIMenu):
            """
            Enters the heat exchanger menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def outlet_temperature(self, *args, **kwargs):
                """
                Prints outlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
            def mass_flow_rate(self, *args, **kwargs):
                """
                Prints mass flow rate.
                """
                return PyMenu(self.service, "/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)
            def inlet_temperature(self, *args, **kwargs):
                """
                Prints inlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)
            def computed_heat_rejection(self, *args, **kwargs):
                """
                Prints total heat rejection.
                """
                return PyMenu(self.service, "/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)
            def specific_heat(self, *args, **kwargs):
                """
                Prints fluid’s specific heat.
                """
                return PyMenu(self.service, "/report/heat_exchanger/specific_heat").execute(*args, **kwargs)

        class population_balance(TUIMenu):
            """
            Population Balance menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def number_density(self, *args, **kwargs):
                """
                Set number density functions.
                """
                return PyMenu(self.service, "/report/population_balance/number_density").execute(*args, **kwargs)
            def moments(self, *args, **kwargs):
                """
                Set moments for population balance.
                """
                return PyMenu(self.service, "/report/population_balance/moments").execute(*args, **kwargs)

        class fluxes(TUIMenu):
            """
            Enters the fluxes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def viscous_work(self, *args, **kwargs):
                """
                Prints the viscous work rate at the boundaries. This text command is only available when the energy equation is enabled and the pressure-based solver is selected.
                """
                return PyMenu(self.service, "/report/fluxes/viscous_work").execute(*args, **kwargs)
            def pressure_work(self, *args, **kwargs):
                """
                Prints the pressure work rate at the boundaries. This text command is only available when the energy equation is enabled, the absolute velocity formulation is selected, and zone motion is enabled for a fluid cell zone.
                """
                return PyMenu(self.service, "/report/fluxes/pressure_work").execute(*args, **kwargs)
            def film_heat_transfer(self, *args, **kwargs):
                """
                Prints wall film heat transfer rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
            def rad_heat_trans(self, *args, **kwargs):
                """
                Prints radiation heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/rad_heat_trans").execute(*args, **kwargs)
            def mass_flow(self, *args, **kwargs):
                """
                Prints mass flow rate at inlets and outlets.
                """
                return PyMenu(self.service, "/report/fluxes/mass_flow").execute(*args, **kwargs)
            def heat_transfer_sensible(self, *args, **kwargs):
                """
                Prints the sensible heat transfer rate at the boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)
            def film_mass_flow(self, *args, **kwargs):
                """
                Prints wall film mass flow rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_mass_flow").execute(*args, **kwargs)
            def heat_transfer(self, *args, **kwargs):
                """
                Prints heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer").execute(*args, **kwargs)

        class dpm_histogram(TUIMenu):
            """
            Enters the DPM histogram menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def compute_sample(self, *args, **kwargs):
                """
                Computes the minimum/maximum of a sample variable.
                """
                return PyMenu(self.service, "/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
            def pick_sample_to_reduce(self, *args, **kwargs):
                """
                Select a sample to be reduced.
                """
                return PyMenu(self.service, "/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)
            def reduce_picked_sample(self, *args, **kwargs):
                """
                Reduce a sample as specified by the data reduction parameters. This command is available only after you selected the sample using the pick-sample-to-reduce text command.
                """
                return PyMenu(self.service, "/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)
            def prep_dpm_sample_cont_plot_exprs(self, *args, **kwargs):
                """
                Prepare named expressions from data in a DPM sample file (collected at a cut plane surface) for contour plotting.
                """
                return PyMenu(self.service, "/report/dpm_histogram/prep_dpm_sample_cont_plot_exprs").execute(*args, **kwargs)
            def plot_sample(self, *args, **kwargs):
                """
                Plots a histogram of a loaded sample.
                """
                return PyMenu(self.service, "/report/dpm_histogram/plot_sample").execute(*args, **kwargs)
            def list_samples(self, *args, **kwargs):
                """
                Shows all samples in a loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/list_samples").execute(*args, **kwargs)
            def read_sample(self, *args, **kwargs):
                """
                Reads a sample file and adds it to the sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/read_sample").execute(*args, **kwargs)
            def write_sample(self, *args, **kwargs):
                """
                Write a histogram of a loaded sample into a file.
                """
                return PyMenu(self.service, "/report/dpm_histogram/write_sample").execute(*args, **kwargs)
            def delete_sample(self, *args, **kwargs):
                """
                Deletes a sample from the loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/delete_sample").execute(*args, **kwargs)

            class setup_reduction(TUIMenu):
                """
                Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Set the minimum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                def all_variables_number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for ALL variables in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)
                def reset_min_and_max(self, *args, **kwargs):
                    """
                    Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)
                def list_settings(self, *args, **kwargs):
                    """
                    List all user inputs for the sample picked for data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                def make_steady_from_unsteady_file(self, *args, **kwargs):
                    """
                    Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)
                def weighting_variable(self, *args, **kwargs):
                    """
                    Choose the weighting variable for the averaging in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)
                def use_weighting(self, *args, **kwargs):
                    """
                    Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Set the maximum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the settings menu for the histogram.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def weighting(self, *args, **kwargs):
                    """
                    Uses weighting with additional variables when sorting data into samples.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Automatically computes the range of the sampling variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)
                def cumulation_curve(self, *args, **kwargs):
                    """
                    Computes a cumulative curve for the sampling variable or correlation variable when correlation? is specified.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Specifies the number of bins.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)
                def diameter_statistics(self, *args, **kwargs):
                    """
                    Computes the Rosin Rammler parameters, Sauter, and other mean diameters.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)
                def histogram_mode(self, *args, **kwargs):
                    """
                    Uses bars for the histogram plot or xy-style.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                def correlation(self, *args, **kwargs):
                    """
                    Computes the correlation of the sampling variable with another variable.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/correlation").execute(*args, **kwargs)
                def percentage(self, *args, **kwargs):
                    """
                    Uses percentages of bins to be computed.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Specifies the maximum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Specifies the minimum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                def variable_power_3(self, *args, **kwargs):
                    """
                    Use the cubic of the cumulation variable during computation of the cumulative curve.
                    When the particle mass was not sampled, the diameter can be used instead.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Enables/disables the use of logarithmic scaling on the abscissa of the histogram.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)

    class turbo_workflow(TUIMenu):
        """
        Enter the turbo workflow menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.workflow = self.__class__.workflow(path + ["workflow"], service)
            super().__init__(path, service)

        class workflow(TUIMenu):
            """
            Enter the workflow menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def enable(self, *args, **kwargs):
                """
                Enable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/enable").execute(*args, **kwargs)
            def reset(self, *args, **kwargs):
                """
                Reset the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/reset").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/disable").execute(*args, **kwargs)

    class define(TUIMenu):
        """
        Enter the define menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.phases = self.__class__.phases(path + ["phases"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.virtual_boundary = self.__class__.virtual_boundary(path + ["virtual_boundary"], service)
            self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
            self.profiles = self.__class__.profiles(path + ["profiles"], service)
            self.custom_field_functions = self.__class__.custom_field_functions(path + ["custom_field_functions"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
            self.spectral = self.__class__.spectral(path + ["spectral"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.curvilinear_coordinate_system = self.__class__.curvilinear_coordinate_system(path + ["curvilinear_coordinate_system"], service)
            super().__init__(path, service)
        def injections(self, *args, **kwargs):
            """
            Enters the injections menu.  For a description of the items in this menu, see define/models/dpm/injections.
            """
            return PyMenu(self.service, "/define/injections").execute(*args, **kwargs)
        def physics(self, *args, **kwargs):
            """
            Manage Physics-regions.
            """
            return PyMenu(self.service, "/define/physics").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Sets unit conversion factors.
            """
            return PyMenu(self.service, "/define/units").execute(*args, **kwargs)
        def beta_feature_access(self, *args, **kwargs):
            """
            Enable access to beta features in the interface.
            """
            return PyMenu(self.service, "/define/beta_feature_access").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            Applies a standard set of units to all quantities. The options include default,si, british, andcgs.
            """
            return PyMenu(self.service, "/define/set_unit_system").execute(*args, **kwargs)
        def enable_mesh_morpher_optimizer(self, *args, **kwargs):
            """
            Enables the mesh morpher/optimizer. When the mesh morpher/optimizer is enabled, the define/mesh-morpher-optimizer text command becomes available.
            """
            return PyMenu(self.service, "/define/enable_mesh_morpher_optimizer").execute(*args, **kwargs)

        class phases(TUIMenu):
            """
            Enters the phases menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                super().__init__(path, service)

            class iac_expert(TUIMenu):
                """
                Enters the IAC expert setting menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hibiki_ishii_model(self, *args, **kwargs):
                    """
                    Sets Hibiki-Ishii model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)
                def iac_pseudo_time_step(self, *args, **kwargs):
                    """
                    Set iac pseudo-time.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)
                def yao_morel_model(self, *args, **kwargs):
                    """
                    Sets Yao-Morel model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)
                def ishii_kim_model(self, *args, **kwargs):
                    """
                    Sets Ishii-Kim model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)

            class set_domain_properties(TUIMenu):
                """
                Enters the menu to set phase domain properties.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                    super().__init__(path, service)
                def phase_domains(self, *args, **kwargs):
                    """
                    Enters the menu to select a specific phase.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                def change_phases_names(self, *args, **kwargs):
                    """
                    Allows you to change the names of all the phases in your simulation.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                class interaction_domain(TUIMenu):
                    """
                    Enters the menu to set the interaction domain 	properties.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                        self.forces = self.__class__.forces(path + ["forces"], service)
                        self.numerics = self.__class__.numerics(path + ["numerics"], service)
                        self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                        self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                        super().__init__(path, service)

                    class heat_mass_reactions(TUIMenu):
                        """
                        Enters the menu to set heat, mass-transfer, and reaction models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            super().__init__(path, service)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Allows you to define multiple heterogeneous reactions and stoichiometry. This option is available only with the species model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Species the heat transfer coefficient function between each pair of phases (constant-htc, nusselt-number, ranz-marshall, hughmark, tomiyama, fixed-to-sat-temp, two-resistance, or user-defined). This command is enable only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enters the menu to set cavitation models. This option is available only for the Mixture multiphase model with the Singhal-et-al cavitation model enabled via solve/set/advanced/singhal-et-al-cavitation-model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Sets the vaporization pressure, surface tension coefficient, and non-condensable gas mass fraction. This command is available only when cavitation? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)

                    class forces(TUIMenu):
                        """
                        Enters the menu to set interfacial forces models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            super().__init__(path, service)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specifies the drag function, drag modification, and drag factor for each pair of phases. This command is available only with the Eulerian and Mixture multiphase models.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specifies the turbulent dispersion model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specifies the restitution coefficient for collisions between each pair of granular phases, and for collisions between particles of the same granular phase. This command is available only for multiphase flows with two or more granular phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specifies the wall lubrication model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specifies the slip velocity function for each secondary phase with respect to the primary phase. This command is available only for the Mixture multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specifies the turbulence interaction model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enters the menu to set the lift force. This item is available only with the Eulerian multiphase model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                Specifies the lift function for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Enables/disables the Shaver-Podowski lift correction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enters the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specifies the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Allows you to include the effects of surface tension along the fluid-fluid interface. This option is only available for the VOF and Eulerian multiphase models.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Selects the surface tension model. You can choose between the continuum surface force and continuum surface stress methods. This item is available only when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the treatment of the contact angle specification at the porous jump boundary. This command is available only for the VOF multiphase model with the continuum surface stress model option and when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the specification for a wall adhesion angle. This item is available only whensfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enters the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specifies the virtual mass coefficient for each pair of phases. This option is available only ifvirtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Allows you to include the virtual mass force effect that occurs when a secondary phase accelerates relative to the primary phase. This command is available only with the Eulerian multiphase model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Specifies what form of the implicit method to use (default, option-2, or option-3). default models the entire virtual mass force while option-2 and option-3 model truncated expressions which may further improve convergence. This option is available only if vmass-implicit? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enables/disables the implicit method for the virtual mass force. This option can improve convergence in some cases. This option is available only if virtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)

                    class numerics(TUIMenu):
                        """
                        Enters the menu to set numerics models. This menu is available for multiphase models with the sharp-dispersed and phase localized discretization interface modeling options (set in define/models/multiphase/interface-modeling-options).
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            super().__init__(path, service)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enters the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enables/disables phase localized compressive scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specifies the slope limiter to set a specific discretization scheme for each phase pair. A value of 0 corresponds to first order upwind, a value of 1 corresponds to second order upwind, a value of 2 applies the compressive scheme, and a value between 0 and 2 corresponds to a blended scheme. This option is available only wheninterphase-discr? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)

                    class interfacial_area(TUIMenu):
                        """
                        Enters the menu to set interfacial area models. This menu is available only for the Mixture and Eulerian multiphase models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            super().__init__(path, service)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Specifies the interfacial area model for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)

                    class model_transition(TUIMenu):
                        """
                        Enters the menu to set model transition mechanisms.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            super().__init__(path, service)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Sets the VOF-to-DPM model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)

        class overset_interfaces(TUIMenu):
            """
            Enters the overset interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                self.cut_control = self.__class__.cut_control(path + ["cut_control"], service)
                self.adapt = self.__class__.adapt(path + ["adapt"], service)
                super().__init__(path, service)
            def write_dci(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to a text file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_dci").execute(*args, **kwargs)
            def find_bounding_cell(self, *args, **kwargs):
                """
                Find bounding cell for given cell or search point.
                """
                return PyMenu(self.service, "/define/overset_interfaces/find_bounding_cell").execute(*args, **kwargs)
            def read_dci_from_case(self, *args, **kwargs):
                """
                Read domain connectivity information (DCI) from case file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/read_dci_from_case").execute(*args, **kwargs)
            def grid_priorities(self, *args, **kwargs):
                """
                Allows you to specify grid priorities on background and component meshes, used in the overlap minimization of an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/grid_priorities").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists information about the overset interfaces. The output depends on the overset verbosity setting.
                """
                return PyMenu(self.service, "/define/overset_interfaces/list").execute(*args, **kwargs)
            def intersect_all(self, *args, **kwargs):
                """
                Executes hole cutting for all overset interfaces in the domain. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/intersect_all").execute(*args, **kwargs)
            def clear_all(self, *args, **kwargs):
                """
                Clears the domain connectivity of all overset interfaces. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/clear_all").execute(*args, **kwargs)
            def mark_cells(self, *args, **kwargs):
                """
                Marks the specified overset cells (solve, receptor, donor, orphan, or dead) and fills registers based on the markings. Display the marked cells via the text command define/overset-interfaces/display-cells.
                """
                return PyMenu(self.service, "/define/overset_interfaces/mark_cells").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/delete").execute(*args, **kwargs)
            def display_cells(self, *args, **kwargs):
                """
                Displays the overset cells marked using the text command define/overset-interfaces/mark-cells.
                """
                return PyMenu(self.service, "/define/overset_interfaces/display_cells").execute(*args, **kwargs)
            def update_from_dci(self, *args, **kwargs):
                """
                Update all overset intrfaces from stored domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/update_from_dci").execute(*args, **kwargs)
            def fill_dci(self, *args, **kwargs):
                """
                Fill overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/fill_dci").execute(*args, **kwargs)
            def debug_hole_cut(self, *args, **kwargs):
                """
                Debugging tool to troubleshoot hole cutting of overset interfaces. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/debug_hole_cut").execute(*args, **kwargs)
            def check(self, *args, **kwargs):
                """
                Checks the integrity of the overset interfaces. Reports orphan cells and errors in the domain connectivity.
                """
                return PyMenu(self.service, "/define/overset_interfaces/check").execute(*args, **kwargs)
            def intersect(self, *args, **kwargs):
                """
                Executes the hole cutting of an overset interface and establishes the domain connectivity. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/intersect").execute(*args, **kwargs)
            def clear(self, *args, **kwargs):
                """
                Clears the domain connectivity of an overset interface. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/clear").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all overset interfaces in the domain.
                """
                return PyMenu(self.service, "/define/overset_interfaces/delete_all").execute(*args, **kwargs)
            def mark_cell_change(self, *args, **kwargs):
                """
                Marks cells that have undergone a specified overset cell type change (from solve,receptor, or dead to any other type) in the last time step. Adaption registers are automatically filled based on these markings. This text command is only available for unsteady simulations and if define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/mark_cell_change").execute(*args, **kwargs)
            def write_dci_to_case(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to case file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_dci_to_case").execute(*args, **kwargs)
            def set_mark_bounds(self, *args, **kwargs):
                """
                Allows you to set bounds so that any marking of cells is performed within a spherical region based on a specified origin and radius. This can be useful when diagnosing a local problem on a large mesh. This text command is only available if define/overset-interfaces/options/expert? is set to yes. After defining the bounds, you can then mark the cells using the define/overset-interfaces/mark-cell-change or define/overset-interfaces/mark-cells text command. To disable the bounds, enter a radius of 0.
                """
                return PyMenu(self.service, "/define/overset_interfaces/set_mark_bounds").execute(*args, **kwargs)
            def write_cell_types(self, *args, **kwargs):
                """
                Write overset cell types into file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_cell_types").execute(*args, **kwargs)
            def free_dci(self, *args, **kwargs):
                """
                Free overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/free_dci").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/create").execute(*args, **kwargs)
            def find_all_bounding_cells(self, *args, **kwargs):
                """
                Find bounding cells for all cell centroids.
                """
                return PyMenu(self.service, "/define/overset_interfaces/find_all_bounding_cells").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the overset interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def modified_donor_search(self, *args, **kwargs):
                    """
                    Enables / disables modified donor search parameters. When enabled, these parameters result in 	a more extended donor search, which can be helpful for 	meshes with orphans. This text command is only available 	when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/modified_donor_search").execute(*args, **kwargs)
                def auto_create(self, *args, **kwargs):
                    """
                    Enables the automatic creation of a default overset interface during 	initialization or mesh motion update.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/auto_create").execute(*args, **kwargs)
                def overlap_boundaries(self, *args, **kwargs):
                    """
                    Allows you to disable the detection of overlapping boundaries during hole cutting, 	in order to reduce the computational expense for cases 	that do not include such boundaries. When enabled, this 	text command also allows you to specify which boundary 	zones should be considered when detecting overlapping 	boundaries; this can be helpful when the default hole 	cutting process fails.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/overlap_boundaries").execute(*args, **kwargs)
                def dead_cell_update(self, *args, **kwargs):
                    """
                    Enables/disables the updating of dead cells during the solution process, which may 	be helpful for some moving and dynamic mesh simulations 	(though at the cost of solver performance). You can 	enter the number of layers of dead cells adjacent to the 	receptor cells that you want updated, or enter -1 to request that all dead 	cells are updated. This text command is only available 	for transient simulations when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/dead_cell_update").execute(*args, **kwargs)
                def minimize_overlap(self, *args, **kwargs):
                    """
                    Allows you to disable overlap minimization during hole cutting.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/minimize_overlap").execute(*args, **kwargs)
                def solve_island_removal(self, *args, **kwargs):
                    """
                    Sets the method used to control the removal of isolated patches of solve cells. This text 	command is only available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/solve_island_removal").execute(*args, **kwargs)
                def node_connected_donors(self, *args, **kwargs):
                    """
                    Allows you to switch between face or node connected donor cells. This text command is only 	available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/node_connected_donors").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specifies the level of detail printed in the console about overset 	interfaces.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/verbosity").execute(*args, **kwargs)
                def donor_priority_method(self, *args, **kwargs):
                    """
                    Allows you to specify whether the cell donor priority used in the overlap 	minimization of an overset interface is inversely proportional to either the 	cell size or the distance to the nearest boundary.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/donor_priority_method").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enables / disables overset-related expert tools.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/expert").execute(*args, **kwargs)
                def render_receptor_cells(self, *args, **kwargs):
                    """
                    Allows you to enable visualization of receptor cells in contour and mesh 	displays.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/render_receptor_cells").execute(*args, **kwargs)
                def mesh_interfaces(self, *args, **kwargs):
                    """
                    Allows the inclusion of non-conformal mesh interfaces 	inside overset cell zones, as long as the mesh 	interfaces do not spatially overlap with the cells where 	the overset interfaces lie.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/mesh_interfaces").execute(*args, **kwargs)
                def modified_hole_cutting(self, *args, **kwargs):
                    """
                    Enables / disables modified hole cutting parameters. When enabled, the parameters used can 	help avoid dead cell zones that result from a hole 	cutting failure. This text command is only available 	when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/modified_hole_cutting").execute(*args, **kwargs)
                def transient_caching(self, *args, **kwargs):
                    """
                    Sets the options to control caching of entities in transient overset simulations. This text 	command is only available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/transient_caching").execute(*args, **kwargs)
                def parallel(self, *args, **kwargs):
                    """
                    Allows you to select the algorithm used for overset parallel processing. You can 	select from the default cell exchange model or the local 	cell zone replication model; the cell exchange model 	should require less memory and may result in faster 	calculations.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/parallel").execute(*args, **kwargs)
                def partial_cut_faces(self, *args, **kwargs):
                    """
                    Enables/disables enhanced hole cutting, where partially overlapping cut faces are 	decomposed into overlapping and non-overlapping 	fractions, and only the non-overlapping fractions 	participate in the hole cutting. This can help avoid the 	situation where a region or cell zone is erroneously 	identified as dead because of leakage during flood 	filling, even though it has overlapping boundaries that 	match well. When this text command is disabled, the 	partially overlapping faces are entirely protected from 	cutting.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/partial_cut_faces").execute(*args, **kwargs)
                def update_before_case_write(self, *args, **kwargs):
                    """
                    Enables/disables the updating of the overset interfaces before writing a case file in the 	Common Fluids Format (CFF). This text command is only 	available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/update_before_case_write").execute(*args, **kwargs)

            class cut_control(TUIMenu):
                """
                Enters the overset hole cut control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.cut_seeds = self.__class__.cut_seeds(path + ["cut_seeds"], service)
                    super().__init__(path, service)
                def delete_all(self, *args, **kwargs):
                    """
                    Deletes the hole cut controls for all boundary 	zones.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/delete_all").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes the hole cut control for a boundary 	zone.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Adds a hole cut control, so that a boundary zone does 	not cut specified cell zones.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists the defined hole cut controls.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/list").execute(*args, **kwargs)

                class cut_seeds(TUIMenu):
                    """
                    Enters the overset hole cut seeds menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a hole cut seed.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/delete").execute(*args, **kwargs)
                    def cut_seeds_for_all_component_zones(self, *args, **kwargs):
                        """
                        Specifies whether all component zones get cut seeds, which cut pilot holes into the overlapping meshes that will then be enlarged during overlap minimization.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/cut_seeds_for_all_component_zones").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a hole cut seed.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/add").execute(*args, **kwargs)
                    def delete_all(self, *args, **kwargs):
                        """
                        Delete all hole cut seeds.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/delete_all").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the defined hole cut seeds.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/list").execute(*args, **kwargs)

            class adapt(TUIMenu):
                """
                Enters the overset adaption menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def mark_adaption(self, *args, **kwargs):
                    """
                    Marks cells to identify those that can be adapted in 	order to improve your overset mesh.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/adapt/mark_adaption").execute(*args, **kwargs)
                def adapt_mesh(self, *args, **kwargs):
                    """
                    Marks and adapts the mesh to improve your overset 	mesh.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/adapt/adapt_mesh").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enters the overset adaption set menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def automatic(self, *args, **kwargs):
                        """
                        Enable the option to automatically adapt overset meshes during solution update.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/automatic").execute(*args, **kwargs)
                    def anisotropic(self, *args, **kwargs):
                        """
                        Enable the option to use anisotropic adaption in prismatic cells.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/anisotropic").execute(*args, **kwargs)
                    def mark_gaps(self, *args, **kwargs):
                        """
                        Enable the option to adapt underresolved gaps.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_gaps").execute(*args, **kwargs)
                    def mark_orphans(self, *args, **kwargs):
                        """
                        Enables/disables the option to adapt for orphan reduction.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_orphans").execute(*args, **kwargs)
                    def gap_resolution(self, *args, **kwargs):
                        """
                        Set the target (minimum) gap resolution used when marking cells for gap adaption.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/gap_resolution").execute(*args, **kwargs)
                    def maximum_refinement_level(self, *args, **kwargs):
                        """
                        Sets the maximum level of refinement during overset adaption, in conjunction with the value set using the mesh/adapt/set/maximum-refinement-level text command (the larger of the two values is used).
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                    def mark_fixed_orphans(self, *args, **kwargs):
                        """
                        Enables/disables the option to also adapt based on cells that are not actual orphans because they were fixed by accepting neighbor donors. This option is only applied if define/overset-interfaces/adapt/set/mark-orphans? is enabled.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_fixed_orphans").execute(*args, **kwargs)
                    def mark_coarsening(self, *args, **kwargs):
                        """
                        Enables/disables the option to coarsen the mesh if mesh refinement is no longer needed. This option is enabled by default.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_coarsening").execute(*args, **kwargs)
                    def adaption_sweeps(self, *args, **kwargs):
                        """
                        Sets the number of rounds of adaption applied during each adaption cycle.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/adaption_sweeps").execute(*args, **kwargs)
                    def mark_size(self, *args, **kwargs):
                        """
                        Enables/disables the option to adapt based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_size").execute(*args, **kwargs)
                    def buffer_layers(self, *args, **kwargs):
                        """
                        Sets the number of cell layers marked in addition to the cells marked for orphan adaption.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/buffer_layers").execute(*args, **kwargs)
                    def length_ratio_max(self, *args, **kwargs):
                        """
                        Sets the length scale ratio threshold used to determine which cells are marked for adaption based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/length_ratio_max").execute(*args, **kwargs)

        class parameters(TUIMenu):
            """
            Enters the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enables/disables parameters in the text user interface.
                """
                return PyMenu(self.service, "/define/parameters/enable_in_TUI").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enters the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/edit").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/list").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enters the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rename(self, *args, **kwargs):
                    """
                    Renames an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/rename").execute(*args, **kwargs)
                def print_to_console(self, *args, **kwargs):
                    """
                    Displays parameter value in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_to_console").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Writes parameter value to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/delete").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Displays all parameter values in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/edit").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/create").execute(*args, **kwargs)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Writes all parameter values to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/input_parameters").execute(*args, **kwargs)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/output_parameters").execute(*args, **kwargs)

        class mixing_planes(TUIMenu):
            """
            Enters the mixing planes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def create(self, *args, **kwargs):
                """
                Creates a mixing plane.
                """
                return PyMenu(self.service, "/define/mixing_planes/create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a mixing plane.
                """
                return PyMenu(self.service, "/define/mixing_planes/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists defined mixing plane(s).
                """
                return PyMenu(self.service, "/define/mixing_planes/list").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Sets global parameters relevant to mixing planes.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.conserve_total_enthalpy = self.__class__.conserve_total_enthalpy(path + ["conserve_total_enthalpy"], service)
                    self.conserve_swirl = self.__class__.conserve_swirl(path + ["conserve_swirl"], service)
                    super().__init__(path, service)
                def fix_pressure_level(self, *args, **kwargs):
                    """
                    Sets fixed pressure level using value based on define/reference-pressure-location.
                    """
                    return PyMenu(self.service, "/define/mixing_planes/set/fix_pressure_level").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Sets mixing plane under-relaxation factor.
                    """
                    return PyMenu(self.service, "/define/mixing_planes/set/under_relaxation").execute(*args, **kwargs)
                def averaging_method(self, *args, **kwargs):
                    """
                    Sets the mixing plane profile averaging method.
                    """
                    return PyMenu(self.service, "/define/mixing_planes/set/averaging_method").execute(*args, **kwargs)

                class conserve_total_enthalpy(TUIMenu):
                    """
                    Enters the menu to set total enthalpy conservation in mixing plane menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enables/disables total enthalpy conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/define/mixing_planes/set/conserve_total_enthalpy/enable").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enables/disables verbosity in total-enthalpy conservation calculations.
                        """
                        return PyMenu(self.service, "/define/mixing_planes/set/conserve_total_enthalpy/verbosity").execute(*args, **kwargs)

                class conserve_swirl(TUIMenu):
                    """
                    Enters the menu to set swirl conservation in mixing plane menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def report_swirl_integration(self, *args, **kwargs):
                        """
                        Reports swirl integration (Torque) on inflow and outflow zones.
                        """
                        return PyMenu(self.service, "/define/mixing_planes/set/conserve_swirl/report_swirl_integration").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enables/disables verbosity in swirl conservation calculations.
                        """
                        return PyMenu(self.service, "/define/mixing_planes/set/conserve_swirl/verbosity").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enables/disables swirl conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/define/mixing_planes/set/conserve_swirl/enable").execute(*args, **kwargs)

        class gap_model(TUIMenu):
            """
            Enters the gap model menu, where you can define one or more gap regions where the flow is blocked or decelerated when face zones move within a specified proximity threshold of each other.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.advanced_options = self.__class__.advanced_options(path + ["advanced_options"], service)
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes an existing gap region.
                """
                return PyMenu(self.service, "/define/gap_model/delete").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the existing gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/delete_all").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates a single gap region, so that when selected face zones move within a specified proximity threshold of each other, flow blockage / deceleration is applied to the cells that lie within the threshold.
                """
                return PyMenu(self.service, "/define/gap_model/create").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing gap region.
                """
                return PyMenu(self.service, "/define/gap_model/edit").execute(*args, **kwargs)
            def list_gap_face_zones(self, *args, **kwargs):
                """
                Lists the names of the face zones that can be used for creating gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_face_zones").execute(*args, **kwargs)
            def render_gap_regions(self, *args, **kwargs):
                """
                Update gap regions for postprocessing.
                """
                return PyMenu(self.service, "/define/gap_model/render_gap_regions").execute(*args, **kwargs)
            def list_gap_cell_zones(self, *args, **kwargs):
                """
                Lists the names of the cell zones that can be excluded for individual gap regions (so that such cells are not marked for flow blockage / deceleration).
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_cell_zones").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables/disables the gap model.
                """
                return PyMenu(self.service, "/define/gap_model/enable").execute(*args, **kwargs)
            def list_gap_regions(self, *args, **kwargs):
                """
                Lists the properties of the gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_regions").execute(*args, **kwargs)

            class advanced_options(TUIMenu):
                """
                Enters the advanced options menu for the gap model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def render_gap_interface(self, *args, **kwargs):
                    """
                    Enables/disables the rendering of the mesh surfaces inside the gap regions when 	displaying the mesh with contours. Note that the 	solution is still not rendered inside the flow-blocking 	gap regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/render_gap_interface").execute(*args, **kwargs)
                def revert_controls_to_default(self, *args, **kwargs):
                    """
                    Reverts the global gap stabilization level and any related 	solver settings to the default.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/revert_controls_to_default").execute(*args, **kwargs)
                def render_flow_modeling_gaps(self, *args, **kwargs):
                    """
                    Enables/disables the rendering of the solution in the cells of flow-modeling gap 	regions during postprocessing. This text command is only 	available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/render_flow_modeling_gaps").execute(*args, **kwargs)
                def update_gap_regions(self, *args, **kwargs):
                    """
                    Update gap regions and gap model solution information.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/update_gap_regions").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity for messages printed in the console 	related to the gap model.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/verbosity").execute(*args, **kwargs)
                def enhanced_data_interpolation(self, *args, **kwargs):
                    """
                    Enables/disables the use of enhanced data 	interpolation when updating information in gap regions. 	This text command is only available if you have enabled 	the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/enhanced_data_interpolation").execute(*args, **kwargs)
                def clear_gap_regions(self, *args, **kwargs):
                    """
                    Clear gap model solution information and marks.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/clear_gap_regions").execute(*args, **kwargs)
                def precise_gap_marking(self, *args, **kwargs):
                    """
                    Enables/disables the use of a more accurate search algorithm for marking cells in 	gap regions. Note that it can be costly, particularly 	for 3D cases or those with a large number of cells 	inside the gap regions. This text command is only 	available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/precise_gap_marking").execute(*args, **kwargs)
                def sponge_layer(self, *args, **kwargs):
                    """
                    Allows you to edit the solution stabilization settings for flow-modeling gap regions 	that have sponge-layer local stabilization 	enabled.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/sponge_layer").execute(*args, **kwargs)
                def fill_data_in_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables the interpolation of solution data throughout the gap regions. This 	text command is only available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/fill_data_in_gap_regions").execute(*args, **kwargs)
                def alternative_marking(self, *args, **kwargs):
                    """
                    Mark gap regions using an alternative marking algorithm.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/alternative_marking").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Sets the global solution stabilization level for the gap 	regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/solution_stabilization").execute(*args, **kwargs)
                def reduce_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables a more restrictive algorithm for marking cells in gap regions. This 	text command is only available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/reduce_gap_regions").execute(*args, **kwargs)
                def check_cfl_condition(self, *args, **kwargs):
                    """
                    Enables/disables the printing of warnings if the time 	step size is too large based on a Courant (CFL) number 	automatically determined for your specified solution 	stability level.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/check_cfl_condition").execute(*args, **kwargs)
                def extend_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables the extending of the gap regions by including additional cells in 	the vicinity of the gap interfaces during marking. This 	is useful when the default shape of the marked cells is 	negatively affecting solution stability or convergence 	behavior.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/extend_gap_regions").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enables/disables access to expert-level text commands 	for the gap model.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/expert").execute(*args, **kwargs)
                def include_coupled_walls(self, *args, **kwargs):
                    """
                    Include coupled walls in gap face zones.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/include_coupled_walls").execute(*args, **kwargs)
                def cell_check_distance_factor(self, *args, **kwargs):
                    """
                    Enter value of the cell distance factor.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/cell_check_distance_factor").execute(*args, **kwargs)
                def flow_blocking_stabilization_parameters(self, *args, **kwargs):
                    """
                    Adjust stabilization settings for the sponge layer used for blocked gap regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/flow_blocking_stabilization_parameters").execute(*args, **kwargs)

        class virtual_boundary(TUIMenu):
            """
            Manage Virtual Boundaries.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def hole_geometry(self, *args, **kwargs):
                """
                Create a Hole Geometry template.
                """
                return PyMenu(self.service, "/define/virtual_boundary/hole_geometry").execute(*args, **kwargs)
            def boundary_interface(self, *args, **kwargs):
                """
                Create a Boundary Interface.
                """
                return PyMenu(self.service, "/define/virtual_boundary/boundary_interface").execute(*args, **kwargs)

        class solution_strategy(TUIMenu):
            """
            Enters the automatic initialization and case modification strategy menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.automatic_case_modification = self.__class__.automatic_case_modification(path + ["automatic_case_modification"], service)
                super().__init__(path, service)
            def disable_modification(self, *args, **kwargs):
                """
                Disable a single defined case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/disable_modification").execute(*args, **kwargs)
            def import_modifications(self, *args, **kwargs):
                """
                Import a list of case modifications from a tsv file.
                """
                return PyMenu(self.service, "/define/solution_strategy/import_modifications").execute(*args, **kwargs)
            def enable_strategy(self, *args, **kwargs):
                """
                Enables/disables automatic initialization and case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/enable_strategy").execute(*args, **kwargs)
            def export_modifications(self, *args, **kwargs):
                """
                Export all case modifications to a tsv file.
                """
                return PyMenu(self.service, "/define/solution_strategy/export_modifications").execute(*args, **kwargs)
            def continue_strategy_execution(self, *args, **kwargs):
                """
                Continues execution of the currently defined automatic initialization and case modification strategy.
                """
                return PyMenu(self.service, "/define/solution_strategy/continue_strategy_execution").execute(*args, **kwargs)
            def execute_strategy(self, *args, **kwargs):
                """
                Executes the currently defined automatic initialization and case modification strategy.
                """
                return PyMenu(self.service, "/define/solution_strategy/execute_strategy").execute(*args, **kwargs)
            def delete_modification(self, *args, **kwargs):
                """
                Delete a single case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/delete_modification").execute(*args, **kwargs)
            def enable_modification(self, *args, **kwargs):
                """
                Enable a single defined case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/enable_modification").execute(*args, **kwargs)
            def copy_modification(self, *args, **kwargs):
                """
                Copy a single case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/copy_modification").execute(*args, **kwargs)
            def add_edit_modification(self, *args, **kwargs):
                """
                Define a single case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/add_edit_modification").execute(*args, **kwargs)
            def automatic_initialization(self, *args, **kwargs):
                """
                Defines how the case is to be automatically initialized.
                """
                return PyMenu(self.service, "/define/solution_strategy/automatic_initialization").execute(*args, **kwargs)

            class automatic_case_modification(TUIMenu):
                """
                Enters the automatic case modification menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def original_settings(self, *args, **kwargs):
                    """
                    Specifies modification to be performed after initialization to restore to original 	settings.
                    """
                    return PyMenu(self.service, "/define/solution_strategy/automatic_case_modification/original_settings").execute(*args, **kwargs)
                def before_init_modification(self, *args, **kwargs):
                    """
                    Specifies modification to be performed before initialization.
                    """
                    return PyMenu(self.service, "/define/solution_strategy/automatic_case_modification/before_init_modification").execute(*args, **kwargs)
                def modifications(self, *args, **kwargs):
                    """
                    Specifies modifications to be performed during solution.
                    """
                    return PyMenu(self.service, "/define/solution_strategy/automatic_case_modification/modifications").execute(*args, **kwargs)

        class profiles(TUIMenu):
            """
            Enters the boundary profiles menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def link_profile_to_reference_frame(self, *args, **kwargs):
                """
                Attaches a profile to a reference frame so that the profile will rotate according to the reference frame.
                """
                return PyMenu(self.service, "/define/profiles/link_profile_to_reference_frame").execute(*args, **kwargs)
            def orient_profile(self, *args, **kwargs):
                """
                Re-orient an existing profile.
                """
                return PyMenu(self.service, "/define/profiles/orient_profile").execute(*args, **kwargs)
            def interpolation_method(self, *args, **kwargs):
                """
                Chooses the method for interpolation of profiles.
                """
                return PyMenu(self.service, "/define/profiles/interpolation_method").execute(*args, **kwargs)
            def display_profile_point_cloud_data(self, *args, **kwargs):
                """
                Display Profile Point Cloud Data.
                """
                return PyMenu(self.service, "/define/profiles/display_profile_point_cloud_data").execute(*args, **kwargs)
            def list_profiles(self, *args, **kwargs):
                """
                Lists all profiles.
                """
                return PyMenu(self.service, "/define/profiles/list_profiles").execute(*args, **kwargs)
            def overlay_profile_surface(self, *args, **kwargs):
                """
                Overlay Profile Surface.
                """
                return PyMenu(self.service, "/define/profiles/overlay_profile_surface").execute(*args, **kwargs)
            def list_profile_parameters(self, *args, **kwargs):
                """
                List the parameters of a particular profile.
                """
                return PyMenu(self.service, "/define/profiles/list_profile_parameters").execute(*args, **kwargs)
            def replicate_profile(self, *args, **kwargs):
                """
                Replicate Profile.
                """
                return PyMenu(self.service, "/define/profiles/replicate_profile").execute(*args, **kwargs)
            def set_preference_profile_point_cloud_data(self, *args, **kwargs):
                """
                Set Preference Profile Point Cloud Data e.g., Point marker symbol,size,color.
                """
                return PyMenu(self.service, "/define/profiles/set_preference_profile_point_cloud_data").execute(*args, **kwargs)
            def display_profile_surface(self, *args, **kwargs):
                """
                Display the profile as a surface (this option is only available if the specified profile contains node-connectivity data).
                """
                return PyMenu(self.service, "/define/profiles/display_profile_surface").execute(*args, **kwargs)
            def morphing(self, *args, **kwargs):
                """
                Enables/disables profile morphing options in Orient Profile panel.
                """
                return PyMenu(self.service, "/define/profiles/morphing").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all boundary-profiles.
                """
                return PyMenu(self.service, "/define/profiles/delete_all").execute(*args, **kwargs)
            def overlay_profile_point_cloud_data(self, *args, **kwargs):
                """
                Overlay Profile Point Cloud Data.
                """
                return PyMenu(self.service, "/define/profiles/overlay_profile_point_cloud_data").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a profile.
                """
                return PyMenu(self.service, "/define/profiles/delete").execute(*args, **kwargs)
            def list_profile_fields(self, *args, **kwargs):
                """
                Lists the fields of a particular profile.
                """
                return PyMenu(self.service, "/define/profiles/list_profile_fields").execute(*args, **kwargs)
            def update_interval(self, *args, **kwargs):
                """
                Sets interval between updates of dynamic profiles.
                """
                return PyMenu(self.service, "/define/profiles/update_interval").execute(*args, **kwargs)

        class custom_field_functions(TUIMenu):
            """
            Enters the custom field functions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def load(self, *args, **kwargs):
                """
                Loads a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/load").execute(*args, **kwargs)
            def save(self, *args, **kwargs):
                """
                Saves a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/save").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/delete").execute(*args, **kwargs)
            def define(self, *args, **kwargs):
                """
                Defines a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/define").execute(*args, **kwargs)
            def list_valid_cell_function_names(self, *args, **kwargs):
                """
                Lists the names of cell functions that can be used in a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/list_valid_cell_function_names").execute(*args, **kwargs)
            def example_cff_definitions(self, *args, **kwargs):
                """
                Lists example custom field functions.
                """
                return PyMenu(self.service, "/define/custom_field_functions/example_cff_definitions").execute(*args, **kwargs)

        class mesh_interfaces(TUIMenu):
            """
            Enters the mesh-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mapped_interface_options = self.__class__.mapped_interface_options(path + ["mapped_interface_options"], service)
                self.non_conformal_interface_numerics = self.__class__.non_conformal_interface_numerics(path + ["non_conformal_interface_numerics"], service)
                self.auto_options = self.__class__.auto_options(path + ["auto_options"], service)
                super().__init__(path, service)
            def enable_si_with_nodes(self, *args, **kwargs):
                """
                Enable sliding interfaces with nodes.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enable_si_with_nodes").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all mesh interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/delete_all").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates mesh interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/create").execute(*args, **kwargs)
            def enforce_continuity_after_bc(self, *args, **kwargs):
                """
                Enables/disables continuity across the boundary condition interface for contour plots in postprocessing.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enforce_continuity_after_bc").execute(*args, **kwargs)
            def one_to_one_pairing(self, *args, **kwargs):
                """
                Use the default one-to-one interface creation method?.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/one_to_one_pairing").execute(*args, **kwargs)
            def auto_pairing(self, *args, **kwargs):
                """
                Automatically "pairs" some or all of the interface zones, in order to create mesh interfaces. This text command is only available when the define/mesh-interfaces/one-to-one-pairing? text command is disabled.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/auto_pairing").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Creates a general turbo interface. This text command is only available if the define/turbo-model/enable-turbo-model? text command is enabled.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/turbo_create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a mesh interface.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits attributes of existing mesh interfaces. For one-to-one interfaces, you can edit the name; for many-to-many interfaces, you can edit the interface options and (for a single interface) the name and the list of interface zones assigned to the interface.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/edit").execute(*args, **kwargs)
            def enable_visualization_of_interfaces(self, *args, **kwargs):
                """
                Enables/disables the filling of node coordinates on the zones of mesh interfaces, so that they can be displayed in the graphics window.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enable_visualization_of_interfaces").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays the specified mesh interface zone.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/display").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/make_phaselag_from_periodic").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all mesh interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/list").execute(*args, **kwargs)
            def transfer_motion_across_interfaces(self, *args, **kwargs):
                """
                Enables/disables the automatic transfer of motion across a mesh interface when only one side is moving as a result of user-defined or system coupling motion. You can specify the method by which the motion is transferred: transfer-displacements (the default) interpolates nodal displacement from the active side of the interface to the passive side, and is recommended when there are gaps and/or penetrations in the mesh interface that must be maintained; project-nodes projects the passive nodes onto the faces of active side, and is recommended when the active side includes significant tangential motion (as only the normal displacement is effectively transferred in this method).
                """
                return PyMenu(self.service, "/define/mesh_interfaces/transfer_motion_across_interfaces").execute(*args, **kwargs)
            def verbosity(self, *args, **kwargs):
                """
                Sets the mesh interface verbosity.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/verbosity").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Make interface zones periodic.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/make_periodic").execute(*args, **kwargs)
            def enforce_coupled_wall_between_solids(self, *args, **kwargs):
                """
                Enables/disables automatic definition of solid-solid interfaces as coupled walls. By default this option is disabled and ANSYS Fluent creates interior boundaries at solid-solid interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enforce_coupled_wall_between_solids").execute(*args, **kwargs)
            def remove_left_handed_interface_faces(self, *args, **kwargs):
                """
                Removes left-handed faces (which can cause the mesh to be invalid) during mesh interface creation.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/remove_left_handed_interface_faces").execute(*args, **kwargs)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Get non-overlapping zone name from the associated interface zone.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/non_overlapping_zone_name").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Checks the quality of all mapped interfaces. If Fluent finds any mapped interfaces that require improvement it will list them and ask you if you would like to increase the tolerance to improve the interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/improve_quality").execute(*args, **kwargs)

            class mapped_interface_options(TUIMenu):
                """
                Enter the mapped-interface-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def solution_controls(self, *args, **kwargs):
                    """
                    Specification of mapped frequency and under-relaxation factor for mapped interfaces.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/mapped_interface_options/solution_controls").execute(*args, **kwargs)
                def convert_to_mapped_interface(self, *args, **kwargs):
                    """
                    Convert non-conformal mesh interface to mapped mesh interfaces.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/mapped_interface_options/convert_to_mapped_interface").execute(*args, **kwargs)
                def tolerance(self, *args, **kwargs):
                    """
                    Specification of mapped interface tolerance.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/mapped_interface_options/tolerance").execute(*args, **kwargs)

            class non_conformal_interface_numerics(TUIMenu):
                """
                Setting non-conformal numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def change_numerics(self, *args, **kwargs):
                    """
                    Enable modified non-conformal interface numerics.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/non_conformal_interface_numerics/change_numerics").execute(*args, **kwargs)

            class auto_options(TUIMenu):
                """
                Enters the auto-options menu. This menu is only available when the define/mesh-interfaces/one-to-one-pairing? text command is enabled.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pairing_between_different_cell_zones_only(self, *args, **kwargs):
                    """
                    Specifies whether the 	one-to-one mesh interfaces are only created between 	different cell zones.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/pairing_between_different_cell_zones_only").execute(*args, **kwargs)
                def naming_option(self, *args, **kwargs):
                    """
                    Specifies whether the name of each new one-to-one mesh 	interface (as well as existing mesh interfaces, if you 	so desire) has no additional suffix, or a suffix that 	includes the names of the associated boundary zones, the 	IDs of the associated boundary zones, or the names of 	the adjacent cell zones.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/naming_option").execute(*args, **kwargs)
                def keep_empty_interface(self, *args, **kwargs):
                    """
                    Keep empty interfaces during one-to-one mesh interface creation.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/keep_empty_interface").execute(*args, **kwargs)
                def set_one_to_one_pairing_tolerance(self, *args, **kwargs):
                    """
                    Enables/disables the use of adjustable tolerances to 	determine which of the selected boundary zones can be 	paired up to make the mesh interfaces, in order to 	account for gaps, thin layers, and/or complex 	geometries.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/set_one_to_one_pairing_tolerance").execute(*args, **kwargs)
                def set_default_name_prefix(self, *args, **kwargs):
                    """
                    Specifies the default interface 	name prefix used for one-to-one mesh interfaces.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/set_default_name_prefix").execute(*args, **kwargs)
                def pairing_between_interface_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones only.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/pairing_between_interface_zones_only").execute(*args, **kwargs)
                def proximity_tolerance(self, *args, **kwargs):
                    """
                    Sets the tolerance used as part 	of the automatic grouping of zones to create mesh 	interfaces when the define/mesh-interfaces/one-to-one-pairing? 	text command is disabled. The proximity tolerance is 	defined relative to the edge lengths in the interface 	zones, and can range from 0 to 1 (representing the minimum 	and maximum edge lengths, respectively).
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/proximity_tolerance").execute(*args, **kwargs)

        class reference_frames(TUIMenu):
            """
            Enters the reference frames menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def hide(self, *args, **kwargs):
                """
                Removes the specified reference frame from the graphics window.
                """
                return PyMenu(self.service, "/define/reference_frames/hide").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new reference frame.
                """
                return PyMenu(self.service, "/define/reference_frames/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/list_properties").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/display").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the reference frames.
                """
                return PyMenu(self.service, "/define/reference_frames/list").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/delete").execute(*args, **kwargs)
            def display_edit(self, *args, **kwargs):
                """
                Display and edit reference frame from graphics.
                """
                return PyMenu(self.service, "/define/reference_frames/display_edit").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Allows you to edit a reference frame.
                """
                return PyMenu(self.service, "/define/reference_frames/edit").execute(*args, **kwargs)

        class boundary_conditions(TUIMenu):
            """
            Enters the boundary conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.perforated_walls = self.__class__.perforated_walls(path + ["perforated_walls"], service)
                self.rename_zone = self.__class__.rename_zone(path + ["rename_zone"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.impedance_data_fitting = self.__class__.impedance_data_fitting(path + ["impedance_data_fitting"], service)
                self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
                self.non_reflecting_bc = self.__class__.non_reflecting_bc(path + ["non_reflecting_bc"], service)
                self.bc_settings = self.__class__.bc_settings(path + ["bc_settings"], service)
                super().__init__(path, service)
            def zone_name(self, *args, **kwargs):
                """
                Gives a zone a new name.
                """
                return PyMenu(self.service, "/define/boundary_conditions/zone_name").execute(*args, **kwargs)
            def periodic(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/periodic").execute(*args, **kwargs)
            def outflow(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/outflow").execute(*args, **kwargs)
            def geometry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/geometry").execute(*args, **kwargs)
            def recirculation_outlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/recirculation_outlet").execute(*args, **kwargs)
            def axis(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/axis").execute(*args, **kwargs)
            def copy_bc(self, *args, **kwargs):
                """
                Copies boundary conditions to other zones.
                """
                return PyMenu(self.service, "/define/boundary_conditions/copy_bc").execute(*args, **kwargs)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Displays the name of the non-overlapping zone associated with a specified interface zone. This text command is only available after a mesh interface has been created.
                """
                return PyMenu(self.service, "/define/boundary_conditions/non_overlapping_zone_name").execute(*args, **kwargs)
            def degassing(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/degassing").execute(*args, **kwargs)
            def recirculation_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/recirculation_inlet").execute(*args, **kwargs)
            def outlet_vent(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/outlet_vent").execute(*args, **kwargs)
            def network_end(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/network_end").execute(*args, **kwargs)
            def pressure_outlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/pressure_outlet").execute(*args, **kwargs)
            def interior(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/interior").execute(*args, **kwargs)
            def shadow(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/shadow").execute(*args, **kwargs)
            def rans_les_interface(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/rans_les_interface").execute(*args, **kwargs)
            def porous_jump(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/porous_jump").execute(*args, **kwargs)
            def exhaust_fan(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/exhaust_fan").execute(*args, **kwargs)
            def solid(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/solid").execute(*args, **kwargs)
            def velocity_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/velocity_inlet").execute(*args, **kwargs)
            def fan(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/fan").execute(*args, **kwargs)
            def mass_flow_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/mass_flow_inlet").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Sets the type for a zone or multiple zones of the same category. You will be prompted for the name / ID of the zone to be changed and the new type for that zone. To change multiple zones, you can enter a list (separated by spaces and contained within a pair of parentheses) or use asterisks (\*) as wildcards.
                """
                return PyMenu(self.service, "/define/boundary_conditions/zone_type").execute(*args, **kwargs)
            def mass_flow_outlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/mass_flow_outlet").execute(*args, **kwargs)
            def intake_fan(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/intake_fan").execute(*args, **kwargs)
            def overset(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/overset").execute(*args, **kwargs)
            def network(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/network").execute(*args, **kwargs)
            def openchannel_threads(self, *args, **kwargs):
                """
                Lists open channel group IDs, names, types and variables.
                """
                return PyMenu(self.service, "/define/boundary_conditions/openchannel_threads").execute(*args, **kwargs)
            def pressure_far_field(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/pressure_far_field").execute(*args, **kwargs)
            def wall(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/wall").execute(*args, **kwargs)
            def open_channel_wave_settings(self, *args, **kwargs):
                """
                Opens channel wave input analysis.
                """
                return PyMenu(self.service, "/define/boundary_conditions/open_channel_wave_settings").execute(*args, **kwargs)
            def knudsen_number_calculator(self, *args, **kwargs):
                """
                Computes the Knudsen number based on a characteristic physical length and the area-averaged flow quantities along an incoming-flow boundary. You can use this information to determine flow regime for selecting the appropriate wall boundary treatment. For details, see .
                """
                return PyMenu(self.service, "/define/boundary_conditions/knudsen_number_calculator").execute(*args, **kwargs)
            def inlet_vent(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/inlet_vent").execute(*args, **kwargs)
            def symmetry(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/symmetry").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                Prints out the types and IDs of all zones in the console window. You can use your mouse to check a zone ID, following the instructions listed under Zone in the
                Boundary Conditions Task Page
                section of the User’s Guide.
                """
                return PyMenu(self.service, "/define/boundary_conditions/list_zones").execute(*args, **kwargs)
            def interface(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/interface").execute(*args, **kwargs)
            def fluid(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/fluid").execute(*args, **kwargs)
            def pressure_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/pressure_inlet").execute(*args, **kwargs)
            def radiator(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/radiator").execute(*args, **kwargs)
            def target_mass_flow_rate_settings(self, *args, **kwargs):
                """
                Enters the targeted mass flow rate settings menu.
                """
                return PyMenu(self.service, "/define/boundary_conditions/target_mass_flow_rate_settings").execute(*args, **kwargs)

            class perforated_walls(TUIMenu):
                """
                Enters the perforated walls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def read_input_file(self, *args, **kwargs):
                    """
                    Reads an input file for perforated walls.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/perforated_walls/read_input_file").execute(*args, **kwargs)
                def model_setup(self, *args, **kwargs):
                    """
                    Sets up the perforated wall model for each effusion 	surface.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/perforated_walls/model_setup").execute(*args, **kwargs)

            class rename_zone(TUIMenu):
                """
                Enter the menu for renaming cell and face zones based on adjacency, adding suffixes or prefixes to names, and renaming zones based on the Fluent naming conventions.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rename_to_default(self, *args, **kwargs):
                    """
                    Rename a zone to use the Fluent naming 	convention.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/rename_zone/rename_to_default").execute(*args, **kwargs)
                def add_suffix_or_prefix(self, *args, **kwargs):
                    """
                    Add a suffix or prefix to one or more zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/rename_zone/add_suffix_or_prefix").execute(*args, **kwargs)
                def rename_by_adjacency(self, *args, **kwargs):
                    """
                    Append the name of the adjacent cell zone to the 	specified face zone. For example, if fluid is the adjacent cell 	zone, and you select a face zone named interior, the resulting name of 	the face zone would be interior-fluid.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/rename_zone/rename_by_adjacency").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Control settings while doing BC setup.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delay_model_change_update(self, *args, **kwargs):
                    """
                    Set model change call update.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/advanced/delay_model_change_update").execute(*args, **kwargs)
                def batch_thread_update(self, *args, **kwargs):
                    """
                    Set batch thread update option.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/advanced/batch_thread_update").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Allows you to define one or more settings at single or multiple boundaries/cell zones of a given type at once. Enter q to exit the define/boundary-conditions/set/<type> command.  For a description of the items in this menu, see corresponding define/boundary-conditions/<type>.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def solid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/solid").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/pressure_far_field").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/pressure_outlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/recirculation_outlet").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/inlet_vent").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/fan").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/overset").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/recirculation_inlet").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/radiator").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/fluid").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/outflow").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/shadow").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/network").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/wall").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/velocity_inlet").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/mass_flow_inlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/geometry").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/interior").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/rans_les_interface").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/degassing").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/pressure_inlet").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/symmetry").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/mass_flow_outlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/axis").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/porous_jump").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/exhaust_fan").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/intake_fan").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/outlet_vent").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/network_end").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/interface").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/periodic").execute(*args, **kwargs)

            class impedance_data_fitting(TUIMenu):
                """
                Enters the impedance data fitting menu, which provides text commands that can be helpful when you are using the impedance boundary condition (IBC).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def convergence_tolerance(self, *args, **kwargs):
                    """
                    Sets the convergence tolerance, which is an accuracy 	that is used for completing the iterative fitting 	procedure in the calculations performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. By default, the tolerance is set to 	1e-6.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/convergence_tolerance").execute(*args, **kwargs)
                def residue_tolerance(self, *args, **kwargs):
                    """
                    Sets the residue tolerance, which is the minimum value of residues that are kept in 	the fitting performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. This residue check helps to eliminate 	parasitic poles. By default, the tolerance is set to 	1e-6.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/residue_tolerance").execute(*args, **kwargs)
                def absorption_data(self, *args, **kwargs):
                    """
                    Reads an input file with experimental absorption coefficient data in the frequency 	domain and then computes the terms needed for an 	approximation of the reflection coefficient as a series 	of poles / residues in the time domain. The resulting 	terms are printed in the console, and can be written to 	a pole / residue file (which can be imported and the 	impedance parameters applied to a boundary condition 	using the define/boundary-conditions/impedance-data-fitting/import-parameters 	text command). You can also write a file with fitted 	frequency / impedance data, which can be compared to the 	input data to evaluate how well it fits.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/absorption_data").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the progress messages during the fitting performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. Setting this to 1 results in messages being 	printed in the console as the fitting calculation 	progresses. The default value of 0 suppresses this 	output.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/verbosity").execute(*args, **kwargs)
                def reflection_data(self, *args, **kwargs):
                    """
                    Reads an input file with experimental reflection coefficient data in the frequency 	domain and then computes the terms needed for an 	approximation of the reflection coefficient as a series 	of poles / residues in the time domain. The resulting 	terms are printed in the console, and can be written to 	a pole / residue file (which can be imported and the 	impedance parameters applied to a boundary condition 	using the define/boundary-conditions/impedance-data-fitting/import-parameters 	text command). You can also write a file with fitted 	frequency / impedance data, which can be compared to the 	input data to evaluate how well it fits.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/reflection_data").execute(*args, **kwargs)
                def impedance_data(self, *args, **kwargs):
                    """
                    Reads an input file with experimental specific 	impedance data in the frequency domain and then computes 	the terms needed for an approximation of the reflection 	coefficient as a series of poles / residues in the time 	domain. The resulting terms are printed in the console, 	and can be written to a pole / residue file (which can 	be imported and the impedance parameters applied to a 	boundary condition using the define/boundary-conditions/impedance-data-fitting/import-parameters 	text command). You can also write a file with fitted 	frequency / impedance data, which can be compared to the 	input data to evaluate how well it fits.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/impedance_data").execute(*args, **kwargs)
                def iterations(self, *args, **kwargs):
                    """
                    Sets the number of internal iterations used for the calculations performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. By default, the number of iterations 	is set to 20.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/iterations").execute(*args, **kwargs)
                def import_parameters(self, *args, **kwargs):
                    """
                    Reads a pole / residue file with impedance parameters 	in the time domain and applies them to a specified 	boundary condition.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/import_parameters").execute(*args, **kwargs)

            class modify_zones(TUIMenu):
                """
                Enters the modify zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def change_zone_phase(self, *args, **kwargs):
                    """
                    Change the realgas phase for a zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/change_zone_phase").execute(*args, **kwargs)
                def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                    """
                    Copies motion variable values for origin, axis, and velocities from Frame Motion to 	Mesh Motion.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
                def sep_face_zone_mark(self, *args, **kwargs):
                    """
                    Separates face zone based on cell marking.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
                def mrf_to_sliding_mesh(self, *args, **kwargs):
                    """
                    Changes the motion specification from MRF to moving mesh.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
                def sep_face_zone_region(self, *args, **kwargs):
                    """
                    Separates face zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
                def merge_zones(self, *args, **kwargs):
                    """
                    Merges zones of same type and condition into one.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/merge_zones").execute(*args, **kwargs)
                def extrude_face_zone_para(self, *args, **kwargs):
                    """
                    Extrudes a face thread a specified distance based on a distance and a list of 	parametric locations between 0 and 1, for example, 0 0.2 	0.4 0.8 1.0.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
                def matching_tolerance(self, *args, **kwargs):
                    """
                    Sets normalized tolerance used for finding coincident nodes.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/matching_tolerance").execute(*args, **kwargs)
                def copy_move_cell_zone(self, *args, **kwargs):
                    """
                    Creates a copy of a cell zone that is offset from the original either by a translational 	distance or a rotational angle. In the copied zone, the 	bounding face zones are all converted to walls, any 	existing cell data is initialized to a constant value, 	and non-conformal interfaces and dynamic zones are not 	copied; otherwise, the model settings are the same as in 	the original zone. Note that if you want the copied zone 	to be connected to existing zones, you must either fuse 	the boundaries (see ) or set up a 	non-conformal interface (see ).
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
                def zone_name(self, *args, **kwargs):
                    """
                    Gives a zone a new name.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/zone_name").execute(*args, **kwargs)
                def sep_cell_zone_region(self, *args, **kwargs):
                    """
                    Separates cell zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
                def delete_cell_zone(self, *args, **kwargs):
                    """
                    Deletes a cell thread.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/delete_cell_zone").execute(*args, **kwargs)
                def deactivate_cell_zone(self, *args, **kwargs):
                    """
                    Deactivates cell thread.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
                def slit_interior_between_diff_solids(self, *args, **kwargs):
                    """
                    Slits the interior zone between solid zones of differing materials to create a 	coupled wall. You will generally be prompted by Fluent 	if this is necessary.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
                def make_periodic(self, *args, **kwargs):
                    """
                    Attempts to establish periodic/shadow face zone connectivity.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/make_periodic").execute(*args, **kwargs)
                def zone_type(self, *args, **kwargs):
                    """
                    Sets the type for a zone or multiple zones of the same 	category. You will be prompted for the name / ID of the 	zone to be changed and the new type for that zone. To 	change multiple zones, you can enter a list (separated 	by spaces and contained within a pair of parentheses) or 	use asterisks (\*) as wildcards.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/zone_type").execute(*args, **kwargs)
                def append_mesh_data(self, *args, **kwargs):
                    """
                    Appends new mesh with data.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/append_mesh_data").execute(*args, **kwargs)
                def scale_zone(self, *args, **kwargs):
                    """
                    Scales individual cell zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/scale_zone").execute(*args, **kwargs)
                def change_zone_state(self, *args, **kwargs):
                    """
                    Sets the state (liquid or vapor) for a specific fluid zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/change_zone_state").execute(*args, **kwargs)
                def create_periodic_interface(self, *args, **kwargs):
                    """
                    Creates a conformal or non-conformal periodic 	interface.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/create_periodic_interface").execute(*args, **kwargs)
                def delete_all_shells(self, *args, **kwargs):
                    """
                    Deletes all shell zones and switches off shell conduction on all the walls. These 	zones can be recreated using the command recreate-all-shells.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/delete_all_shells").execute(*args, **kwargs)
                def replace_zone(self, *args, **kwargs):
                    """
                    Replaces cell zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/replace_zone").execute(*args, **kwargs)
                def slit_face_zone(self, *args, **kwargs):
                    """
                    Slits two-sided wall into two connected wall zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/slit_face_zone").execute(*args, **kwargs)
                def slit_periodic(self, *args, **kwargs):
                    """
                    Slits periodic zone into two symmetry zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/slit_periodic").execute(*args, **kwargs)
                def create_all_shell_threads(self, *args, **kwargs):
                    """
                    Marks all finite thickness walls for shell creation. Shell zones will be created at 	the start of the iterations.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
                def list_zones(self, *args, **kwargs):
                    """
                    Lists zone IDs, types, kinds, and names.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/list_zones").execute(*args, **kwargs)
                def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                    """
                    Converts all solid zones using frame motion to instead 	use solid motion, copying the motion variable values for 	origin, axis, and velocities.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
                def sep_face_zone_face(self, *args, **kwargs):
                    """
                    Separates each face in zone into unique zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
                def fuse_face_zones(self, *args, **kwargs):
                    """
                    Attempts to fuse zones by removing duplicate faces and nodes.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/fuse_face_zones").execute(*args, **kwargs)
                def translate_zone(self, *args, **kwargs):
                    """
                    Translates individual cell zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/translate_zone").execute(*args, **kwargs)
                def append_mesh(self, *args, **kwargs):
                    """
                    Appends new mesh.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/append_mesh").execute(*args, **kwargs)
                def extrude_face_zone_delta(self, *args, **kwargs):
                    """
                    Extrudes a face thread a specified distance based on a list of deltas.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
                def recreate_all_shells(self, *args, **kwargs):
                    """
                    Recreates shells on all the walls that were deleted using the command delete-all-shells.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/recreate_all_shells").execute(*args, **kwargs)
                def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                    """
                    Copies motion variable values for origin, axis, and velocities from Mesh Motion to 	Frame Motion.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
                def rotate_zone(self, *args, **kwargs):
                    """
                    Rotates individual cell zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/rotate_zone").execute(*args, **kwargs)
                def orient_face_zone(self, *args, **kwargs):
                    """
                    Orients the face zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/orient_face_zone").execute(*args, **kwargs)
                def sep_cell_zone_mark(self, *args, **kwargs):
                    """
                    Separates cell zone based on cell marking.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
                def activate_cell_zone(self, *args, **kwargs):
                    """
                    Activates cell thread.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/activate_cell_zone").execute(*args, **kwargs)
                def sep_face_zone_angle(self, *args, **kwargs):
                    """
                    Separates face zone based on significant angle.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)

            class non_reflecting_bc(TUIMenu):
                """
                Enters the non-reflecting boundary condition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.turbo_specific_nrbc = self.__class__.turbo_specific_nrbc(path + ["turbo_specific_nrbc"], service)
                    self.general_nrbc = self.__class__.general_nrbc(path + ["general_nrbc"], service)
                    super().__init__(path, service)

                class turbo_specific_nrbc(TUIMenu):
                    """
                    Enters the turbo specific nrbc menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def show_status(self, *args, **kwargs):
                        """
                        Shows current status of non-reflecting b.c.’s.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/show_status").execute(*args, **kwargs)
                    def initialize(self, *args, **kwargs):
                        """
                        Initializes non-reflecting b.c.’s.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/initialize").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enables/disables non-reflecting b.c.’s.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/enable").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enters the set menu for non-reflecting b.c. parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def discretization(self, *args, **kwargs):
                            """
                            Enables use of higher-order reconstruction at boundaries if available.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/set/discretization").execute(*args, **kwargs)
                        def under_relaxation(self, *args, **kwargs):
                            """
                            Sets non-reflecting b.c. under-relaxation factor.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/set/under_relaxation").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Sets non-reflecting b.c. verbosity level. 0 : silent, 1 : basic information (default), 2 : detailed information for debugging.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/set/verbosity").execute(*args, **kwargs)

                class general_nrbc(TUIMenu):
                    """
                    Setting for general non-reflecting b.c.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)

                    class set(TUIMenu):
                        """
                        Enters the setup menu for general non-reflecting b.c.’s.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sigma2(self, *args, **kwargs):
                            """
                            Sets NRBC sigma2 factor (default value 5.0).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/sigma2").execute(*args, **kwargs)
                        def relax(self, *args, **kwargs):
                            """
                            Set NRBC relaxation factor (default value 0.5).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/relax").execute(*args, **kwargs)
                        def tangential_source(self, *args, **kwargs):
                            """
                            Include or not NRBC tangential source (default value #t).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/tangential_source").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enables/disables nrbc verbosity scheme output.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/verbosity").execute(*args, **kwargs)
                        def sigma(self, *args, **kwargs):
                            """
                            Sets NRBC sigma factor (default value 0.15).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/sigma").execute(*args, **kwargs)

            class bc_settings(TUIMenu):
                """
                Enters the boundary conditions settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.pressure_far_field = self.__class__.pressure_far_field(path + ["pressure_far_field"], service)
                    super().__init__(path, service)
                def mass_flow(self, *args, **kwargs):
                    """
                    Selects method for setting the mass flow rate.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/bc_settings/mass_flow").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Sets advanced options for pressure outlet boundaries.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/bc_settings/pressure_outlet").execute(*args, **kwargs)

                class pressure_far_field(TUIMenu):
                    """
                    Sets advanced options for pressure far field 	boundaries.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def riemann_invariants_tangency_correction(self, *args, **kwargs):
                        """
                        Enables/disables the Riemann-invariant tangency correction as described in .
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/bc_settings/pressure_far_field/riemann_invariants_tangency_correction").execute(*args, **kwargs)
                    def type(self, *args, **kwargs):
                        """
                        Choose pressure-far-field boundary-condition type.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/bc_settings/pressure_far_field/type").execute(*args, **kwargs)

        class user_defined(TUIMenu):
            """
            Enters the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def interpreted_functions(self, *args, **kwargs):
                """
                Loads interpreted user-defined functions.
                """
                return PyMenu(self.service, "/define/user_defined/interpreted_functions").execute(*args, **kwargs)
            def execute_on_demand(self, *args, **kwargs):
                """
                Executes UDFs on demand.
                """
                return PyMenu(self.service, "/define/user_defined/execute_on_demand").execute(*args, **kwargs)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enables/disables the use of a built-in compiler (Clang) when the define/user-defined/compiled-functions text command is used. This text command / compiler is available for Windows only, and is provided as part of the ANSYS Fluent installation. It is recommended that you enable this text command when the compiler you installed on your machine is an older version that is no longer supported. Note that the built-in compiler is used automatically if Fluent determines that you have not installed Microsoft Visual Studio or Clang on your computer, whether this text command is enabled or not.
                """
                return PyMenu(self.service, "/define/user_defined/use_built_in_compiler").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hooks up user-defined functions.
                """
                return PyMenu(self.service, "/define/user_defined/function_hooks").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/define/user_defined/one_D_coupling").execute(*args, **kwargs)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocates user-defined memory.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_memory").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Opens user-defined function library.
                """
                return PyMenu(self.service, "/define/user_defined/compiled_functions").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Defines user-defined scalars.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_scalars").execute(*args, **kwargs)
            def fan_model(self, *args, **kwargs):
                """
                Configures user-defined fan model.
                """
                return PyMenu(self.service, "/define/user_defined/fan_model").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/define/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/define/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/define/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/define/user_defined/use_contributed_cpp").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enters the real-gas menu to enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the NIST real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the NIST real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the user-defined real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)
                def nist_settings(self, *args, **kwargs):
                    """
                    Specifies the name and the location for the REFPROP library and fluid files.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Loads a user-defined multispecies real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Selects the state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/set_state").execute(*args, **kwargs)

        class periodic_conditions(TUIMenu):
            """
            Enters the periodic conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def pressure_gradient_specification(self, *args, **kwargs):
                """
                Enables/disables specification of pressure gradient at the periodic boundary.
                """
                return PyMenu(self.service, "/define/periodic_conditions/pressure_gradient_specification").execute(*args, **kwargs)
            def massflow_rate_specification(self, *args, **kwargs):
                """
                Enables/disables specification of mass flow rate at the periodic boundary.
                """
                return PyMenu(self.service, "/define/periodic_conditions/massflow_rate_specification").execute(*args, **kwargs)

        class spectral(TUIMenu):
            """
            Enter the Spectral menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete_harmonic_exports(self, *args, **kwargs):
                """
                Deletes Harmonic Export data.
                """
                return PyMenu(self.service, "/define/spectral/delete_harmonic_exports").execute(*args, **kwargs)
            def calculate_harmonic_exports(self, *args, **kwargs):
                """
                Calculates Harmonic Export data.
                """
                return PyMenu(self.service, "/define/spectral/calculate_harmonic_exports").execute(*args, **kwargs)
            def calculate_fourier_coefficients(self, *args, **kwargs):
                """
                Calculates Fourier coefficient data.
                """
                return PyMenu(self.service, "/define/spectral/calculate_fourier_coefficients").execute(*args, **kwargs)
            def delete_fourier_coefficients(self, *args, **kwargs):
                """
                Deletes Fourier coefficient data.
                """
                return PyMenu(self.service, "/define/spectral/delete_fourier_coefficients").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enters the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                super().__init__(path, service)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Selects the second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enables/disables the electric-potential model.
                """
                return PyMenu(self.service, "/define/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Selects the backward Euler method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_euler").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Selects the bounded second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enables/disables the NOx model.
                """
                return PyMenu(self.service, "/define/models/nox").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enables/disables frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/define/models/frozen_flux").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enables/disables the soot model.
                """
                return PyMenu(self.service, "/define/models/soot").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enters the crevice model controls menu.
                """
                return PyMenu(self.service, "/define/models/crevice_model_controls").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enables the dual potential MSMD battery model. For text commands that become available when the battery model is enabled, refer to Battery Model Text Commands.
                """
                return PyMenu(self.service, "/define/models/battery_model").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/define/models/energy").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Selects the explicit transient formulation. This text command is only available for unsteady cases that use the density-based solver with the explicit formulation.
                """
                return PyMenu(self.service, "/define/models/unsteady_global_time").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Selects the first-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_1st_order").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enables/disables the steady solution model.
                """
                return PyMenu(self.service, "/define/models/steady").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enables/disables the crevice model.
                """
                return PyMenu(self.service, "/define/models/crevice_model").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/define/models/vbm").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enables/disables noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/define/models/noniterative_time_advance").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Loads addon module.
                """
                return PyMenu(self.service, "/define/models/addon_module").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enables/disables the ablation model.
                """
                return PyMenu(self.service, "/define/models/ablation").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Selects the Newmark method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Specifies whether or not the domain is axisymmetric.
                """
                return PyMenu(self.service, "/define/models/axisymmetric").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enables/disables the solidification and melting model.
                """
                return PyMenu(self.service, "/define/models/solidification_melting").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enables/disables axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/define/models/swirl").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/define/models/virtual_blade_model").execute(*args, **kwargs)

            class radiation(TUIMenu):
                """
                Enters the radiation models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solar_parameters = self.__class__.solar_parameters(path + ["solar_parameters"], service)
                    self.s2s_parameters = self.__class__.s2s_parameters(path + ["s2s_parameters"], service)
                    self.dtrm_parameters = self.__class__.dtrm_parameters(path + ["dtrm_parameters"], service)
                    super().__init__(path, service)
                def method_partially_specular_wall(self, *args, **kwargs):
                    """
                    Sets the method for partially specular wall with discrete ordinate model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/method_partially_specular_wall").execute(*args, **kwargs)
                def wsggm_cell_based(self, *args, **kwargs):
                    """
                    Enables/disables WSGGM cell based method. Note that when enabled, the wsggm-cell-based option will 	become available in theAbsorption Coefficient drop-down list in the Create/Edit Materials dialog 	box.
                    """
                    return PyMenu(self.service, "/define/models/radiation/wsggm_cell_based").execute(*args, **kwargs)
                def discrete_ordinates(self, *args, **kwargs):
                    """
                    Enables/disables discrete ordinates radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_ordinates").execute(*args, **kwargs)
                def s2s(self, *args, **kwargs):
                    """
                    Enables/disables S2S radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/s2s").execute(*args, **kwargs)
                def rosseland(self, *args, **kwargs):
                    """
                    Enables/disables Rosseland radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/rosseland").execute(*args, **kwargs)
                def radiation_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_model_parameters").execute(*args, **kwargs)
                def solution_method_for_do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables the solution method for DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solution_method_for_do_coupling").execute(*args, **kwargs)
                def do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_coupling").execute(*args, **kwargs)
                def discrete_transfer(self, *args, **kwargs):
                    """
                    Enables/disables discrete transfer radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_transfer").execute(*args, **kwargs)
                def do_acceleration(self, *args, **kwargs):
                    """
                    Enables/disables the acceleration of the discrete 	ordinates (DO) radiation model calculations. Note that 	this text command is only available when running on 	Linux in parallel.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_acceleration").execute(*args, **kwargs)
                def solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the solar irradiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_irradiation").execute(*args, **kwargs)
                def fast_second_order_discrete_ordinate(self, *args, **kwargs):
                    """
                    Enables/disables the fast-second-order option for Discrete Ordinate Model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/fast_second_order_discrete_ordinate").execute(*args, **kwargs)
                def solar(self, *args, **kwargs):
                    """
                    Enables/disables solar model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar").execute(*args, **kwargs)
                def solar_calculator(self, *args, **kwargs):
                    """
                    Calculates sun direction and intensity.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_calculator").execute(*args, **kwargs)
                def mc_under_relaxation(self, *args, **kwargs):
                    """
                    Sets the under-relaxation factor for Monte Carlo radiation sources used in the 	energy equation.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_under_relaxation").execute(*args, **kwargs)
                def montecarlo(self, *args, **kwargs):
                    """
                    Enables/disables the Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/montecarlo").execute(*args, **kwargs)
                def target_cells_per_volume_cluster(self, *args, **kwargs):
                    """
                    Sets the amount of coarsening of the radiation mesh 	for the Monte Carlo radiation model. A number greater 	than one implies coarsening, whereas equal to one 	implies no coarsening.
                    """
                    return PyMenu(self.service, "/define/models/radiation/target_cells_per_volume_cluster").execute(*args, **kwargs)
                def blending_factor(self, *args, **kwargs):
                    """
                    Sets numeric option for Discrete Ordinate model. Make sure thatSecond Order Upwind is selected for the Discrete Ordinates spatial 	discretization for the blending-factor option to 	appear in the text command list.
                    """
                    return PyMenu(self.service, "/define/models/radiation/blending_factor").execute(*args, **kwargs)
                def radiation_iteration_parameters(self, *args, **kwargs):
                    """
                    Sets iteration parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_iteration_parameters").execute(*args, **kwargs)
                def non_gray_model_parameters(self, *args, **kwargs):
                    """
                    Sets parameters for non-gray model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/non_gray_model_parameters").execute(*args, **kwargs)
                def p1(self, *args, **kwargs):
                    """
                    Enables/disables P1 radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/p1").execute(*args, **kwargs)
                def apply_full_solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the application of the complete solar load to the first wavelength 	band only, reverting to the pre-2019 R1 behavior of the 	Solar Load and Discrete Ordinates models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/apply_full_solar_irradiation").execute(*args, **kwargs)
                def mc_model_parameters(self, *args, **kwargs):
                    """
                    Specifies Monte Carlo model parameters. This text command is available only when the 	Monte Carlo model is enabled.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_model_parameters").execute(*args, **kwargs)
                def beta_radiation_features(self, *args, **kwargs):
                    """
                    Enable Radiation Models with Non-Iterative Time Advancement (NITA) as Beta features in FL12.0.
                    """
                    return PyMenu(self.service, "/define/models/radiation/beta_radiation_features").execute(*args, **kwargs)

                class solar_parameters(TUIMenu):
                    """
                    Enters the solar parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def use_direction_from_sol_calc(self, *args, **kwargs):
                        """
                        Sets direction computed from solar calculator.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/use_direction_from_sol_calc").execute(*args, **kwargs)
                    def quad_tree_parameters(self, *args, **kwargs):
                        """
                        Sets quad-tree refinement parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/quad_tree_parameters").execute(*args, **kwargs)
                    def illumination_parameters(self, *args, **kwargs):
                        """
                        Sets illumination parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/illumination_parameters").execute(*args, **kwargs)
                    def sun_direction_vector(self, *args, **kwargs):
                        """
                        Sets sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sun_direction_vector").execute(*args, **kwargs)
                    def sol_on_demand(self, *args, **kwargs):
                        """
                        Sets solar load on demand.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_on_demand").execute(*args, **kwargs)
                    def scattering_fraction(self, *args, **kwargs):
                        """
                        Sets scattering fraction parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/scattering_fraction").execute(*args, **kwargs)
                    def ground_reflectivity(self, *args, **kwargs):
                        """
                        Sets ground reflectivity parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/ground_reflectivity").execute(*args, **kwargs)
                    def iteration_parameters(self, *args, **kwargs):
                        """
                        Sets update parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/iteration_parameters").execute(*args, **kwargs)
                    def solar_thread_control(self, *args, **kwargs):
                        """
                        Sets the number of threads to run the solar flux calculation. This item appears only when running in parallel with nodes located on a separate machine from the one running the host process andSolar Ray Tracing is enabled.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/solar_thread_control").execute(*args, **kwargs)
                    def autoread_solar_data(self, *args, **kwargs):
                        """
                        Sets autoread solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autoread_solar_data").execute(*args, **kwargs)
                    def sol_adjacent_fluidcells(self, *args, **kwargs):
                        """
                        Sets solar load on for adjacent fluid cells.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_adjacent_fluidcells").execute(*args, **kwargs)
                    def sol_camera_pos(self, *args, **kwargs):
                        """
                        Sets camera position based on sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_camera_pos").execute(*args, **kwargs)
                    def autosave_solar_data(self, *args, **kwargs):
                        """
                        Sets autosave solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autosave_solar_data").execute(*args, **kwargs)

                class s2s_parameters(TUIMenu):
                    """
                    Enters the S2S parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_mesh_interface_clustering(self, *args, **kwargs):
                        """
                        Enables surface clusters on mesh interfaces.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/enable_mesh_interface_clustering").execute(*args, **kwargs)
                    def print_zonewise_radiation(self, *args, **kwargs):
                        """
                        Prints the zonewise incoming radiation, viewfactors, and average temperature.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_zonewise_radiation").execute(*args, **kwargs)
                    def non_participating_boundary_zones_temperature(self, *args, **kwargs):
                        """
                        Sets temperature for the non-participating boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/non_participating_boundary_zones_temperature").execute(*args, **kwargs)
                    def read_vf_file(self, *args, **kwargs):
                        """
                        Reads S2S file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/read_vf_file").execute(*args, **kwargs)
                    def compute_clusters_and_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write surface cluster first and then view factors.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_clusters_and_vf_accelerated").execute(*args, **kwargs)
                    def use_new_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the new surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_new_cluster_algorithm").execute(*args, **kwargs)
                    def compute_write_vf(self, *args, **kwargs):
                        """
                        Computes/writes surface clusters and view factors for S2S radiation model.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_write_vf").execute(*args, **kwargs)
                    def compute_fpsc_values(self, *args, **kwargs):
                        """
                        Computes only fpsc values based on current settings.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_fpsc_values").execute(*args, **kwargs)
                    def set_global_faces_per_surface_cluster(self, *args, **kwargs):
                        """
                        Sets global value of faces per surface cluster for all boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_global_faces_per_surface_cluster").execute(*args, **kwargs)
                    def print_thread_clusters(self, *args, **kwargs):
                        """
                        Prints the following for all boundary threads: thread-id, number of faces, faces per surface cluster, and the number of surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_thread_clusters").execute(*args, **kwargs)
                    def use_old_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the old surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_old_cluster_algorithm").execute(*args, **kwargs)
                    def split_angle(self, *args, **kwargs):
                        """
                        Sets split angle for the clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/split_angle").execute(*args, **kwargs)
                    def set_vf_parameters(self, *args, **kwargs):
                        """
                        Sets the parameters needed for the viewfactor calculations.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_vf_parameters").execute(*args, **kwargs)
                    def compute_vf_only(self, *args, **kwargs):
                        """
                        Computes/writes view factors only.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_only").execute(*args, **kwargs)
                    def compute_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write view factors from existing surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_accelerated").execute(*args, **kwargs)

                class dtrm_parameters(TUIMenu):
                    """
                    Enters the dtrm parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ray_trace(self, *args, **kwargs):
                        """
                        Creates DTRM rays for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/ray_trace").execute(*args, **kwargs)
                    def make_globs(self, *args, **kwargs):
                        """
                        Makes globs (coarser mesh) for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/make_globs").execute(*args, **kwargs)
                    def controls(self, *args, **kwargs):
                        """
                        Sets dtrm solution controls.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/controls").execute(*args, **kwargs)
                    def check_ray_file(self, *args, **kwargs):
                        """
                        Reads DTRM rays file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/check_ray_file").execute(*args, **kwargs)

            class system_coupling_settings(TUIMenu):
                """
                Enters the system coupling menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.htc = self.__class__.htc(path + ["htc"], service)
                    super().__init__(path, service)
                def use_face_or_element_based_data_transfer(self, *args, **kwargs):
                    """
                    Answering yes at the prompt 	enables Fluent to use element data for mapping surface 	conservative quantities such as surface forces and heat 	flows.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/use_face_or_element_based_data_transfer").execute(*args, **kwargs)
                def update_rigid_body_mesh_motion_before_mesh_transfer(self, *args, **kwargs):
                    """
                    SC Enable/disable mesh motion.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/update_rigid_body_mesh_motion_before_mesh_transfer").execute(*args, **kwargs)
                def specify_system_coupling_volumetric_cell_zones(self, *args, **kwargs):
                    """
                    Enable/disable volumetric cell zones.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/specify_system_coupling_volumetric_cell_zones").execute(*args, **kwargs)

                class htc(TUIMenu):
                    """
                    Enter the heat transfer coeficient menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.unsteady_statistics = self.__class__.unsteady_statistics(path + ["unsteady_statistics"], service)
                        self.htc_calculation_method = self.__class__.htc_calculation_method(path + ["htc_calculation_method"], service)
                        super().__init__(path, service)

                    class unsteady_statistics(TUIMenu):
                        """
                        Enter the unsteady statistics menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sc_enable_sub_stepping_option_per_coupling_step(self, *args, **kwargs):
                            """
                            Enable/disable sub stepping option per coupling step.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/unsteady_statistics/sc_enable_sub_stepping_option_per_coupling_step").execute(*args, **kwargs)

                    class htc_calculation_method(TUIMenu):
                        """
                        Enter the htc calculation menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def use_tref_in_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable tref in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_tref_in_htc_calculation").execute(*args, **kwargs)
                        def use_wall_function_based_htc(self, *args, **kwargs):
                            """
                            Enable/disable wall function based htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_wall_function_based_htc").execute(*args, **kwargs)
                        def use_yplus_based_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable yplus in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_yplus_based_htc_calculation").execute(*args, **kwargs)

            class solver(TUIMenu):
                """
                Enters the menu to select the solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_based(self, *args, **kwargs):
                    """
                    Enables/disables the pressure-based solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/pressure_based").execute(*args, **kwargs)
                def density_based_explicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-explicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_explicit").execute(*args, **kwargs)
                def adjust_solver_defaults_based_on_setup(self, *args, **kwargs):
                    """
                    Enable/disable adjustment of solver defaults based on setup.
                    """
                    return PyMenu(self.service, "/define/models/solver/adjust_solver_defaults_based_on_setup").execute(*args, **kwargs)
                def density_based_implicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-implicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_implicit").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enters the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    super().__init__(path, service)
                def structure_off(self, *args, **kwargs):
                    """
                    Disables the structural model.
                    """
                    return PyMenu(self.service, "/define/models/structure/structure_off").execute(*args, **kwargs)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/define/models/structure/thermal_effects").execute(*args, **kwargs)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/nonlinear_elasticity").execute(*args, **kwargs)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enables the linear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/linear_elasticity").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of a viscous fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables an explicit fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of operating pressure into the fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enters the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Sets the damping factor for the structural model (that is, the amplitude decay factor  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Sets the maximum number of iterations for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Sets the algebraic multigrid (AMG) stabilization method for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/amg_stabilization").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/enhanced_strain").execute(*args, **kwargs)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)

            class shell_conduction(TUIMenu):
                """
                Enters the shell conduction models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def save_shell_zones(self, *args, **kwargs):
                    """
                    Enables the saving of shell zones to case 	files.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/save_shell_zones").execute(*args, **kwargs)
                def write_csv(self, *args, **kwargs):
                    """
                    Writes your saved shell conduction settings to a CSV file.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/write_csv").execute(*args, **kwargs)
                def multi_layer_shell(self, *args, **kwargs):
                    """
                    Enables/disables the ability to define multi-layer 	shell conduction for walls. Note that the warped-face 	gradient correction (WFGC) is not supported when 	multi-layer shells are disabled.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/multi_layer_shell").execute(*args, **kwargs)
                def enhanced_encapsulation(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced routine for the encapsulation of coupled walls during 	mesh partitioning that is enabled by default when shell 	conduction and/or the surface to surface (S2S) radiation 	model is used.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/enhanced_encapsulation").execute(*args, **kwargs)
                def settings(self, *args, **kwargs):
                    """
                    Enables shell conduction and defines the settings for any wall or group of walls by 	manually entering the number and properties of the 	layers.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/settings").execute(*args, **kwargs)
                def read_csv(self, *args, **kwargs):
                    """
                    Defines the shell conduction settings by reading a CSV file.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/read_csv").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enters the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dual_cell_model = self.__class__.dual_cell_model(path + ["dual_cell_model"], service)
                    self.macro_model = self.__class__.macro_model(path + ["macro_model"], service)
                    super().__init__(path, service)

                class dual_cell_model(TUIMenu):
                    """
                    Enters the dual cell model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete_heat_exchanger(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/delete_heat_exchanger").execute(*args, **kwargs)
                    def modify_heat_exchanger(self, *args, **kwargs):
                        """
                        Modifies heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/modify_heat_exchanger").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/write_NTU").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables the dual cell heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/heat_exchanger").execute(*args, **kwargs)
                    def alternative_formulation(self, *args, **kwargs):
                        """
                        Enables/disables alternative formulation for heat transfer calculations.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/alternative_formulation").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/plot_NTU").execute(*args, **kwargs)
                    def add_heat_exchanger(self, *args, **kwargs):
                        """
                        Adds heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/add_heat_exchanger").execute(*args, **kwargs)

                class macro_model(TUIMenu):
                    """
                    Enters the heat macro-model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger_model(self, *args, **kwargs):
                        """
                        Defines heat-exchanger core model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_model").execute(*args, **kwargs)
                    def heat_exchanger_group(self, *args, **kwargs):
                        """
                        Defines heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_macro_report(self, *args, **kwargs):
                        """
                        Reports the computed values of heat rejection, outlet temperature, and inlet temperature for the macroscopic cells (macros) in a heat exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_macro_report").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/write_NTU").execute(*args, **kwargs)
                    def delete_heat_exchanger_group(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/delete_heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_report(self, *args, **kwargs):
                        """
                        Reports the computed values of total heat rejection, outlet temperature, and inlet temperature for a specified heat-exchanger core.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_report").execute(*args, **kwargs)
                    def heat_exchanger_zone(self, *args, **kwargs):
                        """
                        Specifies the zone that represents the heat exchanger, the dimensions of the heat exchanger, the macro grid, and the coolant direction and properties.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_zone").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enters the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enables/disables the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Changes the turbulent Schmidt number for soot/nuclei equations.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Sets soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Selects soot model parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Selects soot process parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enters the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    super().__init__(path, service)
                def solution_options(self, *args, **kwargs):
                    """
                    Sets Eulerian Wall Film Model Solution Options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activates Eulerian Wall Film Equations.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Sets Film Material and Properties.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enables/disables Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initializes Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enters the Coupled-Solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enables/disables the coupled solution method.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enables/disables the film curvature smoothing option and sets the smoothing parameters.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)

            class optics(TUIMenu):
                """
                Enter the optics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.statistics = self.__class__.statistics(path + ["statistics"], service)
                    self.beams = self.__class__.beams(path + ["beams"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/enable").execute(*args, **kwargs)
                def index_of_refraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/index_of_refraction").execute(*args, **kwargs)
                def report(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/report").execute(*args, **kwargs)
                def sampling_iterations(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/sampling_iterations").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/verbosity").execute(*args, **kwargs)

                class statistics(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def reset_statistics(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/reset_statistics").execute(*args, **kwargs)
                    def statistics_controls(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/statistics_controls").execute(*args, **kwargs)

                class beams(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/rename").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/edit").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/copy").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Create a new beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/add").execute(*args, **kwargs)
                    def list_beam_parameters(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/list_beam_parameters").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/delete").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Enters the multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Specifies mixture parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Enables the Algebraic Interfacial Area Density (AIAD) 	model and sets the AIAD secondary continuous phase and 	the secondary entrained phase. Entering 0 as a phase ID cancels any 	previous phase selection. Note that you must define the 	phases in your simulation using the define/phases/ text command 	prior to using the regime-transition-modeling 	text command. This option is available only with the 	Eulerian multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specifies multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/model").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Specifies body force formulation.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Enables coupled level set interface tracking method.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specifies the number of phases.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Specifies interface modeling options.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    Enables the Open Channel sub-model and/or the Open Channel Wave Boundary Condition 	sub-model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/vof_sub_models").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)

                class sub_models(TUIMenu):
                    """
                    Enter the menu to select sub-models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling_options = self.__class__.boiling_options(path + ["boiling_options"], service)
                        super().__init__(path, service)
                    def boiling(self, *args, **kwargs):
                        """
                        Activate boiling model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling").execute(*args, **kwargs)

                    class boiling_options(TUIMenu):
                        """
                        Set boiling options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nlbf_model(self, *args, **kwargs):
                            """
                            Set the non-local boundary field correction.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/nlbf_model").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Choose the type of boiling model.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/options").execute(*args, **kwargs)

                class hybrid_models(TUIMenu):
                    """
                    Enter the menu to select hybrid models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def multi_fluid_vof(self, *args, **kwargs):
                        """
                        Enable the multi-fluid VOF model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/hybrid_models/multi_fluid_vof").execute(*args, **kwargs)
                    def ddpm(self, *args, **kwargs):
                        """
                        Enable the dense discrete phase model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/hybrid_models/ddpm").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enters the population balance models menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        super().__init__(path, service)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Gives you recommendations for appropriate bubble sizes and/or droplet size limits.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)
                    def model(self, *args, **kwargs):
                        """
                        Allows you to select the population balance model and set its parameters.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/model").execute(*args, **kwargs)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enters the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nucleation(self, *args, **kwargs):
                            """
                            Specifies the nucleation rate.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Specifies a factor that controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Specifies a factor that controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def growth(self, *args, **kwargs):
                            """
                            Specifies the growth rate.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)
                        def aggregation(self, *args, **kwargs):
                            """
                            Sets the aggregation kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Specifies a cutoff limit for the volume fraction values for the breakage and aggregation kernels.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)

                class wet_steam(TUIMenu):
                    """
                    Enters the wet steam model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enables/disables the wet steam model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/enable").execute(*args, **kwargs)
                    def load_unload_user_defined_wetsteam_library(self, *args, **kwargs):
                        """
                        Loads or unloads user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/load_unload_user_defined_wetsteam_library").execute(*args, **kwargs)
                    def compile_user_defined_wetsteam_functions(self, *args, **kwargs):
                        """
                        Compiles user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/compile_user_defined_wetsteam_functions").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enters the set menu for setting wet steam model options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_liquid_mass_fraction(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the condensed liquid-phase mass-fraction to prevent divergence.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/max_liquid_mass_fraction").execute(*args, **kwargs)
                        def rgp_tables(self, *args, **kwargs):
                            """
                            Sets the RGP (real gas property) table to be used with the Wet Steam model.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/rgp_tables").execute(*args, **kwargs)
                        def virial_equation(self, *args, **kwargs):
                            """
                            Sets the equation of state for steam to either Vukalovich formulation (default) or Young formulation.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/virial_equation").execute(*args, **kwargs)
                        def stagnation_conditions(self, *args, **kwargs):
                            """
                            Computes stagnation conditions using either gas phase only, or mixture. For details, see .
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/stagnation_conditions").execute(*args, **kwargs)
                        def zonal_phase_change(self, *args, **kwargs):
                            """
                            Select cell zones where phase change process is active.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/zonal_phase_change").execute(*args, **kwargs)
                        def droplet_growth_rate(self, *args, **kwargs):
                            """
                            S formulation (default) or Hill.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/droplet_growth_rate").execute(*args, **kwargs)

                class explicit_expert_options(TUIMenu):
                    """
                    Enters the menu to set explicit VOF expert 	options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.volume_fraction_filtering = self.__class__.volume_fraction_filtering(path + ["volume_fraction_filtering"], service)
                        super().__init__(path, service)
                    def sub_time_step_method(self, *args, **kwargs):
                        """
                        Selects the sub-time step method.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/sub_time_step_method").execute(*args, **kwargs)
                    def solve_vof_every_iter(self, *args, **kwargs):
                        """
                        If you enter yes, the volume fraction equations will be solved every iteration. By default, the volume fraction equations will be solved only once per time step.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/solve_vof_every_iter").execute(*args, **kwargs)

                    class volume_fraction_filtering(TUIMenu):
                        """
                        Enters the volume fraction filtering menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def filtering_options(self, *args, **kwargs):
                            """
                            Selects the volume fraction filtering method. This command becomes available once the define/models/multiphase/explicit-expert-options/volume-fraction-filtering/enable? text option has been set to yes.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/volume_fraction_filtering/filtering_options").execute(*args, **kwargs)
                        def vol_frac_cutoff(self, *args, **kwargs):
                            """
                            Specifies a cut-off value for the volume fraction filtering. This command becomes available after you select the node averaged cutoff method using the define/models/multiphase/explicit-expert-options/volume-fraction-filtering/filtering-options text command.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/volume_fraction_filtering/vol_frac_cutoff").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enables/disables the volume fraction filtering treatment.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/volume_fraction_filtering/enable").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        super().__init__(path, service)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                super().__init__(path, service)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    super().__init__(path, service)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
 