# pylint: disable=too-many-lines
COMPILED_ACCOUNT_CONTRACT = r"""{
    "abi": [
        {
            "members": [
                {
                    "name": "to",
                    "offset": 0,
                    "type": "felt"
                },
                {
                    "name": "selector",
                    "offset": 1,
                    "type": "felt"
                },
                {
                    "name": "data_offset",
                    "offset": 2,
                    "type": "felt"
                },
                {
                    "name": "data_len",
                    "offset": 3,
                    "type": "felt"
                }
            ],
            "name": "AccountCallArray",
            "size": 4,
            "type": "struct"
        },
        {
            "inputs": [
                {
                    "name": "public_key",
                    "type": "felt"
                }
            ],
            "name": "constructor",
            "outputs": [],
            "type": "constructor"
        },
        {
            "inputs": [],
            "name": "get_public_key",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [],
            "name": "get_nonce",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "interfaceId",
                    "type": "felt"
                }
            ],
            "name": "supportsInterface",
            "outputs": [
                {
                    "name": "success",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "new_public_key",
                    "type": "felt"
                }
            ],
            "name": "set_public_key",
            "outputs": [],
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "hash",
                    "type": "felt"
                },
                {
                    "name": "signature_len",
                    "type": "felt"
                },
                {
                    "name": "signature",
                    "type": "felt*"
                }
            ],
            "name": "is_valid_signature",
            "outputs": [
                {
                    "name": "is_valid",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "call_array_len",
                    "type": "felt"
                },
                {
                    "name": "call_array",
                    "type": "AccountCallArray*"
                },
                {
                    "name": "calldata_len",
                    "type": "felt"
                },
                {
                    "name": "calldata",
                    "type": "felt*"
                },
                {
                    "name": "nonce",
                    "type": "felt"
                }
            ],
            "name": "__execute__",
            "outputs": [
                {
                    "name": "response_len",
                    "type": "felt"
                },
                {
                    "name": "response",
                    "type": "felt*"
                }
            ],
            "type": "function"
        }
    ],
    "entry_points_by_type": {
        "CONSTRUCTOR": [
            {
                "offset": "0x1cf",
                "selector": "0x28ffe4ff0f226a9107253e17a904099aa4f63a02a5621de0576e5aa71bc5194"
            }
        ],
        "EXTERNAL": [
            {
                "offset": "0x2ad",
                "selector": "0x15d40a3d6ca2ac30f4031e42be28da9b056fef9bb7357ac5e85627ee876e5ad"
            },
            {
                "offset": "0x1f1",
                "selector": "0x1a35984e05126dbecb7c3bb9929e7dd9106d460c59b1633739a5c733a5fb13b"
            },
            {
                "offset": "0x210",
                "selector": "0x1ac47721ee58ba2813c2a816bca188512839a00d3970f67c05eab986b14006d"
            },
            {
                "offset": "0x270",
                "selector": "0x28420862938116cb3bbdbedee07451ccc54d4e9412dbef71142ad1980a30941"
            },
            {
                "offset": "0x230",
                "selector": "0x29e211664c0b63c79638fbea474206ca74016b3e9a3dc4f9ac300ffd8bdf2cd"
            },
            {
                "offset": "0x24a",
                "selector": "0x2e3e21ff5952b2531241e37999d9c4c8b3034cccc89a202a6bf019bdf5294f9"
            }
        ],
        "L1_HANDLER": []
    },
    "program": {
        "attributes": [
            {
                "accessible_scopes": [
                    "openzeppelin.introspection.ERC165",
                    "openzeppelin.introspection.ERC165.ERC165",
                    "openzeppelin.introspection.ERC165.ERC165.register_interface"
                ],
                "end_pc": 201,
                "flow_tracking_data": {
                    "ap_tracking": {
                        "group": 18,
                        "offset": 0
                    },
                    "reference_ids": {}
                },
                "name": "error_message",
                "start_pc": 196,
                "value": "ERC165: invalid interface id"
            },
            {
                "accessible_scopes": [
                    "openzeppelin.account.library",
                    "openzeppelin.account.library.Account",
                    "openzeppelin.account.library.Account.assert_only_self"
                ],
                "end_pc": 288,
                "flow_tracking_data": {
                    "ap_tracking": {
                        "group": 26,
                        "offset": 12
                    },
                    "reference_ids": {}
                },
                "name": "error_message",
                "start_pc": 287,
                "value": "Account: caller is not this account"
            },
            {
                "accessible_scopes": [
                    "openzeppelin.account.library",
                    "openzeppelin.account.library.Account",
                    "openzeppelin.account.library.Account.execute"
                ],
                "end_pc": 337,
                "flow_tracking_data": {
                    "ap_tracking": {
                        "group": 31,
                        "offset": 15
                    },
                    "reference_ids": {}
                },
                "name": "error_message",
                "start_pc": 335,
                "value": "Account: no reentrant call"
            },
            {
                "accessible_scopes": [
                    "openzeppelin.account.library",
                    "openzeppelin.account.library.Account",
                    "openzeppelin.account.library.Account.execute"
                ],
                "end_pc": 373,
                "flow_tracking_data": {
                    "ap_tracking": {
                        "group": 32,
                        "offset": 44
                    },
                    "reference_ids": {}
                },
                "name": "error_message",
                "start_pc": 371,
                "value": "Account: invalid signature"
            }
        ],
        "builtins": [
            "pedersen",
            "range_check",
            "ecdsa"
        ],
        "data": [
            "0x40780017fff7fff",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x400380007ffb7ffc",
            "0x400380017ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x480280027ffb8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffd",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480080007fff8000",
            "0x400080007ffd7fff",
            "0x482480017ffd8001",
            "0x1",
            "0x482480017ffd8001",
            "0x1",
            "0xa0680017fff7ffe",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffb",
            "0x402a7ffc7ffd7fff",
            "0x208b7fff7fff7ffe",
            "0x208b7fff7fff7ffe",
            "0x48297ffd80007ffc",
            "0x20680017fff7fff",
            "0x4",
            "0x402780017ffc7ffc",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x3ffffffffffffffffffffffffffffff",
            "0x480280017ffc8000",
            "0x48307fff80007ffe",
            "0x400280027ffc7fff",
            "0x480280017ffc8000",
            "0x484480017fff8000",
            "0x100000000000000000000000000000000",
            "0x480280007ffc8000",
            "0x40317fff7ffe7ffd",
            "0x482680017ffc8000",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x20680017fff7fff",
            "0x10",
            "0x480a7ffc7fff8000",
            "0x482680017ffd8000",
            "0x11000000000000000000000000000000000000000000000101",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480680017fff8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x48127ffe7fff8000",
            "0x48287ffd80007ffe",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe7",
            "0x482680017ffd8000",
            "0x11000000000000000000000000000000000000000000000101",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x20680017fff7fff",
            "0xc",
            "0x40780017fff7fff",
            "0xa",
            "0x480680017fff8000",
            "0x7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeff",
            "0x480a7ffc7fff8000",
            "0x48287ffd80007ffe",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd8",
            "0x10780017fff7fff",
            "0x8",
            "0x40780017fff7fff",
            "0xb",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd0",
            "0x480a7ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x43616c6c436f6e7472616374",
            "0x400280007ff97fff",
            "0x400380017ff97ffa",
            "0x400380027ff97ffb",
            "0x400380037ff97ffc",
            "0x400380047ff97ffd",
            "0x482680017ff98000",
            "0x7",
            "0x480280057ff98000",
            "0x480280067ff98000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x47657443616c6c657241646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x476574436f6e747261637441646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f7261676552656164",
            "0x400280007ffc7fff",
            "0x400380017ffc7ffd",
            "0x482680017ffc8000",
            "0x3",
            "0x480280027ffc8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f726167655772697465",
            "0x400280007ffb7fff",
            "0x400380017ffb7ffc",
            "0x400380027ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x4765745478496e666f",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x400380017ff97ffa",
            "0x400380007ff97ffb",
            "0x482680017ff98000",
            "0x2",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480680017fff8000",
            "0x10f6bdc8f69644775581b157f06334cb94ae302da4f6d09656c9a31f092cff6",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff76",
            "0x480a7ffc7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff9b",
            "0x48127fe17fff8000",
            "0x48127ffd7fff8000",
            "0x48127ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff0",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd0",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe2",
            "0x480a7ff97fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc9",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffe00365a",
            "0x20680017fff7fff",
            "0x8",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480680017fff8000",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd8",
            "0x208b7fff7fff7ffe",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0xffffffff",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff53",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd8",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x1813aac5f5e7799684c6dc33e51f44d3627fd748c800724a184ed5be09b713e",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff92",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff8c",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x1379ac0624b939ceb9dede92211d7db5ee174fe28be72245b0a1a2abd81c98f",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff74",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff6e",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x480680017fff8000",
            "0xf10dbd44",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffaf",
            "0x208b7fff7fff7ffe",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff4e",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff44",
            "0x40127fff7fff7ff9",
            "0x48127ffe7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd1",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffad",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffeb",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffcf",
            "0x208b7fff7fff7ffe",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffbc",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x48127ffd7fff8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff45",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffc7fff8000",
            "0x480680017fff8000",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x9",
            "0x480a7ff57fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff14",
            "0x400680017fff7fff",
            "0x0",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffec8",
            "0x48127ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff2b",
            "0x40137fff7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ff67fff8000",
            "0x480a7ff77fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff7e",
            "0x40137ffd7fff8001",
            "0x40137ffe7fff8002",
            "0x40137fff7fff8003",
            "0x400b7ffd7fff8003",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffea1",
            "0x40137fff7fff8004",
            "0x48127ff97fff8000",
            "0x480a7ff97fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a80047fff8000",
            "0x1104800180018000",
            "0x48",
            "0x480a80017fff8000",
            "0x480a80027fff8000",
            "0x480a7ff87fff8000",
            "0x4802800580008000",
            "0x4802800380008000",
            "0x4802800480008000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc8",
            "0x40137ffe7fff8005",
            "0x400680017fff7fff",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x4826800180038000",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff6b",
            "0x40137ffe7fff8006",
            "0x40137fff7fff8007",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe83",
            "0x40137fff7fff8008",
            "0x48127ffa7fff8000",
            "0x480a7ff97fff8000",
            "0x480a80047fff8000",
            "0x480a80087fff8000",
            "0x1104800180018000",
            "0x9",
            "0x48127ffe7fff8000",
            "0x480a80067fff8000",
            "0x480a80077fff8000",
            "0x480a80057fff8000",
            "0x48127ffb7fff8000",
            "0x480a80087fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x20780017fff7ffb",
            "0x6",
            "0x480a7ffa7fff8000",
            "0x480680017fff8000",
            "0x0",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480280007ffc8000",
            "0x480280017ffc8000",
            "0x480280027ffc8000",
            "0x480280037ffc8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffeba",
            "0x40137ffe7fff8000",
            "0x40137fff7fff8001",
            "0x40137ffd7fff8002",
            "0x480a7ffd7fff8000",
            "0x480a80017fff8000",
            "0x480a80007fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe67",
            "0x480a80027fff8000",
            "0x482680017ffb8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x482680017ffc8000",
            "0x4",
            "0x482a80007ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe4",
            "0x48127ffe7fff8000",
            "0x482880007ffe8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffa",
            "0x4",
            "0x480a7ff97fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280007ffb8000",
            "0x400280007ffd7fff",
            "0x480280017ffb8000",
            "0x400280017ffd7fff",
            "0x480280037ffb8000",
            "0x400280027ffd7fff",
            "0x480280027ffb8000",
            "0x48327fff7ffc8000",
            "0x400280037ffd7fff",
            "0x480a7ff97fff8000",
            "0x482680017ffa8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x482680017ffb8000",
            "0x4",
            "0x480a7ffc7fff8000",
            "0x482680017ffd8000",
            "0x4",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffec",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff43",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff3",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff3e",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff25",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe90",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffea",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffee8",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff3",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffed4",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280027ffb8000",
            "0x480280017ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x48307fff7ffe8000",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x1",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x482680017ffd8000",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffdc",
            "0x48127ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe3",
            "0x48127ff37fff8000",
            "0x48127ff37fff8000",
            "0x48127ffb7fff8000",
            "0x48127ff37fff8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ff57fff8000",
            "0x480a7ff67fff8000",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffeb4",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x4003800080007ffb",
            "0x400380007ffd7ffb",
            "0x402780017ffd8001",
            "0x1",
            "0x4826800180008000",
            "0x1",
            "0x40297ffb7fff8002",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffc7fff8000",
            "0x480a7ffb7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffd63",
            "0x480a80017fff8000",
            "0x4829800080008002",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x1",
            "0x480280007ffd8000",
            "0x484480017fff8000",
            "0x4",
            "0x48307fff7ffd8000",
            "0x480280027ffb8000",
            "0x480080007ffe8000",
            "0x400080017ffe7fff",
            "0x482480017ffd8000",
            "0x1",
            "0x480080007ffc8000",
            "0x48307fff7ffe8000",
            "0x482480017fff8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x2",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x482680017ffd8000",
            "0x1",
            "0x480080007ff28000",
            "0x482480017ff18000",
            "0x1",
            "0x480080007ff58000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc0",
            "0x40137ffa7fff8000",
            "0x40137ffb7fff8001",
            "0x40137ffd7fff8002",
            "0x48127ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc6",
            "0x480a80007fff8000",
            "0x480a80017fff8000",
            "0x48127ffb7fff8000",
            "0x480a80027fff8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe"
        ],
        "debug_info": {
            "file_contents": {
                "autogen/starknet/arg_processor/164ac49a4ba7621bb283de066400b7a3a6c3fcb5a82417a78c81b6ddd4e1925e.cairo": "assert [__return_value_ptr] = ret_value.success\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo": "assert [cast(fp + (-4), felt*)] = __calldata_actual_size\n",
                "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo": "let __calldata_arg_call_array_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/2af83e2ace09380d3be2e1d366c8649a74753b790c9d2b5e425bfdf350d70145.cairo": "let __calldata_arg_nonce = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/4f07c4ae795d22b6bc4426e596637ee88f870711dc3768dd8178092f4b2c0b65.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_calldata_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_calldata = cast(__calldata_ptr, felt*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_calldata_len * 1\n",
                "autogen/starknet/arg_processor/5d2294ce8e305b1bd560f56804793340439bb863103e1ba5c235e3d08cf6d272.cairo": "let __calldata_arg_interfaceId = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo": "let __calldata_actual_size =  __calldata_ptr - cast([cast(fp + (-3), felt**)], felt*)\n",
                "autogen/starknet/arg_processor/7bb8ebaf1adbcc95ba53cf61877f9b0182ef69b7220a3f0b03c5d57c3b051667.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_call_array_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_call_array = cast(__calldata_ptr, openzeppelin.account.library.AccountCallArray*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_call_array_len * 4\n",
                "autogen/starknet/arg_processor/82845ad084ad423c1c2d7fd0102ea33cf14d8eea0f8091dcd0bac7c89e6ec075.cairo": "assert [__return_value_ptr] = ret_value.is_valid\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/arg_processor/8799496fe2567340f6719cfd30d7db5f6b8e7aa420ca97e3a3c3ccbdfbb2e674.cairo": "let __calldata_arg_calldata_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo": "let __calldata_arg_new_public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = ret_value.response_len\n# Store the updated range_check_ptr as a local variable to keep it available after\n# the memcpy.\nlocal range_check_ptr = range_check_ptr + 1\n# Keep a reference to __return_value_ptr.\nlet __return_value_ptr_copy = __return_value_ptr\n# Store the updated __return_value_ptr as a local variable to keep it available after\n# the memcpy.\nlocal __return_value_ptr : felt* = __return_value_ptr + ret_value.response_len * 1\nmemcpy(\n    dst=__return_value_ptr_copy,\n    src=ret_value.response,\n    len=ret_value.response_len * 1)\n",
                "autogen/starknet/arg_processor/a46542dc358872d57a2d9f424e61d9b07a0e4c72f24e3645022494cebfb47c83.cairo": "assert [__return_value_ptr] = ret_value.res\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_signature_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_signature = cast(__calldata_ptr, felt*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_signature_len * 1\n",
                "autogen/starknet/arg_processor/dddef5deb48d77c2b777f7818c119d55373dc859a9d96120cc0b9b9d770eaaa8.cairo": "assert [__return_value_ptr] = ret_value.response_len\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo": "let __calldata_arg_signature_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo": "let __calldata_arg_hash = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/f68ac5127c2e5f488e054b6e5406fbd4412fe40038204608d22aadbaf91f8427.cairo": "let __calldata_arg_public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/external/__execute__/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/__execute__/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/__execute__/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/__execute__/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/__execute__/e00a64e3749f85fb2392638ff06fa2928ca3ddb4ecbd4918465b447ba876482e.cairo": "let ret_value = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(call_array_len=__calldata_arg_call_array_len, call_array=__calldata_arg_call_array, calldata_len=__calldata_arg_calldata_len, calldata=__calldata_arg_calldata, nonce=__calldata_arg_nonce,)\nlet (range_check_ptr, retdata_size, retdata) = __execute___encode_return(ret_value, range_check_ptr)\n",
                "autogen/starknet/external/__execute__/e2645b5103a9d5af449b8fe7ba025f8f981a7d85f0d6bd668f32b9064d8689dd.cairo": "func __execute__() -> (syscall_ptr : felt*, pedersen_ptr : starkware.cairo.common.cairo_builtins.HashBuiltin*, range_check_ptr : felt, ecdsa_ptr : starkware.cairo.common.cairo_builtins.SignatureBuiltin*, size, retdata : felt*):\n    alloc_locals\nend\n",
                "autogen/starknet/external/__execute__/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/constructor/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo": "let ret_value = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(public_key=__calldata_arg_public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/constructor/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/constructor/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/constructor/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/get_nonce/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/get_nonce/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_nonce/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/get_nonce/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo": "let ret_value = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_nonce_encode_return(ret_value, range_check_ptr)\n",
                "autogen/starknet/external/get_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo": "let ret_value = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_public_key_encode_return(ret_value, range_check_ptr)\n",
                "autogen/starknet/external/get_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/get_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/is_valid_signature/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo": "let ret_value = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(hash=__calldata_arg_hash, signature_len=__calldata_arg_signature_len, signature=__calldata_arg_signature,)\nlet (range_check_ptr, retdata_size, retdata) = is_valid_signature_encode_return(ret_value, range_check_ptr)\n",
                "autogen/starknet/external/is_valid_signature/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/is_valid_signature/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo": "func __execute___encode_return(ret_value : (response_len : felt, response : felt*), range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo": "func get_nonce_encode_return(ret_value : (res : felt), range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo": "func get_public_key_encode_return(ret_value : (res : felt), range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo": "func is_valid_signature_encode_return(ret_value : (is_valid : felt), range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo": "func supportsInterface_encode_return(ret_value : (success : felt), range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/set_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/set_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/set_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo": "let ret_value = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(new_public_key=__calldata_arg_new_public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/set_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/supportsInterface/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/supportsInterface/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/supportsInterface/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/supportsInterface/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo": "let ret_value = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(interfaceId=__calldata_arg_interfaceId,)\nlet (range_check_ptr, retdata_size, retdata) = supportsInterface_encode_return(ret_value, range_check_ptr)\n",
                "autogen/starknet/storage_var/Account_current_nonce/decl.cairo": "namespace Account_current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/Account_current_nonce/impl.cairo": "namespace Account_current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 680641068382147823690491849560675892800103278811133310055689865859989991742\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend",
                "autogen/starknet/storage_var/Account_public_key/decl.cairo": "namespace Account_public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/Account_public_key/impl.cairo": "namespace Account_public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 550557492744938365112574611882025123252567779123164597803728068558738016655\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend",
                "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo": "namespace ERC165_supported_interfaces:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}(interface_id : felt) -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n        interface_id : felt\n    ) -> (is_supported : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n        interface_id : felt, value : felt\n    ):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo": "namespace ERC165_supported_interfaces:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}(interface_id : felt) -> (res : felt):\n        let res = 479559987705328862372362947504386080106579713470203672197513890426980061174\n        let (res) = hash2{hash_ptr=pedersen_ptr}(res, cast(&interface_id, felt*)[0])\n        let (res) = normalize_address(addr=res)\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n        interface_id : felt\n    ) -> (is_supported : felt):\n        let (storage_addr) = addr(interface_id)\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(\n        interface_id : felt, value : felt\n    ):\n        let (storage_addr) = addr(interface_id)\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend"
            },
            "instruction_locations": {
                "0": {
                    "accessible_scopes": [
                        "starkware.cairo.common.alloc",
                        "starkware.cairo.common.alloc.alloc"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/alloc.cairo"
                                },
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 12,
                        "end_line": 4,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/alloc.cairo"
                        },
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "2": {
                    "accessible_scopes": [
                        "starkware.cairo.common.alloc",
                        "starkware.cairo.common.alloc.alloc"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 5,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/alloc.cairo"
                        },
                        "start_col": 5,
                        "start_line": 5
                    }
                },
                "3": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 14
                    }
                },
                "4": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 15,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 15
                    }
                },
                "5": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 18
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 17
                    }
                },
                "7": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 16,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "start_col": 20,
                                "start_line": 18
                            },
                            "While expanding the reference 'result' in:"
                        ],
                        "start_col": 18,
                        "start_line": 16
                    }
                },
                "8": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 18
                    }
                },
                "9": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 8,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 8
                    }
                },
                "11": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 9,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "12": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 41,
                                "end_line": 12,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 12
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 35,
                                "start_line": 13
                            },
                            "While expanding the reference 'dst' in:"
                        ],
                        "start_col": 13,
                        "start_line": 2
                    }
                },
                "13": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 44,
                                "start_line": 13
                            },
                            "While expanding the reference 'src' in:"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "14": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 26,
                        "start_line": 17
                    }
                },
                "15": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 17
                    }
                },
                "16": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "18": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 23
                    }
                },
                "20": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 24
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 44,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 29
                    }
                },
                "22": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 31,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 31
                    }
                },
                "23": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 26,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 33
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 14,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 34
                    }
                },
                "24": {
                    "accessible_scopes": [
                        "starkware.cairo.lang.compiler.lib.registers",
                        "starkware.cairo.lang.compiler.lib.registers.get_fp_and_pc"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 72,
                        "end_line": 6,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/lang/compiler/lib/registers.cairo"
                        },
                        "start_col": 5,
                        "start_line": 6
                    }
                },
                "25": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 29,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 5,
                                "start_line": 20
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 14,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 8,
                        "start_line": 30
                    }
                },
                "26": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 30
                    }
                },
                "28": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 9,
                        "start_line": 32
                    }
                },
                "30": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_not_equal"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 35,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 35
                    }
                },
                "31": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 5,
                                "start_line": 95
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 50,
                        "end_line": 106,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 36,
                        "start_line": 106
                    }
                },
                "33": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 93,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 57,
                                "end_line": 106,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 53,
                                "start_line": 106
                            },
                            "While expanding the reference 'high' in:"
                        ],
                        "start_col": 16,
                        "start_line": 93
                    }
                },
                "34": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 106,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 36,
                        "start_line": 106
                    }
                },
                "35": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 106,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 106
                    }
                },
                "36": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 93,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 111,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 20,
                                "start_line": 111
                            },
                            "While expanding the reference 'high' in:"
                        ],
                        "start_col": 16,
                        "start_line": 93
                    }
                },
                "37": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 111,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 20,
                        "start_line": 111
                    }
                },
                "39": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 92,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 111,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "start_col": 35,
                                "start_line": 111
                            },
                            "While expanding the reference 'low' in:"
                        ],
                        "start_col": 15,
                        "start_line": 92
                    }
                },
                "40": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 111,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 111
                    }
                },
                "41": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 113,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 114,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 114
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 87
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 113
                    }
                },
                "43": {
                    "accessible_scopes": [
                        "starkware.cairo.common.math",
                        "starkware.cairo.common.math.assert_250_bit"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 114,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "start_col": 5,
                        "start_line": 114
                    }
                },
                "44": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 5,
                        "start_line": 13
                    }
                },
                "46": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 21,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 5,
                                "start_line": 14
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 7,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "48": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 26,
                                        "end_line": 50,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 50
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 87
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "49": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 48,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 50,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 24,
                                "start_line": 50
                            },
                            "While expanding the reference 'x' in:"
                        ],
                        "start_col": 17,
                        "start_line": 48
                    }
                },
                "51": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 50,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 50
                    }
                },
                "53": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 24,
                                "start_line": 51
                            },
                            "While expanding the reference 'y' in:"
                        ],
                        "start_col": 18,
                        "start_line": 49
                    }
                },
                "55": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 50,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 87,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 26,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 51
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 87
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 50
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 87
                    }
                },
                "56": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 24,
                                "start_line": 51
                            },
                            "While expanding the reference 'y' in:"
                        ],
                        "start_col": 17,
                        "start_line": 49
                    }
                },
                "57": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 51
                    }
                },
                "59": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 52,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 21,
                        "start_line": 52
                    }
                },
                "61": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 52,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 52
                    }
                },
                "62": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 23
                    }
                },
                "64": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 57,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 9,
                                "start_line": 24
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 11,
                        "end_line": 25,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "66": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 30
                    }
                },
                "68": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 28,
                        "start_line": 32
                    }
                },
                "70": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 32,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                        },
                                        "start_col": 13,
                                        "start_line": 32
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 87
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "71": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 28,
                        "start_line": 32
                    }
                },
                "72": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 32
                    }
                },
                "74": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 11,
                        "end_line": 25,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "76": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 26,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 26
                    }
                },
                "78": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/math.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 28,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                        },
                                        "start_col": 13,
                                        "start_line": 28
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 87
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "79": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 28,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 28,
                                "start_line": 28
                            },
                            "While expanding the reference 'addr' in:"
                        ],
                        "start_col": 41,
                        "start_line": 12
                    }
                },
                "80": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 28,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 13,
                        "start_line": 28
                    }
                },
                "82": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 34,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "start_col": 21,
                                "start_line": 34
                            },
                            "While expanding the reference 'addr' in:"
                        ],
                        "start_col": 41,
                        "start_line": 12
                    }
                },
                "83": {
                    "accessible_scopes": [
                        "starkware.starknet.common.storage",
                        "starkware.starknet.common.storage.normalize_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "start_col": 9,
                        "start_line": 34
                    }
                },
                "84": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 47,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 47
                    }
                },
                "86": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "87": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "88": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "89": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "90": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "91": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 52,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 52
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 55,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 42,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 56,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 56
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 42
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 55
                    }
                },
                "93": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 26,
                        "start_line": 56
                    }
                },
                "94": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 57,
                        "start_line": 56
                    }
                },
                "95": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 56
                    }
                },
                "96": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 90,
                        "end_line": 196,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 63,
                        "start_line": 196
                    }
                },
                "98": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 91,
                        "end_line": 196,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 196
                    }
                },
                "99": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 93,
                                "end_line": 197,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 197
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 58,
                        "end_line": 198,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 60,
                                        "end_line": 199,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 199
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 194
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 198
                    }
                },
                "101": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 199,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 28,
                        "start_line": 199
                    }
                },
                "102": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 60,
                        "end_line": 199,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 199
                    }
                },
                "103": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 270,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 65,
                        "start_line": 270
                    }
                },
                "105": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 270,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 270
                    }
                },
                "106": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 95,
                                "end_line": 271,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 271
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 60,
                        "end_line": 272,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 268,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 273,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 273
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 268
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 272
                    }
                },
                "108": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 273,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 30,
                        "start_line": 273
                    }
                },
                "109": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 273,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 273
                    }
                },
                "110": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 348,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 58,
                        "start_line": 348
                    }
                },
                "112": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 348,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 348
                    }
                },
                "113": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 348,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 348
                    }
                },
                "114": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 87,
                                "end_line": 349,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 349
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 53,
                        "end_line": 351,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 346,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 352,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 352
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 346
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 351
                    }
                },
                "116": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 352,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 19,
                        "start_line": 352
                    }
                },
                "117": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 352,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 352
                    }
                },
                "118": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 366,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 366
                    }
                },
                "120": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 366,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 365
                    }
                },
                "121": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 366,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 365
                    }
                },
                "122": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 366,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 365
                    }
                },
                "123": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 367,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 367
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 368,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 364,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 369,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 369
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 364
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 368
                    }
                },
                "125": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 369,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 369
                    }
                },
                "126": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 76,
                        "end_line": 435,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 56,
                        "start_line": 435
                    }
                },
                "128": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 77,
                        "end_line": 435,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 435
                    }
                },
                "129": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 86,
                                "end_line": 436,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 436
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 51,
                        "end_line": 438,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 433,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 439,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 439
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 433
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 438
                    }
                },
                "131": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 439,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 21,
                        "start_line": 439
                    }
                },
                "132": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 439,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 439
                    }
                },
                "133": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 98,
                                "end_line": 10,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "start_col": 5,
                                "start_line": 10
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 39,
                        "end_line": 11,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 11
                    }
                },
                "134": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 12
                    }
                },
                "135": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 15,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 15
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 14
                    }
                },
                "137": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 15,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 15
                    }
                },
                "138": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 36,
                                "start_line": 9
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "139": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 53,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 50,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "141": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 84,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 9
                    }
                },
                "142": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 21,
                        "start_line": 9
                    }
                },
                "144": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 12,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 10
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 12
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "145": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 10,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 44,
                                "start_line": 10
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 14,
                        "start_line": 9
                    }
                },
                "146": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 10,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 21,
                        "start_line": 10
                    }
                },
                "148": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 11
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 9
                    }
                },
                "149": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/storage.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 10,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 7,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 11,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 11
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 7
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 10
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 12
                    }
                },
                "150": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 10,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 11,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 11
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 14,
                        "start_line": 10
                    }
                },
                "151": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 11
                    }
                },
                "152": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 17
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 14
                    }
                },
                "153": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 17
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 14
                    }
                },
                "154": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 15,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 35,
                                "start_line": 17
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 9,
                        "start_line": 15
                    }
                },
                "155": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 17,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 17
                    }
                },
                "157": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 346,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 18
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 346
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 14
                    }
                },
                "158": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 17,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 18
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 17
                    }
                },
                "159": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 18,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 18
                    }
                },
                "161": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 346,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 20,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 20
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 18
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 346
                    }
                },
                "162": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 21,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 21
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 17
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "163": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 22,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 22
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 17
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "164": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 18,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 23,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 23
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 18
                    }
                },
                "165": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 24
                    }
                },
                "166": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 27,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 30,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 30
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 27
                    }
                },
                "167": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 27,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 30,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 30
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 27
                    }
                },
                "168": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 28,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 30,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 35,
                                "start_line": 30
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 9,
                        "start_line": 28
                    }
                },
                "169": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 30,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 30
                    }
                },
                "171": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 27,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 364,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 31,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 31
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 364
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 27
                    }
                },
                "172": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 30,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 31
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 30
                    }
                },
                "173": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 31,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 31
                    }
                },
                "174": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 31,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 31
                    }
                },
                "176": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 30,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 21,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 32,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 32
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 21
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 30
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "177": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 30,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 21,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 32,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 32
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 21
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 30
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "178": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces",
                        "openzeppelin.introspection.ERC165.ERC165_supported_interfaces.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 32,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 32
                    }
                },
                "179": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 12,
                        "start_line": 22
                    }
                },
                "181": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 11,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 9,
                        "start_line": 22
                    }
                },
                "183": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 31,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 26,
                                        "end_line": 23,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 13,
                                        "start_line": 23
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 18
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 18
                    }
                },
                "184": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 19,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 26,
                                        "end_line": 23,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 13,
                                        "start_line": 23
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 19
                    }
                },
                "185": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 20,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 20,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 26,
                                        "end_line": 23,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 13,
                                        "start_line": 23
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 20
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 20
                    }
                },
                "186": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 21,
                        "start_line": 23
                    }
                },
                "188": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 13,
                        "start_line": 23
                    }
                },
                "189": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 76,
                                        "end_line": 27,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 27
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 18
                    }
                },
                "190": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 19,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 76,
                                        "end_line": 27,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 27
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 19
                    }
                },
                "191": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 20,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 76,
                                        "end_line": 27,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 27
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 20
                    }
                },
                "192": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 21,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "start_col": 63,
                                "start_line": 27
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 12,
                        "start_line": 21
                    }
                },
                "193": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 76,
                        "end_line": 27,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 30,
                        "start_line": 27
                    }
                },
                "195": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.supports_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 28,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 9,
                        "start_line": 28
                    }
                },
                "196": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 35,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 37,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "start_col": 30,
                                "start_line": 37
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 12,
                        "start_line": 35
                    }
                },
                "197": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 37,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 44,
                        "start_line": 37
                    }
                },
                "199": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 37,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 13,
                        "start_line": 37
                    }
                },
                "201": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 32,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 21,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 62,
                                        "end_line": 39,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 39
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 16,
                                "start_line": 21
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 32
                    }
                },
                "202": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 33,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 21,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 62,
                                        "end_line": 39,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 39
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 21
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 33
                    }
                },
                "203": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 21,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/ERC165_supported_interfaces/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 62,
                                        "end_line": 39,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 39
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 21
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 34
                    }
                },
                "204": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 35,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 39,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "start_col": 43,
                                "start_line": 39
                            },
                            "While expanding the reference 'interface_id' in:"
                        ],
                        "start_col": 12,
                        "start_line": 35
                    }
                },
                "205": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 39,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 57,
                        "start_line": 39
                    }
                },
                "207": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 62,
                        "end_line": 39,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 9,
                        "start_line": 39
                    }
                },
                "209": {
                    "accessible_scopes": [
                        "openzeppelin.introspection.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165",
                        "openzeppelin.introspection.ERC165.ERC165.register_interface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 40,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                        },
                        "start_col": 9,
                        "start_line": 40
                    }
                },
                "210": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "211": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "212": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "214": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "215": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "216": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "217": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "219": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 346,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 346
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "220": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "221": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "223": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 346,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 346
                    }
                },
                "224": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "225": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "226": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "227": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "228": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "229": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "230": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "232": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 364,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 364
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "233": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "234": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "235": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "237": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "238": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "239": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_current_nonce",
                        "openzeppelin.account.library.Account_current_nonce.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "240": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "241": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "242": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "244": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.addr"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "245": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "246": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "247": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "249": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 346,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 346
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "250": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "251": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "253": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 346,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 346
                    }
                },
                "254": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "255": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "256": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "257": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.read"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "258": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "259": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "260": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "262": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 364,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 364
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "263": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "264": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "265": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "267": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "268": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "269": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account_public_key",
                        "openzeppelin.account.library.Account_public_key.write"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "270": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 55,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 59,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 59
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 16,
                                "start_line": 19
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 55
                    }
                },
                "271": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 59,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 59
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 56
                    }
                },
                "272": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 57,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 59,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 59
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 19
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 57
                    }
                },
                "273": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 58,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 45,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 34,
                                "start_line": 59
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 11,
                        "start_line": 58
                    }
                },
                "274": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 59,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 59
                    }
                },
                "276": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 60,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 35,
                        "start_line": 60
                    }
                },
                "278": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 60,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 60
                    }
                },
                "280": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.initializer"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 61,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 61
                    }
                },
                "281": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.assert_only_self"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 68,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 268,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 69,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 22,
                                        "start_line": 69
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 268
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 68
                    }
                },
                "282": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.assert_only_self"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 69,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 22,
                        "start_line": 69
                    }
                },
                "284": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.assert_only_self"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 268,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 194,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 70,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 24,
                                                "start_line": 70
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 25,
                                        "start_line": 194
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 22,
                                "start_line": 69
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 268
                    }
                },
                "285": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.assert_only_self"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 70,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 24,
                        "start_line": 70
                    }
                },
                "287": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.assert_only_self"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 72,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 13,
                        "start_line": 72
                    }
                },
                "288": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.assert_only_self"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 194,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 70,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 68,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 74,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 74
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 27,
                                        "start_line": 68
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 70
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 194
                    }
                },
                "289": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.assert_only_self"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 74,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 74
                    }
                },
                "290": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 82,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 86,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 86
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 82
                    }
                },
                "291": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 83,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 86,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 86
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 83
                    }
                },
                "292": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 84,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 86,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 86
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 84
                    }
                },
                "293": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 86,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 21,
                        "start_line": 86
                    }
                },
                "295": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 87
                    }
                },
                "296": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 91,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 95,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 95
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 91
                    }
                },
                "297": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 92,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 95,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 95
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 92
                    }
                },
                "298": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 93,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 95,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 95
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 93
                    }
                },
                "299": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 95,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 21,
                        "start_line": 95
                    }
                },
                "301": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 96,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 96
                    }
                },
                "302": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 104,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 68,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 108,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 108
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 68
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 104
                    }
                },
                "303": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 108,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 108
                    }
                },
                "305": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 105,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 109,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 109
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 105
                    }
                },
                "306": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 106,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 109,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 109
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 19
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 106
                    }
                },
                "307": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 107,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 109,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 34,
                                "start_line": 109
                            },
                            "While expanding the reference 'new_public_key' in:"
                        ],
                        "start_col": 11,
                        "start_line": 107
                    }
                },
                "308": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 109,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 109
                    }
                },
                "310": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 110,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 110
                    }
                },
                "311": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 118,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 54,
                                        "end_line": 127,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 29,
                                        "start_line": 127
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 118
                    }
                },
                "312": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 119,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 54,
                                        "end_line": 127,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 29,
                                        "start_line": 127
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 119
                    }
                },
                "313": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 120,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 54,
                                        "end_line": 127,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 29,
                                        "start_line": 127
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 120
                    }
                },
                "314": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 127,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 29,
                        "start_line": 127
                    }
                },
                "316": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 121,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 31,
                                        "end_line": 139,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 135
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 121
                    }
                },
                "317": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 123,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 136,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 21,
                                "start_line": 136
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 13,
                        "start_line": 123
                    }
                },
                "318": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 127,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 24,
                                "start_line": 137
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 14,
                        "start_line": 127
                    }
                },
                "319": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 132,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 138,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 25,
                                "start_line": 138
                            },
                            "While expanding the reference 'sig_r' in:"
                        ],
                        "start_col": 21,
                        "start_line": 132
                    }
                },
                "320": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 133,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 139,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 25,
                                "start_line": 139
                            },
                            "While expanding the reference 'sig_s' in:"
                        ],
                        "start_col": 21,
                        "start_line": 133
                    }
                },
                "321": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 139,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 135
                    }
                },
                "323": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 54,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 32,
                                        "end_line": 118,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 31,
                                                "end_line": 141,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 141
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 13,
                                        "start_line": 118
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 127
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "324": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 54,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 119,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 31,
                                                "end_line": 141,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 141
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 13,
                                        "start_line": 119
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 127
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "325": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 54,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 120,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 31,
                                                "end_line": 141,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 141
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 13,
                                        "start_line": 120
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 127
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "326": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 7,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 31,
                                "end_line": 139,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 121,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 31,
                                                "end_line": 141,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 141
                                            },
                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 13,
                                        "start_line": 121
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 135
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 29,
                        "start_line": 7
                    }
                },
                "327": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 141,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 26,
                        "start_line": 141
                    }
                },
                "329": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 141,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 141
                    }
                },
                "330": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 157,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 157
                    }
                },
                "332": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 146,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 194,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 159,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 24,
                                        "start_line": 159
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 194
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 146
                    }
                },
                "333": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 159,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 24,
                        "start_line": 159
                    }
                },
                "335": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 161,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 13,
                        "start_line": 161
                    }
                },
                "337": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 164,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 27,
                        "start_line": 164
                    }
                },
                "339": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 194,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 159,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 433,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 38,
                                                "end_line": 165,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 25,
                                                "start_line": 165
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 18,
                                        "start_line": 433
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 159
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 194
                    }
                },
                "340": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 165,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 25,
                        "start_line": 165
                    }
                },
                "342": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 165,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 21,
                                "end_line": 165,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 14,
                                "start_line": 165
                            },
                            "While auto generating local variable for 'tx_info'."
                        ],
                        "start_col": 14,
                        "start_line": 165
                    }
                },
                "343": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 433,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 165,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 60,
                                                "end_line": 166,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 32,
                                                "start_line": 166
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 15,
                                        "start_line": 13
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 165
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 18,
                        "start_line": 433
                    }
                },
                "344": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 147,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 60,
                                        "end_line": 166,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 166
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 147
                    }
                },
                "345": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 148,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 60,
                                        "end_line": 166,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 166
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 148
                    }
                },
                "346": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 60,
                        "end_line": 166,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 32,
                        "start_line": 166
                    }
                },
                "348": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 60,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 63,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 60,
                                                "end_line": 166,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 32,
                                                "start_line": 166
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 36,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 32,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "349": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 60,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 60,
                                                "end_line": 166,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 32,
                                                "start_line": 166
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 32,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "350": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 166,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 14,
                                "start_line": 166
                            },
                            "While auto generating local variable for '_current_nonce'."
                        ],
                        "start_col": 14,
                        "start_line": 166
                    }
                },
                "351": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 169,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 169
                    }
                },
                "352": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 172,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 31,
                        "start_line": 172
                    }
                },
                "354": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 172,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 14,
                                "start_line": 172
                            },
                            "While auto generating local variable for 'calls'."
                        ],
                        "start_col": 14,
                        "start_line": 172
                    }
                },
                "355": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 60,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 53,
                                        "end_line": 219,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 78,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 173
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 35,
                                        "start_line": 219
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 32,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "356": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 151,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 34,
                                "start_line": 173
                            },
                            "While expanding the reference 'call_array_len' in:"
                        ],
                        "start_col": 13,
                        "start_line": 151
                    }
                },
                "357": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 152,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 60,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 50,
                                "start_line": 173
                            },
                            "While expanding the reference 'call_array' in:"
                        ],
                        "start_col": 13,
                        "start_line": 152
                    }
                },
                "358": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 154,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 62,
                                "start_line": 173
                            },
                            "While expanding the reference 'calldata' in:"
                        ],
                        "start_col": 13,
                        "start_line": 154
                    }
                },
                "359": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 172,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 77,
                                        "end_line": 173,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 72,
                                        "start_line": 173
                                    },
                                    "While expanding the reference 'calls' in:"
                                ],
                                "start_col": 14,
                                "start_line": 172
                            },
                            "While auto generating local variable for 'calls'."
                        ],
                        "start_col": 14,
                        "start_line": 172
                    }
                },
                "360": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 78,
                        "end_line": 173,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 173
                    }
                },
                "362": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 60,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 63,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 60,
                                                "end_line": 166,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 40,
                                                        "end_line": 119,
                                                        "input_file": {
                                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 112,
                                                                "end_line": 177,
                                                                "input_file": {
                                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 26,
                                                                "start_line": 177
                                                            },
                                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                                        ],
                                                        "start_col": 13,
                                                        "start_line": 119
                                                    },
                                                    "While expanding the reference 'pedersen_ptr' in:"
                                                ],
                                                "start_col": 32,
                                                "start_line": 166
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 36,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 32,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "363": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 60,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 60,
                                                "end_line": 166,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 28,
                                                        "end_line": 120,
                                                        "input_file": {
                                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 112,
                                                                "end_line": 177,
                                                                "input_file": {
                                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 26,
                                                                "start_line": 177
                                                            },
                                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                                        ],
                                                        "start_col": 13,
                                                        "start_line": 120
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 32,
                                                "start_line": 166
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 32,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "364": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 149,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 41,
                                "end_line": 121,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 112,
                                        "end_line": 177,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 26,
                                        "start_line": 177
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 121
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 149
                    }
                },
                "365": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 69,
                        "end_line": 177,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 45,
                        "start_line": 177
                    }
                },
                "366": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 92,
                        "end_line": 177,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 71,
                        "start_line": 177
                    }
                },
                "367": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 111,
                        "end_line": 177,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 94,
                        "start_line": 177
                    }
                },
                "368": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 112,
                        "end_line": 177,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 26,
                        "start_line": 177
                    }
                },
                "370": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 121,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 112,
                                "end_line": 177,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 121,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 112,
                                                "end_line": 177,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 26,
                                                "start_line": 177
                                            },
                                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 13,
                                        "start_line": 121
                                    },
                                    "While auto generating local variable for 'ecdsa_ptr'."
                                ],
                                "start_col": 26,
                                "start_line": 177
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 121
                    }
                },
                "371": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 179,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 13,
                        "start_line": 179
                    }
                },
                "373": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 118,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 112,
                                "end_line": 177,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 35,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 183
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 16,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 26,
                                "start_line": 177
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 118
                    }
                },
                "374": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 119,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 112,
                                "end_line": 177,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 183
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 26,
                                "start_line": 177
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 119
                    }
                },
                "375": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 120,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 112,
                                "end_line": 177,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 183
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 26,
                                "start_line": 177
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 120
                    }
                },
                "376": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 183,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 37,
                        "start_line": 183
                    }
                },
                "378": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 183,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 183
                    }
                },
                "380": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 183,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 183
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 9,
                                "start_line": 183
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 19
                    }
                },
                "381": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 183,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 183
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 9,
                                "start_line": 183
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 19
                    }
                },
                "382": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 186,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 34,
                        "start_line": 186
                    }
                },
                "384": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 186,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 186,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 14,
                                "start_line": 186
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 14,
                        "start_line": 186
                    }
                },
                "385": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 183,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 192,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 71,
                                                "end_line": 187,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 30,
                                                "start_line": 187
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 24,
                                        "start_line": 192
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 183
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 19
                    }
                },
                "386": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 151,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 174,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 53,
                                        "end_line": 187,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 44,
                                        "start_line": 187
                                    },
                                    "While expanding the reference 'calls_len' in:"
                                ],
                                "start_col": 25,
                                "start_line": 174
                            },
                            "While expanding the reference 'call_array_len' in:"
                        ],
                        "start_col": 13,
                        "start_line": 151
                    }
                },
                "387": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 172,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 60,
                                        "end_line": 187,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 55,
                                        "start_line": 187
                                    },
                                    "While expanding the reference 'calls' in:"
                                ],
                                "start_col": 14,
                                "start_line": 172
                            },
                            "While auto generating local variable for 'calls'."
                        ],
                        "start_col": 14,
                        "start_line": 172
                    }
                },
                "388": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 186,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 186,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 70,
                                        "end_line": 187,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 62,
                                        "start_line": 187
                                    },
                                    "While expanding the reference 'response' in:"
                                ],
                                "start_col": 14,
                                "start_line": 186
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 14,
                        "start_line": 186
                    }
                },
                "389": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 187,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 30,
                        "start_line": 187
                    }
                },
                "391": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 192,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 71,
                                "end_line": 187,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 32,
                                        "end_line": 146,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 62,
                                                "end_line": 189,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 189
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 13,
                                        "start_line": 146
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 187
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 192
                    }
                },
                "392": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 183,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 40,
                                                        "end_line": 147,
                                                        "input_file": {
                                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 62,
                                                                "end_line": 189,
                                                                "input_file": {
                                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 9,
                                                                "start_line": 189
                                                            },
                                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                                        ],
                                                        "start_col": 13,
                                                        "start_line": 147
                                                    },
                                                    "While expanding the reference 'pedersen_ptr' in:"
                                                ],
                                                "start_col": 9,
                                                "start_line": 183
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 9,
                                "start_line": 183
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 19
                    }
                },
                "393": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 183,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/Account_current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 56,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 28,
                                                        "end_line": 148,
                                                        "input_file": {
                                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 62,
                                                                "end_line": 189,
                                                                "input_file": {
                                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 9,
                                                                "start_line": 189
                                                            },
                                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                                        ],
                                                        "start_col": 13,
                                                        "start_line": 148
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 9,
                                                "start_line": 183
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 9,
                                "start_line": 183
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 19
                    }
                },
                "394": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 121,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 112,
                                "end_line": 177,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 121,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 112,
                                                "end_line": 177,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 41,
                                                        "end_line": 149,
                                                        "input_file": {
                                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 62,
                                                                "end_line": 189,
                                                                "input_file": {
                                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 9,
                                                                "start_line": 189
                                                            },
                                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                                        ],
                                                        "start_col": 13,
                                                        "start_line": 149
                                                    },
                                                    "While expanding the reference 'ecdsa_ptr' in:"
                                                ],
                                                "start_col": 26,
                                                "start_line": 177
                                            },
                                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 13,
                                        "start_line": 121
                                    },
                                    "While auto generating local variable for 'ecdsa_ptr'."
                                ],
                                "start_col": 26,
                                "start_line": 177
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 13,
                        "start_line": 121
                    }
                },
                "395": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 187,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 189,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 30,
                                "start_line": 189
                            },
                            "While expanding the reference 'response_len' in:"
                        ],
                        "start_col": 14,
                        "start_line": 187
                    }
                },
                "396": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 186,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 186,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 61,
                                        "end_line": 189,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 53,
                                        "start_line": 189
                                    },
                                    "While expanding the reference 'response' in:"
                                ],
                                "start_col": 14,
                                "start_line": 186
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 14,
                        "start_line": 186
                    }
                },
                "397": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account.execute"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 62,
                        "end_line": 189,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 189
                    }
                },
                "398": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 197,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 197
                    }
                },
                "400": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 11,
                        "end_line": 200,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 200
                    }
                },
                "402": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 192,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 192,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 22,
                                        "end_line": 201,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 12,
                                        "start_line": 201
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 192
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 192
                    }
                },
                "403": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 20,
                        "start_line": 201
                    }
                },
                "405": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 12,
                        "start_line": 201
                    }
                },
                "406": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 192,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 42,
                                "input_file": {
                                    "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 10,
                                        "end_line": 211,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 19,
                                        "start_line": 206
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 42
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 192
                    }
                },
                "407": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 207,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 30,
                        "start_line": 207
                    }
                },
                "408": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 208,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 31,
                        "start_line": 208
                    }
                },
                "409": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 209,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 27,
                        "start_line": 209
                    }
                },
                "410": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 210,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 22,
                        "start_line": 210
                    }
                },
                "411": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 10,
                        "end_line": 211,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 19,
                        "start_line": 206
                    }
                },
                "413": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 206,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 16,
                                "end_line": 206,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 13,
                                "start_line": 206
                            },
                            "While auto generating local variable for 'res'."
                        ],
                        "start_col": 13,
                        "start_line": 206
                    }
                },
                "414": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 206,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 16,
                                "end_line": 206,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 13,
                                "start_line": 206
                            },
                            "While auto generating local variable for 'res'."
                        ],
                        "start_col": 13,
                        "start_line": 206
                    }
                },
                "415": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 42,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 10,
                                "end_line": 211,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 39,
                                        "end_line": 42,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 10,
                                                "end_line": 211,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 19,
                                                "start_line": 206
                                            },
                                            "While trying to update the implicit return value 'syscall_ptr' in:"
                                        ],
                                        "start_col": 20,
                                        "start_line": 42
                                    },
                                    "While auto generating local variable for 'syscall_ptr'."
                                ],
                                "start_col": 19,
                                "start_line": 206
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 42
                    }
                },
                "416": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 195,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 213,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 16,
                                "start_line": 213
                            },
                            "While expanding the reference 'response' in:"
                        ],
                        "start_col": 13,
                        "start_line": 195
                    }
                },
                "417": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 213,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 26,
                        "start_line": 213
                    }
                },
                "418": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 213,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 39,
                        "start_line": 213
                    }
                },
                "419": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 213,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 213
                    }
                },
                "421": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 42,
                        "input_file": {
                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 10,
                                "end_line": 211,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 39,
                                        "end_line": 42,
                                        "input_file": {
                                            "filename": "/Users/timelock/cairo_venv/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 10,
                                                "end_line": 211,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 42,
                                                        "end_line": 192,
                                                        "input_file": {
                                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 106,
                                                                "end_line": 215,
                                                                "input_file": {
                                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                                },
                                                                "start_col": 30,
                                                                "start_line": 215
                                                            },
                                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                                        ],
                                                        "start_col": 24,
                                                        "start_line": 192
                                                    },
                                                    "While expanding the reference 'syscall_ptr' in:"
                                                ],
                                                "start_col": 19,
                                                "start_line": 206
                                            },
                                            "While trying to update the implicit return value 'syscall_ptr' in:"
                                        ],
                                        "start_col": 20,
                                        "start_line": 42
                                    },
                                    "While auto generating local variable for 'syscall_ptr'."
                                ],
                                "start_col": 19,
                                "start_line": 206
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 42
                    }
                },
                "422": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 215,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 44,
                        "start_line": 215
                    }
                },
                "424": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 76,
                        "end_line": 215,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 59,
                        "start_line": 215
                    }
                },
                "426": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 105,
                        "end_line": 215,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 78,
                        "start_line": 215
                    }
                },
                "427": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 106,
                        "end_line": 215,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 30,
                        "start_line": 215
                    }
                },
                "429": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 192,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 106,
                                "end_line": 215,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 192,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 49,
                                                "end_line": 216,
                                                "input_file": {
                                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 216
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 24,
                                        "start_line": 192
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 215
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 192
                    }
                },
                "430": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 216,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 17,
                        "start_line": 216
                    }
                },
                "431": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._execute_list"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 216,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 216
                    }
                },
                "432": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 11,
                        "end_line": 226,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 226
                    }
                },
                "434": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 219,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 53,
                                "end_line": 219,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 21,
                                        "end_line": 227,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 12,
                                        "start_line": 227
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 35,
                                "start_line": 219
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 35,
                        "start_line": 219
                    }
                },
                "435": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 227,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 12,
                        "start_line": 227
                    }
                },
                "436": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 232,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 20,
                        "start_line": 232
                    }
                },
                "437": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 236,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 231
                    }
                },
                "438": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 233,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 26,
                        "start_line": 233
                    }
                },
                "439": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 236,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 231
                    }
                },
                "440": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 51,
                        "end_line": 234,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 30,
                        "start_line": 234
                    }
                },
                "441": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 236,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 231
                    }
                },
                "442": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 235,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 37,
                        "start_line": 235
                    }
                },
                "443": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 235,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 26,
                        "start_line": 235
                    }
                },
                "444": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 236,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 231
                    }
                },
                "445": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 219,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 53,
                                "end_line": 219,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 118,
                                        "end_line": 238,
                                        "input_file": {
                                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 238
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 35,
                                "start_line": 219
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 35,
                        "start_line": 219
                    }
                },
                "446": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 238,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 34,
                        "start_line": 238
                    }
                },
                "448": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 88,
                        "end_line": 238,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 54,
                        "start_line": 238
                    }
                },
                "450": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 222,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 98,
                                "end_line": 238,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "start_col": 90,
                                "start_line": 238
                            },
                            "While expanding the reference 'calldata' in:"
                        ],
                        "start_col": 13,
                        "start_line": 222
                    }
                },
                "451": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 117,
                        "end_line": 238,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 100,
                        "start_line": 238
                    }
                },
                "453": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 118,
                        "end_line": 238,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 238
                    }
                },
                "455": {
                    "accessible_scopes": [
                        "openzeppelin.account.library",
                        "openzeppelin.account.library.Account",
                        "openzeppelin.account.library.Account._from_call_array_to_call"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 239,
                        "input_file": {
                            "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                        },
                        "start_col": 9,
                        "start_line": 239
                    }
                },
                "456": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 18,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 55,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 22,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 22
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 55
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 18
                    }
                },
                "457": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 19,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 56,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 22,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 22
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 56
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 19
                    }
                },
                "458": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 20,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 57,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 22,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 22
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 57
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "459": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 21,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 22,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 25,
                                "start_line": 22
                            },
                            "While expanding the reference 'public_key' in:"
                        ],
                        "start_col": 7,
                        "start_line": 21
                    }
                },
                "460": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 22,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "462": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 23,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 23
                    }
                },
                "463": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/f68ac5127c2e5f488e054b6e5406fbd4412fe40038204608d22aadbaf91f8427.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 21,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 57,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 17,
                                                                "end_line": 17,
                                                                "input_file": {
                                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 17
                                                            },
                                                            "While handling calldata of"
                                                        ],
                                                        "start_col": 35,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_actual_size' in:"
                                                ],
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While handling calldata of"
                                        ],
                                        "start_col": 31,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 7,
                                "start_line": 21
                            },
                            "While handling calldata argument 'public_key'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "465": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "466": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 55,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 18
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "467": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 82,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 70,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 19
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "468": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 20,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 115,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 100,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 20
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "469": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/f68ac5127c2e5f488e054b6e5406fbd4412fe40038204608d22aadbaf91f8427.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 21,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 153,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 128,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_public_key' in:"
                                ],
                                "start_col": 7,
                                "start_line": 21
                            },
                            "While handling calldata argument 'public_key'"
                        ],
                        "start_col": 33,
                        "start_line": 1
                    }
                },
                "470": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 17,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 17
                    }
                },
                "472": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 17,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 17
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "474": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 44,
                        "start_line": 1
                    }
                },
                "475": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 82,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "476": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 115,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 100,
                        "start_line": 1
                    }
                },
                "477": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "478": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "480": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/2beb1ad1a52488cb90cbb277e60f4638021fd358f9f99ca5a7a9a9c779fcfeda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 17,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 17
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "481": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 17,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 17
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "482": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 32,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 36,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 36
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 82
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 32
                    }
                },
                "483": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 33,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 36,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 36
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 83
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 33
                    }
                },
                "484": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 34,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 84,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 36,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 36
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 84
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 34
                    }
                },
                "485": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 36,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 17,
                        "start_line": 36
                    }
                },
                "487": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 37,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 37
                    }
                },
                "488": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 31,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 31
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "490": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/a46542dc358872d57a2d9f424e61d9b07a0e4c72f24e3645022494cebfb47c83.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 35,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 13,
                                "start_line": 35
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "491": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/a46542dc358872d57a2d9f424e61d9b07a0e4c72f24e3645022494cebfb47c83.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 35,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 35
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "493": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 76,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While handling return value of"
                        ],
                        "start_col": 61,
                        "start_line": 1
                    }
                },
                "494": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "495": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "496": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/6c88a431b3de1f686e46e7719bda3718e5ade4faed116bf334cf2c513d4a6834.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "497": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "498": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 32,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 55,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 32
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "499": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 82,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 70,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 33
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "500": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 34,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 115,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 100,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 34
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "501": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 31,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 31
                    }
                },
                "503": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 115,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 103,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 88,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 100,
                        "start_line": 1
                    }
                },
                "504": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 104,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "506": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 44,
                        "start_line": 1
                    }
                },
                "507": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 82,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "508": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "509": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "510": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "511": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/35b83a34f1cf366b18f748c48a0832a5f033d593109cf21173864ca057c7654e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 31,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 31
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "512": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 31,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 31
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "513": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 42,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 91,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 46,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 46
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 91
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 42
                    }
                },
                "514": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 43,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 46,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 46
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 92
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 43
                    }
                },
                "515": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 44,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 93,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 46,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 46
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 93
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 44
                    }
                },
                "516": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 46,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 17,
                        "start_line": 46
                    }
                },
                "518": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 47,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 47
                    }
                },
                "519": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 15,
                                        "end_line": 41,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 41
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "521": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/a46542dc358872d57a2d9f424e61d9b07a0e4c72f24e3645022494cebfb47c83.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 45,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 13,
                                "start_line": 45
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "522": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/a46542dc358872d57a2d9f424e61d9b07a0e4c72f24e3645022494cebfb47c83.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 45,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 45
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "524": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While handling return value of"
                        ],
                        "start_col": 56,
                        "start_line": 1
                    }
                },
                "525": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "526": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "527": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/bf93b3f24f44c1d231ee962dcd66f445400200471f41f6b8182438865c6aa329.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "528": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "529": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 42,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 55,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 42
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "530": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 82,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 70,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "531": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 44,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 115,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 100,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 44
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "532": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 15,
                        "end_line": 41,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 41
                    }
                },
                "534": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 115,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 98,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 83,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 100,
                        "start_line": 1
                    }
                },
                "535": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 99,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "537": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 44,
                        "start_line": 1
                    }
                },
                "538": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 82,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "539": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "540": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "541": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "542": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e66ea2d9a730c0c7d1a31a268304a4560d262e912e083a980ec218ee0d0494e3.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 41,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 41
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "543": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 41,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 41
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "544": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 52,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 31,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 56,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 56
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 18
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 52
                    }
                },
                "545": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 53,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 56,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 56
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 53
                    }
                },
                "546": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 54,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 20,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/introspection/ERC165.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 56,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 56
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 20
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 54
                    }
                },
                "547": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 55,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 56,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 47,
                                "start_line": 56
                            },
                            "While expanding the reference 'interfaceId' in:"
                        ],
                        "start_col": 8,
                        "start_line": 55
                    }
                },
                "548": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 56,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 21,
                        "start_line": 56
                    }
                },
                "550": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 57,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 57
                    }
                },
                "551": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 23,
                                        "end_line": 51,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 51
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "553": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/164ac49a4ba7621bb283de066400b7a3a6c3fcb5a82417a78c81b6ddd4e1925e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 55,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 31,
                                "start_line": 55
                            },
                            "While handling return value 'success'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "554": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/164ac49a4ba7621bb283de066400b7a3a6c3fcb5a82417a78c81b6ddd4e1925e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 55,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 31,
                                "start_line": 55
                            },
                            "While handling return value 'success'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "556": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While handling return value of"
                        ],
                        "start_col": 68,
                        "start_line": 1
                    }
                },
                "557": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "558": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "559": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/supportsInterface/0ccaafa110e9120e2b106f5b966106f81f3b3154d7181efd59d6d22304c05b8f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "560": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/5d2294ce8e305b1bd560f56804793340439bb863103e1ba5c235e3d08cf6d272.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 55,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 57,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 23,
                                                                "end_line": 51,
                                                                "input_file": {
                                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 51
                                                            },
                                                            "While handling calldata of"
                                                        ],
                                                        "start_col": 35,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_actual_size' in:"
                                                ],
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While handling calldata of"
                                        ],
                                        "start_col": 31,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 8,
                                "start_line": 55
                            },
                            "While handling calldata argument 'interfaceId'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "562": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "563": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 52,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 55,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 52
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "564": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 53,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 82,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 70,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 53
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "565": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 54,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 115,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 100,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 54
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "566": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/5d2294ce8e305b1bd560f56804793340439bb863103e1ba5c235e3d08cf6d272.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 55,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 155,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 129,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_interfaceId' in:"
                                ],
                                "start_col": 8,
                                "start_line": 55
                            },
                            "While handling calldata argument 'interfaceId'"
                        ],
                        "start_col": 34,
                        "start_line": 1
                    }
                },
                "567": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 51,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 51
                    }
                },
                "569": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 115,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 106,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 91,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 100,
                        "start_line": 1
                    }
                },
                "570": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 107,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "572": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 44,
                        "start_line": 1
                    }
                },
                "573": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 82,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "574": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "575": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "576": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "577": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/f42d4bdb706c65af40f5362367216470e8af3c2495211c590a9f91908a664080.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 23,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 51
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "578": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.supportsInterface"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/supportsInterface/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 51
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "579": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 66,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 43,
                                        "end_line": 70,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 70
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 104
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 66
                    }
                },
                "580": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 67,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 43,
                                        "end_line": 70,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 70
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 105
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 67
                    }
                },
                "581": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 68,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 106,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 43,
                                        "end_line": 70,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 70
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 106
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 68
                    }
                },
                "582": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 69,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 70,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 28,
                                "start_line": 70
                            },
                            "While expanding the reference 'new_public_key' in:"
                        ],
                        "start_col": 7,
                        "start_line": 69
                    }
                },
                "583": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 70,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 70
                    }
                },
                "585": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 71,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 71
                    }
                },
                "586": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 57,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 20,
                                                                "end_line": 65,
                                                                "input_file": {
                                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 65
                                                            },
                                                            "While handling calldata of"
                                                        ],
                                                        "start_col": 35,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_actual_size' in:"
                                                ],
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While handling calldata of"
                                        ],
                                        "start_col": 31,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 7,
                                "start_line": 69
                            },
                            "While handling calldata argument 'new_public_key'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "588": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "589": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 66,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 55,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 66
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "590": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 67,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 82,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 70,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 67
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "591": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 68,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 115,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 100,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 68
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "592": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 161,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 132,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_new_public_key' in:"
                                ],
                                "start_col": 7,
                                "start_line": 69
                            },
                            "While handling calldata argument 'new_public_key'"
                        ],
                        "start_col": 37,
                        "start_line": 1
                    }
                },
                "593": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 65,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 65
                    }
                },
                "595": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 65,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 65
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "597": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 44,
                        "start_line": 1
                    }
                },
                "598": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 82,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "599": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 115,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 100,
                        "start_line": 1
                    }
                },
                "600": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "601": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "603": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e204e5e6fd17023eb90ecd048f661ddb42e9bc72687cebc566b9a5843ced08fb.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 65
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "604": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 65
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "605": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 80,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 118,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 89,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 22,
                                        "start_line": 89
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 118
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 80
                    }
                },
                "606": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 81,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 119,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 89,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 22,
                                        "start_line": 89
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 119
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 81
                    }
                },
                "607": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 82,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 120,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 89,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 22,
                                        "start_line": 89
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 120
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 82
                    }
                },
                "608": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 83,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 41,
                                "end_line": 121,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 89,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 22,
                                        "start_line": 89
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 121
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 83
                    }
                },
                "609": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 85,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 53,
                                "end_line": 89,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 49,
                                "start_line": 89
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 9,
                        "start_line": 85
                    }
                },
                "610": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 86,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 68,
                                "end_line": 89,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 55,
                                "start_line": 89
                            },
                            "While expanding the reference 'signature_len' in:"
                        ],
                        "start_col": 9,
                        "start_line": 86
                    }
                },
                "611": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 87,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 79,
                                "end_line": 89,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 70,
                                "start_line": 89
                            },
                            "While expanding the reference 'signature' in:"
                        ],
                        "start_col": 9,
                        "start_line": 87
                    }
                },
                "612": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 89,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 22,
                        "start_line": 89
                    }
                },
                "614": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 90,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 90
                    }
                },
                "615": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 79,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 79
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "617": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 49,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/82845ad084ad423c1c2d7fd0102ea33cf14d8eea0f8091dcd0bac7c89e6ec075.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 88,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 11,
                                "start_line": 88
                            },
                            "While handling return value 'is_valid'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "618": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/82845ad084ad423c1c2d7fd0102ea33cf14d8eea0f8091dcd0bac7c89e6ec075.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 88,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 11,
                                "start_line": 88
                            },
                            "While handling return value 'is_valid'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "620": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While handling return value of"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "621": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "622": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "623": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature_encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/is_valid_signature/2fd1680b9b1da76b330dfd982566c62909fb67849afa1f48d22436e00093ed60.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "624": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 87,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 87
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 9,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "625": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 86,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 87,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 87
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 28,
                                        "start_line": 2
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 86
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "626": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 87
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "627": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 86,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 87,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 87
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 26,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 86
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "629": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 86,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 71,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 87,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 87
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 43,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 86
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "630": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 87
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 26,
                        "start_line": 8
                    }
                },
                "631": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "632": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 3,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 87,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 115,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 24,
                                                                "end_line": 79,
                                                                "input_file": {
                                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 79
                                                            },
                                                            "While constructing the external wrapper for:"
                                                        ],
                                                        "start_col": 100,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 9,
                                                "start_line": 87
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 23,
                                        "start_line": 3
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "633": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 80,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 55,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 44,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 80
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "634": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 81,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 82,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 70,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 81
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "635": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 115,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 100,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 87
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 23,
                        "start_line": 3
                    }
                },
                "637": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 112,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 136,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 127,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "638": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 19,
                                "end_line": 85,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 162,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 143,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_hash' in:"
                                ],
                                "start_col": 9,
                                "start_line": 85
                            },
                            "While handling calldata argument 'hash'"
                        ],
                        "start_col": 27,
                        "start_line": 1
                    }
                },
                "639": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 86,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 206,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 178,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 86
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "640": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 242,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 218,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_signature' in:"
                                ],
                                "start_col": 9,
                                "start_line": 87
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 32,
                        "start_line": 5
                    }
                },
                "642": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 79,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 79
                    }
                },
                "644": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 115,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 107,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 92,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 100,
                        "start_line": 1
                    }
                },
                "645": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 108,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "647": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 44,
                        "start_line": 1
                    }
                },
                "648": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 82,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "649": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "650": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 136,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 127,
                        "start_line": 1
                    }
                },
                "651": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "652": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/97096367aa11c68c9912acfe3d8ee0cc41f71c6e9bbb24b1d835849bc0f742ba.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 79,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 79
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "653": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 79,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 79
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "654": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 95,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 32,
                                "end_line": 146,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 6,
                                        "end_line": 112,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 36,
                                        "start_line": 106
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 146
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 95
                    }
                },
                "655": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 96,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 147,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 6,
                                        "end_line": 112,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 36,
                                        "start_line": 106
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 147
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 96
                    }
                },
                "656": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 97,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 148,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 6,
                                        "end_line": 112,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 36,
                                        "start_line": 106
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 148
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 97
                    }
                },
                "657": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 98,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 41,
                                "end_line": 149,
                                "input_file": {
                                    "filename": "/Users/timelock/swm/starkware/cairo-contracts/src/openzeppelin/account/library.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 6,
                                        "end_line": 112,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 36,
                                        "start_line": 106
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 149
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 98
                    }
                },
                "658": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 100,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 107,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 107
                            },
                            "While expanding the reference 'call_array_len' in:"
                        ],
                        "start_col": 9,
                        "start_line": 100
                    }
                },
                "659": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 101,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 19,
                                "end_line": 108,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 108
                            },
                            "While expanding the reference 'call_array' in:"
                        ],
                        "start_col": 9,
                        "start_line": 101
                    }
                },
                "660": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 102,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 21,
                                "end_line": 109,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 109
                            },
                            "While expanding the reference 'calldata_len' in:"
                        ],
                        "start_col": 9,
                        "start_line": 102
                    }
                },
                "661": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 103,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 110,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 110
                            },
                            "While expanding the reference 'calldata' in:"
                        ],
                        "start_col": 9,
                        "start_line": 103
                    }
                },
                "662": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 104,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 14,
                                "end_line": 111,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 111
                            },
                            "While expanding the reference 'nonce' in:"
                        ],
                        "start_col": 9,
                        "start_line": 104
                    }
                },
                "663": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 112,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 36,
                        "start_line": 106
                    }
                },
                "665": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 113,
                        "input_file": {
                            "filename": "src/openzeppelin/account/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 113
                    }
                },
                "666": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 17,
                                        "end_line": 94,
                                        "input_file": {
                                            "filename": "src/openzeppelin/account/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 94
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 94,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 94
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "668": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/dddef5deb48d77c2b777f7818c119d55373dc859a9d96120cc0b9b9d770eaaa8.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 11,
                                "start_line": 105
                            },
                            "While handling return value 'response_len'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "669": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 31,
                                "start_line": 105
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "670": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 31,
                                "start_line": 105
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 5
                    }
                },
                "672": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/dddef5deb48d77c2b777f7818c119d55373dc859a9d96120cc0b9b9d770eaaa8.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 54,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 46,
                                                "end_line": 105,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 31,
                                                "start_line": 105
                                            },
                                            "While handling return value 'response'"
                                        ],
                                        "start_col": 36,
                                        "start_line": 10
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 11,
                                "start_line": 105
                            },
                            "While handling return value 'response_len'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "674": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 10,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 31,
                                "start_line": 105
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 10
                    }
                },
                "675": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/dddef5deb48d77c2b777f7818c119d55373dc859a9d96120cc0b9b9d770eaaa8.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 7,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 46,
                                                "end_line": 105,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 32,
                                                        "end_line": 12,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 46,
                                                                "end_line": 105,
                                                                "input_file": {
                                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                                },
                                                                "start_col": 31,
                                                                "start_line": 105
                                                            },
                                                            "While handling return value 'response'"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 12
                                                    },
                                                    "While expanding the reference '__return_value_ptr_copy' in:"
                                                ],
                                                "start_col": 31,
                                                "start_line": 105
                                            },
                                            "While handling return value 'response'"
                                        ],
                                        "start_col": 31,
                                        "start_line": 7
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 11,
                                "start_line": 105
                            },
                            "While handling return value 'response_len'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "677": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 31,
                                "start_line": 105
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 9,
                        "start_line": 13
                    }
                },
                "678": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 31,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 31,
                                "start_line": 105
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 9,
                        "start_line": 14
                    }
                },
                "679": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 31,
                                "start_line": 105
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 11
                    }
                },
                "681": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/9a33b36f0b370727591cd73951c78dd45b374422bf83948718aa6f02ba9d5a5a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 94,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 94
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 31,
                                "start_line": 105
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 7,
                        "start_line": 5
                    }
                },
                "682": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 94,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 94
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "683": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 94,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 94,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 94
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 94
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "684": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute___encode_return"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/__execute__/0c74566530ff2aa54d0b76c774b9910d9b6556a601d082a161fd500a11d65a11.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 94,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 94
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "685": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/__execute__/e2645b5103a9d5af449b8fe7ba025f8f981a7d85f0d6bd668f32b9064d8689dd.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 94,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 94
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 5,
                        "start_line": 2
                    }
                },
                "687": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/__execute__/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 97,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/7bb8ebaf1adbcc95ba53cf61877f9b0182ef69b7220a3f0b03c5d57c3b051667.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 38,
                                                "end_line": 101,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 101
                                            },
                                            "While handling calldata argument 'call_array'"
                                        ],
                                        "start_col": 9,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 97
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "688": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 100,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 57,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/7bb8ebaf1adbcc95ba53cf61877f9b0182ef69b7220a3f0b03c5d57c3b051667.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 38,
                                                "end_line": 101,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 101
                                            },
                                            "While handling calldata argument 'call_array'"
                                        ],
                                        "start_col": 28,
                                        "start_line": 2
                                    },
                                    "While expanding the reference '__calldata_arg_call_array_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 100
                            },
                            "While handling calldata argument 'call_array_len'"
                        ],
                        "start_col": 37,
                        "start_line": 1
                    }
                },
                "689": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/7bb8ebaf1adbcc95ba53cf61877f9b0182ef69b7220a3f0b03c5d57c3b051667.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 101,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 101
                            },
                            "While handling calldata argument 'call_array'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "690": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 100,
                                "input_file": {
                                    "filename": "src/openzeppelin/account/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/7bb8ebaf1adbcc95ba53cf61877f9b0182ef69b7220a3f0b03c5d57c3b051667.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 38,
                                                "end_line": 101,
                                                "input_file": {
                                                    "filename": "src/openzeppelin/account/Account.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 101
                                            },
                                            "While handling calldata argument 'call_array'"
                                        ],
                                        "start_col": 26,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 100
                            },
                            "While handling calldata argument 'call_array_len'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "692": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": null,
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
               