#!/usr/bin/env python3

import matplotlib

__all__ = ['tab20c_color', 'google_color', 'ting_color', 'color']

cmap_tab20c: matplotlib.colors.ListedColormap = matplotlib.colormaps['tab20c']
tab20c_color: dict[str, list[tuple]] = {
    'deep': [cmap_tab20c(0), cmap_tab20c(8), cmap_tab20c(4), cmap_tab20c(12)],
    'light': [cmap_tab20c(1), cmap_tab20c(9), cmap_tab20c(5), cmap_tab20c(13)],
}

google_color = {
    'red': '#DB4437',
    'green': '#0F9D58',
    'blue': '#4285F4',
    'yellow': '#F4B400',
}
ting_color = {
    'red': '#DB3236',
    'red_carrot': '#E34638',
    'red_deep': '#C44C3F',

    'purple': '#593982',

    'green': '#429E46',

    'blue': '#6876AB',
    'blue_light': '#4885ED',
    'blue_grey': '#7396AE',

    'yellow': '#F7B52B',
    'yellow_deep': '#E7AD4C',

    'grey': '#989898',
}
color = {
    'red': {
        'red': '#FF0000',
        'light': '#FF7F7F',
        'dark': '#8B0000',

        'CMYK': '#ED1C24',
        'NCS': '#C40233',
        'munsell': '#F2003C',
        'pantone': '#ED2939',
        'crayola': '#EE204D',

        'scarlet': '#FF2400',
        'imperial': '#ED2939',
        'indian': '#CD5C5C',
        'spanish': '#E60026',
        'carmine': '#960018',
        'ruby': '#E0115F',
        'crimson': '#DC143C',
        'rusty': '#DA2C43',
        'fire_engine': '#CE2029',
        'cardinal': '#C41E3A',
        'chili': '#E23D28',
        'cornell': '#B31B1B',
        'fire_brick': '#B22222',
        'madder': '#A50021',
        'redwood': '#A45A52',
        'ou_crimson': '#841617',
        'chocolate_cosmos': '#58111A',
        'maroon': '#800000',
        'barn': '#7C0A02',
        'turkey': '#A91101',
        'cinnabar': '#E44D2E',
        'vermilion': '#E34234',
        'blood': '#660000',
        'lust': '#E62020',


        'pink': '#FFC0CB',
        'salmon_pink': '#FF91A4',
        'coral_pink': '#F88379',
        'salmon': '#FA8072',
    },
    'pink': {
        'pink': '#FFC0CB',
        'light': '#FFB6C1',
        'bright': '#FF007F',
        'hot': '#FF69B4',
        'deep': '#FF1493',
        'light_deep': '#FF5CCD',
        'ultra': '#FF6FFF',
        'shocking': '#FC0FC0',
        'super': '#CF6BA9',
        'light_hot': '#FFB3DE',

        'champagne': '#F1DDCF',
        'lace': '#FFDDF4',
        'piggy': '#FDDDE6',
        'pale': '#F9CCCA',
        'baby': '#F4C2C2',
        'G&S': '#F7BFBE',
        'cameo': '#EFBBCC',
        'orchid': '#F2BDCD',
        'fairy_tale': '#F2C1D1',
        'cherry_blossom': '#FFB7C5',
        'crayola': '#FBAED2',
        'cotton': '#FFBCD9',
        'carnation': '#FFA6C9',
        'baker_miller': '#FF91AF',
        'tickle_me': '#FC89AC',
        'amaranth': '#F19CBB',
        'charm': '#E68FAC',
        'china': '#DE6FA1',
        'mimi': '#FFDAE9',
        'tango': '#E4717A',
        'congo': '#F88379',
        'salmon': '#FA8072',
        'pastel': '#DEA5A4',
        'new_york': '#D7837F',
        'solid': '#893843',
        'silver': '#C4AEAD',
        'queen': '#E8CCD7',
        'lavender': '#DBB2D1',
        'mountbatten': '#997A8D',
        'chilean': '#E8C3BA',
        'pale_dogwood': '#EDCDC2',
        'pantone': '#D74894',
        'mexican': '#E4007C',
        'barbie': '#DA1884',
        'fandango': '#DE5285',
        'paradise': '#E63E62',
        'brink': '#FB607F',
        'french': '#FD6C9E',
        'persian': '#F77FBE',
        'rose': '#FF66CC',
        'rose_pumpadour': '#ED7A9B',
        'steel': '#CC33CC',
    },
    'yellow': {
        'yellow': '#F4B400',
        'light': '#FFFFE0',

        'goldenrod': '#DAA520'
    },
    'green': {
        'green': '#00FF00',
        'html': '#008000',
        'dark_x11': '#006400',
        'light': '#90EE90',
        'lime': '#32CD32',
        'pale': '#98FB98',
        'cmyk': '#00A550',
        'ncs': '#009F6B',
        'munsell': '#00A877',
        'pantone': '#00AD83',
        'crayola': '#1CAC78',
        'bright': '#66FF00',
        'mint_bright': '#4FFFB0',
        'dark': '#013220',
        'pastel_dark': '#03C03C',
        'green_yellow': '#ADFF2F',
        'harlequin': '#3FFF00',
        'neon': '#39FF14',
        'screamin': '#76FF7A',

        'army': '#4B5320',
        'apple': '#8DB600',
        'turtle': '#8A9A5B',
        'avocado': '#568203',
        'olive': '#808000',
        'pear': '#D1E231',
        'tea': '#D0F0C0',
        'forest': '#228B22',
    },
    'cyan': {
        'cyan': '#00FFFF',
        'cmyk': '#00B7EB',

    },
    'blue': {
        'blue': '#0000FF',
        'cmyk': '#333399',
        'ncs': '#0087BD',
        'munsell': '#0093AF',
        'pantone': '#0018A8',
        'crayola': '#1F75FE',

        'dark': '#00008B',
        'light': '#E0FFFF',
        'pale': '#87D3F8',

        'baby': '#89CFF0',
        'light2': '#ADD8E6',
        'periwinkle': '#CCCCFF',
        'powder': '#B0E0E6',
        'ice': '#99FFFF',
        'morning': '#8da399',

        'sky_blue': '#80DAEB',

    },

    'brown': {
        'brown': "#964B00",
        'red': '#A52A2A',
        'pale': '#987654',
        'medium': '#804000',
        'dark': '#654321',

        'beaver': '#9F8170',
        'beige': '#F5F5DC',
        'buff': '#F0DC82',
        'burnt_umber': '#8A3324',
        'chestnut': '#954535',
        'chocolate': '#7B3F00',
        'cocoa': '#D2691E',
        'desert_sand': '#EDC9AF',
        'khaki': '#C3B091',
        'kobicha': '#6B4423',
        'peru': '#CD853F',
        'raw_umber': '#826644',
        'rosy': '#BC8F8F',
        'russet': '#80461B',
        'sandy': '#F4A460',
        'smokey_topaz': '#832A0D',
        'tan': '#D2B48C',
        'taupe': '#483C32',
        'walnut': '#5C5248',
        'wood': '#C19A6B',
    },
}
