# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class CreateFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, name=None, description=None, start_schedule=None,
                 end_schedule=None, cron_expression=None, create_cluster=None, cluster_id=None, host_name=None, namespace=None,
                 application=None, alert_conf=None, alert_user_group_biz_id=None, alert_ding_ding_group_biz_id=None,
                 parent_flow_list=None, parent_category=None, client_token=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.start_schedule = start_schedule  # type: long
        self.end_schedule = end_schedule  # type: long
        self.cron_expression = cron_expression  # type: str
        self.create_cluster = create_cluster  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.host_name = host_name  # type: str
        self.namespace = namespace  # type: str
        self.application = application  # type: str
        self.alert_conf = alert_conf  # type: str
        self.alert_user_group_biz_id = alert_user_group_biz_id  # type: str
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id  # type: str
        self.parent_flow_list = parent_flow_list  # type: str
        self.parent_category = parent_category  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.application is not None:
            result['Application'] = self.application
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateFlowResponseBody(TeaModel):
    def __init__(self, id=None, request_id=None):
        self.id = id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, type=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListUsersResponseBodyUserListUser(TeaModel):
    def __init__(self, linux_status=None, k_8s_status=None, knox_status=None, group_name=None, user_id=None,
                 kerberos_status=None, user_name=None):
        self.linux_status = linux_status  # type: str
        self.k_8s_status = k_8s_status  # type: str
        self.knox_status = knox_status  # type: str
        self.group_name = group_name  # type: str
        self.user_id = user_id  # type: str
        self.kerberos_status = kerberos_status  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersResponseBodyUserListUser, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.linux_status is not None:
            result['LinuxStatus'] = self.linux_status
        if self.k_8s_status is not None:
            result['K8sStatus'] = self.k_8s_status
        if self.knox_status is not None:
            result['KnoxStatus'] = self.knox_status
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.kerberos_status is not None:
            result['KerberosStatus'] = self.kerberos_status
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LinuxStatus') is not None:
            self.linux_status = m.get('LinuxStatus')
        if m.get('K8sStatus') is not None:
            self.k_8s_status = m.get('K8sStatus')
        if m.get('KnoxStatus') is not None:
            self.knox_status = m.get('KnoxStatus')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('KerberosStatus') is not None:
            self.kerberos_status = m.get('KerberosStatus')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ListUsersResponseBodyUserList(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[ListUsersResponseBodyUserListUser]

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUsersResponseBodyUserList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = ListUsersResponseBodyUserListUser()
                self.user.append(temp_model.from_map(k))
        return self


class ListUsersResponseBody(TeaModel):
    def __init__(self, request_id=None, user_list=None):
        self.request_id = request_id  # type: str
        self.user_list = user_list  # type: ListUsersResponseBodyUserList

    def validate(self):
        if self.user_list:
            self.user_list.validate()

    def to_map(self):
        _map = super(ListUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserList') is not None:
            temp_model = ListUsersResponseBodyUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        return self


class ListUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowProjectRequest(TeaModel):
    def __init__(self, project_id=None, region_id=None, name=None, description=None):
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class ModifyFlowProjectResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowProjectResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyFlowProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyFlowProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryKnoxUserPasswordRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, user_id=None, owner_id=None, cluster_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.user_id = user_id  # type: str
        self.owner_id = owner_id  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryKnoxUserPasswordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class QueryKnoxUserPasswordResponseBodyUserInfoListUserInfo(TeaModel):
    def __init__(self, password=None, user_name=None, user_id=None):
        self.password = password  # type: str
        self.user_name = user_name  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryKnoxUserPasswordResponseBodyUserInfoListUserInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class QueryKnoxUserPasswordResponseBodyUserInfoList(TeaModel):
    def __init__(self, user_info=None):
        self.user_info = user_info  # type: list[QueryKnoxUserPasswordResponseBodyUserInfoListUserInfo]

    def validate(self):
        if self.user_info:
            for k in self.user_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryKnoxUserPasswordResponseBodyUserInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UserInfo'] = []
        if self.user_info is not None:
            for k in self.user_info:
                result['UserInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user_info = []
        if m.get('UserInfo') is not None:
            for k in m.get('UserInfo'):
                temp_model = QueryKnoxUserPasswordResponseBodyUserInfoListUserInfo()
                self.user_info.append(temp_model.from_map(k))
        return self


class QueryKnoxUserPasswordResponseBody(TeaModel):
    def __init__(self, request_id=None, user_info_list=None):
        self.request_id = request_id  # type: str
        self.user_info_list = user_info_list  # type: QueryKnoxUserPasswordResponseBodyUserInfoList

    def validate(self):
        if self.user_info_list:
            self.user_info_list.validate()

    def to_map(self):
        _map = super(QueryKnoxUserPasswordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_info_list is not None:
            result['UserInfoList'] = self.user_info_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserInfoList') is not None:
            temp_model = QueryKnoxUserPasswordResponseBodyUserInfoList()
            self.user_info_list = temp_model.from_map(m['UserInfoList'])
        return self


class QueryKnoxUserPasswordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryKnoxUserPasswordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryKnoxUserPasswordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryKnoxUserPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceLauncherLogRequest(TeaModel):
    def __init__(self, start=None, lines=None, offset=None, length=None, reverse=None, start_time=None, end_time=None,
                 node_instance_id=None, project_id=None, region_id=None):
        self.start = start  # type: int
        self.lines = lines  # type: int
        self.offset = offset  # type: int
        self.length = length  # type: int
        self.reverse = reverse  # type: bool
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.node_instance_id = node_instance_id  # type: str
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceLauncherLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.lines is not None:
            result['Lines'] = self.lines
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.reverse is not None:
            result['Reverse'] = self.reverse
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Lines') is not None:
            self.lines = m.get('Lines')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('Reverse') is not None:
            self.reverse = m.get('Reverse')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry(TeaModel):
    def __init__(self, content=None):
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys(TeaModel):
    def __init__(self, log_entry=None):
        self.log_entry = log_entry  # type: list[DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry]

    def validate(self):
        if self.log_entry:
            for k in self.log_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogEntry'] = []
        if self.log_entry is not None:
            for k in self.log_entry:
                result['LogEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.log_entry = []
        if m.get('LogEntry') is not None:
            for k in m.get('LogEntry'):
                temp_model = DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry()
                self.log_entry.append(temp_model.from_map(k))
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBody(TeaModel):
    def __init__(self, log_end=None, request_id=None, log_entrys=None):
        self.log_end = log_end  # type: bool
        self.request_id = request_id  # type: str
        self.log_entrys = log_entrys  # type: DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys

    def validate(self):
        if self.log_entrys:
            self.log_entrys.validate()

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceLauncherLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_end is not None:
            result['LogEnd'] = self.log_end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_entrys is not None:
            result['LogEntrys'] = self.log_entrys.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogEnd') is not None:
            self.log_end = m.get('LogEnd')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogEntrys') is not None:
            temp_model = DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys()
            self.log_entrys = temp_model.from_map(m['LogEntrys'])
        return self


class DescribeFlowNodeInstanceLauncherLogResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowNodeInstanceLauncherLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceLauncherLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceLauncherLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, job_id=None, name=None, id=None, cluster_id=None, status=None,
                 periodic=None, page_number=None, page_size=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.job_id = job_id  # type: str
        self.name = name  # type: str
        self.id = id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.status = status  # type: str
        self.periodic = periodic  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.status is not None:
            result['Status'] = self.status
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFlowResponseBodyFlowFlow(TeaModel):
    def __init__(self, status=None, type=None, alert_user_group_biz_id=None, periodic=None, project_id=None,
                 host_name=None, gmt_modified=None, description=None, create_cluster=None, start_schedule=None,
                 end_schedule=None, graph=None, alert_ding_ding_group_biz_id=None, gmt_create=None, category_id=None,
                 cron_expr=None, name=None, id=None, alert_conf=None, cluster_id=None):
        self.status = status  # type: str
        self.type = type  # type: str
        self.alert_user_group_biz_id = alert_user_group_biz_id  # type: str
        self.periodic = periodic  # type: bool
        self.project_id = project_id  # type: str
        self.host_name = host_name  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.description = description  # type: str
        self.create_cluster = create_cluster  # type: bool
        self.start_schedule = start_schedule  # type: long
        self.end_schedule = end_schedule  # type: long
        self.graph = graph  # type: str
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.category_id = category_id  # type: str
        self.cron_expr = cron_expr  # type: str
        self.name = name  # type: str
        self.id = id  # type: str
        self.alert_conf = alert_conf  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowResponseBodyFlowFlow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.description is not None:
            result['Description'] = self.description
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ListFlowResponseBodyFlow(TeaModel):
    def __init__(self, flow=None):
        self.flow = flow  # type: list[ListFlowResponseBodyFlowFlow]

    def validate(self):
        if self.flow:
            for k in self.flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowResponseBodyFlow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Flow'] = []
        if self.flow is not None:
            for k in self.flow:
                result['Flow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.flow = []
        if m.get('Flow') is not None:
            for k in m.get('Flow'):
                temp_model = ListFlowResponseBodyFlowFlow()
                self.flow.append(temp_model.from_map(k))
        return self


class ListFlowResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total=None, flow=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.flow = flow  # type: ListFlowResponseBodyFlow

    def validate(self):
        if self.flow:
            self.flow.validate()

    def to_map(self):
        _map = super(ListFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.flow is not None:
            result['Flow'] = self.flow.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Flow') is not None:
            temp_model = ListFlowResponseBodyFlow()
            self.flow = temp_model.from_map(m['Flow'])
        return self


class ListFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UntagResourcesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, resource_type=None,
                 resource_ids=None, tag_keys=None, all=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        # 资源类型
        self.resource_type = resource_type  # type: str
        # 集群ID列表
        self.resource_ids = resource_ids  # type: list[str]
        # 解绑的标签键列表
        self.tag_keys = tag_keys  # type: list[str]
        # 是否解绑资源的所有标签
        self.all = all  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(UntagResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys
        if self.all is not None:
            result['All'] = self.all
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        if m.get('TagKeys') is not None:
            self.tag_keys = m.get('TagKeys')
        if m.get('All') is not None:
            self.all = m.get('All')
        return self


class UntagResourcesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_code=None, message=None):
        # Id of the request
        self.request_id = request_id  # type: str
        # 请求是否成功被处理
        self.success = success  # type: bool
        # 响应码
        self.code = code  # type: str
        # 错误码
        self.error_code = error_code  # type: str
        # 响应消息
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UntagResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class UntagResourcesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: UntagResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(UntagResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UntagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterHostRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, cluster_id=None, resource_group_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterHostRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterHostResponseBodyHostListHost(TeaModel):
    def __init__(self, status=None, type=None, serial_number=None, private_ip=None, host_name=None,
                 instance_type=None, host_id=None, host_instance_id=None, cpu=None, public_ip=None, memory=None, role=None):
        self.status = status  # type: str
        self.type = type  # type: str
        self.serial_number = serial_number  # type: str
        self.private_ip = private_ip  # type: str
        self.host_name = host_name  # type: str
        self.instance_type = instance_type  # type: str
        self.host_id = host_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.cpu = cpu  # type: int
        self.public_ip = public_ip  # type: str
        self.memory = memory  # type: int
        self.role = role  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterHostResponseBodyHostListHost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class ListFlowClusterHostResponseBodyHostList(TeaModel):
    def __init__(self, host=None):
        self.host = host  # type: list[ListFlowClusterHostResponseBodyHostListHost]

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowClusterHostResponseBodyHostList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = ListFlowClusterHostResponseBodyHostListHost()
                self.host.append(temp_model.from_map(k))
        return self


class ListFlowClusterHostResponseBody(TeaModel):
    def __init__(self, request_id=None, host_list=None):
        self.request_id = request_id  # type: str
        self.host_list = host_list  # type: ListFlowClusterHostResponseBodyHostList

    def validate(self):
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super(ListFlowClusterHostResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HostList') is not None:
            temp_model = ListFlowClusterHostResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListFlowClusterHostResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowClusterHostResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowClusterHostResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, service_name=None, status=None,
                 page_number=None, page_size=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.service_name = service_name  # type: str
        self.status = status  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterOperationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationResponseBodyClusterOperationListClusterOperation(TeaModel):
    def __init__(self, status=None, start_time=None, comment=None, operation_name=None, operation_id=None,
                 duration=None, percentage=None):
        self.status = status  # type: str
        self.start_time = start_time  # type: str
        self.comment = comment  # type: str
        self.operation_name = operation_name  # type: str
        self.operation_id = operation_id  # type: str
        self.duration = duration  # type: str
        self.percentage = percentage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterOperationResponseBodyClusterOperationListClusterOperation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.operation_name is not None:
            result['OperationName'] = self.operation_name
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OperationName') is not None:
            self.operation_name = m.get('OperationName')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        return self


class ListClusterOperationResponseBodyClusterOperationList(TeaModel):
    def __init__(self, cluster_operation=None):
        self.cluster_operation = cluster_operation  # type: list[ListClusterOperationResponseBodyClusterOperationListClusterOperation]

    def validate(self):
        if self.cluster_operation:
            for k in self.cluster_operation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterOperationResponseBodyClusterOperationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperation'] = []
        if self.cluster_operation is not None:
            for k in self.cluster_operation:
                result['ClusterOperation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_operation = []
        if m.get('ClusterOperation') is not None:
            for k in m.get('ClusterOperation'):
                temp_model = ListClusterOperationResponseBodyClusterOperationListClusterOperation()
                self.cluster_operation.append(temp_model.from_map(k))
        return self


class ListClusterOperationResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None,
                 cluster_operation_list=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.cluster_operation_list = cluster_operation_list  # type: ListClusterOperationResponseBodyClusterOperationList

    def validate(self):
        if self.cluster_operation_list:
            self.cluster_operation_list.validate()

    def to_map(self):
        _map = super(ListClusterOperationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.cluster_operation_list is not None:
            result['ClusterOperationList'] = self.cluster_operation_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ClusterOperationList') is not None:
            temp_model = ListClusterOperationResponseBodyClusterOperationList()
            self.cluster_operation_list = temp_model.from_map(m['ClusterOperationList'])
        return self


class ListClusterOperationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterOperationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterOperationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowEntitySnapshotRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, limit=None, page_number=None, page_size=None,
                 current_size=None, page_count=None, order_field=None, order_mode=None, committer_id=None, entity_type=None,
                 entity_group_id=None, entity_id=None, revision=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.limit = limit  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.current_size = current_size  # type: int
        self.page_count = page_count  # type: int
        self.order_field = order_field  # type: str
        self.order_mode = order_mode  # type: str
        self.committer_id = committer_id  # type: str
        self.entity_type = entity_type  # type: str
        self.entity_group_id = entity_group_id  # type: str
        self.entity_id = entity_id  # type: str
        self.revision = revision  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowEntitySnapshotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.committer_id is not None:
            result['CommitterId'] = self.committer_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.entity_group_id is not None:
            result['EntityGroupId'] = self.entity_group_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.revision is not None:
            result['Revision'] = self.revision
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('CommitterId') is not None:
            self.committer_id = m.get('CommitterId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('EntityGroupId') is not None:
            self.entity_group_id = m.get('EntityGroupId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Revision') is not None:
            self.revision = m.get('Revision')
        return self


class ListFlowEntitySnapshotResponseBodyItemsItem(TeaModel):
    def __init__(self, active=None, data=None, entity_id=None, entity_type=None, user_id=None, gmt_create=None,
                 message=None, entity_group_id=None, committer_id=None, revision=None):
        self.active = active  # type: bool
        self.data = data  # type: str
        self.entity_id = entity_id  # type: str
        self.entity_type = entity_type  # type: str
        self.user_id = user_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.message = message  # type: str
        self.entity_group_id = entity_group_id  # type: str
        self.committer_id = committer_id  # type: str
        self.revision = revision  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowEntitySnapshotResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.data is not None:
            result['Data'] = self.data
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.message is not None:
            result['Message'] = self.message
        if self.entity_group_id is not None:
            result['EntityGroupId'] = self.entity_group_id
        if self.committer_id is not None:
            result['CommitterId'] = self.committer_id
        if self.revision is not None:
            result['Revision'] = self.revision
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('EntityGroupId') is not None:
            self.entity_group_id = m.get('EntityGroupId')
        if m.get('CommitterId') is not None:
            self.committer_id = m.get('CommitterId')
        if m.get('Revision') is not None:
            self.revision = m.get('Revision')
        return self


class ListFlowEntitySnapshotResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[ListFlowEntitySnapshotResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowEntitySnapshotResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListFlowEntitySnapshotResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListFlowEntitySnapshotResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None, items=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.items = items  # type: ListFlowEntitySnapshotResponseBodyItems

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(ListFlowEntitySnapshotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListFlowEntitySnapshotResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListFlowEntitySnapshotResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowEntitySnapshotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowEntitySnapshotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowEntitySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClusterTemplateRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, biz_id=None, resource_group_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.biz_id = biz_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteClusterTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DeleteClusterTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteClusterTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteClusterTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteClusterTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteClusterTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOrderRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CancelOrderResponseBody(TeaModel):
    def __init__(self, cluster_id=None, request_id=None):
        self.cluster_id = cluster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelOrderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CancelOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneFlowJobRequest(TeaModel):
    def __init__(self, project_id=None, id=None, name=None, region_id=None):
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneFlowJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CloneFlowJobResponseBody(TeaModel):
    def __init__(self, id=None, request_id=None):
        self.id = id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneFlowJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneFlowJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CloneFlowJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloneFlowJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, flow_instance_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.flow_instance_id = flow_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        return self


class StartFlowResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class StartFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StartFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StartFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowJobRequestResourceList(TeaModel):
    def __init__(self, path=None, alias=None):
        self.path = path  # type: str
        self.alias = alias  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowJobRequestResourceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class CreateFlowJobRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, name=None, description=None, type=None, fail_act=None,
                 retry_policy=None, params=None, param_conf=None, custom_variables=None, env_conf=None, run_conf=None,
                 monitor_conf=None, mode=None, parent_category=None, adhoc=None, cluster_id=None, alert_conf=None,
                 client_token=None, resource_list=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.type = type  # type: str
        self.fail_act = fail_act  # type: str
        self.retry_policy = retry_policy  # type: str
        self.params = params  # type: str
        self.param_conf = param_conf  # type: str
        self.custom_variables = custom_variables  # type: str
        self.env_conf = env_conf  # type: str
        self.run_conf = run_conf  # type: str
        self.monitor_conf = monitor_conf  # type: str
        self.mode = mode  # type: str
        self.parent_category = parent_category  # type: str
        self.adhoc = adhoc  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.alert_conf = alert_conf  # type: str
        self.client_token = client_token  # type: str
        self.resource_list = resource_list  # type: list[CreateFlowJobRequestResourceList]

    def validate(self):
        if self.resource_list:
            for k in self.resource_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateFlowJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.params is not None:
            result['Params'] = self.params
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['ResourceList'] = []
        if self.resource_list is not None:
            for k in self.resource_list:
                result['ResourceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.resource_list = []
        if m.get('ResourceList') is not None:
            for k in m.get('ResourceList'):
                temp_model = CreateFlowJobRequestResourceList()
                self.resource_list.append(temp_model.from_map(k))
        return self


class CreateFlowJobResponseBody(TeaModel):
    def __init__(self, id=None, request_id=None):
        self.id = id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFlowJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowCategoryRequest(TeaModel):
    def __init__(self, id=None, region_id=None, project_id=None):
        self.id = id  # type: str
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteFlowCategoryResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFlowCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFlowCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowEditLockRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, entity_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.entity_id = entity_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowEditLockRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class DeleteFlowEditLockResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowEditLockResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowEditLockResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFlowEditLockResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFlowEditLockResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowEditLockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResizeClusterRequestHostComponentInfo(TeaModel):
    def __init__(self, component_name_list=None, host_name=None, service_name=None):
        self.component_name_list = component_name_list  # type: list[str]
        self.host_name = host_name  # type: str
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResizeClusterRequestHostComponentInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name_list is not None:
            result['ComponentNameList'] = self.component_name_list
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComponentNameList') is not None:
            self.component_name_list = m.get('ComponentNameList')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ResizeClusterRequestHostGroup(TeaModel):
    def __init__(self, sys_disk_capacity=None, host_group_type=None, comment=None, vswitch_id=None,
                 sys_disk_type=None, auto_renew=None, charge_type=None, disk_type=None, host_group_id=None, instance_type=None,
                 host_key_pair_name=None, disk_count=None, create_type=None, period=None, host_password=None, disk_capacity=None,
                 node_count=None, host_group_name=None, cluster_id=None):
        self.sys_disk_capacity = sys_disk_capacity  # type: int
        self.host_group_type = host_group_type  # type: str
        self.comment = comment  # type: str
        self.vswitch_id = vswitch_id  # type: int
        self.sys_disk_type = sys_disk_type  # type: str
        self.auto_renew = auto_renew  # type: bool
        self.charge_type = charge_type  # type: str
        self.disk_type = disk_type  # type: str
        self.host_group_id = host_group_id  # type: str
        self.instance_type = instance_type  # type: str
        self.host_key_pair_name = host_key_pair_name  # type: str
        self.disk_count = disk_count  # type: int
        self.create_type = create_type  # type: str
        self.period = period  # type: int
        self.host_password = host_password  # type: str
        self.disk_capacity = disk_capacity  # type: int
        self.node_count = node_count  # type: int
        self.host_group_name = host_group_name  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResizeClusterRequestHostGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_key_pair_name is not None:
            result['HostKeyPairName'] = self.host_key_pair_name
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.host_password is not None:
            result['HostPassword'] = self.host_password
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostKeyPairName') is not None:
            self.host_key_pair_name = m.get('HostKeyPairName')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('HostPassword') is not None:
            self.host_password = m.get('HostPassword')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ResizeClusterRequestPromotionInfo(TeaModel):
    def __init__(self, promotion_option_no=None, promotion_option_code=None, product_code=None):
        self.promotion_option_no = promotion_option_no  # type: str
        self.promotion_option_code = promotion_option_code  # type: str
        self.product_code = product_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResizeClusterRequestPromotionInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.promotion_option_no is not None:
            result['PromotionOptionNo'] = self.promotion_option_no
        if self.promotion_option_code is not None:
            result['PromotionOptionCode'] = self.promotion_option_code
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PromotionOptionNo') is not None:
            self.promotion_option_no = m.get('PromotionOptionNo')
        if m.get('PromotionOptionCode') is not None:
            self.promotion_option_code = m.get('PromotionOptionCode')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class ResizeClusterRequest(TeaModel):
    def __init__(self, region_id=None, cluster_id=None, auto_pay_order=None, vswitch_id=None,
                 is_open_public_ip=None, host_component_info=None, host_group=None, promotion_info=None):
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.auto_pay_order = auto_pay_order  # type: bool
        self.vswitch_id = vswitch_id  # type: str
        self.is_open_public_ip = is_open_public_ip  # type: bool
        self.host_component_info = host_component_info  # type: list[ResizeClusterRequestHostComponentInfo]
        self.host_group = host_group  # type: list[ResizeClusterRequestHostGroup]
        self.promotion_info = promotion_info  # type: list[ResizeClusterRequestPromotionInfo]

    def validate(self):
        if self.host_component_info:
            for k in self.host_component_info:
                if k:
                    k.validate()
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.promotion_info:
            for k in self.promotion_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ResizeClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.auto_pay_order is not None:
            result['AutoPayOrder'] = self.auto_pay_order
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        result['HostComponentInfo'] = []
        if self.host_component_info is not None:
            for k in self.host_component_info:
                result['HostComponentInfo'].append(k.to_map() if k else None)
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['PromotionInfo'] = []
        if self.promotion_info is not None:
            for k in self.promotion_info:
                result['PromotionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AutoPayOrder') is not None:
            self.auto_pay_order = m.get('AutoPayOrder')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        self.host_component_info = []
        if m.get('HostComponentInfo') is not None:
            for k in m.get('HostComponentInfo'):
                temp_model = ResizeClusterRequestHostComponentInfo()
                self.host_component_info.append(temp_model.from_map(k))
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ResizeClusterRequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.promotion_info = []
        if m.get('PromotionInfo') is not None:
            for k in m.get('PromotionInfo'):
                temp_model = ResizeClusterRequestPromotionInfo()
                self.promotion_info.append(temp_model.from_map(k))
        return self


class ResizeClusterResponseBody(TeaModel):
    def __init__(self, request_id=None, cluster_id=None):
        self.request_id = request_id  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResizeClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ResizeClusterResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ResizeClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ResizeClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResizeClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetaTablePreviewTaskRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, task_id=None, resource_group_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns(TeaModel):
    def __init__(self, column=None):
        self.column = column  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column is not None:
            result['Column'] = self.column
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Column') is not None:
            self.column = m.get('Column')
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRowsRow(TeaModel):
    def __init__(self, columns=None):
        self.columns = columns  # type: DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns

    def validate(self):
        if self.columns:
            self.columns.validate()

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskResponseBodyDataRowsRow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.columns is not None:
            result['Columns'] = self.columns.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Columns') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns()
            self.columns = temp_model.from_map(m['Columns'])
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRows(TeaModel):
    def __init__(self, row=None):
        self.row = row  # type: list[DescribeMetaTablePreviewTaskResponseBodyDataRowsRow]

    def validate(self):
        if self.row:
            for k in self.row:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskResponseBodyDataRows, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Row'] = []
        if self.row is not None:
            for k in self.row:
                result['Row'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.row = []
        if m.get('Row') is not None:
            for k in m.get('Row'):
                temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRowsRow()
                self.row.append(temp_model.from_map(k))
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataHeaders(TeaModel):
    def __init__(self, header=None):
        self.header = header  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskResponseBodyDataHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header is not None:
            result['Header'] = self.header
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Header') is not None:
            self.header = m.get('Header')
        return self


class DescribeMetaTablePreviewTaskResponseBodyData(TeaModel):
    def __init__(self, rows=None, headers=None):
        self.rows = rows  # type: DescribeMetaTablePreviewTaskResponseBodyDataRows
        self.headers = headers  # type: DescribeMetaTablePreviewTaskResponseBodyDataHeaders

    def validate(self):
        if self.rows:
            self.rows.validate()
        if self.headers:
            self.headers.validate()

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rows is not None:
            result['Rows'] = self.rows.to_map()
        if self.headers is not None:
            result['Headers'] = self.headers.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Rows') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRows()
            self.rows = temp_model.from_map(m['Rows'])
        if m.get('Headers') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataHeaders()
            self.headers = temp_model.from_map(m['Headers'])
        return self


class DescribeMetaTablePreviewTaskResponseBody(TeaModel):
    def __init__(self, end_time=None, start_time=None, request_id=None, task_status=None, task_process=None,
                 execute_time=None, task_id=None, data=None):
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.request_id = request_id  # type: str
        self.task_status = task_status  # type: str
        self.task_process = task_process  # type: int
        self.execute_time = execute_time  # type: long
        self.task_id = task_id  # type: str
        self.data = data  # type: DescribeMetaTablePreviewTaskResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_process is not None:
            result['TaskProcess'] = self.task_process
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskProcess') is not None:
            self.task_process = m.get('TaskProcess')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Data') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DescribeMetaTablePreviewTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeMetaTablePreviewTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetaTablePreviewTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterServiceConfigHistoryRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, service_name=None,
                 config_version=None, host_group_id=None, host_instance_id=None, config_file_name=None, config_item_key=None,
                 author=None, comment=None, page_number=None, page_size=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.service_name = service_name  # type: str
        self.config_version = config_version  # type: str
        self.host_group_id = host_group_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.config_file_name = config_file_name  # type: str
        self.config_item_key = config_item_key  # type: str
        self.author = author  # type: str
        self.comment = comment  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterServiceConfigHistoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_file_name is not None:
            result['ConfigFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['ConfigItemKey'] = self.config_item_key
        if self.author is not None:
            result['Author'] = self.author
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigFileName') is not None:
            self.config_file_name = m.get('ConfigFileName')
        if m.get('ConfigItemKey') is not None:
            self.config_item_key = m.get('ConfigItemKey')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory(TeaModel):
    def __init__(self, old_value=None, comment=None, create_time=None, host_name=None, author=None,
                 config_item_name=None, host_group_id=None, new_value=None, host_instance_id=None, config_file_name=None,
                 applied=None, config_version=None, service_name=None, host_group_name=None):
        self.old_value = old_value  # type: str
        self.comment = comment  # type: str
        self.create_time = create_time  # type: long
        self.host_name = host_name  # type: str
        self.author = author  # type: str
        self.config_item_name = config_item_name  # type: str
        self.host_group_id = host_group_id  # type: str
        self.new_value = new_value  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.config_file_name = config_file_name  # type: str
        self.applied = applied  # type: bool
        self.config_version = config_version  # type: str
        self.service_name = service_name  # type: str
        self.host_group_name = host_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.old_value is not None:
            result['OldValue'] = self.old_value
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.author is not None:
            result['Author'] = self.author
        if self.config_item_name is not None:
            result['ConfigItemName'] = self.config_item_name
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.new_value is not None:
            result['NewValue'] = self.new_value
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_file_name is not None:
            result['ConfigFileName'] = self.config_file_name
        if self.applied is not None:
            result['Applied'] = self.applied
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OldValue') is not None:
            self.old_value = m.get('OldValue')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('ConfigItemName') is not None:
            self.config_item_name = m.get('ConfigItemName')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('NewValue') is not None:
            self.new_value = m.get('NewValue')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigFileName') is not None:
            self.config_file_name = m.get('ConfigFileName')
        if m.get('Applied') is not None:
            self.applied = m.get('Applied')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListClusterServiceConfigHistoryResponseBodyConfigHistoryList(TeaModel):
    def __init__(self, config_history=None):
        self.config_history = config_history  # type: list[ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory]

    def validate(self):
        if self.config_history:
            for k in self.config_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterServiceConfigHistoryResponseBodyConfigHistoryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigHistory'] = []
        if self.config_history is not None:
            for k in self.config_history:
                result['ConfigHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config_history = []
        if m.get('ConfigHistory') is not None:
            for k in m.get('ConfigHistory'):
                temp_model = ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory()
                self.config_history.append(temp_model.from_map(k))
        return self


class ListClusterServiceConfigHistoryResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None,
                 config_history_list=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.config_history_list = config_history_list  # type: ListClusterServiceConfigHistoryResponseBodyConfigHistoryList

    def validate(self):
        if self.config_history_list:
            self.config_history_list.validate()

    def to_map(self):
        _map = super(ListClusterServiceConfigHistoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.config_history_list is not None:
            result['ConfigHistoryList'] = self.config_history_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ConfigHistoryList') is not None:
            temp_model = ListClusterServiceConfigHistoryResponseBodyConfigHistoryList()
            self.config_history_list = temp_model.from_map(m['ConfigHistoryList'])
        return self


class ListClusterServiceConfigHistoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterServiceConfigHistoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterServiceConfigHistoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterServiceConfigHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyScalingConfigItemRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None,
                 config_item_information=None, config_item_type=None, config_item_biz_id=None, scaling_group_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.config_item_information = config_item_information  # type: str
        self.config_item_type = config_item_type  # type: str
        self.config_item_biz_id = config_item_biz_id  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyScalingConfigItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['resourceGroupId'] = self.resource_group_id
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.config_item_biz_id is not None:
            result['ConfigItemBizId'] = self.config_item_biz_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('resourceGroupId') is not None:
            self.resource_group_id = m.get('resourceGroupId')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ConfigItemBizId') is not None:
            self.config_item_biz_id = m.get('ConfigItemBizId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        return self


class ModifyScalingConfigItemResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        # requestId
        self.request_id = request_id  # type: str
        # data
        self.data = data  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyScalingConfigItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ModifyScalingConfigItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyScalingConfigItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyScalingConfigItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterAllRequest(TeaModel):
    def __init__(self, product_type=None, region_id=None, resource_group_id=None):
        self.product_type = product_type  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterAllRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterAllResponseBodyClustersClusterInfoOrderTaskInfo(TeaModel):
    def __init__(self, target_count=None, current_count=None, order_id_list=None):
        self.target_count = target_count  # type: int
        self.current_count = current_count  # type: int
        self.order_id_list = order_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterAllResponseBodyClustersClusterInfoOrderTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_count is not None:
            result['TargetCount'] = self.target_count
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.order_id_list is not None:
            result['OrderIdList'] = self.order_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetCount') is not None:
            self.target_count = m.get('TargetCount')
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('OrderIdList') is not None:
            self.order_id_list = m.get('OrderIdList')
        return self


class ListFlowClusterAllResponseBodyClustersClusterInfoFailReason(TeaModel):
    def __init__(self, error_msg=None, request_id=None, error_code=None):
        self.error_msg = error_msg  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterAllResponseBodyClustersClusterInfoFailReason, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class ListFlowClusterAllResponseBodyClustersClusterInfo(TeaModel):
    def __init__(self, type=None, status=None, running_time=None, order_list=None, create_time=None,
                 charge_type=None, period=None, k_8s_cluster_id=None, expired_time=None, has_uncompleted_order=None, name=None,
                 id=None, create_resource=None, order_task_info=None, fail_reason=None):
        self.type = type  # type: str
        self.status = status  # type: str
        self.running_time = running_time  # type: int
        self.order_list = order_list  # type: str
        self.create_time = create_time  # type: long
        self.charge_type = charge_type  # type: str
        self.period = period  # type: int
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.expired_time = expired_time  # type: long
        self.has_uncompleted_order = has_uncompleted_order  # type: bool
        self.name = name  # type: str
        self.id = id  # type: str
        self.create_resource = create_resource  # type: str
        self.order_task_info = order_task_info  # type: ListFlowClusterAllResponseBodyClustersClusterInfoOrderTaskInfo
        self.fail_reason = fail_reason  # type: ListFlowClusterAllResponseBodyClustersClusterInfoFailReason

    def validate(self):
        if self.order_task_info:
            self.order_task_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super(ListFlowClusterAllResponseBodyClustersClusterInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.order_list is not None:
            result['OrderList'] = self.order_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.has_uncompleted_order is not None:
            result['HasUncompletedOrder'] = self.has_uncompleted_order
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.order_task_info is not None:
            result['OrderTaskInfo'] = self.order_task_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('OrderList') is not None:
            self.order_list = m.get('OrderList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('HasUncompletedOrder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('OrderTaskInfo') is not None:
            temp_model = ListFlowClusterAllResponseBodyClustersClusterInfoOrderTaskInfo()
            self.order_task_info = temp_model.from_map(m['OrderTaskInfo'])
        if m.get('FailReason') is not None:
            temp_model = ListFlowClusterAllResponseBodyClustersClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        return self


class ListFlowClusterAllResponseBodyClusters(TeaModel):
    def __init__(self, cluster_info=None):
        self.cluster_info = cluster_info  # type: list[ListFlowClusterAllResponseBodyClustersClusterInfo]

    def validate(self):
        if self.cluster_info:
            for k in self.cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowClusterAllResponseBodyClusters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInfo'] = []
        if self.cluster_info is not None:
            for k in self.cluster_info:
                result['ClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_info = []
        if m.get('ClusterInfo') is not None:
            for k in m.get('ClusterInfo'):
                temp_model = ListFlowClusterAllResponseBodyClustersClusterInfo()
                self.cluster_info.append(temp_model.from_map(k))
        return self


class ListFlowClusterAllResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None, clusters=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.clusters = clusters  # type: ListFlowClusterAllResponseBodyClusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super(ListFlowClusterAllResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Clusters') is not None:
            temp_model = ListFlowClusterAllResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class ListFlowClusterAllResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowClusterAllResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowClusterAllResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterAllResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingGroupRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, scaling_group_biz_id=None, host_group_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.host_group_biz_id = host_group_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        return self


class DescribeScalingGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, scaling_group_id=None, name=None, description=None, active_status=None,
                 host_group_biz_id=None, scaling_in_mode=None, scaling_min_size=None, scaling_max_size=None, config_state=None):
        # Id of the request
        self.request_id = request_id  # type: str
        self.scaling_group_id = scaling_group_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.active_status = active_status  # type: str
        self.host_group_biz_id = host_group_biz_id  # type: str
        self.scaling_in_mode = scaling_in_mode  # type: str
        self.scaling_min_size = scaling_min_size  # type: long
        self.scaling_max_size = scaling_max_size  # type: long
        self.config_state = config_state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.active_status is not None:
            result['ActiveStatus'] = self.active_status
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        if self.scaling_in_mode is not None:
            result['ScalingInMode'] = self.scaling_in_mode
        if self.scaling_min_size is not None:
            result['ScalingMinSize'] = self.scaling_min_size
        if self.scaling_max_size is not None:
            result['ScalingMaxSize'] = self.scaling_max_size
        if self.config_state is not None:
            result['ConfigState'] = self.config_state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ActiveStatus') is not None:
            self.active_status = m.get('ActiveStatus')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        if m.get('ScalingInMode') is not None:
            self.scaling_in_mode = m.get('ScalingInMode')
        if m.get('ScalingMinSize') is not None:
            self.scaling_min_size = m.get('ScalingMinSize')
        if m.get('ScalingMaxSize') is not None:
            self.scaling_max_size = m.get('ScalingMaxSize')
        if m.get('ConfigState') is not None:
            self.config_state = m.get('ConfigState')
        return self


class DescribeScalingGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeScalingGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeScalingGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScalingGroupRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, limit=None, page_number=None,
                 page_size=None, current_size=None, page_count=None, order_field=None, order_mode=None, cluster_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.limit = limit  # type: long
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.current_size = current_size  # type: long
        self.page_count = page_count  # type: long
        self.order_field = order_field  # type: str
        self.order_mode = order_mode  # type: str
        self.cluster_biz_id = cluster_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListScalingGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.limit is not None:
            result['limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        return self


class ListScalingGroupResponseBodyItemsItem(TeaModel):
    def __init__(self, scaling_group_id=None, name=None, description=None, active_status=None,
                 host_group_biz_id=None, scaling_in_mode=None, scaling_min_size=None, scaling_max_size=None):
        self.scaling_group_id = scaling_group_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.active_status = active_status  # type: str
        self.host_group_biz_id = host_group_biz_id  # type: str
        self.scaling_in_mode = scaling_in_mode  # type: str
        self.scaling_min_size = scaling_min_size  # type: str
        self.scaling_max_size = scaling_max_size  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListScalingGroupResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.active_status is not None:
            result['ActiveStatus'] = self.active_status
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        if self.scaling_in_mode is not None:
            result['ScalingInMode'] = self.scaling_in_mode
        if self.scaling_min_size is not None:
            result['ScalingMinSize'] = self.scaling_min_size
        if self.scaling_max_size is not None:
            result['ScalingMaxSize'] = self.scaling_max_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ActiveStatus') is not None:
            self.active_status = m.get('ActiveStatus')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        if m.get('ScalingInMode') is not None:
            self.scaling_in_mode = m.get('ScalingInMode')
        if m.get('ScalingMinSize') is not None:
            self.scaling_min_size = m.get('ScalingMinSize')
        if m.get('ScalingMaxSize') is not None:
            self.scaling_max_size = m.get('ScalingMaxSize')
        return self


class ListScalingGroupResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[ListScalingGroupResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListScalingGroupResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListScalingGroupResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListScalingGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None, next_token=None,
                 items=None):
        # Id of the request
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long
        self.next_token = next_token  # type: str
        self.items = items  # type: ListScalingGroupResponseBodyItems

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(ListScalingGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            temp_model = ListScalingGroupResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListScalingGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListScalingGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListScalingGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowCategoryRequest(TeaModel):
    def __init__(self, project_id=None, region_id=None, id=None, name=None, parent_id=None):
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.parent_id = parent_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class ModifyFlowCategoryResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyFlowCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyFlowCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyClusterServiceConfigRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, service_name=None, comment=None,
                 config_params=None, custom_config_params=None, group_id=None, host_instance_id=None, config_type=None,
                 refresh_host_config=None, gateway_cluster_id_list=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.service_name = service_name  # type: str
        self.comment = comment  # type: str
        self.config_params = config_params  # type: str
        self.custom_config_params = custom_config_params  # type: str
        self.group_id = group_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.config_type = config_type  # type: str
        self.refresh_host_config = refresh_host_config  # type: bool
        self.gateway_cluster_id_list = gateway_cluster_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterServiceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.config_params is not None:
            result['ConfigParams'] = self.config_params
        if self.custom_config_params is not None:
            result['CustomConfigParams'] = self.custom_config_params
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_type is not None:
            result['ConfigType'] = self.config_type
        if self.refresh_host_config is not None:
            result['RefreshHostConfig'] = self.refresh_host_config
        if self.gateway_cluster_id_list is not None:
            result['GatewayClusterIdList'] = self.gateway_cluster_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ConfigParams') is not None:
            self.config_params = m.get('ConfigParams')
        if m.get('CustomConfigParams') is not None:
            self.custom_config_params = m.get('CustomConfigParams')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigType') is not None:
            self.config_type = m.get('ConfigType')
        if m.get('RefreshHostConfig') is not None:
            self.refresh_host_config = m.get('RefreshHostConfig')
        if m.get('GatewayClusterIdList') is not None:
            self.gateway_cluster_id_list = m.get('GatewayClusterIdList')
        return self


class ModifyClusterServiceConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterServiceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyClusterServiceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyClusterServiceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyClusterServiceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyClusterServiceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneFlowRequest(TeaModel):
    def __init__(self, project_id=None, id=None, region_id=None):
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CloneFlowResponseBody(TeaModel):
    def __init__(self, id=None, request_id=None):
        self.id = id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloneFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CloneFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloneFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterTemplateRequestHostGroup(TeaModel):
    def __init__(self, sys_disk_capacity=None, host_group_type=None, comment=None, multi_instance_types=None,
                 sys_disk_type=None, auto_renew=None, charge_type=None, disk_type=None, host_group_id=None, instance_type=None,
                 disk_count=None, create_type=None, period=None, disk_capacity=None, v_switch_id=None, node_count=None,
                 host_group_name=None, cluster_id=None):
        self.sys_disk_capacity = sys_disk_capacity  # type: int
        self.host_group_type = host_group_type  # type: str
        self.comment = comment  # type: str
        self.multi_instance_types = multi_instance_types  # type: str
        self.sys_disk_type = sys_disk_type  # type: str
        self.auto_renew = auto_renew  # type: bool
        self.charge_type = charge_type  # type: str
        self.disk_type = disk_type  # type: str
        self.host_group_id = host_group_id  # type: str
        self.instance_type = instance_type  # type: str
        self.disk_count = disk_count  # type: int
        self.create_type = create_type  # type: str
        self.period = period  # type: int
        self.disk_capacity = disk_capacity  # type: int
        self.v_switch_id = v_switch_id  # type: str
        self.node_count = node_count  # type: int
        self.host_group_name = host_group_name  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterTemplateRequestHostGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CreateClusterTemplateRequestBootstrapAction(TeaModel):
    def __init__(self, arg=None, path=None, name=None):
        self.arg = arg  # type: str
        self.path = path  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterTemplateRequestBootstrapAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateClusterTemplateRequestConfig(TeaModel):
    def __init__(self, config_value=None, replace=None, file_name=None, service_name=None, config_key=None,
                 encrypt=None):
        self.config_value = config_value  # type: str
        self.replace = replace  # type: str
        self.file_name = file_name  # type: str
        self.service_name = service_name  # type: str
        self.config_key = config_key  # type: str
        self.encrypt = encrypt  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterTemplateRequestConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class CreateClusterTemplateRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterTemplateRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateClusterTemplateRequest(TeaModel):
    def __init__(self, resource_owner_id=None, template_name=None, region_id=None, zone_id=None, log_path=None,
                 security_group_id=None, is_open_public_ip=None, security_group_name=None, period=None, renew_auto=None, vpc_id=None,
                 v_switch_id=None, net_type=None, user_defined_emr_ecs_role=None, emr_ver=None, cluster_type=None,
                 enable_high_availability=None, use_local_meta_db=None, io_optimized_option=None, enable_ssh=None, instance_generation=None,
                 master_pwd=None, key_pair_name=None, meta_store_type=None, meta_store_conf=None, configurations=None,
                 enable_eas=None, deposit_type=None, machine_type=None, use_custom_hive_meta_db=None,
                 init_custom_hive_meta_db=None, resource_group_id=None, client_token=None, option_soft_ware_list=None, host_group=None,
                 bootstrap_action=None, config=None, tag=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.template_name = template_name  # type: str
        self.region_id = region_id  # type: str
        self.zone_id = zone_id  # type: str
        self.log_path = log_path  # type: str
        self.security_group_id = security_group_id  # type: str
        self.is_open_public_ip = is_open_public_ip  # type: bool
        self.security_group_name = security_group_name  # type: str
        self.period = period  # type: int
        self.renew_auto = renew_auto  # type: bool
        self.vpc_id = vpc_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.net_type = net_type  # type: str
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role  # type: str
        self.emr_ver = emr_ver  # type: str
        self.cluster_type = cluster_type  # type: str
        self.enable_high_availability = enable_high_availability  # type: bool
        self.use_local_meta_db = use_local_meta_db  # type: bool
        self.io_optimized_option = io_optimized_option  # type: bool
        self.enable_ssh = enable_ssh  # type: bool
        self.instance_generation = instance_generation  # type: str
        self.master_pwd = master_pwd  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.meta_store_type = meta_store_type  # type: str
        self.meta_store_conf = meta_store_conf  # type: str
        self.configurations = configurations  # type: str
        self.enable_eas = enable_eas  # type: bool
        self.deposit_type = deposit_type  # type: str
        self.machine_type = machine_type  # type: str
        self.use_custom_hive_meta_db = use_custom_hive_meta_db  # type: bool
        self.init_custom_hive_meta_db = init_custom_hive_meta_db  # type: bool
        self.resource_group_id = resource_group_id  # type: str
        self.client_token = client_token  # type: str
        self.option_soft_ware_list = option_soft_ware_list  # type: list[str]
        self.host_group = host_group  # type: list[CreateClusterTemplateRequestHostGroup]
        self.bootstrap_action = bootstrap_action  # type: list[CreateClusterTemplateRequestBootstrapAction]
        self.config = config  # type: list[CreateClusterTemplateRequestConfig]
        self.tag = tag  # type: list[CreateClusterTemplateRequestTag]

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateClusterTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.period is not None:
            result['Period'] = self.period
        if self.renew_auto is not None:
            result['RenewAuto'] = self.renew_auto
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.enable_high_availability is not None:
            result['EnableHighAvailability'] = self.enable_high_availability
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.io_optimized_option is not None:
            result['IoOptimizedOption'] = self.io_optimized_option
        if self.enable_ssh is not None:
            result['EnableSsh'] = self.enable_ssh
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.enable_eas is not None:
            result['EnableEas'] = self.enable_eas
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.option_soft_ware_list is not None:
            result['OptionSoftWareList'] = self.option_soft_ware_list
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RenewAuto') is not None:
            self.renew_auto = m.get('RenewAuto')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EnableHighAvailability') is not None:
            self.enable_high_availability = m.get('EnableHighAvailability')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('IoOptimizedOption') is not None:
            self.io_optimized_option = m.get('IoOptimizedOption')
        if m.get('EnableSsh') is not None:
            self.enable_ssh = m.get('EnableSsh')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EnableEas') is not None:
            self.enable_eas = m.get('EnableEas')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OptionSoftWareList') is not None:
            self.option_soft_ware_list = m.get('OptionSoftWareList')
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = CreateClusterTemplateRequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateClusterTemplateRequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateClusterTemplateRequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateClusterTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateClusterTemplateResponseBody(TeaModel):
    def __init__(self, cluster_template_id=None, request_id=None):
        self.cluster_template_id = cluster_template_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_template_id is not None:
            result['ClusterTemplateId'] = self.cluster_template_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterTemplateId') is not None:
            self.cluster_template_id = m.get('ClusterTemplateId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClusterTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateClusterTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateClusterTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateLibraryInstallTaskStatusRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, task_biz_id=None, status=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.task_biz_id = task_biz_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateLibraryInstallTaskStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_biz_id is not None:
            result['TaskBizId'] = self.task_biz_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskBizId') is not None:
            self.task_biz_id = m.get('TaskBizId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateLibraryInstallTaskStatusResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateLibraryInstallTaskStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateLibraryInstallTaskStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: UpdateLibraryInstallTaskStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(UpdateLibraryInstallTaskStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateLibraryInstallTaskStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScalingConfigItemRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, limit=None, page_number=None, page_size=None,
                 current_size=None, page_count=None, order_field=None, order_mode=None, scaling_group_biz_id=None,
                 config_item_type=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.limit = limit  # type: long
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.current_size = current_size  # type: long
        self.page_count = page_count  # type: long
        self.order_field = order_field  # type: str
        self.order_mode = order_mode  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.config_item_type = config_item_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListScalingConfigItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        return self


class ListScalingConfigItemResponseBodyItemsItems(TeaModel):
    def __init__(self, config_item_type=None, scaling_group_biz_id=None, scaling_config_item_biz_id=None,
                 config_item_information=None):
        self.config_item_type = config_item_type  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.scaling_config_item_biz_id = scaling_config_item_biz_id  # type: str
        self.config_item_information = config_item_information  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListScalingConfigItemResponseBodyItemsItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.scaling_config_item_biz_id is not None:
            result['ScalingConfigItemBizId'] = self.scaling_config_item_biz_id
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ScalingConfigItemBizId') is not None:
            self.scaling_config_item_biz_id = m.get('ScalingConfigItemBizId')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        return self


class ListScalingConfigItemResponseBodyItems(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListScalingConfigItemResponseBodyItemsItems]

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListScalingConfigItemResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListScalingConfigItemResponseBodyItemsItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListScalingConfigItemResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None, next_token=None,
                 items=None):
        # Id of the request
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long
        self.next_token = next_token  # type: str
        self.items = items  # type: ListScalingConfigItemResponseBodyItems

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(ListScalingConfigItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            temp_model = ListScalingConfigItemResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListScalingConfigItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListScalingConfigItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListScalingConfigItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowInstanceRequest(TeaModel):
    def __init__(self, id=None, flow_id=None, flow_name=None, owner=None, instance_id=None, time_range=None,
                 order_by=None, order_type=None, region_id=None, project_id=None, page_number=None, page_size=None,
                 status_list=None):
        self.id = id  # type: str
        self.flow_id = flow_id  # type: str
        self.flow_name = flow_name  # type: str
        self.owner = owner  # type: str
        self.instance_id = instance_id  # type: str
        self.time_range = time_range  # type: str
        self.order_by = order_by  # type: str
        self.order_type = order_type  # type: str
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.status_list = status_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.time_range is not None:
            result['TimeRange'] = self.time_range
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TimeRange') is not None:
            self.time_range = m.get('TimeRange')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListFlowInstanceResponseBodyFlowInstancesFlowInstance(TeaModel):
    def __init__(self, status=None, owner=None, project_id=None, flow_name=None, gmt_modified=None, flow_id=None,
                 end_time=None, start_time=None, has_node_failed=None, gmt_create=None, schedule_time=None, duration=None,
                 id=None, cluster_id=None):
        self.status = status  # type: str
        self.owner = owner  # type: str
        self.project_id = project_id  # type: str
        self.flow_name = flow_name  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.flow_id = flow_id  # type: str
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.has_node_failed = has_node_failed  # type: bool
        self.gmt_create = gmt_create  # type: long
        self.schedule_time = schedule_time  # type: long
        self.duration = duration  # type: long
        self.id = id  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowInstanceResponseBodyFlowInstancesFlowInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.has_node_failed is not None:
            result['HasNodeFailed'] = self.has_node_failed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('HasNodeFailed') is not None:
            self.has_node_failed = m.get('HasNodeFailed')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ListFlowInstanceResponseBodyFlowInstances(TeaModel):
    def __init__(self, flow_instance=None):
        self.flow_instance = flow_instance  # type: list[ListFlowInstanceResponseBodyFlowInstancesFlowInstance]

    def validate(self):
        if self.flow_instance:
            for k in self.flow_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowInstanceResponseBodyFlowInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FlowInstance'] = []
        if self.flow_instance is not None:
            for k in self.flow_instance:
                result['FlowInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.flow_instance = []
        if m.get('FlowInstance') is not None:
            for k in m.get('FlowInstance'):
                temp_model = ListFlowInstanceResponseBodyFlowInstancesFlowInstance()
                self.flow_instance.append(temp_model.from_map(k))
        return self


class ListFlowInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total=None, flow_instances=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.flow_instances = flow_instances  # type: ListFlowInstanceResponseBodyFlowInstances

    def validate(self):
        if self.flow_instances:
            self.flow_instances.validate()

    def to_map(self):
        _map = super(ListFlowInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.flow_instances is not None:
            result['FlowInstances'] = self.flow_instances.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('FlowInstances') is not None:
            temp_model = ListFlowInstanceResponseBodyFlowInstances()
            self.flow_instances = temp_model.from_map(m['FlowInstances'])
        return self


class ListFlowInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingMetricsRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, host_group_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.host_group_id = host_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingMetricsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        return self


class DescribeScalingMetricsResponseBodyMetricList(TeaModel):
    def __init__(self, metric_name=None, unit=None, display_name=None, min_value=None, max_value=None):
        self.metric_name = metric_name  # type: str
        self.unit = unit  # type: str
        self.display_name = display_name  # type: str
        self.min_value = min_value  # type: long
        self.max_value = max_value  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingMetricsResponseBodyMetricList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.min_value is not None:
            result['MinValue'] = self.min_value
        if self.max_value is not None:
            result['MaxValue'] = self.max_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('MinValue') is not None:
            self.min_value = m.get('MinValue')
        if m.get('MaxValue') is not None:
            self.max_value = m.get('MaxValue')
        return self


class DescribeScalingMetricsResponseBody(TeaModel):
    def __init__(self, request_id=None, metric_list=None):
        # Id of the request
        self.request_id = request_id  # type: str
        self.metric_list = metric_list  # type: list[DescribeScalingMetricsResponseBodyMetricList]

    def validate(self):
        if self.metric_list:
            for k in self.metric_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeScalingMetricsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['MetricList'] = []
        if self.metric_list is not None:
            for k in self.metric_list:
                result['MetricList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.metric_list = []
        if m.get('MetricList') is not None:
            for k in m.get('MetricList'):
                temp_model = DescribeScalingMetricsResponseBodyMetricList()
                self.metric_list.append(temp_model.from_map(k))
        return self


class DescribeScalingMetricsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeScalingMetricsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeScalingMetricsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UntagResourcesSystemTagsRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_type=None, tag_owner_uid=None,
                 resource_ids=None, tag_keys=None, all=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        # 资源类型：cluster
        self.resource_type = resource_type  # type: str
        self.tag_owner_uid = tag_owner_uid  # type: long
        # 资源ID
        self.resource_ids = resource_ids  # type: list[str]
        self.tag_keys = tag_keys  # type: list[str]
        self.all = all  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(UntagResourcesSystemTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_owner_uid is not None:
            result['TagOwnerUid'] = self.tag_owner_uid
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys
        if self.all is not None:
            result['All'] = self.all
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TagOwnerUid') is not None:
            self.tag_owner_uid = m.get('TagOwnerUid')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        if m.get('TagKeys') is not None:
            self.tag_keys = m.get('TagKeys')
        if m.get('All') is not None:
            self.all = m.get('All')
        return self


class UntagResourcesSystemTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_code=None, message=None):
        # Id of the request
        self.request_id = request_id  # type: str
        # 请求是否成功被处理
        self.success = success  # type: bool
        # 响应码
        self.code = code  # type: str
        # 错误码
        self.error_code = error_code  # type: str
        # 响应消息
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UntagResourcesSystemTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class UntagResourcesSystemTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: UntagResourcesSystemTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(UntagResourcesSystemTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UntagResourcesSystemTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowProjectRequest(TeaModel):
    def __init__(self, project_id=None, region_id=None):
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowProjectResponseBody(TeaModel):
    def __init__(self, request_id=None, description=None, user_id=None, gmt_create=None, gmt_modified=None,
                 name=None, id=None):
        self.request_id = request_id  # type: str
        self.description = description  # type: str
        self.user_id = user_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.name = name  # type: str
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeFlowProjectResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityWhiteListRequest(TeaModel):
    def __init__(self, cluster_id=None, port_range=None, white_ip=None):
        self.cluster_id = cluster_id  # type: str
        self.port_range = port_range  # type: str
        self.white_ip = white_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecurityWhiteListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.white_ip is not None:
            result['WhiteIp'] = self.white_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('WhiteIp') is not None:
            self.white_ip = m.get('WhiteIp')
        return self


class DeleteSecurityWhiteListResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecurityWhiteListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityWhiteListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteSecurityWhiteListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSecurityWhiteListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSecurityWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScalingActivityRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, limit=None, page_number=None, page_size=None,
                 current_size=None, page_count=None, order_field=None, order_mode=None, cluster_biz_id=None, host_group_id=None,
                 scaling_group_biz_id=None, scaling_rule_name=None, host_group_name=None, status=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.limit = limit  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.current_size = current_size  # type: int
        self.page_count = page_count  # type: int
        self.order_field = order_field  # type: str
        self.order_mode = order_mode  # type: str
        self.cluster_biz_id = cluster_biz_id  # type: str
        self.host_group_id = host_group_id  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.scaling_rule_name = scaling_rule_name  # type: str
        self.host_group_name = host_group_name  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListScalingActivityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListScalingActivityResponseBodyItemsItem(TeaModel):
    def __init__(self, biz_id=None, start_time=None, end_time=None, expect_num=None, instance_ids=None,
                 total_capacity=None, cause=None, description=None, transition=None, status=None, scaling_rule_id=None,
                 scaling_rule_name=None, host_group_biz_id=None, host_group_name=None):
        # bizId
        self.biz_id = biz_id  # type: str
        # startTime
        self.start_time = start_time  # type: long
        # endTime
        self.end_time = end_time  # type: long
        self.expect_num = expect_num  # type: long
        # instanceIds
        self.instance_ids = instance_ids  # type: str
        # totalCapacity
        self.total_capacity = total_capacity  # type: long
        # cause
        self.cause = cause  # type: str
        # description
        self.description = description  # type: str
        # transition
        self.transition = transition  # type: str
        # status
        self.status = status  # type: str
        # scalingRuleId
        self.scaling_rule_id = scaling_rule_id  # type: str
        # scalingRuleName
        self.scaling_rule_name = scaling_rule_name  # type: str
        # hostGroupBizId
        self.host_group_biz_id = host_group_biz_id  # type: str
        # hostGroupName
        self.host_group_name = host_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListScalingActivityResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.expect_num is not None:
            result['ExpectNum'] = self.expect_num
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.total_capacity is not None:
            result['TotalCapacity'] = self.total_capacity
        if self.cause is not None:
            result['Cause'] = self.cause
        if self.description is not None:
            result['Description'] = self.description
        if self.transition is not None:
            result['Transition'] = self.transition
        if self.status is not None:
            result['Status'] = self.status
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExpectNum') is not None:
            self.expect_num = m.get('ExpectNum')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('TotalCapacity') is not None:
            self.total_capacity = m.get('TotalCapacity')
        if m.get('Cause') is not None:
            self.cause = m.get('Cause')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Transition') is not None:
            self.transition = m.get('Transition')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListScalingActivityResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[ListScalingActivityResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListScalingActivityResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListScalingActivityResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListScalingActivityResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None, next_token=None,
                 items=None):
        # requestId
        self.request_id = request_id  # type: str
        # pageNumber
        self.page_number = page_number  # type: long
        # pageSize
        self.page_size = page_size  # type: long
        # totalCount
        self.total_count = total_count  # type: long
        # nextToken
        self.next_token = next_token  # type: long
        self.items = items  # type: ListScalingActivityResponseBodyItems

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(ListScalingActivityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            temp_model = ListScalingActivityResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListScalingActivityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListScalingActivityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListScalingActivityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScalingActivityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagValuesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, resource_type=None,
                 scope=None, next_token=None, page_size=None, key=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        # 资源组类型
        self.resource_type = resource_type  # type: str
        self.scope = scope  # type: str
        self.next_token = next_token  # type: str
        self.page_size = page_size  # type: long
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagValuesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class ListTagValuesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, next_token=None, items=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long
        self.next_token = next_token  # type: str
        # 标签键集合
        self.items = items  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagValuesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        return self


class ListTagValuesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, paging=None, data=None, code=None, error_code=None,
                 message=None):
        # Id of the request
        self.request_id = request_id  # type: str
        # 是否成功响应
        self.success = success  # type: bool
        # 是否分页
        self.paging = paging  # type: bool
        # 标签值集合
        self.data = data  # type: list[ListTagValuesResponseBodyData]
        self.code = code  # type: str
        self.error_code = error_code  # type: str
        self.message = message  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagValuesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.paging is not None:
            result['Paging'] = self.paging
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Paging') is not None:
            self.paging = m.get('Paging')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListTagValuesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ListTagValuesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListTagValuesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTagValuesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTagValuesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterInstalledServiceRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, page_number=None, page_size=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterInstalledServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction(TeaModel):
    def __init__(self, display_name=None, action_name=None, component_name=None, service_name=None, command=None):
        self.display_name = display_name  # type: str
        self.action_name = action_name  # type: str
        self.component_name = component_name  # type: str
        self.service_name = service_name  # type: str
        self.command = command  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.command is not None:
            result['Command'] = self.command
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList(TeaModel):
    def __init__(self, service_action=None):
        self.service_action = service_action  # type: list[ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction]

    def validate(self):
        if self.service_action:
            for k in self.service_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ServiceAction'] = []
        if self.service_action is not None:
            for k in self.service_action:
                result['ServiceAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.service_action = []
        if m.get('ServiceAction') is not None:
            for k in m.get('ServiceAction'):
                temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction()
                self.service_action.append(temp_model.from_map(k))
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService(TeaModel):
    def __init__(self, service_ecm_version=None, service_display_name=None, only_client=None, comment=None,
                 not_started_num=None, need_restart_num=None, service_version=None, service_status=None, service_name=None,
                 abnormal_num=None, service_action_list=None):
        self.service_ecm_version = service_ecm_version  # type: str
        self.service_display_name = service_display_name  # type: str
        self.only_client = only_client  # type: bool
        self.comment = comment  # type: str
        self.not_started_num = not_started_num  # type: int
        self.need_restart_num = need_restart_num  # type: int
        self.service_version = service_version  # type: str
        self.service_status = service_status  # type: str
        self.service_name = service_name  # type: str
        self.abnormal_num = abnormal_num  # type: int
        self.service_action_list = service_action_list  # type: ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList

    def validate(self):
        if self.service_action_list:
            self.service_action_list.validate()

    def to_map(self):
        _map = super(ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_ecm_version is not None:
            result['ServiceEcmVersion'] = self.service_ecm_version
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.only_client is not None:
            result['OnlyClient'] = self.only_client
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.not_started_num is not None:
            result['NotStartedNum'] = self.not_started_num
        if self.need_restart_num is not None:
            result['NeedRestartNum'] = self.need_restart_num
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.abnormal_num is not None:
            result['AbnormalNum'] = self.abnormal_num
        if self.service_action_list is not None:
            result['ServiceActionList'] = self.service_action_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceEcmVersion') is not None:
            self.service_ecm_version = m.get('ServiceEcmVersion')
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('OnlyClient') is not None:
            self.only_client = m.get('OnlyClient')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('NotStartedNum') is not None:
            self.not_started_num = m.get('NotStartedNum')
        if m.get('NeedRestartNum') is not None:
            self.need_restart_num = m.get('NeedRestartNum')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('AbnormalNum') is not None:
            self.abnormal_num = m.get('AbnormalNum')
        if m.get('ServiceActionList') is not None:
            temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList()
            self.service_action_list = temp_model.from_map(m['ServiceActionList'])
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceList(TeaModel):
    def __init__(self, cluster_installed_service=None):
        self.cluster_installed_service = cluster_installed_service  # type: list[ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService]

    def validate(self):
        if self.cluster_installed_service:
            for k in self.cluster_installed_service:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterInstalledServiceResponseBodyClusterInstalledServiceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInstalledService'] = []
        if self.cluster_installed_service is not None:
            for k in self.cluster_installed_service:
                result['ClusterInstalledService'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_installed_service = []
        if m.get('ClusterInstalledService') is not None:
            for k in m.get('ClusterInstalledService'):
                temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService()
                self.cluster_installed_service.append(temp_model.from_map(k))
        return self


class ListClusterInstalledServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, cluster_installed_service_list=None):
        self.request_id = request_id  # type: str
        self.cluster_installed_service_list = cluster_installed_service_list  # type: ListClusterInstalledServiceResponseBodyClusterInstalledServiceList

    def validate(self):
        if self.cluster_installed_service_list:
            self.cluster_installed_service_list.validate()

    def to_map(self):
        _map = super(ListClusterInstalledServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_installed_service_list is not None:
            result['ClusterInstalledServiceList'] = self.cluster_installed_service_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterInstalledServiceList') is not None:
            temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceList()
            self.cluster_installed_service_list = temp_model.from_map(m['ClusterInstalledServiceList'])
        return self


class ListClusterInstalledServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterInstalledServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterInstalledServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterInstalledServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RunClusterServiceActionRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, host_id_list=None,
                 service_name=None, service_action_name=None, custom_command=None, component_name_list=None, comment=None,
                 is_rolling=None, execute_strategy=None, custom_params=None, interval=None, node_count_per_batch=None,
                 tolerate_fail_count=None, only_restart_stale_config_nodes=None, turn_on_maintenance_mode=None,
                 host_group_id_list=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.host_id_list = host_id_list  # type: str
        self.service_name = service_name  # type: str
        self.service_action_name = service_action_name  # type: str
        self.custom_command = custom_command  # type: str
        self.component_name_list = component_name_list  # type: str
        self.comment = comment  # type: str
        self.is_rolling = is_rolling  # type: bool
        self.execute_strategy = execute_strategy  # type: str
        self.custom_params = custom_params  # type: str
        self.interval = interval  # type: long
        self.node_count_per_batch = node_count_per_batch  # type: int
        self.tolerate_fail_count = tolerate_fail_count  # type: int
        self.only_restart_stale_config_nodes = only_restart_stale_config_nodes  # type: bool
        self.turn_on_maintenance_mode = turn_on_maintenance_mode  # type: bool
        self.host_group_id_list = host_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(RunClusterServiceActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_id_list is not None:
            result['HostIdList'] = self.host_id_list
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_action_name is not None:
            result['ServiceActionName'] = self.service_action_name
        if self.custom_command is not None:
            result['CustomCommand'] = self.custom_command
        if self.component_name_list is not None:
            result['ComponentNameList'] = self.component_name_list
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_rolling is not None:
            result['IsRolling'] = self.is_rolling
        if self.execute_strategy is not None:
            result['ExecuteStrategy'] = self.execute_strategy
        if self.custom_params is not None:
            result['CustomParams'] = self.custom_params
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.node_count_per_batch is not None:
            result['NodeCountPerBatch'] = self.node_count_per_batch
        if self.tolerate_fail_count is not None:
            result['TolerateFailCount'] = self.tolerate_fail_count
        if self.only_restart_stale_config_nodes is not None:
            result['OnlyRestartStaleConfigNodes'] = self.only_restart_stale_config_nodes
        if self.turn_on_maintenance_mode is not None:
            result['TurnOnMaintenanceMode'] = self.turn_on_maintenance_mode
        if self.host_group_id_list is not None:
            result['HostGroupIdList'] = self.host_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostIdList') is not None:
            self.host_id_list = m.get('HostIdList')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceActionName') is not None:
            self.service_action_name = m.get('ServiceActionName')
        if m.get('CustomCommand') is not None:
            self.custom_command = m.get('CustomCommand')
        if m.get('ComponentNameList') is not None:
            self.component_name_list = m.get('ComponentNameList')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsRolling') is not None:
            self.is_rolling = m.get('IsRolling')
        if m.get('ExecuteStrategy') is not None:
            self.execute_strategy = m.get('ExecuteStrategy')
        if m.get('CustomParams') is not None:
            self.custom_params = m.get('CustomParams')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('NodeCountPerBatch') is not None:
            self.node_count_per_batch = m.get('NodeCountPerBatch')
        if m.get('TolerateFailCount') is not None:
            self.tolerate_fail_count = m.get('TolerateFailCount')
        if m.get('OnlyRestartStaleConfigNodes') is not None:
            self.only_restart_stale_config_nodes = m.get('OnlyRestartStaleConfigNodes')
        if m.get('TurnOnMaintenanceMode') is not None:
            self.turn_on_maintenance_mode = m.get('TurnOnMaintenanceMode')
        if m.get('HostGroupIdList') is not None:
            self.host_group_id_list = m.get('HostGroupIdList')
        return self


class RunClusterServiceActionResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RunClusterServiceActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RunClusterServiceActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RunClusterServiceActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RunClusterServiceActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RunClusterServiceActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SuspendFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, flow_instance_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.flow_instance_id = flow_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SuspendFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        return self


class SuspendFlowResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SuspendFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SuspendFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SuspendFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SuspendFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SuspendFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectRequest(TeaModel):
    def __init__(self, product_type=None, region_id=None, name=None, description=None, resource_group_id=None,
                 client_token=None):
        self.product_type = product_type  # type: str
        self.region_id = region_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateFlowProjectResponseBody(TeaModel):
    def __init__(self, id=None, request_id=None):
        self.id = id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowProjectResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFlowProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowNodeInstanceContainerStatusRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, node_instance_id=None, project_id=None, region_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.node_instance_id = node_instance_id  # type: str
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowNodeInstanceContainerStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusListContainerStatus(TeaModel):
    def __init__(self, status=None, host_name=None, container_id=None, application_id=None):
        self.status = status  # type: str
        self.host_name = host_name  # type: str
        self.container_id = container_id  # type: str
        self.application_id = application_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusListContainerStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusList(TeaModel):
    def __init__(self, container_status=None):
        self.container_status = container_status  # type: list[ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusListContainerStatus]

    def validate(self):
        if self.container_status:
            for k in self.container_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContainerStatus'] = []
        if self.container_status is not None:
            for k in self.container_status:
                result['ContainerStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.container_status = []
        if m.get('ContainerStatus') is not None:
            for k in m.get('ContainerStatus'):
                temp_model = ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusListContainerStatus()
                self.container_status.append(temp_model.from_map(k))
        return self


class ListFlowNodeInstanceContainerStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total=None, container_status_list=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.container_status_list = container_status_list  # type: ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusList

    def validate(self):
        if self.container_status_list:
            self.container_status_list.validate()

    def to_map(self):
        _map = super(ListFlowNodeInstanceContainerStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.container_status_list is not None:
            result['ContainerStatusList'] = self.container_status_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ContainerStatusList') is not None:
            temp_model = ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusList()
            self.container_status_list = temp_model.from_map(m['ContainerStatusList'])
        return self


class ListFlowNodeInstanceContainerStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowNodeInstanceContainerStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowNodeInstanceContainerStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowNodeInstanceContainerStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyClusterTemplateRequestHostGroup(TeaModel):
    def __init__(self, sys_disk_capacity=None, host_group_type=None, comment=None, multi_instance_types=None,
                 sys_disk_type=None, charge_type=None, disk_type=None, host_group_id=None, instance_type=None, disk_count=None,
                 create_type=None, period=None, disk_capacity=None, v_switch_id=None, node_count=None, host_group_name=None,
                 renew_auto=None, cluster_id=None):
        self.sys_disk_capacity = sys_disk_capacity  # type: int
        self.host_group_type = host_group_type  # type: str
        self.comment = comment  # type: str
        self.multi_instance_types = multi_instance_types  # type: str
        self.sys_disk_type = sys_disk_type  # type: str
        self.charge_type = charge_type  # type: str
        self.disk_type = disk_type  # type: str
        self.host_group_id = host_group_id  # type: str
        self.instance_type = instance_type  # type: str
        self.disk_count = disk_count  # type: int
        self.create_type = create_type  # type: str
        self.period = period  # type: int
        self.disk_capacity = disk_capacity  # type: int
        self.v_switch_id = v_switch_id  # type: str
        self.node_count = node_count  # type: int
        self.host_group_name = host_group_name  # type: str
        self.renew_auto = renew_auto  # type: bool
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterTemplateRequestHostGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.renew_auto is not None:
            result['RenewAuto'] = self.renew_auto
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('RenewAuto') is not None:
            self.renew_auto = m.get('RenewAuto')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ModifyClusterTemplateRequestBootstrapAction(TeaModel):
    def __init__(self, arg=None, path=None, name=None):
        self.arg = arg  # type: str
        self.path = path  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterTemplateRequestBootstrapAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ModifyClusterTemplateRequestConfig(TeaModel):
    def __init__(self, config_value=None, replace=None, file_name=None, service_name=None, config_key=None,
                 encrypt=None):
        self.config_value = config_value  # type: str
        self.replace = replace  # type: str
        self.file_name = file_name  # type: str
        self.service_name = service_name  # type: str
        self.config_key = config_key  # type: str
        self.encrypt = encrypt  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterTemplateRequestConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class ModifyClusterTemplateRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterTemplateRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ModifyClusterTemplateRequest(TeaModel):
    def __init__(self, resource_owner_id=None, biz_id=None, template_name=None, region_id=None, zone_id=None,
                 log_path=None, security_group_id=None, is_open_public_ip=None, security_group_name=None, charge_type=None,
                 period=None, renew_auto=None, vpc_id=None, v_switch_id=None, net_type=None,
                 user_defined_emr_ecs_role=None, emr_ver=None, cluster_type=None, enable_high_availability=None, use_local_meta_db=None,
                 io_optimized_option=None, enable_ssh=None, instance_generation=None, master_pwd=None, key_pair_name=None,
                 meta_store_type=None, meta_store_conf=None, configurations=None, enable_eas=None, deposit_type=None,
                 machine_type=None, use_custom_hive_meta_db=None, init_custom_hive_meta_db=None, resource_group_id=None,
                 option_soft_ware_list=None, host_group=None, bootstrap_action=None, config=None, tag=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.biz_id = biz_id  # type: str
        self.template_name = template_name  # type: str
        self.region_id = region_id  # type: str
        self.zone_id = zone_id  # type: str
        self.log_path = log_path  # type: str
        self.security_group_id = security_group_id  # type: str
        self.is_open_public_ip = is_open_public_ip  # type: bool
        self.security_group_name = security_group_name  # type: str
        self.charge_type = charge_type  # type: str
        self.period = period  # type: int
        self.renew_auto = renew_auto  # type: bool
        self.vpc_id = vpc_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.net_type = net_type  # type: str
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role  # type: str
        self.emr_ver = emr_ver  # type: str
        self.cluster_type = cluster_type  # type: str
        self.enable_high_availability = enable_high_availability  # type: bool
        self.use_local_meta_db = use_local_meta_db  # type: bool
        self.io_optimized_option = io_optimized_option  # type: bool
        self.enable_ssh = enable_ssh  # type: bool
        self.instance_generation = instance_generation  # type: str
        self.master_pwd = master_pwd  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.meta_store_type = meta_store_type  # type: str
        self.meta_store_conf = meta_store_conf  # type: str
        self.configurations = configurations  # type: str
        self.enable_eas = enable_eas  # type: bool
        self.deposit_type = deposit_type  # type: str
        self.machine_type = machine_type  # type: str
        self.use_custom_hive_meta_db = use_custom_hive_meta_db  # type: bool
        self.init_custom_hive_meta_db = init_custom_hive_meta_db  # type: bool
        self.resource_group_id = resource_group_id  # type: str
        self.option_soft_ware_list = option_soft_ware_list  # type: list[str]
        self.host_group = host_group  # type: list[ModifyClusterTemplateRequestHostGroup]
        self.bootstrap_action = bootstrap_action  # type: list[ModifyClusterTemplateRequestBootstrapAction]
        self.config = config  # type: list[ModifyClusterTemplateRequestConfig]
        self.tag = tag  # type: list[ModifyClusterTemplateRequestTag]

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ModifyClusterTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.renew_auto is not None:
            result['RenewAuto'] = self.renew_auto
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.enable_high_availability is not None:
            result['EnableHighAvailability'] = self.enable_high_availability
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.io_optimized_option is not None:
            result['IoOptimizedOption'] = self.io_optimized_option
        if self.enable_ssh is not None:
            result['EnableSsh'] = self.enable_ssh
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.enable_eas is not None:
            result['EnableEas'] = self.enable_eas
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.option_soft_ware_list is not None:
            result['OptionSoftWareList'] = self.option_soft_ware_list
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RenewAuto') is not None:
            self.renew_auto = m.get('RenewAuto')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EnableHighAvailability') is not None:
            self.enable_high_availability = m.get('EnableHighAvailability')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('IoOptimizedOption') is not None:
            self.io_optimized_option = m.get('IoOptimizedOption')
        if m.get('EnableSsh') is not None:
            self.enable_ssh = m.get('EnableSsh')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EnableEas') is not None:
            self.enable_eas = m.get('EnableEas')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('OptionSoftWareList') is not None:
            self.option_soft_ware_list = m.get('OptionSoftWareList')
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ModifyClusterTemplateRequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = ModifyClusterTemplateRequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = ModifyClusterTemplateRequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ModifyClusterTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ModifyClusterTemplateResponseBody(TeaModel):
    def __init__(self, cluster_template_id=None, request_id=None):
        self.cluster_template_id = cluster_template_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_template_id is not None:
            result['ClusterTemplateId'] = self.cluster_template_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterTemplateId') is not None:
            self.cluster_template_id = m.get('ClusterTemplateId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyClusterTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyClusterTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyClusterTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSecurityWhiteListRequest(TeaModel):
    def __init__(self, cluster_id=None, port_range=None, white_ip_list=None, description=None):
        self.cluster_id = cluster_id  # type: str
        self.port_range = port_range  # type: str
        self.white_ip_list = white_ip_list  # type: list[str]
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSecurityWhiteListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.white_ip_list is not None:
            result['WhiteIpList'] = self.white_ip_list
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('WhiteIpList') is not None:
            self.white_ip_list = m.get('WhiteIpList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class AddSecurityWhiteListResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSecurityWhiteListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSecurityWhiteListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddSecurityWhiteListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddSecurityWhiteListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddSecurityWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMetaClusterRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, page_number=None, page_size=None, source_type=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.source_type = source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMetaClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class ListMetaClusterResponseBodyItemsItemSoftwareInfo(TeaModel):
    def __init__(self, cluster_type=None, emr_ver=None):
        self.cluster_type = cluster_type  # type: str
        self.emr_ver = emr_ver  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMetaClusterResponseBodyItemsItemSoftwareInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        return self


class ListMetaClusterResponseBodyItemsItem(TeaModel):
    def __init__(self, name=None, id=None, software_info=None):
        self.name = name  # type: str
        self.id = id  # type: str
        self.software_info = software_info  # type: ListMetaClusterResponseBodyItemsItemSoftwareInfo

    def validate(self):
        if self.software_info:
            self.software_info.validate()

    def to_map(self):
        _map = super(ListMetaClusterResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SoftwareInfo') is not None:
            temp_model = ListMetaClusterResponseBodyItemsItemSoftwareInfo()
            self.software_info = temp_model.from_map(m['SoftwareInfo'])
        return self


class ListMetaClusterResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[ListMetaClusterResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMetaClusterResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListMetaClusterResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListMetaClusterResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None, items=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.items = items  # type: ListMetaClusterResponseBodyItems

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(ListMetaClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListMetaClusterResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListMetaClusterResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListMetaClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListMetaClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMetaClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationHostRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, operation_id=None, status=None,
                 page_number=None, page_size=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.operation_id = operation_id  # type: str
        self.status = status  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterOperationHostRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost(TeaModel):
    def __init__(self, status=None, host_name=None, percentage=None, host_id=None):
        self.status = status  # type: str
        self.host_name = host_name  # type: str
        self.percentage = percentage  # type: str
        self.host_id = host_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.host_id is not None:
            result['HostId'] = self.host_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        return self


class ListClusterOperationHostResponseBodyClusterOperationHostList(TeaModel):
    def __init__(self, cluster_operation_host=None):
        self.cluster_operation_host = cluster_operation_host  # type: list[ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost]

    def validate(self):
        if self.cluster_operation_host:
            for k in self.cluster_operation_host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterOperationHostResponseBodyClusterOperationHostList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperationHost'] = []
        if self.cluster_operation_host is not None:
            for k in self.cluster_operation_host:
                result['ClusterOperationHost'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_operation_host = []
        if m.get('ClusterOperationHost') is not None:
            for k in m.get('ClusterOperationHost'):
                temp_model = ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost()
                self.cluster_operation_host.append(temp_model.from_map(k))
        return self


class ListClusterOperationHostResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None,
                 cluster_operation_host_list=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.cluster_operation_host_list = cluster_operation_host_list  # type: ListClusterOperationHostResponseBodyClusterOperationHostList

    def validate(self):
        if self.cluster_operation_host_list:
            self.cluster_operation_host_list.validate()

    def to_map(self):
        _map = super(ListClusterOperationHostResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.cluster_operation_host_list is not None:
            result['ClusterOperationHostList'] = self.cluster_operation_host_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ClusterOperationHostList') is not None:
            temp_model = ListClusterOperationHostResponseBodyClusterOperationHostList()
            self.cluster_operation_host_list = temp_model.from_map(m['ClusterOperationHostList'])
        return self


class ListClusterOperationHostResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterOperationHostResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterOperationHostResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterTemplatesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, biz_id=None, page_number=None, page_size=None,
                 product_type=None, resource_group_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.biz_id = biz_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.product_type = product_type  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(self, path=None, name=None, arg=None):
        self.path = path  # type: str
        self.name = name  # type: str
        self.arg = arg  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.arg is not None:
            result['Arg'] = self.arg
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList(TeaModel):
    def __init__(self, bootstrap_action=None):
        self.bootstrap_action = bootstrap_action  # type: list[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction]

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup(TeaModel):
    def __init__(self, sys_disk_capacity=None, host_group_type=None, multi_instance_types=None, sys_disk_type=None,
                 charge_type=None, disk_type=None, host_group_id=None, instance_type=None, disk_count=None, period=None,
                 disk_capacity=None, node_count=None, host_group_name=None):
        self.sys_disk_capacity = sys_disk_capacity  # type: int
        self.host_group_type = host_group_type  # type: str
        self.multi_instance_types = multi_instance_types  # type: str
        self.sys_disk_type = sys_disk_type  # type: str
        self.charge_type = charge_type  # type: str
        self.disk_type = disk_type  # type: str
        self.host_group_id = host_group_id  # type: str
        self.instance_type = instance_type  # type: str
        self.disk_count = disk_count  # type: int
        self.period = period  # type: str
        self.disk_capacity = disk_capacity  # type: int
        self.node_count = node_count  # type: int
        self.host_group_name = host_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList(TeaModel):
    def __init__(self, host_group=None):
        self.host_group = host_group  # type: list[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup]

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig(TeaModel):
    def __init__(self, config_value=None, replace=None, file_name=None, service_name=None, config_key=None,
                 encrypt=None):
        self.config_value = config_value  # type: str
        self.replace = replace  # type: str
        self.file_name = file_name  # type: str
        self.service_name = service_name  # type: str
        self.config_key = config_key  # type: str
        self.encrypt = encrypt  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig]

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList(TeaModel):
    def __init__(self, software_info=None):
        self.software_info = software_info  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SoftwareInfo') is not None:
            self.software_info = m.get('SoftwareInfo')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo(TeaModel):
    def __init__(self, vpc_id=None, key_pair_name=None, log_enable=None, ssh_enable=None,
                 high_availability_enable=None, security_group_id=None, user_id=None, is_open_public_ip=None, allow_notebook=None,
                 gmt_modified=None, template_name=None, deposit_type=None, security_group_name=None, create_source=None,
                 instance_generation=None, use_custom_hive_meta_db=None, eas_enable=None, user_defined_emr_ecs_role=None,
                 meta_store_type=None, machine_type=None, use_local_meta_db=None, master_node_total=None,
                 init_custom_hive_meta_db=None, io_optimized=None, meta_store_conf=None, v_switch_id=None, configurations=None,
                 log_path=None, cluster_type=None, net_type=None, zone_id=None, gmt_create=None, id=None,
                 bootstrap_action_list=None, host_group_list=None, config_list=None, software_info_list=None):
        self.vpc_id = vpc_id  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.log_enable = log_enable  # type: bool
        self.ssh_enable = ssh_enable  # type: bool
        self.high_availability_enable = high_availability_enable  # type: bool
        self.security_group_id = security_group_id  # type: str
        self.user_id = user_id  # type: str
        self.is_open_public_ip = is_open_public_ip  # type: bool
        self.allow_notebook = allow_notebook  # type: bool
        self.gmt_modified = gmt_modified  # type: long
        self.template_name = template_name  # type: str
        self.deposit_type = deposit_type  # type: str
        self.security_group_name = security_group_name  # type: str
        self.create_source = create_source  # type: str
        self.instance_generation = instance_generation  # type: str
        self.use_custom_hive_meta_db = use_custom_hive_meta_db  # type: bool
        self.eas_enable = eas_enable  # type: bool
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role  # type: str
        self.meta_store_type = meta_store_type  # type: str
        self.machine_type = machine_type  # type: str
        self.use_local_meta_db = use_local_meta_db  # type: bool
        self.master_node_total = master_node_total  # type: int
        self.init_custom_hive_meta_db = init_custom_hive_meta_db  # type: bool
        self.io_optimized = io_optimized  # type: bool
        self.meta_store_conf = meta_store_conf  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.configurations = configurations  # type: str
        self.log_path = log_path  # type: str
        self.cluster_type = cluster_type  # type: str
        self.net_type = net_type  # type: str
        self.zone_id = zone_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.id = id  # type: str
        self.bootstrap_action_list = bootstrap_action_list  # type: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList
        self.host_group_list = host_group_list  # type: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList
        self.config_list = config_list  # type: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList
        self.software_info_list = software_info_list  # type: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList

    def validate(self):
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.host_group_list:
            self.host_group_list.validate()
        if self.config_list:
            self.config_list.validate()
        if self.software_info_list:
            self.software_info_list.validate()

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.allow_notebook is not None:
            result['AllowNotebook'] = self.allow_notebook
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.software_info_list is not None:
            result['SoftwareInfoList'] = self.software_info_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('SshEnable') is not None:
            self.ssh_enable = m.get('SshEnable')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('AllowNotebook') is not None:
            self.allow_notebook = m.get('AllowNotebook')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BootstrapActionList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('HostGroupList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('ConfigList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        if m.get('SoftwareInfoList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList()
            self.software_info_list = temp_model.from_map(m['SoftwareInfoList'])
        return self


class ListClusterTemplatesResponseBodyTemplateInfoList(TeaModel):
    def __init__(self, template_info=None):
        self.template_info = template_info  # type: list[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo]

    def validate(self):
        if self.template_info:
            for k in self.template_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBodyTemplateInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TemplateInfo'] = []
        if self.template_info is not None:
            for k in self.template_info:
                result['TemplateInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.template_info = []
        if m.get('TemplateInfo') is not None:
            for k in m.get('TemplateInfo'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo()
                self.template_info.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None, template_info_list=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.template_info_list = template_info_list  # type: ListClusterTemplatesResponseBodyTemplateInfoList

    def validate(self):
        if self.template_info_list:
            self.template_info_list.validate()

    def to_map(self):
        _map = super(ListClusterTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.template_info_list is not None:
            result['TemplateInfoList'] = self.template_info_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TemplateInfoList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoList()
            self.template_info_list = temp_model.from_map(m['TemplateInfoList'])
        return self


class ListClusterTemplatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClustersRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClustersRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListClustersRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, create_type=None, machine_type=None, is_desc=None,
                 deposit_type=None, page_number=None, page_size=None, default_status=None, name=None, resource_group_id=None,
                 cluster_type_list=None, status_list=None, tag=None, expired_tag_list=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.create_type = create_type  # type: str
        self.machine_type = machine_type  # type: str
        self.is_desc = is_desc  # type: bool
        self.deposit_type = deposit_type  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.default_status = default_status  # type: bool
        self.name = name  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.cluster_type_list = cluster_type_list  # type: list[str]
        self.status_list = status_list  # type: list[str]
        self.tag = tag  # type: list[ListClustersRequestTag]
        self.expired_tag_list = expired_tag_list  # type: list[str]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClustersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.is_desc is not None:
            result['IsDesc'] = self.is_desc
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.default_status is not None:
            result['DefaultStatus'] = self.default_status
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.cluster_type_list is not None:
            result['ClusterTypeList'] = self.cluster_type_list
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.expired_tag_list is not None:
            result['ExpiredTagList'] = self.expired_tag_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('IsDesc') is not None:
            self.is_desc = m.get('IsDesc')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('DefaultStatus') is not None:
            self.default_status = m.get('DefaultStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClusterTypeList') is not None:
            self.cluster_type_list = m.get('ClusterTypeList')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ExpiredTagList') is not None:
            self.expired_tag_list = m.get('ExpiredTagList')
        return self


class ListClustersResponseBodyClustersClusterInfoTagsTag(TeaModel):
    def __init__(self, tag_value=None, tag_key=None):
        self.tag_value = tag_value  # type: str
        self.tag_key = tag_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClustersResponseBodyClustersClusterInfoTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class ListClustersResponseBodyClustersClusterInfoTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[ListClustersResponseBodyClustersClusterInfoTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClustersResponseBodyClustersClusterInfoTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListClustersResponseBodyClustersClusterInfoTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListClustersResponseBodyClustersClusterInfoOrderTaskInfo(TeaModel):
    def __init__(self, target_count=None, current_count=None, order_id_list=None):
        self.target_count = target_count  # type: int
        self.current_count = current_count  # type: int
        self.order_id_list = order_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClustersResponseBodyClustersClusterInfoOrderTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_count is not None:
            result['TargetCount'] = self.target_count
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.order_id_list is not None:
            result['OrderIdList'] = self.order_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetCount') is not None:
            self.target_count = m.get('TargetCount')
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('OrderIdList') is not None:
            self.order_id_list = m.get('OrderIdList')
        return self


class ListClustersResponseBodyClustersClusterInfoFailReason(TeaModel):
    def __init__(self, error_msg=None, request_id=None, error_code=None):
        self.error_msg = error_msg  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClustersResponseBodyClustersClusterInfoFailReason, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class ListClustersResponseBodyClustersClusterInfo(TeaModel):
    def __init__(self, type=None, status=None, running_time=None, meta_store_type=None, machine_type=None,
                 order_list=None, create_time=None, charge_type=None, deposit_type=None, period=None, k_8s_cluster_id=None,
                 expired_time=None, has_uncompleted_order=None, name=None, create_resource=None, id=None, tags=None,
                 order_task_info=None, fail_reason=None):
        self.type = type  # type: str
        self.status = status  # type: str
        self.running_time = running_time  # type: int
        self.meta_store_type = meta_store_type  # type: str
        self.machine_type = machine_type  # type: str
        self.order_list = order_list  # type: str
        self.create_time = create_time  # type: long
        self.charge_type = charge_type  # type: str
        self.deposit_type = deposit_type  # type: str
        self.period = period  # type: int
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.expired_time = expired_time  # type: long
        self.has_uncompleted_order = has_uncompleted_order  # type: bool
        self.name = name  # type: str
        self.create_resource = create_resource  # type: str
        self.id = id  # type: str
        self.tags = tags  # type: ListClustersResponseBodyClustersClusterInfoTags
        self.order_task_info = order_task_info  # type: ListClustersResponseBodyClustersClusterInfoOrderTaskInfo
        self.fail_reason = fail_reason  # type: ListClustersResponseBodyClustersClusterInfoFailReason

    def validate(self):
        if self.tags:
            self.tags.validate()
        if self.order_task_info:
            self.order_task_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super(ListClustersResponseBodyClustersClusterInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.order_list is not None:
            result['OrderList'] = self.order_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.period is not None:
            result['Period'] = self.period
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.has_uncompleted_order is not None:
            result['HasUncompletedOrder'] = self.has_uncompleted_order
        if self.name is not None:
            result['Name'] = self.name
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.id is not None:
            result['Id'] = self.id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.order_task_info is not None:
            result['OrderTaskInfo'] = self.order_task_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('OrderList') is not None:
            self.order_list = m.get('OrderList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('HasUncompletedOrder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Tags') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('OrderTaskInfo') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoOrderTaskInfo()
            self.order_task_info = temp_model.from_map(m['OrderTaskInfo'])
        if m.get('FailReason') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        return self


class ListClustersResponseBodyClusters(TeaModel):
    def __init__(self, cluster_info=None):
        self.cluster_info = cluster_info  # type: list[ListClustersResponseBodyClustersClusterInfo]

    def validate(self):
        if self.cluster_info:
            for k in self.cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClustersResponseBodyClusters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInfo'] = []
        if self.cluster_info is not None:
            for k in self.cluster_info:
                result['ClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_info = []
        if m.get('ClusterInfo') is not None:
            for k in m.get('ClusterInfo'):
                temp_model = ListClustersResponseBodyClustersClusterInfo()
                self.cluster_info.append(temp_model.from_map(k))
        return self


class ListClustersResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None, clusters=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.clusters = clusters  # type: ListClustersResponseBodyClusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super(ListClustersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Clusters') is not None:
            temp_model = ListClustersResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class ListClustersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClustersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClustersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TagResourcesSystemTagsRequestTags(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(TagResourcesSystemTagsRequestTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class TagResourcesSystemTagsRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_type=None, tag_owner_uid=None, scope=None,
                 tags=None, resource_ids=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        # 资源类型：cluster
        self.resource_type = resource_type  # type: str
        # 主账号UID
        self.tag_owner_uid = tag_owner_uid  # type: long
        self.scope = scope  # type: str
        # 资源标签
        self.tags = tags  # type: list[TagResourcesSystemTagsRequestTags]
        # 资源ID
        self.resource_ids = resource_ids  # type: list[str]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(TagResourcesSystemTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_owner_uid is not None:
            result['TagOwnerUid'] = self.tag_owner_uid
        if self.scope is not None:
            result['Scope'] = self.scope
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TagOwnerUid') is not None:
            self.tag_owner_uid = m.get('TagOwnerUid')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = TagResourcesSystemTagsRequestTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        return self


class TagResourcesSystemTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_code=None, message=None):
        # Id of the request
        self.request_id = request_id  # type: str
        # 请求是否成功被处理
        self.success = success  # type: bool
        # 响应码
        self.code = code  # type: str
        # 错误码
        self.error_code = error_code  # type: str
        # 响应消息
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(TagResourcesSystemTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class TagResourcesSystemTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: TagResourcesSystemTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(TagResourcesSystemTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = TagResourcesSystemTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowJobRequestResourceList(TeaModel):
    def __init__(self, path=None, alias=None):
        self.path = path  # type: str
        self.alias = alias  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowJobRequestResourceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class ModifyFlowJobRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, id=None, name=None, description=None, fail_act=None,
                 retry_policy=None, params=None, param_conf=None, custom_variables=None, env_conf=None, run_conf=None,
                 monitor_conf=None, mode=None, cluster_id=None, alert_conf=None, resource_list=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.fail_act = fail_act  # type: str
        self.retry_policy = retry_policy  # type: str
        self.params = params  # type: str
        self.param_conf = param_conf  # type: str
        self.custom_variables = custom_variables  # type: str
        self.env_conf = env_conf  # type: str
        self.run_conf = run_conf  # type: str
        self.monitor_conf = monitor_conf  # type: str
        self.mode = mode  # type: str
        self.cluster_id = cluster_id  # type: str
        self.alert_conf = alert_conf  # type: str
        self.resource_list = resource_list  # type: list[ModifyFlowJobRequestResourceList]

    def validate(self):
        if self.resource_list:
            for k in self.resource_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ModifyFlowJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.params is not None:
            result['Params'] = self.params
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        result['ResourceList'] = []
        if self.resource_list is not None:
            for k in self.resource_list:
                result['ResourceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        self.resource_list = []
        if m.get('ResourceList') is not None:
            for k in m.get('ResourceList'):
                temp_model = ModifyFlowJobRequestResourceList()
                self.resource_list.append(temp_model.from_map(k))
        return self


class ModifyFlowJobResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyFlowJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyFlowJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowRequest(TeaModel):
    def __init__(self, id=None, project_id=None, region_id=None):
        self.id = id  # type: str
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteFlowResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowEditLockRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, entity_id=None, force=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.entity_id = entity_id  # type: str
        self.force = force  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowEditLockRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.force is not None:
            result['Force'] = self.force
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        return self


class CreateFlowEditLockResponseBody(TeaModel):
    def __init__(self, status=None, request_id=None, entity_id=None, user_id=None, biz_id=None, owner_id=None):
        self.status = status  # type: str
        self.request_id = request_id  # type: str
        self.entity_id = entity_id  # type: str
        self.user_id = user_id  # type: str
        self.biz_id = biz_id  # type: str
        self.owner_id = owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowEditLockResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class CreateFlowEditLockResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFlowEditLockResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowEditLockResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowEditLockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceRequest(TeaModel):
    def __init__(self, project_id=None, id=None, region_id=None):
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceResponseBody(TeaModel):
    def __init__(self, status=None, type=None, env_conf=None, project_id=None, retry_interval=None, job_type=None,
                 mode=None, external_info=None, gmt_modified=None, external_child_ids=None, monitor_conf=None,
                 external_status=None, request_id=None, job_name=None, retry_policy=None, adhoc=None, external_id=None, pending=None,
                 cluster_id=None, max_retry=None, fail_act=None, job_params=None, flow_instance_id=None, param_conf=None,
                 host_name=None, flow_id=None, retries=None, end_time=None, start_time=None, run_conf=None,
                 external_sub_id=None, node_name=None, job_id=None, cluster_name=None, gmt_create=None, duration=None, id=None):
        self.status = status  # type: str
        self.type = type  # type: str
        self.env_conf = env_conf  # type: str
        self.project_id = project_id  # type: str
        self.retry_interval = retry_interval  # type: str
        self.job_type = job_type  # type: str
        self.mode = mode  # type: str
        self.external_info = external_info  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.external_child_ids = external_child_ids  # type: str
        self.monitor_conf = monitor_conf  # type: str
        self.external_status = external_status  # type: str
        self.request_id = request_id  # type: str
        self.job_name = job_name  # type: str
        self.retry_policy = retry_policy  # type: str
        self.adhoc = adhoc  # type: bool
        self.external_id = external_id  # type: str
        self.pending = pending  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.max_retry = max_retry  # type: str
        self.fail_act = fail_act  # type: str
        self.job_params = job_params  # type: str
        self.flow_instance_id = flow_instance_id  # type: str
        self.param_conf = param_conf  # type: str
        self.host_name = host_name  # type: str
        self.flow_id = flow_id  # type: str
        self.retries = retries  # type: int
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.run_conf = run_conf  # type: str
        self.external_sub_id = external_sub_id  # type: str
        self.node_name = node_name  # type: str
        self.job_id = job_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.gmt_create = gmt_create  # type: long
        self.duration = duration  # type: long
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.external_child_ids is not None:
            result['ExternalChildIds'] = self.external_child_ids
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.pending is not None:
            result['Pending'] = self.pending
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.external_sub_id is not None:
            result['ExternalSubId'] = self.external_sub_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ExternalChildIds') is not None:
            self.external_child_ids = m.get('ExternalChildIds')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('Pending') is not None:
            self.pending = m.get('Pending')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('ExternalSubId') is not None:
            self.external_sub_id = m.get('ExternalSubId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeFlowNodeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowNodeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachAndReleaseClusterEniRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, target_cluster_id=None, vswitch_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.target_cluster_id = target_cluster_id  # type: str
        self.vswitch_id = vswitch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachAndReleaseClusterEniRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_cluster_id is not None:
            result['TargetClusterId'] = self.target_cluster_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetClusterId') is not None:
            self.target_cluster_id = m.get('TargetClusterId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class DetachAndReleaseClusterEniResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachAndReleaseClusterEniResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachAndReleaseClusterEniResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DetachAndReleaseClusterEniResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DetachAndReleaseClusterEniResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DetachAndReleaseClusterEniResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingGroupInstanceRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, scaling_group_biz_id=None,
                 host_group_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.host_group_biz_id = host_group_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfigInstanceTypeList(TeaModel):
    def __init__(self, instance_type_list=None):
        self.instance_type_list = instance_type_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingConfigInstanceTypeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type_list is not None:
            result['instanceTypeList'] = self.instance_type_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('instanceTypeList') is not None:
            self.instance_type_list = m.get('instanceTypeList')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimits(TeaModel):
    def __init__(self, instance_type=None, price_limit=None):
        self.instance_type = instance_type  # type: str
        self.price_limit = price_limit  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimits, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.price_limit is not None:
            result['PriceLimit'] = self.price_limit
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('PriceLimit') is not None:
            self.price_limit = m.get('PriceLimit')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimits(TeaModel):
    def __init__(self, spot_price_limits=None):
        self.spot_price_limits = spot_price_limits  # type: list[DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimits]

    def validate(self):
        if self.spot_price_limits:
            for k in self.spot_price_limits:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimits, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['spotPriceLimits'] = []
        if self.spot_price_limits is not None:
            for k in self.spot_price_limits:
                result['spotPriceLimits'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.spot_price_limits = []
        if m.get('spotPriceLimits') is not None:
            for k in m.get('spotPriceLimits'):
                temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimits()
                self.spot_price_limits.append(temp_model.from_map(k))
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfig(TeaModel):
    def __init__(self, spot_strategy=None, pay_type=None, data_disk_category=None, data_disk_size=None,
                 data_disk_count=None, sys_disk_category=None, sys_disk_size=None, instance_type_list=None, spot_price_limits=None):
        self.spot_strategy = spot_strategy  # type: str
        self.pay_type = pay_type  # type: str
        self.data_disk_category = data_disk_category  # type: str
        self.data_disk_size = data_disk_size  # type: long
        self.data_disk_count = data_disk_count  # type: long
        self.sys_disk_category = sys_disk_category  # type: str
        self.sys_disk_size = sys_disk_size  # type: long
        self.instance_type_list = instance_type_list  # type: DescribeScalingGroupInstanceResponseBodyScalingConfigInstanceTypeList
        self.spot_price_limits = spot_price_limits  # type: DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimits

    def validate(self):
        if self.instance_type_list:
            self.instance_type_list.validate()
        if self.spot_price_limits:
            self.spot_price_limits.validate()

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.data_disk_count is not None:
            result['DataDiskCount'] = self.data_disk_count
        if self.sys_disk_category is not None:
            result['SysDiskCategory'] = self.sys_disk_category
        if self.sys_disk_size is not None:
            result['SysDiskSize'] = self.sys_disk_size
        if self.instance_type_list is not None:
            result['InstanceTypeList'] = self.instance_type_list.to_map()
        if self.spot_price_limits is not None:
            result['SpotPriceLimits'] = self.spot_price_limits.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DataDiskCount') is not None:
            self.data_disk_count = m.get('DataDiskCount')
        if m.get('SysDiskCategory') is not None:
            self.sys_disk_category = m.get('SysDiskCategory')
        if m.get('SysDiskSize') is not None:
            self.sys_disk_size = m.get('SysDiskSize')
        if m.get('InstanceTypeList') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfigInstanceTypeList()
            self.instance_type_list = temp_model.from_map(m['InstanceTypeList'])
        if m.get('SpotPriceLimits') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimits()
            self.spot_price_limits = temp_model.from_map(m['SpotPriceLimits'])
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleSchedulerTrigger(TeaModel):
    def __init__(self, launch_time=None, launch_expiration_time=None, recurrence_type=None, recurrence_value=None,
                 recurrence_end_time=None):
        self.launch_time = launch_time  # type: long
        self.launch_expiration_time = launch_expiration_time  # type: long
        self.recurrence_type = recurrence_type  # type: str
        self.recurrence_value = recurrence_value  # type: str
        self.recurrence_end_time = recurrence_end_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleSchedulerTrigger, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleCloudWatchTrigger(TeaModel):
    def __init__(self, metric_name=None, period=None, statistics=None, comparison_operator=None, threshold=None,
                 evaluation_count=None, unit=None, metric_display_name=None):
        self.metric_name = metric_name  # type: str
        self.period = period  # type: long
        self.statistics = statistics  # type: str
        self.comparison_operator = comparison_operator  # type: str
        self.threshold = threshold  # type: str
        self.evaluation_count = evaluation_count  # type: str
        self.unit = unit  # type: str
        self.metric_display_name = metric_display_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleCloudWatchTrigger, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.metric_display_name is not None:
            result['MetricDisplayName'] = self.metric_display_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('MetricDisplayName') is not None:
            self.metric_display_name = m.get('MetricDisplayName')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRule(TeaModel):
    def __init__(self, rule_category=None, ess_scaling_rule_id=None, scaling_group_id=None, rule_name=None,
                 adjustment_type=None, adjustment_value=None, cooldown=None, status=None, launch_time=None,
                 launch_expiration_time=None, recurrence_type=None, recurrence_value=None, recurrence_end_time=None, with_grace=None,
                 timeout_with_grace=None, scheduler_trigger=None, cloud_watch_trigger=None):
        self.rule_category = rule_category  # type: str
        self.ess_scaling_rule_id = ess_scaling_rule_id  # type: str
        self.scaling_group_id = scaling_group_id  # type: long
        self.rule_name = rule_name  # type: str
        self.adjustment_type = adjustment_type  # type: str
        self.adjustment_value = adjustment_value  # type: long
        self.cooldown = cooldown  # type: long
        self.status = status  # type: str
        self.launch_time = launch_time  # type: str
        self.launch_expiration_time = launch_expiration_time  # type: long
        self.recurrence_type = recurrence_type  # type: str
        self.recurrence_value = recurrence_value  # type: str
        self.recurrence_end_time = recurrence_end_time  # type: str
        self.with_grace = with_grace  # type: bool
        self.timeout_with_grace = timeout_with_grace  # type: long
        self.scheduler_trigger = scheduler_trigger  # type: DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleSchedulerTrigger
        self.cloud_watch_trigger = cloud_watch_trigger  # type: DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleCloudWatchTrigger

    def validate(self):
        if self.scheduler_trigger:
            self.scheduler_trigger.validate()
        if self.cloud_watch_trigger:
            self.cloud_watch_trigger.validate()

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_category is not None:
            result['RuleCategory'] = self.rule_category
        if self.ess_scaling_rule_id is not None:
            result['EssScalingRuleId'] = self.ess_scaling_rule_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.adjustment_type is not None:
            result['AdjustmentType'] = self.adjustment_type
        if self.adjustment_value is not None:
            result['AdjustmentValue'] = self.adjustment_value
        if self.cooldown is not None:
            result['Cooldown'] = self.cooldown
        if self.status is not None:
            result['Status'] = self.status
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        if self.scheduler_trigger is not None:
            result['SchedulerTrigger'] = self.scheduler_trigger.to_map()
        if self.cloud_watch_trigger is not None:
            result['CloudWatchTrigger'] = self.cloud_watch_trigger.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleCategory') is not None:
            self.rule_category = m.get('RuleCategory')
        if m.get('EssScalingRuleId') is not None:
            self.ess_scaling_rule_id = m.get('EssScalingRuleId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('AdjustmentType') is not None:
            self.adjustment_type = m.get('AdjustmentType')
        if m.get('AdjustmentValue') is not None:
            self.adjustment_value = m.get('AdjustmentValue')
        if m.get('Cooldown') is not None:
            self.cooldown = m.get('Cooldown')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        if m.get('SchedulerTrigger') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleSchedulerTrigger()
            self.scheduler_trigger = temp_model.from_map(m['SchedulerTrigger'])
        if m.get('CloudWatchTrigger') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleCloudWatchTrigger()
            self.cloud_watch_trigger = temp_model.from_map(m['CloudWatchTrigger'])
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleList(TeaModel):
    def __init__(self, scaling_rule=None):
        self.scaling_rule = scaling_rule  # type: list[DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRule]

    def validate(self):
        if self.scaling_rule:
            for k in self.scaling_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBodyScalingRuleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ScalingRule'] = []
        if self.scaling_rule is not None:
            for k in self.scaling_rule:
                result['ScalingRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.scaling_rule = []
        if m.get('ScalingRule') is not None:
            for k in m.get('ScalingRule'):
                temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRule()
                self.scaling_rule.append(temp_model.from_map(k))
        return self


class DescribeScalingGroupInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, host_group_id=None, scaling_group_id=None, min_size=None, max_size=None,
                 default_cooldown=None, active_rule_category=None, with_grace=None, timeout_with_grace=None,
                 multi_available_policy=None, multi_available_policy_param=None, scaling_config=None, scaling_rule_list=None):
        # Id of the request
        self.request_id = request_id  # type: str
        self.host_group_id = host_group_id  # type: str
        self.scaling_group_id = scaling_group_id  # type: str
        self.min_size = min_size  # type: long
        self.max_size = max_size  # type: long
        self.default_cooldown = default_cooldown  # type: long
        self.active_rule_category = active_rule_category  # type: str
        self.with_grace = with_grace  # type: bool
        self.timeout_with_grace = timeout_with_grace  # type: long
        self.multi_available_policy = multi_available_policy  # type: str
        self.multi_available_policy_param = multi_available_policy_param  # type: str
        self.scaling_config = scaling_config  # type: DescribeScalingGroupInstanceResponseBodyScalingConfig
        self.scaling_rule_list = scaling_rule_list  # type: DescribeScalingGroupInstanceResponseBodyScalingRuleList

    def validate(self):
        if self.scaling_config:
            self.scaling_config.validate()
        if self.scaling_rule_list:
            self.scaling_rule_list.validate()

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.min_size is not None:
            result['MinSize'] = self.min_size
        if self.max_size is not None:
            result['MaxSize'] = self.max_size
        if self.default_cooldown is not None:
            result['DefaultCooldown'] = self.default_cooldown
        if self.active_rule_category is not None:
            result['ActiveRuleCategory'] = self.active_rule_category
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        if self.multi_available_policy is not None:
            result['MultiAvailablePolicy'] = self.multi_available_policy
        if self.multi_available_policy_param is not None:
            result['MultiAvailablePolicyParam'] = self.multi_available_policy_param
        if self.scaling_config is not None:
            result['ScalingConfig'] = self.scaling_config.to_map()
        if self.scaling_rule_list is not None:
            result['ScalingRuleList'] = self.scaling_rule_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('MinSize') is not None:
            self.min_size = m.get('MinSize')
        if m.get('MaxSize') is not None:
            self.max_size = m.get('MaxSize')
        if m.get('DefaultCooldown') is not None:
            self.default_cooldown = m.get('DefaultCooldown')
        if m.get('ActiveRuleCategory') is not None:
            self.active_rule_category = m.get('ActiveRuleCategory')
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        if m.get('MultiAvailablePolicy') is not None:
            self.multi_available_policy = m.get('MultiAvailablePolicy')
        if m.get('MultiAvailablePolicyParam') is not None:
            self.multi_available_policy_param = m.get('MultiAvailablePolicyParam')
        if m.get('ScalingConfig') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfig()
            self.scaling_config = temp_model.from_map(m['ScalingConfig'])
        if m.get('ScalingRuleList') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleList()
            self.scaling_rule_list = temp_model.from_map(m['ScalingRuleList'])
        return self


class DescribeScalingGroupInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeScalingGroupInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeScalingGroupInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterHostGroupRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, host_group_name=None,
                 host_group_type=None, comment=None, pay_type=None, vswitch_id=None, security_group_id=None, host_group_params=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.host_group_name = host_group_name  # type: str
        self.host_group_type = host_group_type  # type: str
        self.comment = comment  # type: str
        self.pay_type = pay_type  # type: str
        self.vswitch_id = vswitch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.host_group_params = host_group_params  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterHostGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.host_group_params is not None:
            result['HostGroupParams'] = self.host_group_params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('HostGroupParams') is not None:
            self.host_group_params = m.get('HostGroupParams')
        return self


class CreateClusterHostGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, cluster_id=None, host_group_id=None):
        # Id of the request
        self.request_id = request_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.host_group_id = host_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterHostGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        return self


class CreateClusterHostGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateClusterHostGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateClusterHostGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterTemplateRequest(TeaModel):
    def __init__(self, resource_owner_id=None, biz_id=None, resource_group_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.biz_id = biz_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(self, path=None, name=None, arg=None):
        self.path = path  # type: str
        self.name = name  # type: str
        self.arg = arg  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.arg is not None:
            result['Arg'] = self.arg
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList(TeaModel):
    def __init__(self, bootstrap_action=None):
        self.bootstrap_action = bootstrap_action  # type: list[DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction]

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup(TeaModel):
    def __init__(self, sys_disk_capacity=None, host_group_type=None, multi_instance_types=None, sys_disk_type=None,
                 charge_type=None, disk_type=None, host_group_id=None, instance_type=None, disk_count=None, period=None,
                 disk_capacity=None, node_count=None, host_group_name=None):
        self.sys_disk_capacity = sys_disk_capacity  # type: int
        self.host_group_type = host_group_type  # type: str
        self.multi_instance_types = multi_instance_types  # type: str
        self.sys_disk_type = sys_disk_type  # type: str
        self.charge_type = charge_type  # type: str
        self.disk_type = disk_type  # type: str
        self.host_group_id = host_group_id  # type: str
        self.instance_type = instance_type  # type: str
        self.disk_count = disk_count  # type: int
        self.period = period  # type: str
        self.disk_capacity = disk_capacity  # type: int
        self.node_count = node_count  # type: int
        self.host_group_name = host_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList(TeaModel):
    def __init__(self, host_group=None):
        self.host_group = host_group  # type: list[DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup]

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig(TeaModel):
    def __init__(self, config_value=None, replace=None, file_name=None, service_name=None, config_key=None,
                 encrypt=None):
        self.config_value = config_value  # type: str
        self.replace = replace  # type: str
        self.file_name = file_name  # type: str
        self.service_name = service_name  # type: str
        self.config_key = config_key  # type: str
        self.encrypt = encrypt  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig]

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoTagsTag(TeaModel):
    def __init__(self, tag_value=None, tag_key=None):
        self.tag_value = tag_value  # type: str
        self.tag_key = tag_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeClusterTemplateResponseBodyTemplateInfoTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList(TeaModel):
    def __init__(self, software_info=None):
        self.software_info = software_info  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SoftwareInfo') is not None:
            self.software_info = m.get('SoftwareInfo')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfo(TeaModel):
    def __init__(self, vpc_id=None, key_pair_name=None, log_enable=None, ssh_enable=None,
                 high_availability_enable=None, security_group_id=None, master_pwd=None, user_id=None, is_open_public_ip=None,
                 allow_notebook=None, gmt_modified=None, template_name=None, deposit_type=None, security_group_name=None,
                 create_source=None, instance_generation=None, use_custom_hive_meta_db=None, eas_enable=None,
                 user_defined_emr_ecs_role=None, meta_store_type=None, machine_type=None, use_local_meta_db=None, master_node_total=None,
                 init_custom_hive_meta_db=None, io_optimized=None, meta_store_conf=None, v_switch_id=None, configurations=None, emr_ver=None,
                 log_path=None, cluster_type=None, net_type=None, zone_id=None, gmt_create=None, id=None,
                 bootstrap_action_list=None, host_group_list=None, config_list=None, tags=None, software_info_list=None):
        self.vpc_id = vpc_id  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.log_enable = log_enable  # type: bool
        self.ssh_enable = ssh_enable  # type: bool
        self.high_availability_enable = high_availability_enable  # type: bool
        self.security_group_id = security_group_id  # type: str
        self.master_pwd = master_pwd  # type: str
        self.user_id = user_id  # type: str
        self.is_open_public_ip = is_open_public_ip  # type: bool
        self.allow_notebook = allow_notebook  # type: bool
        self.gmt_modified = gmt_modified  # type: long
        self.template_name = template_name  # type: str
        self.deposit_type = deposit_type  # type: str
        self.security_group_name = security_group_name  # type: str
        self.create_source = create_source  # type: str
        self.instance_generation = instance_generation  # type: str
        self.use_custom_hive_meta_db = use_custom_hive_meta_db  # type: bool
        self.eas_enable = eas_enable  # type: bool
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role  # type: str
        self.meta_store_type = meta_store_type  # type: str
        self.machine_type = machine_type  # type: str
        self.use_local_meta_db = use_local_meta_db  # type: bool
        self.master_node_total = master_node_total  # type: int
        self.init_custom_hive_meta_db = init_custom_hive_meta_db  # type: bool
        self.io_optimized = io_optimized  # type: bool
        self.meta_store_conf = meta_store_conf  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.configurations = configurations  # type: str
        self.emr_ver = emr_ver  # type: str
        self.log_path = log_path  # type: str
        self.cluster_type = cluster_type  # type: str
        self.net_type = net_type  # type: str
        self.zone_id = zone_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.id = id  # type: str
        self.bootstrap_action_list = bootstrap_action_list  # type: DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList
        self.host_group_list = host_group_list  # type: DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList
        self.config_list = config_list  # type: DescribeClusterTemplateResponseBodyTemplateInfoConfigList
        self.tags = tags  # type: DescribeClusterTemplateResponseBodyTemplateInfoTags
        self.software_info_list = software_info_list  # type: DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList

    def validate(self):
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.host_group_list:
            self.host_group_list.validate()
        if self.config_list:
            self.config_list.validate()
        if self.tags:
            self.tags.validate()
        if self.software_info_list:
            self.software_info_list.validate()

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBodyTemplateInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.allow_notebook is not None:
            result['AllowNotebook'] = self.allow_notebook
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.software_info_list is not None:
            result['SoftwareInfoList'] = self.software_info_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('SshEnable') is not None:
            self.ssh_enable = m.get('SshEnable')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('AllowNotebook') is not None:
            self.allow_notebook = m.get('AllowNotebook')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('HostGroupList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('ConfigList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        if m.get('Tags') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('SoftwareInfoList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList()
            self.software_info_list = temp_model.from_map(m['SoftwareInfoList'])
        return self


class DescribeClusterTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_info=None):
        self.request_id = request_id  # type: str
        self.template_info = template_info  # type: DescribeClusterTemplateResponseBodyTemplateInfo

    def validate(self):
        if self.template_info:
            self.template_info.validate()

    def to_map(self):
        _map = super(DescribeClusterTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_info is not None:
            result['TemplateInfo'] = self.template_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateInfo') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfo()
            self.template_info = temp_model.from_map(m['TemplateInfo'])
        return self


class DescribeClusterTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeClusterTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TagResourcesRequestTags(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(TagResourcesRequestTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class TagResourcesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, resource_type=None,
                 resource_ids=None, tags=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        # 资源类型
        self.resource_type = resource_type  # type: str
        # 资源ID
        self.resource_ids = resource_ids  # type: list[str]
        # 标签列表
        self.tags = tags  # type: list[TagResourcesRequestTags]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(TagResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = TagResourcesRequestTags()
                self.tags.append(temp_model.from_map(k))
        return self


class TagResourcesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_code=None, message=None):
        # Id of the request
        self.request_id = request_id  # type: str
        # 请求是否成功被处理
        self.success = success  # type: bool
        # 响应码
        self.code = code  # type: str
        # 错误码
        self.error_code = error_code  # type: str
        # 响应消息
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(TagResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class TagResourcesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: TagResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(TagResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = TagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommitFlowEntitySnapshotRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, entity_type=None, entity_id=None, message=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.entity_type = entity_type  # type: str
        self.entity_id = entity_id  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommitFlowEntitySnapshotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class CommitFlowEntitySnapshotResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommitFlowEntitySnapshotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CommitFlowEntitySnapshotResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CommitFlowEntitySnapshotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CommitFlowEntitySnapshotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CommitFlowEntitySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitFlowJobRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, job_id=None, cluster_id=None, host_name=None, conf=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.job_id = job_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.host_name = host_name  # type: str
        self.conf = conf  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitFlowJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.conf is not None:
            result['Conf'] = self.conf
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Conf') is not None:
            self.conf = m.get('Conf')
        return self


class SubmitFlowJobResponseBody(TeaModel):
    def __init__(self, id=None, request_id=None):
        self.id = id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitFlowJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SubmitFlowJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitFlowJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitFlowJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowJobHistoryRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, id=None, job_type=None, instance_id=None, time_range=None,
                 page_number=None, page_size=None, status_list=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.job_type = job_type  # type: str
        self.instance_id = instance_id  # type: str
        self.time_range = time_range  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.status_list = status_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowJobHistoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.time_range is not None:
            result['TimeRange'] = self.time_range
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TimeRange') is not None:
            self.time_range = m.get('TimeRange')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListFlowJobHistoryResponseBodyNodeInstancesNodeInstance(TeaModel):
    def __init__(self, type=None, status=None, pending=None, env_conf=None, retry_interval=None, project_id=None,
                 job_type=None, gmt_modified=None, external_info=None, external_status=None, job_name=None, external_id=None,
                 max_retry=None, cluster_id=None, fail_act=None, job_params=None, param_conf=None, host_name=None,
                 retries=None, end_time=None, start_time=None, run_conf=None, node_name=None, job_id=None, gmt_create=None,
                 id=None):
        self.type = type  # type: str
        self.status = status  # type: str
        self.pending = pending  # type: bool
        self.env_conf = env_conf  # type: str
        self.retry_interval = retry_interval  # type: long
        self.project_id = project_id  # type: str
        self.job_type = job_type  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.external_info = external_info  # type: str
        self.external_status = external_status  # type: str
        self.job_name = job_name  # type: str
        self.external_id = external_id  # type: str
        self.max_retry = max_retry  # type: int
        self.cluster_id = cluster_id  # type: str
        self.fail_act = fail_act  # type: str
        self.job_params = job_params  # type: str
        self.param_conf = param_conf  # type: str
        self.host_name = host_name  # type: str
        self.retries = retries  # type: int
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.run_conf = run_conf  # type: str
        self.node_name = node_name  # type: str
        self.job_id = job_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowJobHistoryResponseBodyNodeInstancesNodeInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.pending is not None:
            result['pending'] = self.pending
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('pending') is not None:
            self.pending = m.get('pending')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListFlowJobHistoryResponseBodyNodeInstances(TeaModel):
    def __init__(self, node_instance=None):
        self.node_instance = node_instance  # type: list[ListFlowJobHistoryResponseBodyNodeInstancesNodeInstance]

    def validate(self):
        if self.node_instance:
            for k in self.node_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowJobHistoryResponseBodyNodeInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeInstance'] = []
        if self.node_instance is not None:
            for k in self.node_instance:
                result['NodeInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node_instance = []
        if m.get('NodeInstance') is not None:
            for k in m.get('NodeInstance'):
                temp_model = ListFlowJobHistoryResponseBodyNodeInstancesNodeInstance()
                self.node_instance.append(temp_model.from_map(k))
        return self


class ListFlowJobHistoryResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total=None, node_instances=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.node_instances = node_instances  # type: ListFlowJobHistoryResponseBodyNodeInstances

    def validate(self):
        if self.node_instances:
            self.node_instances.validate()

    def to_map(self):
        _map = super(ListFlowJobHistoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.node_instances is not None:
            result['NodeInstances'] = self.node_instances.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('NodeInstances') is not None:
            temp_model = ListFlowJobHistoryResponseBodyNodeInstances()
            self.node_instances = temp_model.from_map(m['NodeInstances'])
        return self


class ListFlowJobHistoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowJobHistoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowJobHistoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowJobHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagResourcesRequestTags(TeaModel):
    def __init__(self, key=None, value=None):
        # 标签键
        self.key = key  # type: str
        # 标签值
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagResourcesRequestTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, resource_type=None,
                 resource_ids=None, tags=None, next_token=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_type = resource_type  # type: str
        # 资源组ID
        self.resource_ids = resource_ids  # type: list[str]
        # 标签
        self.tags = tags  # type: list[ListTagResourcesRequestTags]
        self.next_token = next_token  # type: str

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListTagResourcesRequestTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListTagResourcesResponseBodyData(TeaModel):
    def __init__(self, tag_key=None, tag_value=None, resource_type=None, resource_id=None):
        # 标签键
        self.tag_key = tag_key  # type: str
        # 标签值
        self.tag_value = tag_value  # type: str
        # 资源类型
        self.resource_type = resource_type  # type: str
        # 资源ID
        self.resource_id = resource_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagResourcesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class ListTagResourcesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_code=None, message=None, data=None):
        # Id of the request
        self.request_id = request_id  # type: str
        # 请求是否成功被处理
        self.success = success  # type: bool
        # 响应码
        self.code = code  # type: str
        # 错误码
        self.error_code = error_code  # type: str
        # 响应消息
        self.message = message  # type: str
        self.data = data  # type: list[ListTagResourcesResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListTagResourcesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListTagResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHostComponentRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, host_instance_id=None,
                 host_name=None, service_name=None, component_name=None, component_status=None, host_role=None,
                 page_number=None, page_size=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.host_name = host_name  # type: str
        self.service_name = service_name  # type: str
        self.component_name = component_name  # type: str
        self.component_status = component_status  # type: str
        self.host_role = host_role  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterHostComponentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_status is not None:
            result['ComponentStatus'] = self.component_status
        if self.host_role is not None:
            result['HostRole'] = self.host_role
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentStatus') is not None:
            self.component_status = m.get('ComponentStatus')
        if m.get('HostRole') is not None:
            self.host_role = m.get('HostRole')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterHostComponentResponseBodyComponentListComponent(TeaModel):
    def __init__(self, serial_number=None, status=None, service_display_name=None, private_ip=None,
                 server_status=None, component_name=None, commission_status=None, host_name=None, instance_type=None,
                 need_restart=None, host_id=None, host_instance_id=None, cpu=None, component_display_name=None, public_ip=None,
                 memory=None, role=None, service_name=None):
        self.serial_number = serial_number  # type: str
        self.status = status  # type: str
        self.service_display_name = service_display_name  # type: str
        self.private_ip = private_ip  # type: str
        self.server_status = server_status  # type: str
        self.component_name = component_name  # type: str
        self.commission_status = commission_status  # type: str
        self.host_name = host_name  # type: str
        self.instance_type = instance_type  # type: str
        self.need_restart = need_restart  # type: bool
        self.host_id = host_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.cpu = cpu  # type: int
        self.component_display_name = component_display_name  # type: str
        self.public_ip = public_ip  # type: str
        self.memory = memory  # type: int
        self.role = role  # type: str
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterHostComponentResponseBodyComponentListComponent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.status is not None:
            result['Status'] = self.status
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.server_status is not None:
            result['ServerStatus'] = self.server_status
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.commission_status is not None:
            result['CommissionStatus'] = self.commission_status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.need_restart is not None:
            result['NeedRestart'] = self.need_restart
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.component_display_name is not None:
            result['ComponentDisplayName'] = self.component_display_name
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.role is not None:
            result['Role'] = self.role
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('ServerStatus') is not None:
            self.server_status = m.get('ServerStatus')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('CommissionStatus') is not None:
            self.commission_status = m.get('CommissionStatus')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NeedRestart') is not None:
            self.need_restart = m.get('NeedRestart')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('ComponentDisplayName') is not None:
            self.component_display_name = m.get('ComponentDisplayName')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListClusterHostComponentResponseBodyComponentList(TeaModel):
    def __init__(self, component=None):
        self.component = component  # type: list[ListClusterHostComponentResponseBodyComponentListComponent]

    def validate(self):
        if self.component:
            for k in self.component:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterHostComponentResponseBodyComponentList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Component'] = []
        if self.component is not None:
            for k in self.component:
                result['Component'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.component = []
        if m.get('Component') is not None:
            for k in m.get('Component'):
                temp_model = ListClusterHostComponentResponseBodyComponentListComponent()
                self.component.append(temp_model.from_map(k))
        return self


class ListClusterHostComponentResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total=None, component_list=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.component_list = component_list  # type: ListClusterHostComponentResponseBodyComponentList

    def validate(self):
        if self.component_list:
            self.component_list.validate()

    def to_map(self):
        _map = super(ListClusterHostComponentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.component_list is not None:
            result['ComponentList'] = self.component_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ComponentList') is not None:
            temp_model = ListClusterHostComponentResponseBodyComponentList()
            self.component_list = temp_model.from_map(m['ComponentList'])
        return self


class ListClusterHostComponentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterHostComponentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterHostComponentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterHostComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyScalingGroupRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, name=None, description=None,
                 scaling_group_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyScalingGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        return self


class ModifyScalingGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        # requestId
        self.request_id = request_id  # type: str
        # data
        self.data = data  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyScalingGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ModifyScalingGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyScalingGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyScalingGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowProjectClusterSettingRequest(TeaModel):
    def __init__(self, project_id=None, region_id=None, cluster_id=None):
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowProjectClusterSettingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeFlowProjectClusterSettingResponseBodyQueueList(TeaModel):
    def __init__(self, queue=None):
        self.queue = queue  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowProjectClusterSettingResponseBodyQueueList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class DescribeFlowProjectClusterSettingResponseBodyUserList(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowProjectClusterSettingResponseBodyUserList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeFlowProjectClusterSettingResponseBodyHostList(TeaModel):
    def __init__(self, host=None):
        self.host = host  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowProjectClusterSettingResponseBodyHostList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        return self


class DescribeFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(self, request_id=None, k_8s_cluster_id=None, default_queue=None, project_id=None, gmt_create=None,
                 default_user=None, gmt_modified=None, cluster_id=None, queue_list=None, user_list=None, host_list=None):
        self.request_id = request_id  # type: str
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.default_queue = default_queue  # type: str
        self.project_id = project_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.default_user = default_user  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.cluster_id = cluster_id  # type: str
        self.queue_list = queue_list  # type: DescribeFlowProjectClusterSettingResponseBodyQueueList
        self.user_list = user_list  # type: DescribeFlowProjectClusterSettingResponseBodyUserList
        self.host_list = host_list  # type: DescribeFlowProjectClusterSettingResponseBodyHostList

    def validate(self):
        if self.queue_list:
            self.queue_list.validate()
        if self.user_list:
            self.user_list.validate()
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super(DescribeFlowProjectClusterSettingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list.to_map()
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('QueueList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyQueueList()
            self.queue_list = temp_model.from_map(m['QueueList'])
        if m.get('UserList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        if m.get('HostList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class DescribeFlowProjectClusterSettingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowProjectClusterSettingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowProjectClusterSettingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowProjectClusterSettingRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, page_number=None, page_size=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingQueueList(TeaModel):
    def __init__(self, queue=None):
        self.queue = queue  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingQueueList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingUserList(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingUserList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingHostList(TeaModel):
    def __init__(self, host=None):
        self.host = host  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingHostList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSetting(TeaModel):
    def __init__(self, k_8s_cluster_id=None, default_queue=None, project_id=None, gmt_create=None,
                 cluster_name=None, default_user=None, gmt_modified=None, cluster_id=None, queue_list=None, user_list=None,
                 host_list=None):
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.default_queue = default_queue  # type: str
        self.project_id = project_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.cluster_name = cluster_name  # type: str
        self.default_user = default_user  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.cluster_id = cluster_id  # type: str
        self.queue_list = queue_list  # type: ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingQueueList
        self.user_list = user_list  # type: ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingUserList
        self.host_list = host_list  # type: ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingHostList

    def validate(self):
        if self.queue_list:
            self.queue_list.validate()
        if self.user_list:
            self.user_list.validate()
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSetting, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list.to_map()
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('QueueList') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingQueueList()
            self.queue_list = temp_model.from_map(m['QueueList'])
        if m.get('UserList') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        if m.get('HostList') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettings(TeaModel):
    def __init__(self, cluster_setting=None):
        self.cluster_setting = cluster_setting  # type: list[ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSetting]

    def validate(self):
        if self.cluster_setting:
            for k in self.cluster_setting:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingResponseBodyClusterSettings, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterSetting'] = []
        if self.cluster_setting is not None:
            for k in self.cluster_setting:
                result['ClusterSetting'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_setting = []
        if m.get('ClusterSetting') is not None:
            for k in m.get('ClusterSetting'):
                temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSetting()
                self.cluster_setting.append(temp_model.from_map(k))
        return self


class ListFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total=None, cluster_settings=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.cluster_settings = cluster_settings  # type: ListFlowProjectClusterSettingResponseBodyClusterSettings

    def validate(self):
        if self.cluster_settings:
            self.cluster_settings.validate()

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.cluster_settings is not None:
            result['ClusterSettings'] = self.cluster_settings.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ClusterSettings') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettings()
            self.cluster_settings = temp_model.from_map(m['ClusterSettings'])
        return self


class ListFlowProjectClusterSettingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowProjectClusterSettingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowProjectClusterSettingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, flow_id=None, conf=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.flow_id = flow_id  # type: str
        self.conf = conf  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.conf is not None:
            result['Conf'] = self.conf
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('Conf') is not None:
            self.conf = m.get('Conf')
        return self


class SubmitFlowResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, instance_id=None, id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.instance_id = instance_id  # type: str
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class SubmitFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingCommonConfigRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None):
        # ResourceOwnerId
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingCommonConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeScalingCommonConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, auto_scaling_hook_heartbeat_default_time=None,
                 auto_scaling_cool_down_time=None, auto_scaling_mnsscaling_thread_sleep_time=None, auto_scaling_group_min_size_limit=None,
                 auto_scaling_group_max_size_limit=None, auto_scaling_rule_min_delay_limit=None, auto_scaling_rule_alarm_delay_limit=None,
                 auto_scaling_rule_alarm_silent_time=None, auto_scaling_config_system_disk_size=None,
                 auto_scaling_config_decommission_query_interval=None):
        # requestId
        self.request_id = request_id  # type: str
        # autoScalingHookHeartbeatDefaultTime
        self.auto_scaling_hook_heartbeat_default_time = auto_scaling_hook_heartbeat_default_time  # type: long
        self.auto_scaling_cool_down_time = auto_scaling_cool_down_time  # type: long
        self.auto_scaling_mnsscaling_thread_sleep_time = auto_scaling_mnsscaling_thread_sleep_time  # type: long
        self.auto_scaling_group_min_size_limit = auto_scaling_group_min_size_limit  # type: long
        self.auto_scaling_group_max_size_limit = auto_scaling_group_max_size_limit  # type: long
        self.auto_scaling_rule_min_delay_limit = auto_scaling_rule_min_delay_limit  # type: long
        self.auto_scaling_rule_alarm_delay_limit = auto_scaling_rule_alarm_delay_limit  # type: long
        self.auto_scaling_rule_alarm_silent_time = auto_scaling_rule_alarm_silent_time  # type: long
        self.auto_scaling_config_system_disk_size = auto_scaling_config_system_disk_size  # type: long
        self.auto_scaling_config_decommission_query_interval = auto_scaling_config_decommission_query_interval  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingCommonConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.auto_scaling_hook_heartbeat_default_time is not None:
            result['AutoScalingHookHeartbeatDefaultTime'] = self.auto_scaling_hook_heartbeat_default_time
        if self.auto_scaling_cool_down_time is not None:
            result['AutoScalingCoolDownTime'] = self.auto_scaling_cool_down_time
        if self.auto_scaling_mnsscaling_thread_sleep_time is not None:
            result['AutoScalingMNSScalingThreadSleepTime'] = self.auto_scaling_mnsscaling_thread_sleep_time
        if self.auto_scaling_group_min_size_limit is not None:
            result['AutoScalingGroupMinSizeLimit'] = self.auto_scaling_group_min_size_limit
        if self.auto_scaling_group_max_size_limit is not None:
            result['AutoScalingGroupMaxSizeLimit'] = self.auto_scaling_group_max_size_limit
        if self.auto_scaling_rule_min_delay_limit is not None:
            result['AutoScalingRuleMinDelayLimit'] = self.auto_scaling_rule_min_delay_limit
        if self.auto_scaling_rule_alarm_delay_limit is not None:
            result['AutoScalingRuleAlarmDelayLimit'] = self.auto_scaling_rule_alarm_delay_limit
        if self.auto_scaling_rule_alarm_silent_time is not None:
            result['AutoScalingRuleAlarmSilentTime'] = self.auto_scaling_rule_alarm_silent_time
        if self.auto_scaling_config_system_disk_size is not None:
            result['AutoScalingConfigSystemDiskSize'] = self.auto_scaling_config_system_disk_size
        if self.auto_scaling_config_decommission_query_interval is not None:
            result['AutoScalingConfigDecommissionQueryInterval'] = self.auto_scaling_config_decommission_query_interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('AutoScalingHookHeartbeatDefaultTime') is not None:
            self.auto_scaling_hook_heartbeat_default_time = m.get('AutoScalingHookHeartbeatDefaultTime')
        if m.get('AutoScalingCoolDownTime') is not None:
            self.auto_scaling_cool_down_time = m.get('AutoScalingCoolDownTime')
        if m.get('AutoScalingMNSScalingThreadSleepTime') is not None:
            self.auto_scaling_mnsscaling_thread_sleep_time = m.get('AutoScalingMNSScalingThreadSleepTime')
        if m.get('AutoScalingGroupMinSizeLimit') is not None:
            self.auto_scaling_group_min_size_limit = m.get('AutoScalingGroupMinSizeLimit')
        if m.get('AutoScalingGroupMaxSizeLimit') is not None:
            self.auto_scaling_group_max_size_limit = m.get('AutoScalingGroupMaxSizeLimit')
        if m.get('AutoScalingRuleMinDelayLimit') is not None:
            self.auto_scaling_rule_min_delay_limit = m.get('AutoScalingRuleMinDelayLimit')
        if m.get('AutoScalingRuleAlarmDelayLimit') is not None:
            self.auto_scaling_rule_alarm_delay_limit = m.get('AutoScalingRuleAlarmDelayLimit')
        if m.get('AutoScalingRuleAlarmSilentTime') is not None:
            self.auto_scaling_rule_alarm_silent_time = m.get('AutoScalingRuleAlarmSilentTime')
        if m.get('AutoScalingConfigSystemDiskSize') is not None:
            self.auto_scaling_config_system_disk_size = m.get('AutoScalingConfigSystemDiskSize')
        if m.get('AutoScalingConfigDecommissionQueryInterval') is not None:
            self.auto_scaling_config_decommission_query_interval = m.get('AutoScalingConfigDecommissionQueryInterval')
        return self


class DescribeScalingCommonConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeScalingCommonConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeScalingCommonConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingCommonConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResumeFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, flow_instance_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.flow_instance_id = flow_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResumeFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        return self


class ResumeFlowResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResumeFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ResumeFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ResumeFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ResumeFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResumeFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RestoreFlowEntitySnapshotRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, operator_id=None, entity_type=None, entity_id=None,
                 revision=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.operator_id = operator_id  # type: str
        self.entity_type = entity_type  # type: str
        self.entity_id = entity_id  # type: str
        self.revision = revision  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RestoreFlowEntitySnapshotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.revision is not None:
            result['Revision'] = self.revision
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Revision') is not None:
            self.revision = m.get('Revision')
        return self


class RestoreFlowEntitySnapshotResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RestoreFlowEntitySnapshotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RestoreFlowEntitySnapshotResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RestoreFlowEntitySnapshotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RestoreFlowEntitySnapshotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RestoreFlowEntitySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLibraryRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, client_token=None, type=None, name=None,
                 library_version=None, source_type=None, source_location=None, scope=None, properties=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.client_token = client_token  # type: str
        self.type = type  # type: str
        self.name = name  # type: str
        self.library_version = library_version  # type: str
        self.source_type = source_type  # type: str
        self.source_location = source_location  # type: str
        self.scope = scope  # type: str
        self.properties = properties  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLibraryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.library_version is not None:
            result['LibraryVersion'] = self.library_version
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_location is not None:
            result['SourceLocation'] = self.source_location
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.properties is not None:
            result['Properties'] = self.properties
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('LibraryVersion') is not None:
            self.library_version = m.get('LibraryVersion')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceLocation') is not None:
            self.source_location = m.get('SourceLocation')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        return self


class CreateLibraryResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLibraryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLibraryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateLibraryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLibraryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLibraryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListVswitchRequest(TeaModel):
    def __init__(self, region_id=None, vpc_id=None, zone_id=None, deposit_type=None, product_type=None):
        self.region_id = region_id  # type: str
        self.vpc_id = vpc_id  # type: str
        self.zone_id = zone_id  # type: str
        self.deposit_type = deposit_type  # type: str
        self.product_type = product_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListVswitchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        return self


class ListVswitchResponseBodyVswitchListVswitch(TeaModel):
    def __init__(self, creation_time=None, status=None, vpc_id=None, is_default=None, v_switch_id=None,
                 cidr_block=None, description=None, available_ip_address_count=None, resource_group_id=None, zone_id=None,
                 v_switch_name=None):
        self.creation_time = creation_time  # type: str
        self.status = status  # type: str
        self.vpc_id = vpc_id  # type: str
        self.is_default = is_default  # type: bool
        self.v_switch_id = v_switch_id  # type: str
        self.cidr_block = cidr_block  # type: str
        self.description = description  # type: str
        self.available_ip_address_count = available_ip_address_count  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.zone_id = zone_id  # type: str
        self.v_switch_name = v_switch_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListVswitchResponseBodyVswitchListVswitch, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.available_ip_address_count is not None:
            result['AvailableIpAddressCount'] = self.available_ip_address_count
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AvailableIpAddressCount') is not None:
            self.available_ip_address_count = m.get('AvailableIpAddressCount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        return self


class ListVswitchResponseBodyVswitchList(TeaModel):
    def __init__(self, vswitch=None):
        self.vswitch = vswitch  # type: list[ListVswitchResponseBodyVswitchListVswitch]

    def validate(self):
        if self.vswitch:
            for k in self.vswitch:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListVswitchResponseBodyVswitchList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Vswitch'] = []
        if self.vswitch is not None:
            for k in self.vswitch:
                result['Vswitch'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.vswitch = []
        if m.get('Vswitch') is not None:
            for k in m.get('Vswitch'):
                temp_model = ListVswitchResponseBodyVswitchListVswitch()
                self.vswitch.append(temp_model.from_map(k))
        return self


class ListVswitchResponseBody(TeaModel):
    def __init__(self, request_id=None, vswitch_list=None):
        self.request_id = request_id  # type: str
        self.vswitch_list = vswitch_list  # type: ListVswitchResponseBodyVswitchList

    def validate(self):
        if self.vswitch_list:
            self.vswitch_list.validate()

    def to_map(self):
        _map = super(ListVswitchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vswitch_list is not None:
            result['VswitchList'] = self.vswitch_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VswitchList') is not None:
            temp_model = ListVswitchResponseBodyVswitchList()
            self.vswitch_list = temp_model.from_map(m['VswitchList'])
        return self


class ListVswitchResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListVswitchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListVswitchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListVswitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteFlowProjectResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowProjectResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFlowProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFlowProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReleaseClusterRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, id=None, force_release=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.id = id  # type: str
        self.force_release = force_release  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReleaseClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.force_release is not None:
            result['ForceRelease'] = self.force_release
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ForceRelease') is not None:
            self.force_release = m.get('ForceRelease')
        return self


class ReleaseClusterResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReleaseClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ReleaseClusterResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ReleaseClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ReleaseClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReleaseClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddScalingConfigItemRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, scaling_group_biz_id=None,
                 config_item_type=None, config_item_information=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.config_item_type = config_item_type  # type: str
        self.config_item_information = config_item_information  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddScalingConfigItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        return self


class AddScalingConfigItemResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        # requestId
        self.request_id = request_id  # type: str
        # data
        self.data = data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddScalingConfigItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class AddScalingConfigItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddScalingConfigItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddScalingConfigItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResetUserPasswordRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, type=None, old_password=None,
                 password=None, user_name=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.type = type  # type: str
        self.old_password = old_password  # type: str
        self.password = password  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetUserPasswordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.type is not None:
            result['Type'] = self.type
        if self.old_password is not None:
            result['OldPassword'] = self.old_password
        if self.password is not None:
            result['Password'] = self.password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('OldPassword') is not None:
            self.old_password = m.get('OldPassword')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ResetUserPasswordResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetUserPasswordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ResetUserPasswordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ResetUserPasswordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ResetUserPasswordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResetUserPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterAllHostsRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, cluster_id=None, resource_group_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterAllHostsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterAllHostsResponseBodyHostListHost(TeaModel):
    def __init__(self, status=None, type=None, serial_number=None, private_ip=None, host_name=None,
                 instance_type=None, host_id=None, host_instance_id=None, cpu=None, public_ip=None, memory=None, role=None):
        self.status = status  # type: str
        self.type = type  # type: str
        self.serial_number = serial_number  # type: str
        self.private_ip = private_ip  # type: str
        self.host_name = host_name  # type: str
        self.instance_type = instance_type  # type: str
        self.host_id = host_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.cpu = cpu  # type: int
        self.public_ip = public_ip  # type: str
        self.memory = memory  # type: int
        self.role = role  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterAllHostsResponseBodyHostListHost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class ListFlowClusterAllHostsResponseBodyHostList(TeaModel):
    def __init__(self, host=None):
        self.host = host  # type: list[ListFlowClusterAllHostsResponseBodyHostListHost]

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowClusterAllHostsResponseBodyHostList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = ListFlowClusterAllHostsResponseBodyHostListHost()
                self.host.append(temp_model.from_map(k))
        return self


class ListFlowClusterAllHostsResponseBody(TeaModel):
    def __init__(self, request_id=None, host_list=None):
        self.request_id = request_id  # type: str
        self.host_list = host_list  # type: ListFlowClusterAllHostsResponseBodyHostList

    def validate(self):
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super(ListFlowClusterAllHostsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HostList') is not None:
            temp_model = ListFlowClusterAllHostsResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListFlowClusterAllHostsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowClusterAllHostsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowClusterAllHostsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterAllHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLibrariesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, library_biz_id_list=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.library_biz_id_list = library_biz_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLibrariesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.library_biz_id_list is not None:
            result['LibraryBizIdList'] = self.library_biz_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('LibraryBizIdList') is not None:
            self.library_biz_id_list = m.get('LibraryBizIdList')
        return self


class DeleteLibrariesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLibrariesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLibrariesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteLibrariesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLibrariesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowCategoryTreeRequest(TeaModel):
    def __init__(self, project_id=None, region_id=None, type=None, mode=None, keyword=None, category_id=None):
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str
        self.type = type  # type: str
        self.mode = mode  # type: str
        self.keyword = keyword  # type: str
        self.category_id = category_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowCategoryTreeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DescribeFlowCategoryTreeResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowCategoryTreeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFlowCategoryTreeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowCategoryTreeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowCategoryTreeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowCategoryTreeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDatasourceInstancesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, target_cluster_id=None, datasource_type=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.target_cluster_id = target_cluster_id  # type: str
        self.datasource_type = datasource_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDatasourceInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_cluster_id is not None:
            result['TargetClusterId'] = self.target_cluster_id
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetClusterId') is not None:
            self.target_cluster_id = m.get('TargetClusterId')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        return self


class ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfoPrivateAddressList(TeaModel):
    def __init__(self, private_address_list=None):
        self.private_address_list = private_address_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfoPrivateAddressList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_address_list is not None:
            result['privateAddressList'] = self.private_address_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('privateAddressList') is not None:
            self.private_address_list = m.get('privateAddressList')
        return self


class ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfo(TeaModel):
    def __init__(self, cluster_id=None, create_time=None, datasource_id=None, descreption=None, modify_time=None,
                 name=None, status=None, type=None, vswitch_id=None, private_address_list=None, security_group_id=None):
        self.cluster_id = cluster_id  # type: str
        self.create_time = create_time  # type: long
        self.datasource_id = datasource_id  # type: str
        self.descreption = descreption  # type: str
        self.modify_time = modify_time  # type: long
        self.name = name  # type: str
        self.status = status  # type: str
        self.type = type  # type: str
        self.vswitch_id = vswitch_id  # type: str
        self.private_address_list = private_address_list  # type: ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfoPrivateAddressList
        self.security_group_id = security_group_id  # type: str

    def validate(self):
        if self.private_address_list:
            self.private_address_list.validate()

    def to_map(self):
        _map = super(ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.datasource_id is not None:
            result['DatasourceId'] = self.datasource_id
        if self.descreption is not None:
            result['Descreption'] = self.descreption
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.private_address_list is not None:
            result['PrivateAddressList'] = self.private_address_list.to_map()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DatasourceId') is not None:
            self.datasource_id = m.get('DatasourceId')
        if m.get('Descreption') is not None:
            self.descreption = m.get('Descreption')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('PrivateAddressList') is not None:
            temp_model = ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfoPrivateAddressList()
            self.private_address_list = temp_model.from_map(m['PrivateAddressList'])
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class ListDatasourceInstancesResponseBodyDdiDatasourceInfoList(TeaModel):
    def __init__(self, ddi_datasource_info=None):
        self.ddi_datasource_info = ddi_datasource_info  # type: list[ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfo]

    def validate(self):
        if self.ddi_datasource_info:
            for k in self.ddi_datasource_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDatasourceInstancesResponseBodyDdiDatasourceInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DdiDatasourceInfo'] = []
        if self.ddi_datasource_info is not None:
            for k in self.ddi_datasource_info:
                result['DdiDatasourceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ddi_datasource_info = []
        if m.get('DdiDatasourceInfo') is not None:
            for k in m.get('DdiDatasourceInfo'):
                temp_model = ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfo()
                self.ddi_datasource_info.append(temp_model.from_map(k))
        return self


class ListDatasourceInstancesResponseBody(TeaModel):
    def __init__(self, ddi_datasource_info_list=None, request_id=None):
        self.ddi_datasource_info_list = ddi_datasource_info_list  # type: ListDatasourceInstancesResponseBodyDdiDatasourceInfoList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.ddi_datasource_info_list:
            self.ddi_datasource_info_list.validate()

    def to_map(self):
        _map = super(ListDatasourceInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ddi_datasource_info_list is not None:
            result['DdiDatasourceInfoList'] = self.ddi_datasource_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DdiDatasourceInfoList') is not None:
            temp_model = ListDatasourceInstancesResponseBodyDdiDatasourceInfoList()
            self.ddi_datasource_info_list = temp_model.from_map(m['DdiDatasourceInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDatasourceInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDatasourceInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDatasourceInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDatasourceInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowNodeSqlResultRequest(TeaModel):
    def __init__(self, node_instance_id=None, sql_index=None, offset=None, length=None, project_id=None,
                 region_id=None):
        self.node_instance_id = node_instance_id  # type: str
        self.sql_index = sql_index  # type: int
        self.offset = offset  # type: int
        self.length = length  # type: int
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowNodeSqlResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.sql_index is not None:
            result['SqlIndex'] = self.sql_index
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('SqlIndex') is not None:
            self.sql_index = m.get('SqlIndex')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListFlowNodeSqlResultResponseBodyHeaderList(TeaModel):
    def __init__(self, header=None):
        self.header = header  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowNodeSqlResultResponseBodyHeaderList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header is not None:
            result['Header'] = self.header
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Header') is not None:
            self.header = m.get('Header')
        return self


class ListFlowNodeSqlResultResponseBodyRowListRowRowItemList(TeaModel):
    def __init__(self, row_item=None):
        self.row_item = row_item  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowNodeSqlResultResponseBodyRowListRowRowItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row_item is not None:
            result['RowItem'] = self.row_item
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RowItem') is not None:
            self.row_item = m.get('RowItem')
        return self


class ListFlowNodeSqlResultResponseBodyRowListRow(TeaModel):
    def __init__(self, row_index=None, row_item_list=None):
        self.row_index = row_index  # type: int
        self.row_item_list = row_item_list  # type: ListFlowNodeSqlResultResponseBodyRowListRowRowItemList

    def validate(self):
        if self.row_item_list:
            self.row_item_list.validate()

    def to_map(self):
        _map = super(ListFlowNodeSqlResultResponseBodyRowListRow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row_index is not None:
            result['RowIndex'] = self.row_index
        if self.row_item_list is not None:
            result['RowItemList'] = self.row_item_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RowIndex') is not None:
            self.row_index = m.get('RowIndex')
        if m.get('RowItemList') is not None:
            temp_model = ListFlowNodeSqlResultResponseBodyRowListRowRowItemList()
            self.row_item_list = temp_model.from_map(m['RowItemList'])
        return self


class ListFlowNodeSqlResultResponseBodyRowList(TeaModel):
    def __init__(self, row=None):
        self.row = row  # type: list[ListFlowNodeSqlResultResponseBodyRowListRow]

    def validate(self):
        if self.row:
            for k in self.row:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowNodeSqlResultResponseBodyRowList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Row'] = []
        if self.row is not None:
            for k in self.row:
                result['Row'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.row = []
        if m.get('Row') is not None:
            for k in m.get('Row'):
                temp_model = ListFlowNodeSqlResultResponseBodyRowListRow()
                self.row.append(temp_model.from_map(k))
        return self


class ListFlowNodeSqlResultResponseBody(TeaModel):
    def __init__(self, end=None, request_id=None, header_list=None, row_list=None):
        self.end = end  # type: bool
        self.request_id = request_id  # type: str
        self.header_list = header_list  # type: ListFlowNodeSqlResultResponseBodyHeaderList
        self.row_list = row_list  # type: ListFlowNodeSqlResultResponseBodyRowList

    def validate(self):
        if self.header_list:
            self.header_list.validate()
        if self.row_list:
            self.row_list.validate()

    def to_map(self):
        _map = super(ListFlowNodeSqlResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.header_list is not None:
            result['HeaderList'] = self.header_list.to_map()
        if self.row_list is not None:
            result['RowList'] = self.row_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HeaderList') is not None:
            temp_model = ListFlowNodeSqlResultResponseBodyHeaderList()
            self.header_list = temp_model.from_map(m['HeaderList'])
        if m.get('RowList') is not None:
            temp_model = ListFlowNodeSqlResultResponseBodyRowList()
            self.row_list = temp_model.from_map(m['RowList'])
        return self


class ListFlowNodeSqlResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowNodeSqlResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowNodeSqlResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowNodeSqlResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowJobRequest(TeaModel):
    def __init__(self, project_id=None, id=None, region_id=None):
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowJobResponseBodyResourceListResource(TeaModel):
    def __init__(self, path=None, alias=None):
        self.path = path  # type: str
        self.alias = alias  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowJobResponseBodyResourceListResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class DescribeFlowJobResponseBodyResourceList(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeFlowJobResponseBodyResourceListResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowJobResponseBodyResourceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeFlowJobResponseBodyResourceListResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeFlowJobResponseBody(TeaModel):
    def __init__(self, type=None, last_instance_id=None, env_conf=None, retry_interval=None, mode=None,
                 gmt_modified=None, monitor_conf=None, params=None, request_id=None, description=None, retry_policy=None,
                 adhoc=None, name=None, max_retry=None, max_running_time_sec=None, fail_act=None, custom_variables=None,
                 edit_lock_detail=None, param_conf=None, run_conf=None, gmt_create=None, category_id=None, id=None, alert_conf=None,
                 resource_list=None):
        self.type = type  # type: str
        self.last_instance_id = last_instance_id  # type: str
        self.env_conf = env_conf  # type: str
        self.retry_interval = retry_interval  # type: long
        self.mode = mode  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.monitor_conf = monitor_conf  # type: str
        self.params = params  # type: str
        self.request_id = request_id  # type: str
        self.description = description  # type: str
        self.retry_policy = retry_policy  # type: str
        self.adhoc = adhoc  # type: str
        self.name = name  # type: str
        self.max_retry = max_retry  # type: int
        self.max_running_time_sec = max_running_time_sec  # type: long
        self.fail_act = fail_act  # type: str
        self.custom_variables = custom_variables  # type: str
        self.edit_lock_detail = edit_lock_detail  # type: str
        self.param_conf = param_conf  # type: str
        self.run_conf = run_conf  # type: str
        self.gmt_create = gmt_create  # type: long
        self.category_id = category_id  # type: str
        self.id = id  # type: str
        self.alert_conf = alert_conf  # type: str
        self.resource_list = resource_list  # type: DescribeFlowJobResponseBodyResourceList

    def validate(self):
        if self.resource_list:
            self.resource_list.validate()

    def to_map(self):
        _map = super(DescribeFlowJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.last_instance_id is not None:
            result['LastInstanceId'] = self.last_instance_id
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.name is not None:
            result['Name'] = self.name
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.max_running_time_sec is not None:
            result['MaxRunningTimeSec'] = self.max_running_time_sec
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.edit_lock_detail is not None:
            result['EditLockDetail'] = self.edit_lock_detail
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.id is not None:
            result['Id'] = self.id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.resource_list is not None:
            result['ResourceList'] = self.resource_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('LastInstanceId') is not None:
            self.last_instance_id = m.get('LastInstanceId')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('MaxRunningTimeSec') is not None:
            self.max_running_time_sec = m.get('MaxRunningTimeSec')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('EditLockDetail') is not None:
            self.edit_lock_detail = m.get('EditLockDetail')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ResourceList') is not None:
            temp_model = DescribeFlowJobResponseBodyResourceList()
            self.resource_list = temp_model.from_map(m['ResourceList'])
        return self


class DescribeFlowJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLibraryInstallTaskDetailRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, task_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.task_biz_id = task_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLibraryInstallTaskDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_biz_id is not None:
            result['TaskBizId'] = self.task_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskBizId') is not None:
            self.task_biz_id = m.get('TaskBizId')
        return self


class DescribeLibraryInstallTaskDetailResponseBody(TeaModel):
    def __init__(self, library_biz_id=None, hostname=None, end_time=None, start_time=None, task_type=None,
                 request_id=None, task_group_id=None, task_status=None, task_process=None, execute_time=None,
                 cluster_biz_id=None, task_id=None, detail=None):
        self.library_biz_id = library_biz_id  # type: str
        self.hostname = hostname  # type: str
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.task_type = task_type  # type: str
        self.request_id = request_id  # type: str
        self.task_group_id = task_group_id  # type: str
        self.task_status = task_status  # type: str
        self.task_process = task_process  # type: int
        self.execute_time = execute_time  # type: long
        self.cluster_biz_id = cluster_biz_id  # type: str
        self.task_id = task_id  # type: str
        self.detail = detail  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLibraryInstallTaskDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_group_id is not None:
            result['TaskGroupId'] = self.task_group_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_process is not None:
            result['TaskProcess'] = self.task_process
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.detail is not None:
            result['Detail'] = self.detail
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskGroupId') is not None:
            self.task_group_id = m.get('TaskGroupId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskProcess') is not None:
            self.task_process = m.get('TaskProcess')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        return self


class DescribeLibraryInstallTaskDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeLibraryInstallTaskDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLibraryInstallTaskDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLibraryInstallTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowForWebRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, id=None, name=None, status=None, description=None,
                 periodic=None, start_schedule=None, end_schedule=None, cron_expr=None, create_cluster=None, cluster_id=None,
                 host_name=None, namespace=None, graph=None, alert_conf=None, alert_user_group_biz_id=None,
                 alert_ding_ding_group_biz_id=None, parent_flow_list=None, parent_category=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.status = status  # type: str
        self.description = description  # type: str
        self.periodic = periodic  # type: bool
        self.start_schedule = start_schedule  # type: long
        self.end_schedule = end_schedule  # type: long
        self.cron_expr = cron_expr  # type: str
        self.create_cluster = create_cluster  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.host_name = host_name  # type: str
        self.namespace = namespace  # type: str
        self.graph = graph  # type: str
        self.alert_conf = alert_conf  # type: str
        self.alert_user_group_biz_id = alert_user_group_biz_id  # type: str
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id  # type: str
        self.parent_flow_list = parent_flow_list  # type: str
        self.parent_category = parent_category  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowForWebRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        return self


class ModifyFlowForWebResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowForWebResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowForWebResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyFlowForWebResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyFlowForWebResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowForWebResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveScalingConfigItemRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, scaling_group_biz_id=None,
                 config_item_type=None, config_item_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.config_item_type = config_item_type  # type: str
        self.config_item_biz_id = config_item_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveScalingConfigItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.config_item_biz_id is not None:
            result['ConfigItemBizId'] = self.config_item_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ConfigItemBizId') is not None:
            self.config_item_biz_id = m.get('ConfigItemBizId')
        return self


class RemoveScalingConfigItemResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        # requestId
        self.request_id = request_id  # type: str
        # data
        self.data = data  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveScalingConfigItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class RemoveScalingConfigItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveScalingConfigItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveScalingConfigItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityWhiteListRequest(TeaModel):
    def __init__(self, cluster_id=None):
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityWhiteListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeSecurityWhiteListResponseBodyDescribeSecurityWhiteList(TeaModel):
    def __init__(self, port_range=None, white_ip=None, description=None, create_time=None):
        self.port_range = port_range  # type: str
        self.white_ip = white_ip  # type: str
        self.description = description  # type: str
        self.create_time = create_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSecurityWhiteListResponseBodyDescribeSecurityWhiteList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.white_ip is not None:
            result['WhiteIp'] = self.white_ip
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('WhiteIp') is not None:
            self.white_ip = m.get('WhiteIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class DescribeSecurityWhiteListResponseBody(TeaModel):
    def __init__(self, describe_security_white_list=None, request_id=None):
        self.describe_security_white_list = describe_security_white_list  # type: list[DescribeSecurityWhiteListResponseBodyDescribeSecurityWhiteList]
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.describe_security_white_list:
            for k in self.describe_security_white_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSecurityWhiteListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DescribeSecurityWhiteList'] = []
        if self.describe_security_white_list is not None:
            for k in self.describe_security_white_list:
                result['DescribeSecurityWhiteList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.describe_security_white_list = []
        if m.get('DescribeSecurityWhiteList') is not None:
            for k in m.get('DescribeSecurityWhiteList'):
                temp_model = DescribeSecurityWhiteListResponseBodyDescribeSecurityWhiteList()
                self.describe_security_white_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSecurityWhiteListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSecurityWhiteListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSecurityWhiteListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceContainerLogRequest(TeaModel):
    def __init__(self, offset=None, length=None, node_instance_id=None, app_id=None, container_id=None,
                 log_name=None, project_id=None, region_id=None):
        self.offset = offset  # type: int
        self.length = length  # type: int
        self.node_instance_id = node_instance_id  # type: str
        self.app_id = app_id  # type: str
        self.container_id = container_id  # type: str
        self.log_name = log_name  # type: str
        self.project_id = project_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceContainerLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry(TeaModel):
    def __init__(self, content=None):
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys(TeaModel):
    def __init__(self, log_entry=None):
        self.log_entry = log_entry  # type: list[DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry]

    def validate(self):
        if self.log_entry:
            for k in self.log_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogEntry'] = []
        if self.log_entry is not None:
            for k in self.log_entry:
                result['LogEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.log_entry = []
        if m.get('LogEntry') is not None:
            for k in m.get('LogEntry'):
                temp_model = DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry()
                self.log_entry.append(temp_model.from_map(k))
        return self


class DescribeFlowNodeInstanceContainerLogResponseBody(TeaModel):
    def __init__(self, log_end=None, request_id=None, log_entrys=None):
        self.log_end = log_end  # type: bool
        self.request_id = request_id  # type: str
        self.log_entrys = log_entrys  # type: DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys

    def validate(self):
        if self.log_entrys:
            self.log_entrys.validate()

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceContainerLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_end is not None:
            result['LogEnd'] = self.log_end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_entrys is not None:
            result['LogEntrys'] = self.log_entrys.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogEnd') is not None:
            self.log_end = m.get('LogEnd')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogEntrys') is not None:
            temp_model = DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys()
            self.log_entrys = temp_model.from_map(m['LogEntrys'])
        return self


class DescribeFlowNodeInstanceContainerLogResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowNodeInstanceContainerLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowNodeInstanceContainerLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceContainerLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RerunFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, flow_instance_id=None, re_run_fail=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.flow_instance_id = flow_instance_id  # type: str
        self.re_run_fail = re_run_fail  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RerunFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.re_run_fail is not None:
            result['ReRunFail'] = self.re_run_fail
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('ReRunFail') is not None:
            self.re_run_fail = m.get('ReRunFail')
        return self


class RerunFlowResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RerunFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RerunFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RerunFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RerunFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RerunFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagKeysRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, resource_group_id=None, resource_type=None,
                 category=None, scope=None, next_token=None, page_size=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        # 资源类型
        self.resource_type = resource_type  # type: str
        self.category = category  # type: str
        self.scope = scope  # type: str
        self.next_token = next_token  # type: str
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagKeysRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.category is not None:
            result['Category'] = self.category
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListTagKeysResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, next_token=None, items=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long
        self.next_token = next_token  # type: str
        # 标签键集合
        self.items = items  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagKeysResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        return self


class ListTagKeysResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, paging=None, data=None, code=None, error_code=None,
                 message=None):
        # Id of the request
        self.request_id = request_id  # type: str
        # 是否成功响应
        self.success = success  # type: bool
        # 是否分页
        self.paging = paging  # type: bool
        # 标签键集合
        self.data = data  # type: list[ListTagKeysResponseBodyData]
        self.code = code  # type: str
        self.error_code = error_code  # type: str
        self.message = message  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagKeysResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.paging is not None:
            result['Paging'] = self.paging
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Paging') is not None:
            self.paging = m.get('Paging')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListTagKeysResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ListTagKeysResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListTagKeysResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTagKeysResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTagKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterOperationHostTaskLogRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, operation_id=None, host_id=None,
                 task_id=None, status=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.operation_id = operation_id  # type: str
        self.host_id = host_id  # type: str
        self.task_id = task_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterOperationHostTaskLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeClusterOperationHostTaskLogResponseBody(TeaModel):
    def __init__(self, request_id=None, stdout=None, stderr=None):
        self.request_id = request_id  # type: str
        self.stdout = stdout  # type: str
        self.stderr = stderr  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterOperationHostTaskLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stdout is not None:
            result['Stdout'] = self.stdout
        if self.stderr is not None:
            result['Stderr'] = self.stderr
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Stdout') is not None:
            self.stdout = m.get('Stdout')
        if m.get('Stderr') is not None:
            self.stderr = m.get('Stderr')
        return self


class DescribeClusterOperationHostTaskLogResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeClusterOperationHostTaskLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterOperationHostTaskLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterOperationHostTaskLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class KillFlowJobRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, job_instance_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.job_instance_id = job_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(KillFlowJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_instance_id is not None:
            result['JobInstanceId'] = self.job_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobInstanceId') is not None:
            self.job_instance_id = m.get('JobInstanceId')
        return self


class KillFlowJobResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(KillFlowJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class KillFlowJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: KillFlowJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(KillFlowJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = KillFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UninstallLibrariesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_biz_id_list=None, library_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_biz_id_list = cluster_biz_id_list  # type: list[str]
        self.library_biz_id = library_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UninstallLibrariesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_biz_id_list is not None:
            result['ClusterBizIdList'] = self.cluster_biz_id_list
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterBizIdList') is not None:
            self.cluster_biz_id_list = m.get('ClusterBizIdList')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        return self


class UninstallLibrariesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UninstallLibrariesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UninstallLibrariesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: UninstallLibrariesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(UninstallLibrariesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UninstallLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterV2Request(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2Request, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo(TeaModel):
    def __init__(self, cluster_name=None, status=None, cluster_id=None):
        self.cluster_name = cluster_name  # type: str
        self.status = status  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList(TeaModel):
    def __init__(self, gateway_cluster_info=None):
        self.gateway_cluster_info = gateway_cluster_info  # type: list[DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo]

    def validate(self):
        if self.gateway_cluster_info:
            for k in self.gateway_cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GatewayClusterInfo'] = []
        if self.gateway_cluster_info is not None:
            for k in self.gateway_cluster_info:
                result['GatewayClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.gateway_cluster_info = []
        if m.get('GatewayClusterInfo') is not None:
            for k in m.get('GatewayClusterInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo()
                self.gateway_cluster_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos(TeaModel):
    def __init__(self, daemon_info=None):
        self.daemon_info = daemon_info  # type: list[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo]

    def validate(self):
        if self.daemon_info:
            for k in self.daemon_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DaemonInfo'] = []
        if self.daemon_info is not None:
            for k in self.daemon_info:
                result['DaemonInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.daemon_info = []
        if m.get('DaemonInfo') is not None:
            for k in m.get('DaemonInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo()
                self.daemon_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo(TeaModel):
    def __init__(self, type=None, disk_id=None, size=None, device=None, disk_name=None):
        self.type = type  # type: str
        self.disk_id = disk_id  # type: str
        self.size = size  # type: int
        self.device = device  # type: str
        self.disk_name = disk_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos(TeaModel):
    def __init__(self, disk_info=None):
        self.disk_info = disk_info  # type: list[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo]

    def validate(self):
        if self.disk_info:
            for k in self.disk_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiskInfo'] = []
        if self.disk_info is not None:
            for k in self.disk_info:
                result['DiskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.disk_info = []
        if m.get('DiskInfo') is not None:
            for k in m.get('DiskInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo()
                self.disk_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode(TeaModel):
    def __init__(self, status=None, support_ip_v6=None, inner_ip=None, expired_time=None, create_time=None,
                 zone_id=None, instance_id=None, emr_expired_time=None, pub_ip=None, daemon_infos=None, disk_infos=None):
        self.status = status  # type: str
        self.support_ip_v6 = support_ip_v6  # type: bool
        self.inner_ip = inner_ip  # type: str
        self.expired_time = expired_time  # type: str
        self.create_time = create_time  # type: str
        self.zone_id = zone_id  # type: str
        self.instance_id = instance_id  # type: str
        self.emr_expired_time = emr_expired_time  # type: str
        self.pub_ip = pub_ip  # type: str
        self.daemon_infos = daemon_infos  # type: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos
        self.disk_infos = disk_infos  # type: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos

    def validate(self):
        if self.daemon_infos:
            self.daemon_infos.validate()
        if self.disk_infos:
            self.disk_infos.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.support_ip_v6 is not None:
            result['SupportIpV6'] = self.support_ip_v6
        if self.inner_ip is not None:
            result['InnerIp'] = self.inner_ip
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.emr_expired_time is not None:
            result['EmrExpiredTime'] = self.emr_expired_time
        if self.pub_ip is not None:
            result['PubIp'] = self.pub_ip
        if self.daemon_infos is not None:
            result['DaemonInfos'] = self.daemon_infos.to_map()
        if self.disk_infos is not None:
            result['DiskInfos'] = self.disk_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SupportIpV6') is not None:
            self.support_ip_v6 = m.get('SupportIpV6')
        if m.get('InnerIp') is not None:
            self.inner_ip = m.get('InnerIp')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EmrExpiredTime') is not None:
            self.emr_expired_time = m.get('EmrExpiredTime')
        if m.get('PubIp') is not None:
            self.pub_ip = m.get('PubIp')
        if m.get('DaemonInfos') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos()
            self.daemon_infos = temp_model.from_map(m['DaemonInfos'])
        if m.get('DiskInfos') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos()
            self.disk_infos = temp_model.from_map(m['DiskInfos'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes(TeaModel):
    def __init__(self, node=None):
        self.node = node  # type: list[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode]

    def validate(self):
        if self.node:
            for k in self.node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Node'] = []
        if self.node is not None:
            for k in self.node:
                result['Node'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node = []
        if m.get('Node') is not None:
            for k in m.get('Node'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode()
                self.node.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup(TeaModel):
    def __init__(self, lock_type=None, host_group_sub_type=None, host_group_type=None,
                 host_group_change_status=None, charge_type=None, lock_reason=None, disk_type=None, host_group_id=None, band_width=None,
                 instance_type=None, disk_count=None, period=None, disk_capacity=None, cpu_core=None, memory_capacity=None,
                 node_count=None, host_group_change_type=None, host_group_name=None, nodes=None):
        self.lock_type = lock_type  # type: str
        self.host_group_sub_type = host_group_sub_type  # type: str
        self.host_group_type = host_group_type  # type: str
        self.host_group_change_status = host_group_change_status  # type: str
        self.charge_type = charge_type  # type: str
        self.lock_reason = lock_reason  # type: str
        self.disk_type = disk_type  # type: str
        self.host_group_id = host_group_id  # type: str
        self.band_width = band_width  # type: str
        self.instance_type = instance_type  # type: str
        self.disk_count = disk_count  # type: int
        self.period = period  # type: str
        self.disk_capacity = disk_capacity  # type: int
        self.cpu_core = cpu_core  # type: int
        self.memory_capacity = memory_capacity  # type: int
        self.node_count = node_count  # type: int
        self.host_group_change_type = host_group_change_type  # type: str
        self.host_group_name = host_group_name  # type: str
        self.nodes = nodes  # type: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes

    def validate(self):
        if self.nodes:
            self.nodes.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_type is not None:
            result['LockType'] = self.lock_type
        if self.host_group_sub_type is not None:
            result['HostGroupSubType'] = self.host_group_sub_type
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.host_group_change_status is not None:
            result['HostGroupChangeStatus'] = self.host_group_change_status
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.cpu_core is not None:
            result['CpuCore'] = self.cpu_core
        if self.memory_capacity is not None:
            result['MemoryCapacity'] = self.memory_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_change_type is not None:
            result['HostGroupChangeType'] = self.host_group_change_type
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.nodes is not None:
            result['Nodes'] = self.nodes.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LockType') is not None:
            self.lock_type = m.get('LockType')
        if m.get('HostGroupSubType') is not None:
            self.host_group_sub_type = m.get('HostGroupSubType')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('HostGroupChangeStatus') is not None:
            self.host_group_change_status = m.get('HostGroupChangeStatus')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('CpuCore') is not None:
            self.cpu_core = m.get('CpuCore')
        if m.get('MemoryCapacity') is not None:
            self.memory_capacity = m.get('MemoryCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupChangeType') is not None:
            self.host_group_change_type = m.get('HostGroupChangeType')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('Nodes') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes()
            self.nodes = temp_model.from_map(m['Nodes'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupList(TeaModel):
    def __init__(self, host_group=None):
        self.host_group = host_group  # type: list[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup]

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(self, path=None, name=None, arg=None):
        self.path = path  # type: str
        self.name = name  # type: str
        self.arg = arg  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.arg is not None:
            result['Arg'] = self.arg
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        return self


class DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList(TeaModel):
    def __init__(self, bootstrap_action=None):
        self.bootstrap_action = bootstrap_action  # type: list[DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction]

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo(TeaModel):
    def __init__(self, cluster_name=None, status=None, cluster_id=None):
        self.cluster_name = cluster_name  # type: str
        self.status = status  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo(TeaModel):
    def __init__(self, hp_name=None, hp_biz_id=None):
        self.hp_name = hp_name  # type: str
        self.hp_biz_id = hp_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hp_name is not None:
            result['HpName'] = self.hp_name
        if self.hp_biz_id is not None:
            result['HpBizId'] = self.hp_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HpName') is not None:
            self.hp_name = m.get('HpName')
        if m.get('HpBizId') is not None:
            self.hp_biz_id = m.get('HpBizId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoFailReason(TeaModel):
    def __init__(self, error_msg=None, request_id=None, error_code=None):
        self.error_msg = error_msg  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoFailReason, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware(TeaModel):
    def __init__(self, display_name=None, only_display=None, start_tpe=None, name=None, version=None):
        self.display_name = display_name  # type: str
        self.only_display = only_display  # type: bool
        self.start_tpe = start_tpe  # type: int
        self.name = name  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.only_display is not None:
            result['OnlyDisplay'] = self.only_display
        if self.start_tpe is not None:
            result['StartTpe'] = self.start_tpe
        if self.name is not None:
            result['Name'] = self.name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OnlyDisplay') is not None:
            self.only_display = m.get('OnlyDisplay')
        if m.get('StartTpe') is not None:
            self.start_tpe = m.get('StartTpe')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares(TeaModel):
    def __init__(self, software=None):
        self.software = software  # type: list[DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware]

    def validate(self):
        if self.software:
            for k in self.software:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Software'] = []
        if self.software is not None:
            for k in self.software:
                result['Software'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.software = []
        if m.get('Software') is not None:
            for k in m.get('Software'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware()
                self.software.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo(TeaModel):
    def __init__(self, cluster_type=None, emr_ver=None, softwares=None):
        self.cluster_type = cluster_type  # type: str
        self.emr_ver = emr_ver  # type: str
        self.softwares = softwares  # type: DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares

    def validate(self):
        if self.softwares:
            self.softwares.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.softwares is not None:
            result['Softwares'] = self.softwares.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('Softwares') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares()
            self.softwares = temp_model.from_map(m['Softwares'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink(TeaModel):
    def __init__(self, port=None, link=None):
        self.port = port  # type: str
        self.link = link  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.link is not None:
            result['Link'] = self.link
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks(TeaModel):
    def __init__(self, zklink=None):
        self.zklink = zklink  # type: list[DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink]

    def validate(self):
        if self.zklink:
            for k in self.zklink:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ZKLink'] = []
        if self.zklink is not None:
            for k in self.zklink:
                result['ZKLink'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.zklink = []
        if m.get('ZKLink') is not None:
            for k in m.get('ZKLink'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink()
                self.zklink.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfo(TeaModel):
    def __init__(self, zklinks=None):
        self.zklinks = zklinks  # type: DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks

    def validate(self):
        if self.zklinks:
            self.zklinks.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfoAccessInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zklinks is not None:
            result['ZKLinks'] = self.zklinks.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ZKLinks') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks()
            self.zklinks = temp_model.from_map(m['ZKLinks'])
        return self


class DescribeClusterV2ResponseBodyClusterInfo(TeaModel):
    def __init__(self, vpc_id=None, log_enable=None, task_node_in_service=None,
                 auto_scaling_spot_with_limit_allowed=None, user_id=None, charge_type=None, stop_time=None, deposit_type=None, create_type=None,
                 relate_cluster_id=None, security_group_name=None, resize_disk_enable=None, image_id=None,
                 user_defined_emr_ecs_role=None, meta_store_type=None, start_time=None, configurations=None, log_path=None,
                 auto_scaling_version=None, net_type=None, zone_id=None, create_resource=None, status=None, running_time=None,
                 high_availability_enable=None, security_group_id=None, auto_scaling_allowed=None, master_node_in_service=None,
                 auto_scaling_enable=None, auto_scaling_with_grace_allowed=None, core_node_in_service=None,
                 show_software_interface=None, k_8s_cluster_id=None, auto_scaling_by_load_allowed=None, local_meta_db=None,
                 instance_generation=None, name=None, eas_enable=None, machine_type=None, master_node_total=None, region_id=None,
                 period=None, extra_info=None, io_optimized=None, v_switch_id=None, expired_time=None,
                 core_node_total=None, gateway_cluster_ids=None, bootstrap_failed=None, id=None, task_node_total=None,
                 gateway_cluster_info_list=None, host_group_list=None, bootstrap_action_list=None, relate_cluster_info=None,
                 host_pool_info=None, fail_reason=None, software_info=None, access_info=None):
        self.vpc_id = vpc_id  # type: str
        self.log_enable = log_enable  # type: bool
        self.task_node_in_service = task_node_in_service  # type: int
        self.auto_scaling_spot_with_limit_allowed = auto_scaling_spot_with_limit_allowed  # type: bool
        self.user_id = user_id  # type: str
        self.charge_type = charge_type  # type: str
        self.stop_time = stop_time  # type: long
        self.deposit_type = deposit_type  # type: str
        self.create_type = create_type  # type: str
        self.relate_cluster_id = relate_cluster_id  # type: str
        self.security_group_name = security_group_name  # type: str
        self.resize_disk_enable = resize_disk_enable  # type: bool
        self.image_id = image_id  # type: str
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role  # type: str
        self.meta_store_type = meta_store_type  # type: str
        self.start_time = start_time  # type: long
        self.configurations = configurations  # type: str
        self.log_path = log_path  # type: str
        self.auto_scaling_version = auto_scaling_version  # type: str
        self.net_type = net_type  # type: str
        self.zone_id = zone_id  # type: str
        self.create_resource = create_resource  # type: str
        self.status = status  # type: str
        self.running_time = running_time  # type: int
        self.high_availability_enable = high_availability_enable  # type: bool
        self.security_group_id = security_group_id  # type: str
        self.auto_scaling_allowed = auto_scaling_allowed  # type: bool
        self.master_node_in_service = master_node_in_service  # type: int
        self.auto_scaling_enable = auto_scaling_enable  # type: bool
        self.auto_scaling_with_grace_allowed = auto_scaling_with_grace_allowed  # type: bool
        self.core_node_in_service = core_node_in_service  # type: int
        self.show_software_interface = show_software_interface  # type: bool
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.auto_scaling_by_load_allowed = auto_scaling_by_load_allowed  # type: bool
        self.local_meta_db = local_meta_db  # type: bool
        self.instance_generation = instance_generation  # type: str
        self.name = name  # type: str
        self.eas_enable = eas_enable  # type: bool
        self.machine_type = machine_type  # type: str
        self.master_node_total = master_node_total  # type: int
        self.region_id = region_id  # type: str
        self.period = period  # type: int
        self.extra_info = extra_info  # type: str
        self.io_optimized = io_optimized  # type: bool
        self.v_switch_id = v_switch_id  # type: str
        self.expired_time = expired_time  # type: long
        self.core_node_total = core_node_total  # type: int
        self.gateway_cluster_ids = gateway_cluster_ids  # type: str
        self.bootstrap_failed = bootstrap_failed  # type: bool
        self.id = id  # type: str
        self.task_node_total = task_node_total  # type: int
        self.gateway_cluster_info_list = gateway_cluster_info_list  # type: DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList
        self.host_group_list = host_group_list  # type: DescribeClusterV2ResponseBodyClusterInfoHostGroupList
        self.bootstrap_action_list = bootstrap_action_list  # type: DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList
        self.relate_cluster_info = relate_cluster_info  # type: DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo
        self.host_pool_info = host_pool_info  # type: DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo
        self.fail_reason = fail_reason  # type: DescribeClusterV2ResponseBodyClusterInfoFailReason
        self.software_info = software_info  # type: DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo
        self.access_info = access_info  # type: DescribeClusterV2ResponseBodyClusterInfoAccessInfo

    def validate(self):
        if self.gateway_cluster_info_list:
            self.gateway_cluster_info_list.validate()
        if self.host_group_list:
            self.host_group_list.validate()
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.relate_cluster_info:
            self.relate_cluster_info.validate()
        if self.host_pool_info:
            self.host_pool_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()
        if self.software_info:
            self.software_info.validate()
        if self.access_info:
            self.access_info.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBodyClusterInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.task_node_in_service is not None:
            result['TaskNodeInService'] = self.task_node_in_service
        if self.auto_scaling_spot_with_limit_allowed is not None:
            result['AutoScalingSpotWithLimitAllowed'] = self.auto_scaling_spot_with_limit_allowed
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.relate_cluster_id is not None:
            result['RelateClusterId'] = self.relate_cluster_id
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.resize_disk_enable is not None:
            result['ResizeDiskEnable'] = self.resize_disk_enable
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.auto_scaling_version is not None:
            result['AutoScalingVersion'] = self.auto_scaling_version
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.auto_scaling_allowed is not None:
            result['AutoScalingAllowed'] = self.auto_scaling_allowed
        if self.master_node_in_service is not None:
            result['MasterNodeInService'] = self.master_node_in_service
        if self.auto_scaling_enable is not None:
            result['AutoScalingEnable'] = self.auto_scaling_enable
        if self.auto_scaling_with_grace_allowed is not None:
            result['AutoScalingWithGraceAllowed'] = self.auto_scaling_with_grace_allowed
        if self.core_node_in_service is not None:
            result['CoreNodeInService'] = self.core_node_in_service
        if self.show_software_interface is not None:
            result['ShowSoftwareInterface'] = self.show_software_interface
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.auto_scaling_by_load_allowed is not None:
            result['AutoScalingByLoadAllowed'] = self.auto_scaling_by_load_allowed
        if self.local_meta_db is not None:
            result['LocalMetaDb'] = self.local_meta_db
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.name is not None:
            result['Name'] = self.name
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.core_node_total is not None:
            result['CoreNodeTotal'] = self.core_node_total
        if self.gateway_cluster_ids is not None:
            result['GatewayClusterIds'] = self.gateway_cluster_ids
        if self.bootstrap_failed is not None:
            result['BootstrapFailed'] = self.bootstrap_failed
        if self.id is not None:
            result['Id'] = self.id
        if self.task_node_total is not None:
            result['TaskNodeTotal'] = self.task_node_total
        if self.gateway_cluster_info_list is not None:
            result['GatewayClusterInfoList'] = self.gateway_cluster_info_list.to_map()
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.relate_cluster_info is not None:
            result['RelateClusterInfo'] = self.relate_cluster_info.to_map()
        if self.host_pool_info is not None:
            result['HostPoolInfo'] = self.host_pool_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info.to_map()
        if self.access_info is not None:
            result['AccessInfo'] = self.access_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('TaskNodeInService') is not None:
            self.task_node_in_service = m.get('TaskNodeInService')
        if m.get('AutoScalingSpotWithLimitAllowed') is not None:
            self.auto_scaling_spot_with_limit_allowed = m.get('AutoScalingSpotWithLimitAllowed')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('RelateClusterId') is not None:
            self.relate_cluster_id = m.get('RelateClusterId')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ResizeDiskEnable') is not None:
            self.resize_disk_enable = m.get('ResizeDiskEnable')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('AutoScalingVersion') is not None:
            self.auto_scaling_version = m.get('AutoScalingVersion')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('AutoScalingAllowed') is not None:
            self.auto_scaling_allowed = m.get('AutoScalingAllowed')
        if m.get('MasterNodeInService') is not None:
            self.master_node_in_service = m.get('MasterNodeInService')
        if m.get('AutoScalingEnable') is not None:
            self.auto_scaling_enable = m.get('AutoScalingEnable')
        if m.get('AutoScalingWithGraceAllowed') is not None:
            self.auto_scaling_with_grace_allowed = m.get('AutoScalingWithGraceAllowed')
        if m.get('CoreNodeInService') is not None:
            self.core_node_in_service = m.get('CoreNodeInService')
        if m.get('ShowSoftwareInterface') is not None:
            self.show_software_interface = m.get('ShowSoftwareInterface')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('AutoScalingByLoadAllowed') is not None:
            self.auto_scaling_by_load_allowed = m.get('AutoScalingByLoadAllowed')
        if m.get('LocalMetaDb') is not None:
            self.local_meta_db = m.get('LocalMetaDb')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CoreNodeTotal') is not None:
            self.core_node_total = m.get('CoreNodeTotal')
        if m.get('GatewayClusterIds') is not None:
            self.gateway_cluster_ids = m.get('GatewayClusterIds')
        if m.get('BootstrapFailed') is not None:
            self.bootstrap_failed = m.get('BootstrapFailed')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskNodeTotal') is not None:
            self.task_node_total = m.get('TaskNodeTotal')
        if m.get('GatewayClusterInfoList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList()
            self.gateway_cluster_info_list = temp_model.from_map(m['GatewayClusterInfoList'])
        if m.get('HostGroupList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('RelateClusterInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo()
            self.relate_cluster_info = temp_model.from_map(m['RelateClusterInfo'])
        if m.get('HostPoolInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo()
            self.host_pool_info = temp_model.from_map(m['HostPoolInfo'])
        if m.get('FailReason') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        if m.get('SoftwareInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo()
            self.software_info = temp_model.from_map(m['SoftwareInfo'])
        if m.get('AccessInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfo()
            self.access_info = temp_model.from_map(m['AccessInfo'])
        return self


class DescribeClusterV2ResponseBody(TeaModel):
    def __init__(self, request_id=None, cluster_info=None):
        self.request_id = request_id  # type: str
        self.cluster_info = cluster_info  # type: DescribeClusterV2ResponseBodyClusterInfo

    def validate(self):
        if self.cluster_info:
            self.cluster_info.validate()

    def to_map(self):
        _map = super(DescribeClusterV2ResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_info is not None:
            result['ClusterInfo'] = self.cluster_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfo()
            self.cluster_info = temp_model.from_map(m['ClusterInfo'])
        return self


class DescribeClusterV2Response(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeClusterV2ResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterV2Response, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowRequest(TeaModel):
    def __init__(self, project_id=None, id=None, region_id=None):
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowResponseBodyParentFlowListParentFlow(TeaModel):
    def __init__(self, parent_flow_name=None, parent_flow_id=None, project_name=None, project_id=None):
        self.parent_flow_name = parent_flow_name  # type: str
        self.parent_flow_id = parent_flow_id  # type: str
        self.project_name = project_name  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowResponseBodyParentFlowListParentFlow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_flow_name is not None:
            result['ParentFlowName'] = self.parent_flow_name
        if self.parent_flow_id is not None:
            result['ParentFlowId'] = self.parent_flow_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParentFlowName') is not None:
            self.parent_flow_name = m.get('ParentFlowName')
        if m.get('ParentFlowId') is not None:
            self.parent_flow_id = m.get('ParentFlowId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DescribeFlowResponseBodyParentFlowList(TeaModel):
    def __init__(self, parent_flow=None):
        self.parent_flow = parent_flow  # type: list[DescribeFlowResponseBodyParentFlowListParentFlow]

    def validate(self):
        if self.parent_flow:
            for k in self.parent_flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowResponseBodyParentFlowList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParentFlow'] = []
        if self.parent_flow is not None:
            for k in self.parent_flow:
                result['ParentFlow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.parent_flow = []
        if m.get('ParentFlow') is not None:
            for k in m.get('ParentFlow'):
                temp_model = DescribeFlowResponseBodyParentFlowListParentFlow()
                self.parent_flow.append(temp_model.from_map(k))
        return self


class DescribeFlowResponseBody(TeaModel):
    def __init__(self, status=None, type=None, alert_user_group_biz_id=None, periodic=None, edit_lock_detail=None,
                 namespace=None, host_name=None, application=None, gmt_modified=None, request_id=None, description=None,
                 create_cluster=None, start_schedule=None, end_schedule=None, graph=None, alert_ding_ding_group_biz_id=None,
                 gmt_create=None, category_id=None, cron_expr=None, name=None, id=None, alert_conf=None, cluster_id=None,
                 parent_flow_list=None):
        self.status = status  # type: str
        self.type = type  # type: str
        self.alert_user_group_biz_id = alert_user_group_biz_id  # type: str
        self.periodic = periodic  # type: bool
        self.edit_lock_detail = edit_lock_detail  # type: str
        self.namespace = namespace  # type: str
        self.host_name = host_name  # type: str
        self.application = application  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.request_id = request_id  # type: str
        self.description = description  # type: str
        self.create_cluster = create_cluster  # type: bool
        self.start_schedule = start_schedule  # type: long
        self.end_schedule = end_schedule  # type: long
        self.graph = graph  # type: str
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.category_id = category_id  # type: str
        self.cron_expr = cron_expr  # type: str
        self.name = name  # type: str
        self.id = id  # type: str
        self.alert_conf = alert_conf  # type: str
        self.cluster_id = cluster_id  # type: str
        self.parent_flow_list = parent_flow_list  # type: DescribeFlowResponseBodyParentFlowList

    def validate(self):
        if self.parent_flow_list:
            self.parent_flow_list.validate()

    def to_map(self):
        _map = super(DescribeFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.edit_lock_detail is not None:
            result['EditLockDetail'] = self.edit_lock_detail
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.application is not None:
            result['Application'] = self.application
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('EditLockDetail') is not None:
            self.edit_lock_detail = m.get('EditLockDetail')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ParentFlowList') is not None:
            temp_model = DescribeFlowResponseBodyParentFlowList()
            self.parent_flow_list = temp_model.from_map(m['ParentFlowList'])
        return self


class DescribeFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, page_number=None, page_size=None, resource_group_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterResponseBodyClustersClusterInfoOrderTaskInfo(TeaModel):
    def __init__(self, target_count=None, current_count=None, order_id_list=None):
        self.target_count = target_count  # type: int
        self.current_count = current_count  # type: int
        self.order_id_list = order_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterResponseBodyClustersClusterInfoOrderTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_count is not None:
            result['TargetCount'] = self.target_count
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.order_id_list is not None:
            result['OrderIdList'] = self.order_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetCount') is not None:
            self.target_count = m.get('TargetCount')
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('OrderIdList') is not None:
            self.order_id_list = m.get('OrderIdList')
        return self


class ListFlowClusterResponseBodyClustersClusterInfoFailReason(TeaModel):
    def __init__(self, error_msg=None, request_id=None, error_code=None):
        self.error_msg = error_msg  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowClusterResponseBodyClustersClusterInfoFailReason, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class ListFlowClusterResponseBodyClustersClusterInfo(TeaModel):
    def __init__(self, type=None, status=None, running_time=None, order_list=None, create_time=None,
                 charge_type=None, period=None, k_8s_cluster_id=None, expired_time=None, has_uncompleted_order=None, name=None,
                 id=None, create_resource=None, order_task_info=None, fail_reason=None):
        self.type = type  # type: str
        self.status = status  # type: str
        self.running_time = running_time  # type: int
        self.order_list = order_list  # type: str
        self.create_time = create_time  # type: long
        self.charge_type = charge_type  # type: str
        self.period = period  # type: int
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.expired_time = expired_time  # type: long
        self.has_uncompleted_order = has_uncompleted_order  # type: bool
        self.name = name  # type: str
        self.id = id  # type: str
        self.create_resource = create_resource  # type: str
        self.order_task_info = order_task_info  # type: ListFlowClusterResponseBodyClustersClusterInfoOrderTaskInfo
        self.fail_reason = fail_reason  # type: ListFlowClusterResponseBodyClustersClusterInfoFailReason

    def validate(self):
        if self.order_task_info:
            self.order_task_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super(ListFlowClusterResponseBodyClustersClusterInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.order_list is not None:
            result['OrderList'] = self.order_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.has_uncompleted_order is not None:
            result['HasUncompletedOrder'] = self.has_uncompleted_order
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.order_task_info is not None:
            result['OrderTaskInfo'] = self.order_task_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('OrderList') is not None:
            self.order_list = m.get('OrderList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('HasUncompletedOrder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('OrderTaskInfo') is not None:
            temp_model = ListFlowClusterResponseBodyClustersClusterInfoOrderTaskInfo()
            self.order_task_info = temp_model.from_map(m['OrderTaskInfo'])
        if m.get('FailReason') is not None:
            temp_model = ListFlowClusterResponseBodyClustersClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        return self


class ListFlowClusterResponseBodyClusters(TeaModel):
    def __init__(self, cluster_info=None):
        self.cluster_info = cluster_info  # type: list[ListFlowClusterResponseBodyClustersClusterInfo]

    def validate(self):
        if self.cluster_info:
            for k in self.cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowClusterResponseBodyClusters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInfo'] = []
        if self.cluster_info is not None:
            for k in self.cluster_info:
                result['ClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_info = []
        if m.get('ClusterInfo') is not None:
            for k in m.get('ClusterInfo'):
                temp_model = ListFlowClusterResponseBodyClustersClusterInfo()
                self.cluster_info.append(temp_model.from_map(k))
        return self


class ListFlowClusterResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None, clusters=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.clusters = clusters  # type: ListFlowClusterResponseBodyClusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super(ListFlowClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Clusters') is not None:
            temp_model = ListFlowClusterResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class ListFlowClusterResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLdapUsersRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, user_name_search=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.user_name_search = user_name_search  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLdapUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.user_name_search is not None:
            result['UserNameSearch'] = self.user_name_search
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('UserNameSearch') is not None:
            self.user_name_search = m.get('UserNameSearch')
        return self


class ListLdapUsersResponseBodyUserListUser(TeaModel):
    def __init__(self, user_create_time=None, group_name=None, user_id=None, note=None, keytab_hex=None,
                 user_name=None):
        self.user_create_time = user_create_time  # type: long
        self.group_name = group_name  # type: str
        self.user_id = user_id  # type: str
        self.note = note  # type: str
        self.keytab_hex = keytab_hex  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLdapUsersResponseBodyUserListUser, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_create_time is not None:
            result['UserCreateTime'] = self.user_create_time
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.note is not None:
            result['Note'] = self.note
        if self.keytab_hex is not None:
            result['KeytabHex'] = self.keytab_hex
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UserCreateTime') is not None:
            self.user_create_time = m.get('UserCreateTime')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('KeytabHex') is not None:
            self.keytab_hex = m.get('KeytabHex')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ListLdapUsersResponseBodyUserList(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[ListLdapUsersResponseBodyUserListUser]

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLdapUsersResponseBodyUserList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = ListLdapUsersResponseBodyUserListUser()
                self.user.append(temp_model.from_map(k))
        return self


class ListLdapUsersResponseBody(TeaModel):
    def __init__(self, is_admin=None, request_id=None, user_list=None):
        self.is_admin = is_admin  # type: bool
        self.request_id = request_id  # type: str
        self.user_list = user_list  # type: ListLdapUsersResponseBodyUserList

    def validate(self):
        if self.user_list:
            self.user_list.validate()

    def to_map(self):
        _map = super(ListLdapUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_admin is not None:
            result['IsAdmin'] = self.is_admin
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsAdmin') is not None:
            self.is_admin = m.get('IsAdmin')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserList') is not None:
            temp_model = ListLdapUsersResponseBodyUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        return self


class ListLdapUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListLdapUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLdapUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLdapUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, user_id=None, type=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.user_id = user_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteUserResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectClusterSettingRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, cluster_id=None, default_user=None, default_queue=None,
                 client_token=None, user_list=None, queue_list=None, host_list=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.default_user = default_user  # type: str
        self.default_queue = default_queue  # type: str
        self.client_token = client_token  # type: str
        self.user_list = user_list  # type: list[str]
        self.queue_list = queue_list  # type: list[str]
        self.host_list = host_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowProjectClusterSettingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.user_list is not None:
            result['UserList'] = self.user_list
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list
        if self.host_list is not None:
            result['HostList'] = self.host_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        if m.get('QueueList') is not None:
            self.queue_list = m.get('QueueList')
        if m.get('HostList') is not None:
            self.host_list = m.get('HostList')
        return self


class CreateFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowProjectClusterSettingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowProjectClusterSettingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFlowProjectClusterSettingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowProjectClusterSettingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowInstanceRequest(TeaModel):
    def __init__(self, project_id=None, id=None, region_id=None):
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow(TeaModel):
    def __init__(self, schedule_key=None, biz_date=None, dependency_instance_id=None, dependency_flow_id=None,
                 meet=None, flow_instance_id=None, project_id=None, flow_id=None):
        self.schedule_key = schedule_key  # type: str
        self.biz_date = biz_date  # type: long
        self.dependency_instance_id = dependency_instance_id  # type: str
        self.dependency_flow_id = dependency_flow_id  # type: str
        self.meet = meet  # type: bool
        self.flow_instance_id = flow_instance_id  # type: str
        self.project_id = project_id  # type: str
        self.flow_id = flow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_key is not None:
            result['ScheduleKey'] = self.schedule_key
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.dependency_instance_id is not None:
            result['DependencyInstanceId'] = self.dependency_instance_id
        if self.dependency_flow_id is not None:
            result['DependencyFlowId'] = self.dependency_flow_id
        if self.meet is not None:
            result['Meet'] = self.meet
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScheduleKey') is not None:
            self.schedule_key = m.get('ScheduleKey')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DependencyInstanceId') is not None:
            self.dependency_instance_id = m.get('DependencyInstanceId')
        if m.get('DependencyFlowId') is not None:
            self.dependency_flow_id = m.get('DependencyFlowId')
        if m.get('Meet') is not None:
            self.meet = m.get('Meet')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class DescribeFlowInstanceResponseBodyDependencyFlowList(TeaModel):
    def __init__(self, parent_flow=None):
        self.parent_flow = parent_flow  # type: list[DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow]

    def validate(self):
        if self.parent_flow:
            for k in self.parent_flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowInstanceResponseBodyDependencyFlowList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParentFlow'] = []
        if self.parent_flow is not None:
            for k in self.parent_flow:
                result['ParentFlow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.parent_flow = []
        if m.get('ParentFlow') is not None:
            for k in m.get('ParentFlow'):
                temp_model = DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow()
                self.parent_flow.append(temp_model.from_map(k))
        return self


class DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance(TeaModel):
    def __init__(self, status=None, type=None, fail_act=None, project_id=None, retry_interval=None, job_type=None,
                 host_name=None, external_info=None, gmt_modified=None, retries=None, end_time=None, start_time=None,
                 external_status=None, job_name=None, node_name=None, job_id=None, gmt_create=None, external_id=None, duration=None,
                 id=None, pending=None, cluster_id=None, max_retry=None):
        self.status = status  # type: str
        self.type = type  # type: str
        self.fail_act = fail_act  # type: str
        self.project_id = project_id  # type: str
        self.retry_interval = retry_interval  # type: str
        self.job_type = job_type  # type: str
        self.host_name = host_name  # type: str
        self.external_info = external_info  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.retries = retries  # type: int
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.external_status = external_status  # type: str
        self.job_name = job_name  # type: str
        self.node_name = node_name  # type: str
        self.job_id = job_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.external_id = external_id  # type: str
        self.duration = duration  # type: long
        self.id = id  # type: str
        self.pending = pending  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.max_retry = max_retry  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        if self.pending is not None:
            result['Pending'] = self.pending
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Pending') is not None:
            self.pending = m.get('Pending')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        return self


class DescribeFlowInstanceResponseBodyNodeInstance(TeaModel):
    def __init__(self, node_instance=None):
        self.node_instance = node_instance  # type: list[DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance]

    def validate(self):
        if self.node_instance:
            for k in self.node_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowInstanceResponseBodyNodeInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeInstance'] = []
        if self.node_instance is not None:
            for k in self.node_instance:
                result['NodeInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node_instance = []
        if m.get('NodeInstance') is not None:
            for k in m.get('NodeInstance'):
                temp_model = DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance()
                self.node_instance.append(temp_model.from_map(k))
        return self


class DescribeFlowInstanceResponseBody(TeaModel):
    def __init__(self, status=None, project_id=None, namespace=None, flow_name=None, gmt_modified=None, flow_id=None,
                 cron_expression=None, end_time=None, start_time=None, has_node_failed=None, request_id=None, graph=None,
                 gmt_create=None, schedule_time=None, duration=None, id=None, cluster_id=None, dependency_flow_list=None,
                 node_instance=None):
        self.status = status  # type: str
        self.project_id = project_id  # type: str
        self.namespace = namespace  # type: str
        self.flow_name = flow_name  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.flow_id = flow_id  # type: str
        self.cron_expression = cron_expression  # type: str
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.has_node_failed = has_node_failed  # type: bool
        self.request_id = request_id  # type: str
        self.graph = graph  # type: str
        self.gmt_create = gmt_create  # type: long
        self.schedule_time = schedule_time  # type: long
        self.duration = duration  # type: long
        self.id = id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.dependency_flow_list = dependency_flow_list  # type: DescribeFlowInstanceResponseBodyDependencyFlowList
        self.node_instance = node_instance  # type: DescribeFlowInstanceResponseBodyNodeInstance

    def validate(self):
        if self.dependency_flow_list:
            self.dependency_flow_list.validate()
        if self.node_instance:
            self.node_instance.validate()

    def to_map(self):
        _map = super(DescribeFlowInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.has_node_failed is not None:
            result['HasNodeFailed'] = self.has_node_failed
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.dependency_flow_list is not None:
            result['DependencyFlowList'] = self.dependency_flow_list.to_map()
        if self.node_instance is not None:
            result['NodeInstance'] = self.node_instance.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('HasNodeFailed') is not None:
            self.has_node_failed = m.get('HasNodeFailed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DependencyFlowList') is not None:
            temp_model = DescribeFlowInstanceResponseBodyDependencyFlowList()
            self.dependency_flow_list = temp_model.from_map(m['DependencyFlowList'])
        if m.get('NodeInstance') is not None:
            temp_model = DescribeFlowInstanceResponseBodyNodeInstance()
            self.node_instance = temp_model.from_map(m['NodeInstance'])
        return self


class DescribeFlowInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeFlowInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectUserRequestUser(TeaModel):
    def __init__(self, user_id=None, user_name=None):
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowProjectUserRequestUser, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateFlowProjectUserRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, client_token=None, user=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.client_token = client_token  # type: str
        self.user = user  # type: list[CreateFlowProjectUserRequestUser]

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateFlowProjectUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = CreateFlowProjectUserRequestUser()
                self.user.append(temp_model.from_map(k))
        return self


class CreateFlowProjectUserResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowProjectUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowProjectUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFlowProjectUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowProjectUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowCategoryRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, name=None, type=None, parent_id=None, client_token=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.name = name  # type: str
        self.type = type  # type: str
        self.parent_id = parent_id  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateFlowCategoryResponseBody(TeaModel):
    def __init__(self, id=None, request_id=None):
        self.id = id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFlowCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectClusterSettingRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, cluster_id=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowProjectClusterSettingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DeleteFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowProjectClusterSettingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowProjectClusterSettingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFlowProjectClusterSettingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFlowProjectClusterSettingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLibrariesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, limit=None, page_number=None, page_size=None,
                 current_size=None, page_count=None, order_field=None, order_mode=None, cluster_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.limit = limit  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.current_size = current_size  # type: int
        self.page_count = page_count  # type: int
        self.order_field = order_field  # type: str
        self.order_mode = order_mode  # type: str
        self.cluster_biz_id = cluster_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLibrariesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        return self


class ListLibrariesResponseBodyItemsItem(TeaModel):
    def __init__(self, type=None, create_time=None, user_id=None, source_type=None, biz_id=None, scope=None,
                 library_version=None, name=None, properties=None, source_location=None):
        self.type = type  # type: str
        self.create_time = create_time  # type: long
        self.user_id = user_id  # type: str
        self.source_type = source_type  # type: str
        self.biz_id = biz_id  # type: str
        self.scope = scope  # type: str
        self.library_version = library_version  # type: str
        self.name = name  # type: str
        self.properties = properties  # type: str
        self.source_location = source_location  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLibrariesResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.library_version is not None:
            result['LibraryVersion'] = self.library_version
        if self.name is not None:
            result['Name'] = self.name
        if self.properties is not None:
            result['Properties'] = self.properties
        if self.source_location is not None:
            result['SourceLocation'] = self.source_location
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('LibraryVersion') is not None:
            self.library_version = m.get('LibraryVersion')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        if m.get('SourceLocation') is not None:
            self.source_location = m.get('SourceLocation')
        return self


class ListLibrariesResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[ListLibrariesResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLibrariesResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListLibrariesResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListLibrariesResponseBody(TeaModel):
    def __init__(self, next_token=None, page_size=None, page_number=None, request_id=None, total_count=None,
                 items=None):
        self.next_token = next_token  # type: str
        self.page_size = page_size  # type: int
        self.page_number = page_number  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.items = items  # type: ListLibrariesResponseBodyItems

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(ListLibrariesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListLibrariesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListLibrariesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListLibrariesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLibrariesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RunScalingActionRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, scaling_action_type=None, scaling_group_biz_id=None,
                 action_param=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.scaling_action_type = scaling_action_type  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.action_param = action_param  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RunScalingActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_action_type is not None:
            result['ScalingActionType'] = self.scaling_action_type
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.action_param is not None:
            result['ActionParam'] = self.action_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingActionType') is not None:
            self.scaling_action_type = m.get('ScalingActionType')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ActionParam') is not None:
            self.action_param = m.get('ActionParam')
        return self


class RunScalingActionResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        # requestId
        self.request_id = request_id  # type: str
        # data
        self.data = data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RunScalingActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class RunScalingActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RunScalingActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RunScalingActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RunScalingActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallLibrariesRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_biz_id_list=None, library_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_biz_id_list = cluster_biz_id_list  # type: list[str]
        self.library_biz_id = library_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallLibrariesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_biz_id_list is not None:
            result['ClusterBizIdList'] = self.cluster_biz_id_list
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterBizIdList') is not None:
            self.cluster_biz_id_list = m.get('ClusterBizIdList')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        return self


class InstallLibrariesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallLibrariesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InstallLibrariesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InstallLibrariesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InstallLibrariesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InstallLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowJobsRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, id=None, name=None, type=None, adhoc=None, page_number=None,
                 page_size=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.type = type  # type: str
        self.adhoc = adhoc  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFlowJobsResponseBodyJobListJobResourceListResource(TeaModel):
    def __init__(self, path=None, alias=None):
        self.path = path  # type: str
        self.alias = alias  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowJobsResponseBodyJobListJobResourceListResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class ListFlowJobsResponseBodyJobListJobResourceList(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[ListFlowJobsResponseBodyJobListJobResourceListResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowJobsResponseBodyJobListJobResourceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = ListFlowJobsResponseBodyJobListJobResourceListResource()
                self.resource.append(temp_model.from_map(k))
        return self


class ListFlowJobsResponseBodyJobListJob(TeaModel):
    def __init__(self, type=None, fail_act=None, custom_variables=None, retry_interval=None, env_conf=None,
                 param_conf=None, mode=None, gmt_modified=None, monitor_conf=None, last_instance_detail=None, run_conf=None,
                 params=None, description=None, gmt_create=None, category_id=None, adhoc=None, name=None, id=None,
                 max_retry=None, alert_conf=None, resource_list=None):
        self.type = type  # type: str
        self.fail_act = fail_act  # type: str
        self.custom_variables = custom_variables  # type: str
        self.retry_interval = retry_interval  # type: long
        self.env_conf = env_conf  # type: str
        self.param_conf = param_conf  # type: str
        self.mode = mode  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.monitor_conf = monitor_conf  # type: str
        self.last_instance_detail = last_instance_detail  # type: str
        self.run_conf = run_conf  # type: str
        self.params = params  # type: str
        self.description = description  # type: str
        self.gmt_create = gmt_create  # type: long
        self.category_id = category_id  # type: str
        self.adhoc = adhoc  # type: str
        self.name = name  # type: str
        self.id = id  # type: str
        self.max_retry = max_retry  # type: int
        self.alert_conf = alert_conf  # type: str
        self.resource_list = resource_list  # type: ListFlowJobsResponseBodyJobListJobResourceList

    def validate(self):
        if self.resource_list:
            self.resource_list.validate()

    def to_map(self):
        _map = super(ListFlowJobsResponseBodyJobListJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.last_instance_detail is not None:
            result['LastInstanceDetail'] = self.last_instance_detail
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.params is not None:
            result['Params'] = self.params
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.resource_list is not None:
            result['ResourceList'] = self.resource_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('LastInstanceDetail') is not None:
            self.last_instance_detail = m.get('LastInstanceDetail')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ResourceList') is not None:
            temp_model = ListFlowJobsResponseBodyJobListJobResourceList()
            self.resource_list = temp_model.from_map(m['ResourceList'])
        return self


class ListFlowJobsResponseBodyJobList(TeaModel):
    def __init__(self, job=None):
        self.job = job  # type: list[ListFlowJobsResponseBodyJobListJob]

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowJobsResponseBodyJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = ListFlowJobsResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class ListFlowJobsResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, total=None, job_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total = total  # type: int
        self.job_list = job_list  # type: ListFlowJobsResponseBodyJobList

    def validate(self):
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super(ListFlowJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('JobList') is not None:
            temp_model = ListFlowJobsResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        return self


class ListFlowJobsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListFlowJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFlowJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, id=None, name=None, status=None, description=None,
                 periodic=None, start_schedule=None, end_schedule=None, cron_expr=None, create_cluster=None, cluster_id=None,
                 host_name=None, application=None, alert_conf=None, alert_user_group_biz_id=None,
                 alert_ding_ding_group_biz_id=None, parent_flow_list=None, parent_category=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.status = status  # type: str
        self.description = description  # type: str
        self.periodic = periodic  # type: bool
        self.start_schedule = start_schedule  # type: long
        self.end_schedule = end_schedule  # type: long
        self.cron_expr = cron_expr  # type: str
        self.create_cluster = create_cluster  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.host_name = host_name  # type: str
        self.application = application  # type: str
        self.alert_conf = alert_conf  # type: str
        self.alert_user_group_biz_id = alert_user_group_biz_id  # type: str
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id  # type: str
        self.parent_flow_list = parent_flow_list  # type: str
        self.parent_category = parent_category  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.application is not None:
            result['Application'] = self.application
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        return self


class ModifyFlowResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRegionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionsResponseBodyBusinessLocationsDistrict(TeaModel):
    def __init__(self, ordering=None, cn_name=None, show_name=None, district_id=None, en_name=None):
        self.ordering = ordering  # type: str
        self.cn_name = cn_name  # type: str
        self.show_name = show_name  # type: str
        self.district_id = district_id  # type: str
        self.en_name = en_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRegionsResponseBodyBusinessLocationsDistrict, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ordering is not None:
            result['Ordering'] = self.ordering
        if self.cn_name is not None:
            result['CnName'] = self.cn_name
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        if self.district_id is not None:
            result['DistrictId'] = self.district_id
        if self.en_name is not None:
            result['EnName'] = self.en_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ordering') is not None:
            self.ordering = m.get('Ordering')
        if m.get('CnName') is not None:
            self.cn_name = m.get('CnName')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        if m.get('DistrictId') is not None:
            self.district_id = m.get('DistrictId')
        if m.get('EnName') is not None:
            self.en_name = m.get('EnName')
        return self


class DescribeRegionsResponseBodyBusinessLocations(TeaModel):
    def __init__(self, ordering=None, type=None, show_name=None, description=None, en_description=None, en_name=None,
                 cn_name=None, name=None, district=None):
        self.ordering = ordering  # type: str
        self.type = type  # type: str
        self.show_name = show_name  # type: str
        self.description = description  # type: str
        self.en_description = en_description  # type: str
        self.en_name = en_name  # type: str
        self.cn_name = cn_name  # type: str
        self.name = name  # type: str
        self.district = district  # type: DescribeRegionsResponseBodyBusinessLocationsDistrict

    def validate(self):
        if self.district:
            self.district.validate()

    def to_map(self):
        _map = super(DescribeRegionsResponseBodyBusinessLocations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ordering is not None:
            result['Ordering'] = self.ordering
        if self.type is not None:
            result['Type'] = self.type
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        if self.description is not None:
            result['Description'] = self.description
        if self.en_description is not None:
            result['EnDescription'] = self.en_description
        if self.en_name is not None:
            result['EnName'] = self.en_name
        if self.cn_name is not None:
            result['CnName'] = self.cn_name
        if self.name is not None:
            result['Name'] = self.name
        if self.district is not None:
            result['District'] = self.district.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ordering') is not None:
            self.ordering = m.get('Ordering')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnDescription') is not None:
            self.en_description = m.get('EnDescription')
        if m.get('EnName') is not None:
            self.en_name = m.get('EnName')
        if m.get('CnName') is not None:
            self.cn_name = m.get('CnName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('District') is not None:
            temp_model = DescribeRegionsResponseBodyBusinessLocationsDistrict()
            self.district = temp_model.from_map(m['District'])
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(self, request_id=None, business_locations=None):
        self.request_id = request_id  # type: str
        self.business_locations = business_locations  # type: list[DescribeRegionsResponseBodyBusinessLocations]

    def validate(self):
        if self.business_locations:
            for k in self.business_locations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRegionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['BusinessLocations'] = []
        if self.business_locations is not None:
            for k in self.business_locations:
                result['BusinessLocations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.business_locations = []
        if m.get('BusinessLocations') is not None:
            for k in m.get('BusinessLocations'):
                temp_model = DescribeRegionsResponseBodyBusinessLocations()
                self.business_locations.append(temp_model.from_map(k))
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRegionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRegionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLibraryStatusRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, limit=None, page_number=None, page_size=None,
                 current_size=None, page_count=None, order_field=None, order_mode=None, library_biz_id=None, cluster_biz_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.limit = limit  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.current_size = current_size  # type: int
        self.page_count = page_count  # type: int
        self.order_field = order_field  # type: str
        self.order_mode = order_mode  # type: str
        self.library_biz_id = library_biz_id  # type: str
        self.cluster_biz_id = cluster_biz_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLibraryStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        return self


class ListLibraryStatusResponseBodyItemsItem(TeaModel):
    def __init__(self, status=None, cluster_name=None, cluster_biz_id=None, library_biz_id=None, library_name=None):
        self.status = status  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cluster_biz_id = cluster_biz_id  # type: str
        self.library_biz_id = library_biz_id  # type: str
        self.library_name = library_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLibraryStatusResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.library_name is not None:
            result['LibraryName'] = self.library_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('LibraryName') is not None:
            self.library_name = m.get('LibraryName')
        return self


class ListLibraryStatusResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[ListLibraryStatusResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLibraryStatusResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListLibraryStatusResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListLibraryStatusResponseBody(TeaModel):
    def __init__(self, next_token=None, page_size=None, page_number=None, request_id=None, total_count=None,
                 items=None):
        self.next_token = next_token  # type: str
        self.page_size = page_size  # type: int
        self.page_number = page_number  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.items = items  # type: ListLibraryStatusResponseBodyItems

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(ListLibraryStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListLibraryStatusResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListLibraryStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListLibraryStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLibraryStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLibraryStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceConfigRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, service_name=None,
                 config_version=None, group_id=None, host_instance_id=None, tag_value=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.service_name = service_name  # type: str
        self.config_version = config_version  # type: str
        self.group_id = group_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue(TeaModel):
    def __init__(self, value=None, description=None, item_name=None, is_custom=None):
        self.value = value  # type: str
        self.description = description  # type: str
        self.item_name = item_name  # type: str
        self.is_custom = is_custom  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.description is not None:
            result['Description'] = self.description
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.is_custom is not None:
            result['IsCustom'] = self.is_custom
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('IsCustom') is not None:
            self.is_custom = m.get('IsCustom')
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList(TeaModel):
    def __init__(self, config_item_value=None):
        self.config_item_value = config_item_value  # type: list[DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue]

    def validate(self):
        if self.config_item_value:
            for k in self.config_item_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigItemValue'] = []
        if self.config_item_value is not None:
            for k in self.config_item_value:
                result['ConfigItemValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config_item_value = []
        if m.get('ConfigItemValue') is not None:
            for k in m.get('ConfigItemValue'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue()
                self.config_item_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue(TeaModel):
    def __init__(self, config_name=None, scope_id=None, scope=None, allow_custom=None, config_item_value_list=None):
        self.config_name = config_name  # type: str
        self.scope_id = scope_id  # type: long
        self.scope = scope  # type: str
        self.allow_custom = allow_custom  # type: bool
        self.config_item_value_list = config_item_value_list  # type: DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList

    def validate(self):
        if self.config_item_value_list:
            self.config_item_value_list.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.scope_id is not None:
            result['ScopeId'] = self.scope_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.allow_custom is not None:
            result['AllowCustom'] = self.allow_custom
        if self.config_item_value_list is not None:
            result['ConfigItemValueList'] = self.config_item_value_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ScopeId') is not None:
            self.scope_id = m.get('ScopeId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('AllowCustom') is not None:
            self.allow_custom = m.get('AllowCustom')
        if m.get('ConfigItemValueList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList()
            self.config_item_value_list = temp_model.from_map(m['ConfigItemValueList'])
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueList(TeaModel):
    def __init__(self, config_value=None):
        self.config_value = config_value  # type: list[DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue]

    def validate(self):
        if self.config_value:
            for k in self.config_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigConfigValueList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigValue'] = []
        if self.config_value is not None:
            for k in self.config_value:
                result['ConfigValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config_value = []
        if m.get('ConfigValue') is not None:
            for k in m.get('ConfigValue'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue()
                self.config_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes(TeaModel):
    def __init__(self, property_type=None):
        self.property_type = property_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.property_type is not None:
            result['PropertyType'] = self.property_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PropertyType') is not None:
            self.property_type = m.get('PropertyType')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo(TeaModel):
    def __init__(self, value=None, label=None, description=None):
        self.value = value  # type: str
        self.label = label  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.label is not None:
            result['Label'] = self.label
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries(TeaModel):
    def __init__(self, value_entry_info=None):
        self.value_entry_info = value_entry_info  # type: list[DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo]

    def validate(self):
        if self.value_entry_info:
            for k in self.value_entry_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ValueEntryInfo'] = []
        if self.value_entry_info is not None:
            for k in self.value_entry_info:
                result['ValueEntryInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.value_entry_info = []
        if m.get('ValueEntryInfo') is not None:
            for k in m.get('ValueEntryInfo'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo()
                self.value_entry_info.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes(TeaModel):
    def __init__(self, type=None, maximum=None, unit=None, hidden=None, incrememt_step=None, read_only=None,
                 mimimum=None, entries=None):
        self.type = type  # type: str
        self.maximum = maximum  # type: str
        self.unit = unit  # type: str
        self.hidden = hidden  # type: bool
        self.incrememt_step = incrememt_step  # type: str
        self.read_only = read_only  # type: bool
        self.mimimum = mimimum  # type: str
        self.entries = entries  # type: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries

    def validate(self):
        if self.entries:
            self.entries.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.maximum is not None:
            result['Maximum'] = self.maximum
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.hidden is not None:
            result['Hidden'] = self.hidden
        if self.incrememt_step is not None:
            result['IncrememtStep'] = self.incrememt_step
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.mimimum is not None:
            result['Mimimum'] = self.mimimum
        if self.entries is not None:
            result['Entries'] = self.entries.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Maximum') is not None:
            self.maximum = m.get('Maximum')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Hidden') is not None:
            self.hidden = m.get('Hidden')
        if m.get('IncrememtStep') is not None:
            self.incrememt_step = m.get('IncrememtStep')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('Mimimum') is not None:
            self.mimimum = m.get('Mimimum')
        if m.get('Entries') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries()
            self.entries = temp_model.from_map(m['Entries'])
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay(TeaModel):
    def __init__(self, effect_type=None, invoke_service_name=None):
        self.effect_type = effect_type  # type: str
        self.invoke_service_name = invoke_service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect_type is not None:
            result['EffectType'] = self.effect_type
        if self.invoke_service_name is not None:
            result['InvokeServiceName'] = self.invoke_service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EffectType') is not None:
            self.effect_type = m.get('EffectType')
        if m.get('InvokeServiceName') is not None:
            self.invoke_service_name = m.get('InvokeServiceName')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo(TeaModel):
    def __init__(self, display_name=None, value=None, description=None, component=None, file_name=None, name=None,
                 service_name=None, property_types=None, property_value_attributes=None, effect_way=None):
        self.display_name = display_name  # type: str
        self.value = value  # type: str
        self.description = description  # type: str
        self.component = component  # type: str
        self.file_name = file_name  # type: str
        self.name = name  # type: str
        self.service_name = service_name  # type: str
        self.property_types = property_types  # type: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes
        self.property_value_attributes = property_value_attributes  # type: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes
        self.effect_way = effect_way  # type: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay

    def validate(self):
        if self.property_types:
            self.property_types.validate()
        if self.property_value_attributes:
            self.property_value_attributes.validate()
        if self.effect_way:
            self.effect_way.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.value is not None:
            result['Value'] = self.value
        if self.description is not None:
            result['Description'] = self.description
        if self.component is not None:
            result['Component'] = self.component
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.name is not None:
            result['Name'] = self.name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.property_types is not None:
            result['PropertyTypes'] = self.property_types.to_map()
        if self.property_value_attributes is not None:
            result['PropertyValueAttributes'] = self.property_value_attributes.to_map()
        if self.effect_way is not None:
            result['EffectWay'] = self.effect_way.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Component') is not None:
            self.component = m.get('Component')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('PropertyTypes') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes()
            self.property_types = temp_model.from_map(m['PropertyTypes'])
        if m.get('PropertyValueAttributes') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes()
            self.property_value_attributes = temp_model.from_map(m['PropertyValueAttributes'])
        if m.get('EffectWay') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay()
            self.effect_way = temp_model.from_map(m['EffectWay'])
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList(TeaModel):
    def __init__(self, property_info=None):
        self.property_info = property_info  # type: list[DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo]

    def validate(self):
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfig(TeaModel):
    def __init__(self, applied=None, comment=None, create_time=None, config_version=None, author=None,
                 service_name=None, config_value_list=None, property_info_list=None):
        self.applied = applied  # type: str
        self.comment = comment  # type: str
        self.create_time = create_time  # type: str
        self.config_version = config_version  # type: str
        self.author = author  # type: str
        self.service_name = service_name  # type: str
        self.config_value_list = config_value_list  # type: DescribeClusterServiceConfigResponseBodyConfigConfigValueList
        self.property_info_list = property_info_list  # type: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList

    def validate(self):
        if self.config_value_list:
            self.config_value_list.validate()
        if self.property_info_list:
            self.property_info_list.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBodyConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applied is not None:
            result['Applied'] = self.applied
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.author is not None:
            result['Author'] = self.author
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_value_list is not None:
            result['ConfigValueList'] = self.config_value_list.to_map()
        if self.property_info_list is not None:
            result['PropertyInfoList'] = self.property_info_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Applied') is not None:
            self.applied = m.get('Applied')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigValueList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueList()
            self.config_value_list = temp_model.from_map(m['ConfigValueList'])
        if m.get('PropertyInfoList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList()
            self.property_info_list = temp_model.from_map(m['PropertyInfoList'])
        return self


class DescribeClusterServiceConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, config=None):
        self.request_id = request_id  # type: str
        self.config = config  # type: DescribeClusterServiceConfigResponseBodyConfig

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Config') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class DescribeClusterServiceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeClusterServiceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowProjectClusterSettingRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, cluster_id=None, default_user=None, default_queue=None,
                 user_list=None, queue_list=None, host_list=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.default_user = default_user  # type: str
        self.default_queue = default_queue  # type: str
        self.user_list = user_list  # type: list[str]
        self.queue_list = queue_list  # type: list[str]
        self.host_list = host_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowProjectClusterSettingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.user_list is not None:
            result['UserList'] = self.user_list
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list
        if self.host_list is not None:
            result['HostList'] = self.host_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        if m.get('QueueList') is not None:
            self.queue_list = m.get('QueueList')
        if m.get('HostList') is not None:
            self.host_list = m.get('HostList')
        return self


class ModifyFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyFlowProjectClusterSettingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowProjectClusterSettingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyFlowProjectClusterSettingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyFlowProjectClusterSettingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectUserRequest(TeaModel):
    def __init__(self, region_id=None, project_id=None, user_name=None):
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowProjectUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DeleteFlowProjectUserResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowProjectUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowProjectUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFlowProjectUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFlowProjectUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterV2RequestUserInfo(TeaModel):
    def __init__(self, password=None, user_id=None, user_name=None):
        self.password = password  # type: str
        self.user_id = user_id  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestUserInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateClusterV2RequestHostComponentInfo(TeaModel):
    def __init__(self, component_name_list=None, host_name=None, service_name=None):
        self.component_name_list = component_name_list  # type: list[str]
        self.host_name = host_name  # type: str
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestHostComponentInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name_list is not None:
            result['ComponentNameList'] = self.component_name_list
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComponentNameList') is not None:
            self.component_name_list = m.get('ComponentNameList')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateClusterV2RequestServiceInfo(TeaModel):
    def __init__(self, service_name=None, service_version=None):
        self.service_name = service_name  # type: str
        self.service_version = service_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestServiceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        return self


class CreateClusterV2RequestPromotionInfo(TeaModel):
    def __init__(self, product_code=None, promotion_option_code=None, promotion_option_no=None):
        self.product_code = product_code  # type: str
        self.promotion_option_code = promotion_option_code  # type: str
        self.promotion_option_no = promotion_option_no  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestPromotionInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.promotion_option_code is not None:
            result['PromotionOptionCode'] = self.promotion_option_code
        if self.promotion_option_no is not None:
            result['PromotionOptionNo'] = self.promotion_option_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('PromotionOptionCode') is not None:
            self.promotion_option_code = m.get('PromotionOptionCode')
        if m.get('PromotionOptionNo') is not None:
            self.promotion_option_no = m.get('PromotionOptionNo')
        return self


class CreateClusterV2RequestHostGroup(TeaModel):
    def __init__(self, auto_renew=None, charge_type=None, cluster_id=None, comment=None, create_type=None,
                 disk_capacity=None, disk_count=None, disk_type=None, gpu_driver=None, host_group_id=None, host_group_name=None,
                 host_group_type=None, instance_type=None, node_count=None, period=None, sys_disk_capacity=None, sys_disk_type=None,
                 v_switch_id=None):
        self.auto_renew = auto_renew  # type: bool
        self.charge_type = charge_type  # type: str
        self.cluster_id = cluster_id  # type: str
        self.comment = comment  # type: str
        self.create_type = create_type  # type: str
        self.disk_capacity = disk_capacity  # type: int
        self.disk_count = disk_count  # type: int
        self.disk_type = disk_type  # type: str
        self.gpu_driver = gpu_driver  # type: str
        self.host_group_id = host_group_id  # type: str
        self.host_group_name = host_group_name  # type: str
        self.host_group_type = host_group_type  # type: str
        self.instance_type = instance_type  # type: str
        self.node_count = node_count  # type: int
        self.period = period  # type: int
        self.sys_disk_capacity = sys_disk_capacity  # type: int
        self.sys_disk_type = sys_disk_type  # type: str
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestHostGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.gpu_driver is not None:
            result['GpuDriver'] = self.gpu_driver
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.period is not None:
            result['Period'] = self.period
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('GpuDriver') is not None:
            self.gpu_driver = m.get('GpuDriver')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateClusterV2RequestBootstrapAction(TeaModel):
    def __init__(self, arg=None, name=None, path=None):
        self.arg = arg  # type: str
        self.name = name  # type: str
        self.path = path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestBootstrapAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class CreateClusterV2RequestConfig(TeaModel):
    def __init__(self, config_key=None, config_value=None, encrypt=None, file_name=None, replace=None,
                 service_name=None):
        self.config_key = config_key  # type: str
        self.config_value = config_value  # type: str
        self.encrypt = encrypt  # type: str
        self.file_name = file_name  # type: str
        self.replace = replace  # type: str
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateClusterV2RequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2RequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateClusterV2Request(TeaModel):
    def __init__(self, resource_owner_id=None, name=None, region_id=None, zone_id=None, log_path=None,
                 security_group_id=None, is_open_public_ip=None, security_group_name=None, charge_type=None, period=None, auto=None,
                 auto_pay_order=None, vpc_id=None, v_switch_id=None, net_type=None, user_defined_emr_ecs_role=None, emr_ver=None,
                 cluster_type=None, enable_high_availability=None, use_local_meta_db=None, enable_ssh=None,
                 instance_generation=None, master_pwd=None, key_pair_name=None, meta_store_type=None, meta_store_conf=None,
                 click_house_conf=None, extra_attributes=None, deposit_type=None, machine_type=None, use_custom_hive_meta_db=None,
                 init_custom_hive_meta_db=None, configurations=None, enable_eas=None, related_cluster_id=None, white_list_type=None,
                 authorize_content=None, resource_group_id=None, client_token=None, user_info=None, host_component_info=None,
                 service_info=None, promotion_info=None, host_group=None, bootstrap_action=None, config=None, tag=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.name = name  # type: str
        self.region_id = region_id  # type: str
        self.zone_id = zone_id  # type: str
        self.log_path = log_path  # type: str
        self.security_group_id = security_group_id  # type: str
        self.is_open_public_ip = is_open_public_ip  # type: bool
        self.security_group_name = security_group_name  # type: str
        self.charge_type = charge_type  # type: str
        self.period = period  # type: int
        self.auto = auto  # type: bool
        self.auto_pay_order = auto_pay_order  # type: bool
        self.vpc_id = vpc_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.net_type = net_type  # type: str
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role  # type: str
        self.emr_ver = emr_ver  # type: str
        self.cluster_type = cluster_type  # type: str
        self.enable_high_availability = enable_high_availability  # type: bool
        self.use_local_meta_db = use_local_meta_db  # type: bool
        self.enable_ssh = enable_ssh  # type: bool
        self.instance_generation = instance_generation  # type: str
        self.master_pwd = master_pwd  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.meta_store_type = meta_store_type  # type: str
        self.meta_store_conf = meta_store_conf  # type: str
        self.click_house_conf = click_house_conf  # type: str
        self.extra_attributes = extra_attributes  # type: str
        self.deposit_type = deposit_type  # type: str
        self.machine_type = machine_type  # type: str
        self.use_custom_hive_meta_db = use_custom_hive_meta_db  # type: bool
        self.init_custom_hive_meta_db = init_custom_hive_meta_db  # type: bool
        self.configurations = configurations  # type: str
        self.enable_eas = enable_eas  # type: bool
        self.related_cluster_id = related_cluster_id  # type: str
        self.white_list_type = white_list_type  # type: str
        self.authorize_content = authorize_content  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.client_token = client_token  # type: str
        self.user_info = user_info  # type: list[CreateClusterV2RequestUserInfo]
        self.host_component_info = host_component_info  # type: list[CreateClusterV2RequestHostComponentInfo]
        self.service_info = service_info  # type: list[CreateClusterV2RequestServiceInfo]
        self.promotion_info = promotion_info  # type: list[CreateClusterV2RequestPromotionInfo]
        self.host_group = host_group  # type: list[CreateClusterV2RequestHostGroup]
        self.bootstrap_action = bootstrap_action  # type: list[CreateClusterV2RequestBootstrapAction]
        self.config = config  # type: list[CreateClusterV2RequestConfig]
        self.tag = tag  # type: list[CreateClusterV2RequestTag]

    def validate(self):
        if self.user_info:
            for k in self.user_info:
                if k:
                    k.validate()
        if self.host_component_info:
            for k in self.host_component_info:
                if k:
                    k.validate()
        if self.service_info:
            for k in self.service_info:
                if k:
                    k.validate()
        if self.promotion_info:
            for k in self.promotion_info:
                if k:
                    k.validate()
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateClusterV2Request, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.auto is not None:
            result['Auto'] = self.auto
        if self.auto_pay_order is not None:
            result['AutoPayOrder'] = self.auto_pay_order
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.enable_high_availability is not None:
            result['EnableHighAvailability'] = self.enable_high_availability
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.enable_ssh is not None:
            result['EnableSsh'] = self.enable_ssh
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.click_house_conf is not None:
            result['ClickHouseConf'] = self.click_house_conf
        if self.extra_attributes is not None:
            result['ExtraAttributes'] = self.extra_attributes
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDB'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDB'] = self.init_custom_hive_meta_db
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.enable_eas is not None:
            result['EnableEas'] = self.enable_eas
        if self.related_cluster_id is not None:
            result['RelatedClusterId'] = self.related_cluster_id
        if self.white_list_type is not None:
            result['WhiteListType'] = self.white_list_type
        if self.authorize_content is not None:
            result['AuthorizeContent'] = self.authorize_content
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['UserInfo'] = []
        if self.user_info is not None:
            for k in self.user_info:
                result['UserInfo'].append(k.to_map() if k else None)
        result['HostComponentInfo'] = []
        if self.host_component_info is not None:
            for k in self.host_component_info:
                result['HostComponentInfo'].append(k.to_map() if k else None)
        result['ServiceInfo'] = []
        if self.service_info is not None:
            for k in self.service_info:
                result['ServiceInfo'].append(k.to_map() if k else None)
        result['PromotionInfo'] = []
        if self.promotion_info is not None:
            for k in self.promotion_info:
                result['PromotionInfo'].append(k.to_map() if k else None)
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Auto') is not None:
            self.auto = m.get('Auto')
        if m.get('AutoPayOrder') is not None:
            self.auto_pay_order = m.get('AutoPayOrder')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EnableHighAvailability') is not None:
            self.enable_high_availability = m.get('EnableHighAvailability')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('EnableSsh') is not None:
            self.enable_ssh = m.get('EnableSsh')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('ClickHouseConf') is not None:
            self.click_house_conf = m.get('ClickHouseConf')
        if m.get('ExtraAttributes') is not None:
            self.extra_attributes = m.get('ExtraAttributes')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDB') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDB')
        if m.get('InitCustomHiveMetaDB') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDB')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EnableEas') is not None:
            self.enable_eas = m.get('EnableEas')
        if m.get('RelatedClusterId') is not None:
            self.related_cluster_id = m.get('RelatedClusterId')
        if m.get('WhiteListType') is not None:
            self.white_list_type = m.get('WhiteListType')
        if m.get('AuthorizeContent') is not None:
            self.authorize_content = m.get('AuthorizeContent')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.user_info = []
        if m.get('UserInfo') is not None:
            for k in m.get('UserInfo'):
                temp_model = CreateClusterV2RequestUserInfo()
                self.user_info.append(temp_model.from_map(k))
        self.host_component_info = []
        if m.get('HostComponentInfo') is not None:
            for k in m.get('HostComponentInfo'):
                temp_model = CreateClusterV2RequestHostComponentInfo()
                self.host_component_info.append(temp_model.from_map(k))
        self.service_info = []
        if m.get('ServiceInfo') is not None:
            for k in m.get('ServiceInfo'):
                temp_model = CreateClusterV2RequestServiceInfo()
                self.service_info.append(temp_model.from_map(k))
        self.promotion_info = []
        if m.get('PromotionInfo') is not None:
            for k in m.get('PromotionInfo'):
                temp_model = CreateClusterV2RequestPromotionInfo()
                self.promotion_info.append(temp_model.from_map(k))
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = CreateClusterV2RequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateClusterV2RequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateClusterV2RequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateClusterV2RequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateClusterV2ResponseBody(TeaModel):
    def __init__(self, cluster_id=None, core_order_id=None, emr_order_id=None, master_order_id=None,
                 request_id=None):
        self.cluster_id = cluster_id  # type: str
        self.core_order_id = core_order_id  # type: str
        self.emr_order_id = emr_order_id  # type: str
        self.master_order_id = master_order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateClusterV2ResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.core_order_id is not None:
            result['CoreOrderId'] = self.core_order_id
        if self.emr_order_id is not None:
            result['EmrOrderId'] = self.emr_order_id
        if self.master_order_id is not None:
            result['MasterOrderId'] = self.master_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CoreOrderId') is not None:
            self.core_order_id = m.get('CoreOrderId')
        if m.get('EmrOrderId') is not None:
            self.emr_order_id = m.get('EmrOrderId')
        if m.get('MasterOrderId') is not None:
            self.master_order_id = m.get('MasterOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClusterV2Response(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateClusterV2ResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateClusterV2Response, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyClusterNameRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, id=None, name=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterNameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ModifyClusterNameResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyClusterNameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyClusterNameResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyClusterNameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyClusterNameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyClusterNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationHostTaskRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, operation_id=None, host_id=None,
                 status=None, page_number=None, page_size=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.operation_id = operation_id  # type: str
        self.host_id = host_id  # type: str
        self.status = status  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterOperationHostTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask(TeaModel):
    def __init__(self, status=None, percentage=None, task_id=None, task_name=None):
        self.status = status  # type: str
        self.percentage = percentage  # type: str
        self.task_id = task_id  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList(TeaModel):
    def __init__(self, cluster_operation_host_task=None):
        self.cluster_operation_host_task = cluster_operation_host_task  # type: list[ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask]

    def validate(self):
        if self.cluster_operation_host_task:
            for k in self.cluster_operation_host_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperationHostTask'] = []
        if self.cluster_operation_host_task is not None:
            for k in self.cluster_operation_host_task:
                result['ClusterOperationHostTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_operation_host_task = []
        if m.get('ClusterOperationHostTask') is not None:
            for k in m.get('ClusterOperationHostTask'):
                temp_model = ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask()
                self.cluster_operation_host_task.append(temp_model.from_map(k))
        return self


class ListClusterOperationHostTaskResponseBody(TeaModel):
    def __init__(self, page_size=None, request_id=None, page_number=None, total_count=None,
                 cluster_operation_host_task_list=None):
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.cluster_operation_host_task_list = cluster_operation_host_task_list  # type: ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList

    def validate(self):
        if self.cluster_operation_host_task_list:
            self.cluster_operation_host_task_list.validate()

    def to_map(self):
        _map = super(ListClusterOperationHostTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.cluster_operation_host_task_list is not None:
            result['ClusterOperationHostTaskList'] = self.cluster_operation_host_task_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ClusterOperationHostTaskList') is not None:
            temp_model = ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList()
            self.cluster_operation_host_task_list = temp_model.from_map(m['ClusterOperationHostTaskList'])
        return self


class ListClusterOperationHostTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterOperationHostTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterOperationHostTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationHostTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingConfigItemRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, scaling_config_item_id=None,
                 scaling_group_biz_id=None, config_item_type=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.scaling_config_item_id = scaling_config_item_id  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.config_item_type = config_item_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingConfigItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_config_item_id is not None:
            result['ScalingConfigItemId'] = self.scaling_config_item_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingConfigItemId') is not None:
            self.scaling_config_item_id = m.get('ScalingConfigItemId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        return self


class DescribeScalingConfigItemResponseBody(TeaModel):
    def __init__(self, request_id=None, config_item_type=None, scaling_group_biz_id=None,
                 scaling_config_item_biz_id=None, config_item_information=None):
        # requestId
        self.request_id = request_id  # type: str
        # data
        self.config_item_type = config_item_type  # type: str
        self.scaling_group_biz_id = scaling_group_biz_id  # type: str
        self.scaling_config_item_biz_id = scaling_config_item_biz_id  # type: str
        self.config_item_information = config_item_information  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeScalingConfigItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.scaling_config_item_biz_id is not None:
            result['ScalingConfigItemBizId'] = self.scaling_config_item_biz_id
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ScalingConfigItemBizId') is not None:
            self.scaling_config_item_biz_id = m.get('ScalingConfigItemBizId')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        return self


class DescribeScalingConfigItemResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeScalingConfigItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeScalingConfigItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHostRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, host_instance_id=None,
                 host_group_id=None, host_name=None, private_ip=None, public_ip=None, group_type=None, component_name=None,
                 page_number=None, page_size=None, status_list=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.host_group_id = host_group_id  # type: str
        self.host_name = host_name  # type: str
        self.private_ip = private_ip  # type: str
        self.public_ip = public_ip  # type: str
        self.group_type = group_type  # type: str
        self.component_name = component_name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.status_list = status_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterHostRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListClusterHostResponseBodyHostListHostDiskListDisk(TeaModel):
    def __init__(self, type=None, disk_type=None, disk_id=None, device=None, disk_size=None):
        self.type = type  # type: str
        self.disk_type = disk_type  # type: str
        self.disk_id = disk_id  # type: str
        self.device = device  # type: str
        self.disk_size = disk_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterHostResponseBodyHostListHostDiskListDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        return self


class ListClusterHostResponseBodyHostListHostDiskList(TeaModel):
    def __init__(self, disk=None):
        self.disk = disk  # type: list[ListClusterHostResponseBodyHostListHostDiskListDisk]

    def validate(self):
        if self.disk:
            for k in self.disk:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterHostResponseBodyHostListHostDiskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Disk'] = []
        if self.disk is not None:
            for k in self.disk:
                result['Disk'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.disk = []
        if m.get('Disk') is not None:
            for k in m.get('Disk'):
                temp_model = ListClusterHostResponseBodyHostListHostDiskListDisk()
                self.disk.append(temp_model.from_map(k))
        return self


class ListClusterHostResponseBodyHostListHost(TeaModel):
    def __init__(self, serial_number=None, type=None, status=None, private_ip=None, create_time=None,
                 charge_type=None, host_name=None, host_group_id=None, instance_type=None, host_instance_id=None,
                 support_ip_v6=None, cpu=None, expired_time=None, zone_id=None, public_ip=None, instance_status=None, memory=None,
                 emr_expired_time=None, role=None, disk_list=None):
        self.serial_number = serial_number  # type: str
        self.type = type  # type: str
        self.status = status  # type: str
        self.private_ip = private_ip  # type: str
        self.create_time = create_time  # type: str
        self.charge_type = charge_type  # type: str
        self.host_name = host_name  # type: str
        self.host_group_id = host_group_id  # type: str
        self.instance_type = instance_type  # type: str
        self.host_instance_id = host_instance_id  # type: str
        self.support_ip_v6 = support_ip_v6  # type: bool
        self.cpu = cpu  # type: int
        self.expired_time = expired_time  # type: long
        self.zone_id = zone_id  # type: str
        self.public_ip = public_ip  # type: str
        self.instance_status = instance_status  # type: str
        self.memory = memory  # type: int
        self.emr_expired_time = emr_expired_time  # type: str
        self.role = role  # type: str
        self.disk_list = disk_list  # type: ListClusterHostResponseBodyHostListHostDiskList

    def validate(self):
        if self.disk_list:
            self.disk_list.validate()

    def to_map(self):
        _map = super(ListClusterHostResponseBodyHostListHost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.support_ip_v6 is not None:
            result['SupportIpV6'] = self.support_ip_v6
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.instance_status is not None:
            result['InstanceStatus'] = self.instance_status
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.emr_expired_time is not None:
            result['EmrExpiredTime'] = self.emr_expired_time
        if self.role is not None:
            result['Role'] = self.role
        if self.disk_list is not None:
            result['DiskList'] = self.disk_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('SupportIpV6') is not None:
            self.support_ip_v6 = m.get('SupportIpV6')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('InstanceStatus') is not None:
            self.instance_status = m.get('InstanceStatus')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('EmrExpiredTime') is not None:
            self.emr_expired_time = m.get('EmrExpiredTime')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DiskList') is not None:
            temp_model = ListClusterHostResponseBodyHostListHostDiskList()
            self.disk_list = temp_model.from_map(m['DiskList'])
        return self


class ListClusterHostResponseBodyHostList(TeaModel):
    def __init__(self, host=None):
        self.host = host  # type: list[ListClusterHostResponseBodyHostListHost]

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterHostResponseBodyHostList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = ListClusterHostResponseBodyHostListHost()
                self.host.append(temp_model.from_map(k))
        return self


class ListClusterHostResponseBody(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total=None, host_list=None):
        self.request_id = request_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.host_list = host_list  # type: ListClusterHostResponseBodyHostList

    def validate(self):
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super(ListClusterHostResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('HostList') is not None:
            temp_model = ListClusterHostResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListClusterHostResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListClusterHostResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterHostResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScalingGroupRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, name=None, description=None, host_group_id=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.name = name  # type: str
        self.description = description  # type: str
        self.host_group_id = host_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateScalingGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        return self


class CreateScalingGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        # requestId
        self.request_id = request_id  # type: str
        # data
        self.data = data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateScalingGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateScalingGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateScalingGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateScalingGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceRequest(TeaModel):
    def __init__(self, resource_owner_id=None, region_id=None, cluster_id=None, service_name=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.region_id = region_id  # type: str
        self.cluster_id = cluster_id  # type: str
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction(TeaModel):
    def __init__(self, display_name=None, action_name=None, component_name=None, service_name=None, command=None):
        self.display_name = display_name  # type: str
        self.action_name = action_name  # type: str
        self.component_name = component_name  # type: str
        self.service_name = service_name  # type: str
        self.command = command  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.command is not None:
            result['Command'] = self.command
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        return self


class DescribeClusterServiceResponseBodyServiceInfoServiceActionList(TeaModel):
    def __init__(self, service_action=None):
        self.service_action = service_action  # type: list[DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction]

    def validate(self):
        if self.service_action:
            for k in self.service_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBodyServiceInfoServiceActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ServiceAction'] = []
        if self.service_action is not None:
            for k in self.service_action:
                result['ServiceAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.service_action = []
        if m.get('ServiceAction') is not None:
            for k in m.get('ServiceAction'):
                temp_model = DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction()
                self.service_action.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary(TeaModel):
    def __init__(self, key=None, display_name=None, status=None, type=None, value=None, desired_stopped_value=None,
                 alert_info=None, category=None):
        self.key = key  # type: str
        self.display_name = display_name  # type: str
        self.status = status  # type: str
        self.type = type  # type: str
        self.value = value  # type: str
        self.desired_stopped_value = desired_stopped_value  # type: int
        self.alert_info = alert_info  # type: str
        self.category = category  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.desired_stopped_value is not None:
            result['DesiredStoppedValue'] = self.desired_stopped_value
        if self.alert_info is not None:
            result['AlertInfo'] = self.alert_info
        if self.category is not None:
            result['Category'] = self.category
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('DesiredStoppedValue') is not None:
            self.desired_stopped_value = m.get('DesiredStoppedValue')
        if m.get('AlertInfo') is not None:
            self.alert_info = m.get('AlertInfo')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        return self


class DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList(TeaModel):
    def __init__(self, cluster_service_summary=None):
        self.cluster_service_summary = cluster_service_summary  # type: list[DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary]

    def validate(self):
        if self.cluster_service_summary:
            for k in self.cluster_service_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterServiceSummary'] = []
        if self.cluster_service_summary is not None:
            for k in self.cluster_service_summary:
                result['ClusterServiceSummary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_service_summary = []
        if m.get('ClusterServiceSummary') is not None:
            for k in m.get('ClusterServiceSummary'):
                temp_model = DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary()
                self.cluster_service_summary.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList(TeaModel):
    def __init__(self, service=None):
        self.service = service  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service is not None:
            result['Service'] = self.service
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Service') is not None:
            self.service = m.get('Service')
        return self


class DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList(TeaModel):
    def __init__(self, service=None):
        self.service = service  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service is not None:
            result['Service'] = self.service
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Service') is not None:
            self.service = m.get('Service')
        return self


class DescribeClusterServiceResponseBodyServiceInfo(TeaModel):
    def __init__(self, need_restart_info=None, service_version=None, service_status=None, service_name=None,
                 need_restart_num=None, service_action_list=None, cluster_service_summary_list=None,
                 need_restart_host_id_list=None, need_restart_component_name_list=None):
        self.need_restart_info = need_restart_info  # type: str
        self.service_version = service_version  # type: str
        self.service_status = service_status  # type: str
        self.service_name = service_name  # type: str
        self.need_restart_num = need_restart_num  # type: int
        self.service_action_list = service_action_list  # type: DescribeClusterServiceResponseBodyServiceInfoServiceActionList
        self.cluster_service_summary_list = cluster_service_summary_list  # type: DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList
        self.need_restart_host_id_list = need_restart_host_id_list  # type: DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList
        self.need_restart_component_name_list = need_restart_component_name_list  # type: DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList

    def validate(self):
        if self.service_action_list:
            self.service_action_list.validate()
        if self.cluster_service_summary_list:
            self.cluster_service_summary_list.validate()
        if self.need_restart_host_id_list:
            self.need_restart_host_id_list.validate()
        if self.need_restart_component_name_list:
            self.need_restart_component_name_list.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBodyServiceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_restart_info is not None:
            result['NeedRestartInfo'] = self.need_restart_info
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.need_restart_num is not None:
            result['NeedRestartNum'] = self.need_restart_num
        if self.service_action_list is not None:
            result['ServiceActionList'] = self.service_action_list.to_map()
        if self.cluster_service_summary_list is not None:
            result['ClusterServiceSummaryList'] = self.cluster_service_summary_list.to_map()
        if self.need_restart_host_id_list is not None:
            result['NeedRestartHostIdList'] = self.need_restart_host_id_list.to_map()
        if self.need_restart_component_name_list is not None:
            result['NeedRestartComponentNameList'] = self.need_restart_component_name_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NeedRestartInfo') is not None:
            self.need_restart_info = m.get('NeedRestartInfo')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('NeedRestartNum') is not None:
            self.need_restart_num = m.get('NeedRestartNum')
        if m.get('ServiceActionList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoServiceActionList()
            self.service_action_list = temp_model.from_map(m['ServiceActionList'])
        if m.get('ClusterServiceSummaryList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList()
            self.cluster_service_summary_list = temp_model.from_map(m['ClusterServiceSummaryList'])
        if m.get('NeedRestartHostIdList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList()
            self.need_restart_host_id_list = temp_model.from_map(m['NeedRestartHostIdList'])
        if m.get('NeedRestartComponentNameList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList()
            self.need_restart_component_name_list = temp_model.from_map(m['NeedRestartComponentNameList'])
        return self


class DescribeClusterServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, service_info=None):
        self.request_id = request_id  # type: str
        self.service_info = service_info  # type: DescribeClusterServiceResponseBodyServiceInfo

    def validate(self):
        if self.service_info:
            self.service_info.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.service_info is not None:
            result['ServiceInfo'] = self.service_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServiceInfo') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfo()
            self.service_info = temp_model.from_map(m['ServiceInfo'])
        return self


class DescribeClusterServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeClusterServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowProjectsRequest(TeaModel):
    def __init__(self, product_type=None, region_id=None, project_id=None, name=None, page_number=None,
                 page_size=None, resource_group_id=None):
        self.product_type = product_type  # type: str
        self.region_id = region_id  # type: str
        self.project_id = project_id  # type: str
        self.name = name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowProjectsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowProjectsResponseBodyProjectsProject(TeaModel):
    def __init__(self, description=None, user_id=None, gmt_create=None, gmt_modified=None, name=None, id=None):
        self.description = description  # type: str
        self.user_id = user_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.name = name  # type: str
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFlowProjectsResponseBodyProjectsProject, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListFlowProjectsResponseBodyProjects(TeaModel):
    def __init__(self, project=None):
        self.project = project  # type: list[ListFlowProjectsResponseBodyProjectsProject]

    def validate(self):
        if self.project:
            for k in self.project:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFlowProjectsResponseBodyProjects, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Project'] = []
        if self.project is not None:
            for k in self.project:
                result['Project'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.project = []
        if m.get('Project') is not None:
            for k in m.get('Project'):
                temp_model = ListFlowProjectsResponseBodyProjectsProject()
                self.project.append(temp_model.from_map(k))
        return self


class ListFlowProjectsResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, total=None, projects=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total = total  # type: int
        self.projects = projects  # type: ListFlowProjectsResponseBodyProjects

    def validate(self):
        if self.projects:
            self.projects.validate()

    def to_map(self):
        _map = super(ListFlowProjectsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.projects is not None:
            result['Projects'] = self.projects.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total'