# coding=utf-8
# Copyright 2020 The TensorFlow Datasets Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Tests for NYU Depth V2 Dataset."""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from tensorflow_datasets.image import nyu_depth_v2
import tensorflow_datasets.public_api as tfds


class NyuDepthV2Test(tfds.testing.DatasetBuilderTestCase):
  DATASET_CLASS = nyu_depth_v2.NyuDepthV2
  SPLITS = {"train": 2, "validation": 1}


if __name__ == "__main__":
  tfds.testing.test_main()
