# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['malwarebazaar', 'malwarebazaar.api']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'pydantic>=1.10.4,<2.0.0',
 'pyzipper>=0.3.6,<0.4.0',
 'requests>=2.28.1,<3.0.0']

extras_require = \
{'cli': ['rich>=13.3.2,<14.0.0', 'typer>=0.7.0,<0.8.0']}

entry_points = \
{'console_scripts': ['bazaar = malwarebazaar.bazaar:bazaar_app',
                     'yaraify = malwarebazaar.yaraify:yaraify_app']}

setup_kwargs = {
    'name': 'malwarebazaar',
    'version': '0.2.2',
    'description': 'CLI wrapper for malware bazaar API (bazaar.abuse.ch) and YARAify API (yaraify.abuse.ch)',
    'long_description': '# malwarebazaar\n**A [MalwareBazaar](https://bazaar.abuse.ch) and [YARAify](https://yaraify.abuse.ch) API wrapper and CLI**\n\nThis python module provides a Python API for MalwareBazaar as well as YARAify which can be used very easy to\naccess both APIs:\n\n```python\nfrom malwarebazaar import Bazaar, Yaraify\n\nb = Bazaar(\n    api_key="my_api_key"\n)\nb.query_hash(...)\n\ny = Yaraify(\n    api_key="my_api_key",\n    malpedia_key="optional_malpedia_api_key"\n)\ny.query_hash(...)\n```\n\nOptionally, this module provides a CLI for both services, too:\n\n```text\n$ bazaar --help\n\n Usage: bazaar [OPTIONS] COMMAND [ARGS]...                                                       \n                                                                                                 \n Query MalwareBazaar from the command line!                                                      \n                                                                                                 \n╭─ Options ─────────────────────────────────────────────────────────────────────────────────────╮\n│ --install-completion        [bash|zsh|fish|powershell|pwsh]  Install completion for the       │\n│                                                              specified shell.                 │\n│                                                              [default: None]                  │\n│ --show-completion           [bash|zsh|fish|powershell|pwsh]  Show completion for the          │\n│                                                              specified shell, to copy it or   │\n│                                                              customize the installation.      │\n│                                                              [default: None]                  │\n│ --help                                                       Show this message and exit.      │\n╰───────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Commands ────────────────────────────────────────────────────────────────────────────────────╮\n│ batch    Download daily malware batches. The DATE_STR argument needs to be in the format of   │\n│          YYYY-mm-dd.                                                                          │\n│ init     Initialize bazaar config file.                                                       │\n│ query    Query the MalwareBazaar API.                                                         │\n│ recent   Get information about recently submitted samples. The API allows either the last 100 │\n│          samples or samples uploaded in the last 60 minutes. As the amount is quite big, the  │\n│          default output type is csv.                                                          │\n│ version  Print and check bazaar version.                                                      │\n╰───────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n```text\n$ yaraify --help\n\n Usage: yaraify [OPTIONS] COMMAND [ARGS]...                                                      \n                                                                                                 \n Query YARAify from your command line!                                                           \n                                                                                                 \n╭─ Options ─────────────────────────────────────────────────────────────────────────────────────╮\n│ --install-completion        [bash|zsh|fish|powershell|pwsh]  Install completion for the       │\n│                                                              specified shell.                 │\n│                                                              [default: None]                  │\n│ --show-completion           [bash|zsh|fish|powershell|pwsh]  Show completion for the          │\n│                                                              specified shell, to copy it or   │\n│                                                              customize the installation.      │\n│                                                              [default: None]                  │\n│ --help                                                       Show this message and exit.      │\n╰───────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Commands ────────────────────────────────────────────────────────────────────────────────────╮\n│ download           Download all TLP:CLEAR YARAify rules.                                      │\n│ get                Fetch Yara rule by its UUID                                                │\n│ init               Initialize YARAify cli.                                                    │\n│ query              Query the YARAify API.                                                     │\n│ recent             Query for recent Yara rules.                                               │\n│ task               Fetch task results                                                         │\n│ version            Print and check yaraify version.                                           │\n╰───────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n## Installation\nUsually, this module will be distributed via PyPI. If you want to use pre-release versions, check the release section of\nthis repository. If you don\'t intent to use the CLI, you do not need to install the "cli eye candy modules" and stick to\nthe pure Python API via:\n\n```\npip install malwarebazaar\n```\n\nIf you want to use the CLI, you need to include the `cli` extra:\n\n```\npip install malwarebazaar[cli]\n```\n\n_**Note**: Previous versions also included pre-built binaries, however, I stopped adding them.\nPlease just use a local python environment instead._\n\n## Usage\n\n### Python API\n```python\nfrom malwarebazaar import Bazaar, Yaraify\nfrom malwarebazaar.models import Sample, YaraRule\n\nb = Bazaar(\n    api_key="myapikey"\n)\ny = Yaraify(\n    api_key="myapikey"\n)\nresponse = b.query_recent()\nsamples = [Sample(**sample_dict) for sample_dict in response["data"]]\nfile_content = b.download_file(samples[0].sha256_hash)  # or response["data"][0]["sha256_hash"]\n\nresponse = y.query_recent_yara()\nyaras = [YaraRule(**yara_dict) for yara_dict in response["data"]]\nfor yara in yaras:\n    if yara.rule_name != "classified":\n        rule = y.download_yara(yara.yarahub_uuid)\n        print(rule)\n        break\n```\n\nThere is no dedicated API documentation, however, the function names are pretty self-explanatory and you can just take\na look at the respective API functions here:\n\n- Bazaar: [bazaar.py](malwarebazaar/api/bazaar.py)\n- YARAify: [yaraify.py](malwarebazaar/api/yaraify.py)\n\n### CLI\n\nThis module provides two CLI commands: `bazaar` and `yaraify`.\nThey use the same configuration file and must be initialized with the specific API key before they can be used.\nOptionally, auto-completion can be installed for your shell via `bazaar --install-completion <shell>` (same for\n`yaraify`).\n\n#### `bazaar` example\n```text\n$ bazaar init myapikey\nSuccessfully set API-Key!\n$ bazaar query hash f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807\n                ╷                                                                                \n  Filename      │ 03891ab57eb301579005f62953dfd21e.exe                                           \n  Filesize      │ 21504 bytes                                                                    \n  Filetype      │ application/x-dosexec                                                          \n  Sightings     │ First-Seen: 2021-06-04 07:22:18                                                \n                │ Last-Seen:  None                                                               \n                │ Sightings:  None                                                               \n  Hashes        │ MD5:        03891ab57eb301579005f62953dfd21e                                   \n                │ SHA1:       41efd56ea49b72c6dd53b5341f295e549b1b64a5                           \n                │ SHA256:     f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807   \n                │ SHA3-384:                                                                      \n                │ 72399548d0b0c9c679b3c492bef7f5df38f24e772d0897116b443937c16102fe2b9009aa2f2d0  \n                │ b534ac7bfb710e4a394                                                            \n                │ Icon Dhash: None                                                               \n  Import Hashes │ Imphash:    f34d5f2d4577ed6d9ceec516c1f5a744                                   \n                │ Gimphash:   None                                                               \n                │ Telfhash:   None                                                               \n  Fuzzy Hashes  │ Ssdeep:     384:/SkWXcoDeR7tojS+hsQjouy9lda2zEaNc5jPp:Acie1Cj9hsQDOXEr         \n                │ Tlsh:                                                                          \n                │ 04A2196433DCD671ECEB0B71AAB28644E6F5F4855802FB2B1AC481C759A3758CE32793         \n                │                                                                                \n  Signature     │ RedLineStealer                                                                 \n  Tags          │ exe, RedLineStealer                                                            \n                ╵                                                                                \n             ╷            ╷               ╷                               \n  ANY.RUN    │ No family  │ CERT-PL_MWDB  │ Undetected                    \n             │ malicious  │               │                               \n             │            │               │                               \n  YOROI_YOMI │ suspicious │ vxCube        │ malicious                     \n             │            │               │                               \n  InQuest    │ malicious  │ CAPE          │ RedLine                       \n             │            │               │                               \n  Triage     │ redline    │ ReversingLabs │ ByteCode-MSIL.Trojan.Wacatac  \n             │ malicious  │               │ malicious                     \n             │            │               │                               \n  UnpacMe    │ Undetected │               │                               \n             │            │               │                               \n             │            │               │                               \n             ╵            ╵               ╵                               \n$ bazaar download f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807\n$ file f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.zip \nf670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.zip: Zip archive data, at least v5.1 to extract\n$ bazaar download f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807 --unzip\n$ file f670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.exe \nf670080b1f42d1b70a37adda924976e6d7bd62bf77c35263aff97e7968291807.exe: PE32 executable (GUI) Intel 80386 Mono/.Net assembly, for MS Windows\n$ bazaar recent -s -l5\nc2ae8ce5833306a5f311cf95a75271d9f25c037f177f935dff1d27b99b9af549 [Undetected] [@andretavare5] (exe)\nb885520ef95e0c2159243d800bda652bd2b787098a9e1d29718a6e73b1204a36 [Undetected] [@andretavare5] (exe)\n8b4fa170c0a68f07870823524579484ec7ba31b058ae80e23b8a29d3bfe96d84 [Undetected] [@andretavare5] (exe)\ned3d540886144d18a9f15c349cff1a89080dbb9e62ad224efbe83307af3171f2 [NanoCore] [@abuse_ch] (exe, NanoCore, RAT)\n26507309b1d73937d7f62b28e9065e1fe94a74b3b293b263140370fa6cfa90f8 [Undetected] [@andretavare5] (exe)\n```\n\n#### `yaraify` example\n```text\n$ yaraify init myapikey --malpedia mymalpediaapikey\nSuccessfully created config:\n{"api_key": "bazaar_api_key", "yaraify": {"api_key": "myapikey", "malpedia_key": \n"mymalpediaapikey", "csv_columns": {"rule_name": "rule_name", "author": "author", "uuid": "yarahub_uuid"}}, \n"csv_columns": {"md5": "md5_hash", "sha1": "sha1_hash", "sha256": "sha256_hash", "imphash": "imphash", "signature": "signature", "tags": "tags"}}\n$ yaraify query hash 7a6fcc2f0115c73bc66e9eacf74af4e5c11b06d600fd2038a289d5ee2163d459\nSample 1/1\n                ╷                                                                                \n  Filename      │ None                                                                           \n  Filesize      │ 2691072 bytes                                                                  \n  Filetype      │ application/x-dosexec                                                          \n  Sightings     │ First-Seen: 2022-12-22 11:35:25                                                \n                │ Last-Seen:  None                                                               \n                │ Sightings:  1                                                                  \n  Hashes        │ MD5:        6ae5d1343e41801bf5a501055f43818d                                   \n                │ SHA1:       18d068b535785ec16d56c0f421addb35232fe377                           \n                │ SHA256:     7a6fcc2f0115c73bc66e9eacf74af4e5c11b06d600fd2038a289d5ee2163d459   \n                │ SHA3-384:                                                                      \n                │ cc7dab7054f50e9bdcef92d4bdfbc2b27bcca1ea025f2d340703083ae819a2c6e312c20317804  \n                │ 078a4ce124e91f74a64                                                            \n                │ Icon Dhash: None                                                               \n  Import Hashes │ Imphash:    5c7397fd7c1832e37a3cb00b6ee7c377                                   \n                │ Gimphash:   None                                                               \n                │ Telfhash:   None                                                               \n  Fuzzy Hashes  │ Ssdeep:                                                                        \n                │ 49152:NWrMtlmeF2RBzD8CSkkZA2loXISPEB8ClDl1mZDdeP7RWUOIQ:aMtlmeF2RBz1SkkZAKWIS  \n                │ YFgDoPl8IQ                                                                     \n                │ Tlsh:                                                                          \n                │ T14EC5AE83B7C690F1DB963030051F976EEA7DBE285C749607B3A13A6F69302016B2D79D       \n                │                                                                                \n                ╵                                                                                \nTask 1/1\n                     ╷                                                 \n  Task ID            │ ba3f2653-81ec-11ed-a7d0-42010aa4000b            \n  YARAify Parameters │ ClamAV ✔ Unpack ✖ Share ✔                       \n  Detections         │ Clam-AV:     No Clam-AV results                 \n                     │ Name:        BitcoinAddress                     \n                     │ Author:      Didier Stevens (@DidierStevens)    \n                     │ Description: Contains a valid Bitcoin address   \n                     │ TLP:         WHITE                              \n                     │                                                 \n                     │ Name:        malware_shellcode_hash             \n                     │ Author:      JPCERT/CC Incident Response Group  \n                     │ Description: detect shellcode api hash value    \n                     │ TLP:         WHITE                              \n                     │                                                 \n                     │ Name:        meth_get_eip                       \n                     │ Author:      Willi Ballenthin                   \n                     │ Description: No description provided.           \n                     │ TLP:         WHITE                              \n                     │                                                 \n                     │ Name:        pdb_YARAify                        \n                     │ Author:      @wowabiy314                        \n                     │ Description: PDB                                \n                     │ TLP:         WHITE                              \n                     │                                                 \n                     ╵                             \n$ yaraify recent -s -l 5\nclassified [classified] (4e00e916-1b7a-4020-b64a-701ff3390ca9)\nclassified [classified] (8f965345-b8d2-4a55-a9c3-2ff23a03ed1e)\nwin_aurora_stealer_a_706a [@viql] (706a5977-69fb-44ae-bfa7-f61e214148e7)\nclassified [classified] (5d5e97ac-33f7-4823-9534-ca969d135556)\nwin_phorpiex_a_84fc [@viql] (84fc2940-d204-4d75-9f17-89cce6b1dea2)\n$ yaraify get 706a5977-69fb-44ae-bfa7-f61e214148e7\nrule win_aurora_stealer_a_706a {\n\n    meta:\n        author                    = "Johannes Bader"\n        date                      = "2022-12-14"\n        description               = "detects Aurora Stealer samples"\n        hash1_md5                 = "51c153501e991f6ce4901e6d9578d0c8"\n        hash1_sha1                = "3816f17052b28603855bde3e57db77a8455bdea4"\n        hash1_sha256              = "c148c449e1f6c4c53a7278090453d935d1ab71c3e8b69511f98993b6057f612d"\n        hash2_md5                 = "65692e1d5b98225dbfb1b6b2b8935689"\n        hash2_sha1                = "0b51765c175954c9e47c39309e020bcb0f90b783"\n        hash2_sha256              = "5a42aa4fc8180c7489ce54d7a43f19d49136bd15ed7decf81f6e9e638bdaee2b"\n        malpedia_family           = "win.aurora_stealer"\n        tlp                       = "TLP:WHITE"\n        version                   = "v1.0"\n        yarahub_author_email      = "yara@bin.re"\n        yarahub_author_twitter    = "@viql"\n        yarahub_license           = "CC BY-SA 4.0"\n        yarahub_reference_md5     = "51c153501e991f6ce4901e6d9578d0c8"\n        yarahub_rule_matching_tlp = "TLP:WHITE"\n        yarahub_rule_sharing_tlp  = "TLP:WHITE"\n        yarahub_uuid              = "706a5977-69fb-44ae-bfa7-f61e214148e7"\n\n    strings:\n\n        $str_func_01 = "main.(*DATA_BLOB).ToByteArray"\n        $str_func_02 = "main.Base64Encode"\n        $str_func_03 = "main.Capture"\n        $str_func_04 = "main.CaptureRect"\n        $str_func_05 = "main.ConnectToServer"\n        $str_func_06 = "main.CreateImage"\n        $str_func_07 = "main.FileExsist"\n        $str_func_08 = "main.GetDisplayBounds"\n        $str_func_09 = "main.GetInfoUser"\n        $str_func_10 = "main.GetOS"\n        $str_func_11 = "main.Grab"\n        $str_func_12 = "main.MachineID"\n        $str_func_13 = "main.NewBlob"\n        $str_func_14 = "main.NumActiveDisplays"\n        $str_func_15 = "main.PathTrans"\n        $str_func_16 = "main.SendToServer_NEW"\n        $str_func_17 = "main.SetUsermame"\n        $str_func_18 = "main.Zip"\n        $str_func_19 = "main.base64Decode"\n        $str_func_20 = "main.countupMonitorCallback"\n        $str_func_21 = "main.enumDisplayMonitors"\n        $str_func_22 = "main.getCPU"\n        $str_func_23 = "main.getDesktopWindow"\n        $str_func_24 = "main.getGPU"\n        $str_func_25 = "main.getMasterKey"\n        $str_func_26 = "main.getMonitorBoundsCallback"\n        $str_func_27 = "main.getMonitorRealSize"\n        $str_func_28 = "main.sysTotalMemory"\n        $str_func_29 = "main.xDecrypt"\n\n        $str_type_01 = "type..eq.main.Browser_G"\n        $str_type_02 = "type..eq.main.STRUSER"\n        $str_type_03 = "type..eq.main.Telegram_G"\n        $str_type_04 = "type..eq.main.Crypto_G"\n        $str_type_05 = "type..eq.main.ScreenShot_G"\n        $str_type_06 = "type..eq.main.FileGrabber_G"\n        $str_type_07 = "type..eq.main.FTP_G"\n        $str_type_08 = "type..eq.main.Steam_G"\n        $str_type_09 = "type..eq.main.DATA_BLOB"\n        $str_type_10 = "type..eq.main.Grabber"\n\n        $varia_01 = "\\\\User Data\\\\Local State"\n        $varia_02 = "\\\\\\\\Opera Stable\\\\\\\\Local State"\n        $varia_03 = "Reconnect 1"\n        $varia_04 = "@ftmone"\n        $varia_05 = "^user^"\n        $varia_06 = "wmic path win32_VideoController get name"\n        $varia_07 = "\\\\AppData\\\\Roaming\\\\Telegram Desktop\\\\tdata"\n        $varia_08 = "C:\\\\Windows.old\\\\Users\\\\"\n        $varia_09 = "ScreenShot"\n        $varia_10 = "Crypto"\n\n    condition:\n        uint16(0) == 0x5A4D and\n        (\n            32 of ($str_*) or\n            9 of ($varia_*)\n        )\n}\n```\n',
    'author': '3c7',
    'author_email': '3c7@posteo.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/3c7/bazaar',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.12',
}


setup(**setup_kwargs)
