"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticSearchAndKibana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
class LambdaToElasticSearchAndKibana extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the CognitoToApiGatewayToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CognitoToApiGatewayToLambdaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        if (props.vpcProps && !props.deployVpc) {
            throw new Error("Error - deployVpc must be true when defining vpcProps");
        }
        if (props.lambdaFunctionProps?.vpc || props.lambdaFunctionProps?.vpcSubnets) {
            throw new Error("Error - Define VPC using construct parameters not Lambda function props");
        }
        if (props.esDomainProps?.vpcOptions) {
            throw new Error("Error - Define VPC using construct parameters not Elasticsearch props");
        }
        if (props.deployVpc || props.existingVpc) {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
        }
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc
        });
        // Find the lambda service Role ARN
        const lambdaFunctionRoleARN = this.lambdaFunction.role?.roleArn;
        let cognitoAuthorizedRole;
        [this.userPool, this.userPoolClient, this.identityPool, cognitoAuthorizedRole] =
            this.setupCognito(this, props.cognitoDomainName ?? props.domainName);
        const buildElasticSearchProps = {
            userpool: this.userPool,
            identitypool: this.identityPool,
            cognitoAuthorizedRoleARN: cognitoAuthorizedRole.roleArn,
            serviceRoleARN: lambdaFunctionRoleARN,
            vpc: this.vpc,
            domainName: props.domainName,
            clientDomainProps: props.esDomainProps
        };
        if (this.vpc) {
            const securityGroupIds = defaults.getLambdaVpcSecurityGroupIds(this.lambdaFunction);
            buildElasticSearchProps.securityGroupIds = securityGroupIds;
        }
        [this.elasticsearchDomain, this.elasticsearchRole] = defaults.buildElasticSearch(this, buildElasticSearchProps);
        // Add ES Domain to lambda environment variable
        const domainEndpointEnvironmentVariableName = props.domainEndpointEnvironmentVariableName || 'DOMAIN_ENDPOINT';
        this.lambdaFunction.addEnvironment(domainEndpointEnvironmentVariableName, this.elasticsearchDomain.attrDomainEndpoint);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for ES
            this.cloudwatchAlarms = defaults.buildElasticSearchCWAlarms(this);
        }
    }
    setupCognito(scope, domainName) {
        const userPool = defaults.buildUserPool(scope);
        const userPoolClient = defaults.buildUserPoolClient(scope, userPool);
        const identityPool = defaults.buildIdentityPool(scope, userPool, userPoolClient);
        const cognitoAuthorizedRole = defaults.setupCognitoForElasticSearch(scope, domainName, {
            userpool: userPool,
            identitypool: identityPool,
            userpoolclient: userPoolClient
        });
        return [userPool, userPoolClient, identityPool, cognitoAuthorizedRole];
    }
}
exports.LambdaToElasticSearchAndKibana = LambdaToElasticSearchAndKibana;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticSearchAndKibana[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticsearch-kibana.LambdaToElasticSearchAndKibana", version: "1.163.2" };
//# sourceMappingURL=data:application/json;base64,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