import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface EnvVar {
    /**
     * (experimental) Name of the environment variable.
     *
     * Must be a C_IDENTIFIER.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EnvVar#name
     */
    readonly name: string;
    /**
     * (experimental) Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables.
     *
     * If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
     *
     * @default .
     * @experimental
     * @schema io.k8s.api.core.v1.EnvVar#value
     */
    readonly value?: string;
}
/**
 * @experimental
 */
export interface AwsLoadBalancerControllerOptions {
    /**
     * (experimental) Extra labels to associate with resources.
     *
     * @default - none
     * @experimental
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * (experimental) Default Namespace for aws-load-balancer-controller.
     *
     * @default - kube-system
     * @experimental
     */
    readonly namespace?: string;
    /**
     * (experimental) Kubernetes Cluster Name for aws-load-balancer-controller.
     *
     * @default - None
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) service account for aws-load-balancer-controller.
     *
     * @default - true
     * @experimental
     */
    readonly createServiceAccount?: boolean;
    /**
     * (experimental) Service Account Name for aws-load-balancer-controller.
     *
     * @default - aws-load-balancer-controller
     * @experimental
     */
    readonly serviceAccountName: string;
    /**
     * (experimental) Default image for aws-load-balancer-controller.
     *
     * @default - docker.io/amazon/aws-aws-load-balancer-controller:v1.1.9
     * @experimental
     */
    readonly image?: string;
    /**
     * (experimental) Another Args for aws-load-balancer-controller.
     *
     * @default - None
     * @experimental
     */
    readonly args?: string[];
    /**
     * (experimental) Another Args for aws-load-balancer-controller.
     *
     * @default - None
     * @experimental
     */
    readonly env?: EnvVar[];
    /**
     * (experimental) Replicas for aws-load-balancer-controller.
     *
     * @default - 1
     * @experimental
     */
    readonly replicas?: number;
}
/**
 * (experimental) Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @experimental
 */
export declare class AwsLoadBalancerController extends Construct {
    /**
     * (experimental) service account for aws-load-balancer-controller.
     *
     * @default - true
     * @experimental
     */
    readonly createServiceAccount?: boolean;
    /**
     * (experimental) Service Account Name for aws-load-balancer-controller.
     *
     * @experimental
     */
    readonly serviceAccountName: string;
    /**
     * (experimental) Kubernetes Cluster Name for aws-load-balancer-controller.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) Kubernetes Deployment Name for aws-load-balancer-controller.
     *
     * @experimental
     */
    readonly deploymentName: string;
    /**
     * (experimental) Namespace for aws-load-balancer-controller.
     *
     * @default - kube-system
     * @experimental
     */
    readonly namespace: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, options: AwsLoadBalancerControllerOptions);
    private argsFunc;
    private envFunc;
}
