# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dart_version_manager', 'dart_version_manager.commands']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'typer>=0.3.2,<0.4.0']

entry_points = \
{'console_scripts': ['dvm = dart_version_manager.main:app']}

setup_kwargs = {
    'name': 'dart-version-manager',
    'version': '1.0.0',
    'description': 'Dart Version Manager CLI implemented with Python and Typer.',
    'long_description': '# `Dart Version Manager`\n\n[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)\n[![Test](https://github.com/educup/dart_version_manager/workflows/CI/badge.svg)](https://github.com/educup/dart_version_manager/actions?query=workflow%3ACI)\n[![Version](https://img.shields.io/pypi/v/dart_version_manager?color=%2334D058&label=Version)](https://pypi.org/project/dart_version_manager)\n[![Last commit](https://img.shields.io/github/last-commit/educup/dart_version_manager.svg?style=flat)](https://github.com/educup/dart_version_manager/commits)\n[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/educup/dart_version_manager)](https://github.com/educup/dart_version_manager/commits)\n[![Github Stars](https://img.shields.io/github/stars/educup/dart_version_manager?style=flat&logo=github)](https://github.com/educup/dart_version_manager/stargazers)\n[![Github Forks](https://img.shields.io/github/forks/educup/dart_version_manager?style=flat&logo=github)](https://github.com/educup/dart_version_manager/network/members)\n[![Github Watchers](https://img.shields.io/github/watchers/educup/dart_version_manager?style=flat&logo=github)](https://github.com/educup/dart_version_manager)\n[![Website](https://img.shields.io/website?up_message=online&url=https%3A%2F%2Feducup.github.io/dart_version_manager)](https://educup.github.io/dart_version_manager)\n[![GitHub contributors](https://img.shields.io/github/contributors/educup/dart_version_manager)](https://github.com/educup/dart_version_manager/graphs/contributors)\n\nDart Version Manager CLI implemented with Python and Typer\n\n**Usage**:\n\n```console\n$ dvm [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `build`: Manage "build" tag\n* `get`: Get project version\n* `major`: Manage "major" version\n* `minor`: Manage "minor" version\n* `patch`: Manage "patch"\n* `pre-release`: Manage "pre-release" tag\n* `set`: Set project version\n\n## `dvm build`\n\nManage "build" tag\n\n**Usage**:\n\n```console\n$ dvm build [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get "build" tag\n* `set`: Set "build" tag\n* `up`: Increase "build" tag\'s first detected number...\n\n### `dvm build get`\n\nGet "build" tag\n\n**Usage**:\n\n```console\n$ dvm build get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm build set`\n\nSet "build" tag\n\n**Usage**:\n\n```console\n$ dvm build set [OPTIONS] BUILD [FILENAME]\n```\n\n**Arguments**:\n\n* `BUILD`: "build" tag  [required]\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm build up`\n\nIncrease "build" tag\'s first detected number by 1\n\n**Usage**:\n\n```console\n$ dvm build up [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n## `dvm get`\n\nGet project version\n\n**Usage**:\n\n```console\n$ dvm get [OPTIONS] [PUBSPEC_FILE]\n```\n\n**Arguments**:\n\n* `[PUBSPEC_FILE]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n## `dvm major`\n\nManage "major" version\n\n**Usage**:\n\n```console\n$ dvm major [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get "major" version\n* `set`: Set "major" version\n* `up`: Increase "major" version by 1\n\n### `dvm major get`\n\nGet "major" version\n\n**Usage**:\n\n```console\n$ dvm major get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm major set`\n\nSet "major" version\n\n**Usage**:\n\n```console\n$ dvm major set [OPTIONS] MAJOR [FILENAME]\n```\n\n**Arguments**:\n\n* `MAJOR`: "major" version  [required]\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm major up`\n\nIncrease "major" version by 1\n\n**Usage**:\n\n```console\n$ dvm major up [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--keep-pre-release / --no-keep-pre-release`: [default: False]\n* `--keep-build / --no-keep-build`: [default: False]\n* `--help`: Show this message and exit.\n\n## `dvm minor`\n\nManage "minor" version\n\n**Usage**:\n\n```console\n$ dvm minor [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get "minor" version\n* `set`: Set "minor" version\n* `up`: Increase "minor" version by 1\n\n### `dvm minor get`\n\nGet "minor" version\n\n**Usage**:\n\n```console\n$ dvm minor get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm minor set`\n\nSet "minor" version\n\n**Usage**:\n\n```console\n$ dvm minor set [OPTIONS] MINOR [FILENAME]\n```\n\n**Arguments**:\n\n* `MINOR`: "minor" version  [required]\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm minor up`\n\nIncrease "minor" version by 1\n\n**Usage**:\n\n```console\n$ dvm minor up [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--keep-pre-release / --no-keep-pre-release`: [default: False]\n* `--keep-build / --no-keep-build`: [default: False]\n* `--help`: Show this message and exit.\n\n## `dvm patch`\n\nManage "patch"\n\n**Usage**:\n\n```console\n$ dvm patch [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get "patch"\n* `set`: Set "patch"\n* `up`: Increase "patch" by 1\n\n### `dvm patch get`\n\nGet "patch"\n\n**Usage**:\n\n```console\n$ dvm patch get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm patch set`\n\nSet "patch"\n\n**Usage**:\n\n```console\n$ dvm patch set [OPTIONS] PATCH [FILENAME]\n```\n\n**Arguments**:\n\n* `PATCH`: "patch" number  [required]\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm patch up`\n\nIncrease "patch" by 1\n\n**Usage**:\n\n```console\n$ dvm patch up [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--keep-pre-release / --no-keep-pre-release`: [default: False]\n* `--keep-build / --no-keep-build`: [default: False]\n* `--help`: Show this message and exit.\n\n## `dvm pre-release`\n\nManage "pre-release" tag\n\n**Usage**:\n\n```console\n$ dvm pre-release [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get`: Get "pre-release" tag\n* `set`: Set "pre-release" tag\n* `up`: Increase "pre-release" tag\'s first detected...\n\n### `dvm pre-release get`\n\nGet "pre-release" tag\n\n**Usage**:\n\n```console\n$ dvm pre-release get [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm pre-release set`\n\nSet "pre-release" tag\n\n**Usage**:\n\n```console\n$ dvm pre-release set [OPTIONS] PRE_RELEASE [FILENAME]\n```\n\n**Arguments**:\n\n* `PRE_RELEASE`: "pre-release" tag  [required]\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n### `dvm pre-release up`\n\nIncrease "pre-release" tag\'s first detected number by 1\n\n**Usage**:\n\n```console\n$ dvm pre-release up [OPTIONS] [FILENAME]\n```\n\n**Arguments**:\n\n* `[FILENAME]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n\n## `dvm set`\n\nSet project version\n\n**Usage**:\n\n```console\n$ dvm set [OPTIONS] VERSION [PUBSPEC_FILE]\n```\n\n**Arguments**:\n\n* `VERSION`: The version to set in format "\\<major\\>.\\<minor\\>.\\<patch\\>-\\<pre-release\\>+\\<build\\>". The "major", "minor" and "patch" must be all integers. The "pre-release" and "build" are words splited by ".".  [required]\n* `[PUBSPEC_FILE]`: Path to the pubspec file of the Dart project  [env var: DVM_FILENAME;default: .\\pubspec.yaml]\n\n**Options**:\n\n* `--verbose / --no-verbose`: [default: True]\n* `--help`: Show this message and exit.\n',
    'author': 'educup',
    'author_email': 'hello@educup.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/educup/dart_version_manager',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
